/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.formplugin.web.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ActivityInstanceUtils {
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final int INT_EIGHT = 8;

    private ActivityInstanceUtils() {
    }

    private static Date parseInstanceDate(String yearKey, String dateKey, int year, DynamicObject dynamicObject) throws ParseException {
        String yearMark = HRStringUtils.isEmpty((String)yearKey) ? null : dynamicObject.getString(yearKey);
        return HRDateTimeUtils.parseDate((String)(("2".equals(yearMark) ? year + 1 : year) + "-" + dynamicObject.getString(dateKey)), (String)YYYY_MM_DD);
    }

    public static Date calcInstanceDate(Date date, int monthAdd, String dateConfig) throws ParseException {
        if (monthAdd < 1) {
            return date;
        }
        Date dateResult = HRDateTimeUtils.addMonth((Date)date, (int)monthAdd);
        if (Items.MONTH_END_SET.contains(dateConfig) && HRDateTimeUtils.getMonth((Date)dateResult) - HRDateTimeUtils.getMonth((Date)date) > monthAdd) {
            String monthStart = HRDateTimeUtils.format((Date)dateResult, (String)YYYY_MM_DD).substring(0, 8) + "01";
            return HRDateTimeUtils.addDay((Date)HRDateTimeUtils.parseDate((String)monthStart, (String)YYYY_MM_DD), (long)-1L);
        }
        if (Items.SEC_DATE_SET.contains(dateConfig)) {
            dateResult = HRDateTimeUtils.addDay((Date)date, (long)((monthAdd + 1) * 30));
            String monthStart = HRDateTimeUtils.format((Date)dateResult, (String)YYYY_MM_DD).substring(0, 8) + "01";
            return HRDateTimeUtils.addDay((Date)HRDateTimeUtils.parseDate((String)monthStart, (String)YYYY_MM_DD), (long)-1L);
        }
        return dateResult;
    }

    public static Date calcInstanceNextDate(Date startDate, int cyclelen, int offset) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startDate);
        ((Calendar)calendar).add(2, cyclelen * offset);
        Date defaultFirstDate = calendar.getTime();
        return defaultFirstDate;
    }

    private static class Items {
        private static final Set<String> MONTH_END_SET = new HashSet<String>(32);
        private static final Set<String> SEC_DATE_SET;

        private Items() {
        }

        static {
            Collections.addAll(MONTH_END_SET, "01-31");
            SEC_DATE_SET = new HashSet<String>(32);
            Collections.addAll(SEC_DATE_SET, "02-28", "02-29", "03-31", "04-30", "05-31", "06-30", "07-31", "08-31", "09-30", "10-31", "11-30", "12-31");
        }
    }
}

