/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.validator;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class HRRoleGrpSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(datas);
        }
    }

    private void canSave(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject roleGrp = dataEntity.getDataEntity();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_rolegroup");
            String roleGrpName = roleGrp.getString("name");
            QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)roleGrpName)};
            DynamicObject permFileDyc = serviceHelper.queryOne("id", filters);
            this.checkUnique(dataEntity, roleGrp, permFileDyc);
        }
    }

    private void checkUnique(ExtendedDataEntity dataEntity, DynamicObject roleGrp, DynamicObject roleGrpDyc) {
        String permId;
        String dycId;
        if (roleGrpDyc != null && !HRStringUtils.equals((String)(dycId = roleGrpDyc.getPkValue().toString()), (String)(permId = roleGrp.getPkValue().toString()))) {
            String number = roleGrp.getString("number");
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"HRRoleGrpSaveValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), number);
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

