/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class LoginSceneEnableValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operationKey = this.getOperateKey();
        ExtendedDataEntity[] datas = this.getDataEntities();
        if ("disable".equals(operationKey)) {
            this.canDisable(datas);
        }
    }

    private void canDisable(ExtendedDataEntity[] datas) {
        DynamicObject[] dynamicObjects;
        ArrayList<Long> idList = new ArrayList<Long>(datas.length);
        HashMap<Long, ExtendedDataEntity> reportDataMap = new HashMap<Long, ExtendedDataEntity>(datas.length);
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            idList.add(dynamicObject.getLong("id"));
            reportDataMap.put(dynamicObject.getLong("id"), dataEntity);
        }
        for (DynamicObject tempDynamicObject : dynamicObjects = this.getLoginConfigDatas(idList)) {
            String sceneName = tempDynamicObject.getString("loginscene.name");
            String configName = tempDynamicObject.getString("name");
            String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u88ab\u767b\u5f55\u914d\u7f6e\u7684\u201c%2$s\u201d\u5f15\u7528\u3002", (String)"LoginSceneEnableValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), sceneName, configName);
            this.addErrorMessage((ExtendedDataEntity)reportDataMap.get(tempDynamicObject.getLong("loginscene.id")), message);
        }
    }

    private DynamicObject[] getLoginConfigDatas(List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_loginconfig");
        DynamicObject[] dobjs = serviceHelper.query("id,name,loginscene.id,loginscene.name", new QFilter[]{new QFilter("loginscene.id", "in", ids)});
        return dobjs;
    }
}

