/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.diff;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbss.opplugin.web.validate.DiffCustomAOPConfigSaveOpValidator;

public class DiffCustomAOPConfigOp
extends HRDataBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("save".equals(operationKey)) {
            this.saveOtherData(e);
        } else if ("delete".equals(operationKey)) {
            this.deleteCustomDiffHandler(e);
        } else if ("enable".equals(operationKey)) {
            this.batchUpdateStatus(e, "1");
        } else if ("disable".equals(operationKey)) {
            this.batchUpdateStatus(e, "0");
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("diffhandler");
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        String type = (String)this.operateMeta.get("type");
        if ("save".equals(type)) {
            args.addValidator((AbstractValidator)new DiffCustomAOPConfigSaveOpValidator());
        }
    }

    private void deleteCustomDiffHandler(BeginOperationTransactionArgs e) {
        DynamicObject[] curDynObjs = e.getDataEntities();
        if (curDynObjs.length <= 0) {
            return;
        }
        List pks = Arrays.stream(curDynObjs).map(obj -> {
            DynamicObject diffHandlerDynObj = obj.getDynamicObject("diffhandler");
            return diffHandlerDynObj.getLong("id");
        }).collect(Collectors.toList());
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pks), new QFilter("type", "=", (Object)"APIAOP")};
        DeleteServiceHelper.delete((String)"hbss_diffhandler", (QFilter[])qFilters);
    }

    private void saveOtherData(BeginOperationTransactionArgs e) {
        DynamicObject curDynObj = e.getDataEntities()[0];
        String isvId = ISVServiceHelper.getISVInfo().getId();
        curDynObj.set("isv", (Object)isvId);
        curDynObj.set("type", (Object)"APIAOP");
        DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"hbss_diffhandler");
        DynamicObject diffHandlerDynObj = curDynObj.getDynamicObject("diffhandler");
        if (diffHandlerDynObj != null && diffHandlerDynObj.getLong("id") > 0L) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)diffHandlerDynObj.getLong("id"))};
            DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"hbss_diffhandler", (String)"id,number,name,cloud,app,functionname,sourceclassname,sourcemethodname,creator,createtime,modifier,modifytime", (QFilter[])filters, null);
            if (dynObjs.length > 0) {
                dynObj = dynObjs[0];
            }
        } else {
            Long diffHandlerId = DBServiceHelper.genGlobalLongId();
            dynObj.set("id", (Object)diffHandlerId);
            dynObj.set("isv", curDynObj.get("isv"));
            dynObj.set("apitype", (Object)"OTHER");
            dynObj.set("issyspreset", (Object)"0");
            dynObj.set("type", (Object)"APIAOP");
        }
        dynObj.set("number", curDynObj.get("number"));
        dynObj.set("name", curDynObj.get("name"));
        dynObj.set("cloud", curDynObj.get("cloud"));
        dynObj.set("app", curDynObj.get("app"));
        dynObj.set("functionname", curDynObj.get("functionname"));
        dynObj.set("sourceclassname", curDynObj.get("sourceclassname"));
        dynObj.set("sourcemethodname", curDynObj.get("sourcemethodname"));
        dynObj.set("creator", curDynObj.get("creator"));
        dynObj.set("createtime", curDynObj.get("createtime"));
        dynObj.set("modifier", curDynObj.get("modifier"));
        dynObj.set("modifytime", curDynObj.get("modifytime"));
        curDynObj.set("diffhandler", (Object)dynObj);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynObj});
    }

    private void batchUpdateStatus(BeginOperationTransactionArgs e, String status) {
        DynamicObject[] items;
        DynamicObject[] curDynObjs = e.getDataEntities();
        if (curDynObjs.length <= 0) {
            return;
        }
        List idList = Arrays.stream(curDynObjs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_diffcusconfig");
        for (DynamicObject item : items = serviceHelper.query("enable", new QFilter[]{new QFilter("id", "in", idList)})) {
            item.set("enable", (Object)status);
        }
        SaveServiceHelper.save((DynamicObject[])items);
    }
}

