/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.diff;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.DiffServiceHelper;
import kd.hr.hbp.business.service.diff.cache.DiffCache;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import org.apache.commons.collections.CollectionUtils;

public class DiffHandlerEnableDisableOp
extends HRDataBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey;
        super.beginOperationTransaction(e);
        List<Long> selectedIds = Arrays.stream(e.getDataEntities()).map(item -> item.getLong("id")).collect(Collectors.toList());
        DynamicObject[] selectedDynamicObject = this.getByIds(selectedIds);
        List selectedHandlerList = Arrays.stream(selectedDynamicObject).filter(it -> "HANDLER".equalsIgnoreCase(it.getString("type"))).map(item -> item.getLong("id")).collect(Collectors.toList());
        List selectedApiAopList = Arrays.stream(selectedDynamicObject).filter(it -> "APIAOP".equalsIgnoreCase(it.getString("type"))).map(item -> item.getLong("id")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(selectedHandlerList)) {
            operationKey = e.getOperationKey();
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"enable")) {
                DiffServiceHelper.batchEnableHandler(selectedHandlerList);
                DiffCache.removeAllHandlerCache();
            } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"disable")) {
                DiffServiceHelper.batchDisableHandler(selectedHandlerList);
                DiffCache.removeAllHandlerCache();
            } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"delete")) {
                DiffCache.removeAllHandlerCache();
            }
        }
        if (CollectionUtils.isNotEmpty(selectedApiAopList)) {
            operationKey = e.getOperationKey();
            if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"enable")) {
                DiffServiceHelper.batchEnableApiAop(selectedApiAopList);
                DiffCache.removeAllApiAopCache();
            } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"disable")) {
                DiffServiceHelper.batchDisableApiAop(selectedApiAopList);
                DiffCache.removeAllApiAopCache();
            } else if (StringUtils.equals((CharSequence)operationKey, (CharSequence)"delete")) {
                DiffServiceHelper.batchDisableApiAop(selectedApiAopList);
                DiffCache.removeAllApiAopCache();
            }
        }
    }

    private DynamicObject[] getByIds(List<Long> ids) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_diffhandler");
        return helper.query("type", new QFilter[]{new QFilter("id", "in", ids)});
    }
}

