/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.hrbu;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbss.bussiness.service.hrbu.HRBUSyncStrategyService;
import kd.hr.hbss.bussiness.servicehelper.BosOrgServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.opplugin.web.hrbu.validator.HRBUViewQueryListOpValidator;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class HEBUViewQueryListOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(HEBUViewQueryListOp.class);
    private static final String EXCEPTION_LOG = "HEBUViewQueryListOp  exception:";
    private Map<OrgParam, DynamicObject> saveAllOrgParamToHrBuViewExtDyMap = new LinkedHashMap<OrgParam, DynamicObject>();
    private Map<Long, DynamicObject> structureIdToHrBuExtDyMap = new HashMap<Long, DynamicObject>();

    public static Object[] saveHRBUExtView(Map<OrgParam, DynamicObject> saveAllOrgParamToHrBuViewExtDyMap) {
        HRBaseServiceHelper hrbuExtViewHelper = new HRBaseServiceHelper("hbss_hrbuviewext");
        ArrayList hrBuViewExtDyList = Lists.newArrayListWithExpectedSize((int)saveAllOrgParamToHrBuViewExtDyMap.size());
        ArrayList bosViewNumbers = Lists.newArrayListWithExpectedSize((int)saveAllOrgParamToHrBuViewExtDyMap.size());
        ArrayList bosOrgIds = Lists.newArrayListWithExpectedSize((int)saveAllOrgParamToHrBuViewExtDyMap.size());
        saveAllOrgParamToHrBuViewExtDyMap.forEach((orgParam, value) -> {
            bosViewNumbers.add(orgParam.getDuty());
            bosOrgIds.add(orgParam.getId());
        });
        Map viewNumberOrgIdToStructureMap = HRBUExtServiceHelper.getBosOrgStructByBosOrg((List)bosViewNumbers, (List)bosOrgIds);
        saveAllOrgParamToHrBuViewExtDyMap.forEach((orgParam, value) -> {
            DynamicObject bosOrgStructure = (DynamicObject)viewNumberOrgIdToStructureMap.get(orgParam.getDuty() + "!" + orgParam.getId());
            long structureId = bosOrgStructure.getLong("id");
            DynamicObject hrBuViewExtDy = hrbuExtViewHelper.generateEmptyDynamicObject();
            hrBuViewExtDy.set("id", (Object)DBServiceHelper.genGlobalLongId());
            hrBuViewExtDy.set("bosorgstructure", (Object)structureId);
            hrBuViewExtDy.set("description", (Object)value.getString("description"));
            hrBuViewExtDyList.add(hrBuViewExtDy);
        });
        return hrbuExtViewHelper.save(hrBuViewExtDyList.toArray(new DynamicObject[0]));
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new HRBUViewQueryListOpValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] dys = args.getDataEntities();
        if (dys == null || dys.length == 0) {
            args.setCancel(true);
            args.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"HEBUViewQueryListOp_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
            return;
        }
        String operationKey = args.getOperationKey().toLowerCase(Locale.ROOT);
        try {
            switch (operationKey) {
                case "donew": 
                case "save": 
                case "dobatchsave": {
                    this.handleDoBatchSave(args);
                    break;
                }
                case "doupdate": {
                    this.handleDoUpdate(args);
                    break;
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(EXCEPTION_LOG + ExceptionUtils.getStackTrace((Throwable)e1));
            this.dealOperationError(args, EXCEPTION_LOG + e1.getMessage());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] hrBuViewExtDys = args.getDataEntities();
        if (hrBuViewExtDys == null || hrBuViewExtDys.length == 0) {
            this.operationResult.setMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e\u3002", (String)"HEBUViewQueryListOp_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
            this.operationResult.setShowMessage(true);
            args.setCancelOperation(true);
            this.getOperationResult().setSuccess(false);
            return;
        }
        String operationKey = args.getOperationKey().toLowerCase(Locale.ROOT);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                switch (operationKey) {
                    case "donew": 
                    case "save": 
                    case "dobatchsave": {
                        this.syncHrBuViewExt();
                        break;
                    }
                    case "doupdate": {
                        HRBUExtServiceHelper.updateHRBUExtView((DynamicObject[])hrBuViewExtDys);
                        break;
                    }
                }
            }
            catch (Exception e1) {
                LOGGER.error(EXCEPTION_LOG + ExceptionUtils.getStackTrace((Throwable)e1));
                this.dealOperationError(args, txHandle, EXCEPTION_LOG + e1.getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
    }

    private void handleDoBatchSave(BeforeOperationArgs args) {
        OrgApiResult orgApiResult = this.syncBatchSaveBosOrgStructure(args.getDataEntities());
        if (!orgApiResult.isSuccess()) {
            String msg = this.getMsg(orgApiResult);
            this.dealOperationError(args, msg);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String getMsg(OrgApiResult orgApiResult) {
        StringBuilder sb = new StringBuilder();
        if (orgApiResult != null) {
            List resultList = orgApiResult.getResultList();
            for (OrgApiResult orgRes : resultList) {
                sb.append(orgRes.getErrorMsg());
            }
        }
        if (sb.length() > 500) {
            return sb.substring(0, 500);
        }
        return sb.toString();
    }

    private void handleDoUpdate(BeforeOperationArgs args) {
        OrgApiResult orgApiResult = this.syncBatchUpdateBosOrgStructure(args.getDataEntities()[0]);
        if (!orgApiResult.isSuccess()) {
            this.dealOperationError(args, orgApiResult.getErrorMsg());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private OrgApiResult syncBatchUpdateBosOrgStructure(DynamicObject hrBuViewExtDy) {
        DynamicObject bosOrgStructure = hrBuViewExtDy.getDynamicObject("bosorgstructure");
        DynamicObject parent = hrBuViewExtDy.getDynamicObject("parentorg");
        DynamicObject dyDynamicObject = hrBuViewExtDy.getDynamicObject("name");
        bosOrgStructure.set("name", (Object)dyDynamicObject.getString("name"));
        bosOrgStructure.set("number", (Object)dyDynamicObject.getString("number"));
        bosOrgStructure.set("parent", (Object)parent);
        String viewNumber = hrBuViewExtDy.getString("viewnumber");
        long viewId = HRBUExtServiceHelper.getViewIdByNumberId((Object)viewNumber);
        DynamicObject[] childViews = HRBUExtServiceHelper.getBosChildViewDyByFinalParentViewId((long)viewId);
        if (childViews.length == 0) {
            return BosOrgServiceHelper.updateOrgUnit((DynamicObject[])new DynamicObject[]{bosOrgStructure}, (OperationType)OperationType.update);
        }
        DynamicObject[] updateBosOrgStructures = this.getExistBosOrgStructures(new DynamicObject[]{hrBuViewExtDy}, childViews, "desc");
        ArrayList bosOrgStructuresWithChild = Lists.newArrayListWithExpectedSize((int)16);
        bosOrgStructuresWithChild.add(bosOrgStructure);
        Arrays.stream(updateBosOrgStructures).forEach(structure -> {
            structure.set("parent", (Object)parent);
            bosOrgStructuresWithChild.add(structure);
        });
        return BosOrgServiceHelper.updateOrgUnit((DynamicObject[])bosOrgStructuresWithChild.toArray(new DynamicObject[0]), (OperationType)OperationType.update);
    }

    public OrgApiResult syncBatchSaveBosOrgStructure(DynamicObject[] hrBuViewExtDys) {
        String viewNumber = hrBuViewExtDys[0].getString("viewnumber");
        long viewId = HRBUExtServiceHelper.getViewIdByNumberId((Object)viewNumber);
        List childViewsList = HRBUSyncStrategyService.getChildViewDys((long)viewId);
        return this.syncStructureWithChildView(hrBuViewExtDys, childViewsList.toArray(new DynamicObject[0]));
    }

    private OrgApiResult syncStructureWithChildView(DynamicObject[] hrBuViewExtDys, DynamicObject[] childViews) {
        DynamicObject[] updateBosStructures = this.getExistBosOrgStructures(hrBuViewExtDys, childViews, "asc");
        HashMap saveChildOrgParamToHrBuViewExtDyMap = Maps.newHashMapWithExpectedSize((int)updateBosStructures.length);
        ArrayList unfreezeChildBosOrgStructures = Lists.newArrayListWithExpectedSize((int)updateBosStructures.length);
        for (DynamicObject hrBuViewExtDy : hrBuViewExtDys) {
            Arrays.stream(childViews).forEach(childView -> this.diffOrgStructure(updateBosStructures, unfreezeChildBosOrgStructures, saveChildOrgParamToHrBuViewExtDyMap, this.structureIdToHrBuExtDyMap, hrBuViewExtDy, (DynamicObject)childView));
        }
        this.saveAllOrgParamToHrBuViewExtDyMap.putAll(saveChildOrgParamToHrBuViewExtDyMap);
        List<OrgParam> orgParams = this.mergeOrgView(this.saveAllOrgParamToHrBuViewExtDyMap.keySet());
        LOGGER.info("HEBUViewQueryListOp.syncStructureWithChildView() viewMap:{}", orgParams);
        ArrayList sortedParamList = Lists.newArrayListWithExpectedSize((int)orgParams.size());
        this.makeViewTree(orgParams, sortedParamList);
        return BosOrgServiceHelper.saveOrUpdateOrgUnit((List)sortedParamList, (DynamicObject[])updateBosStructures, (List)unfreezeChildBosOrgStructures);
    }

    private List<OrgParam> mergeOrgView(Collection<OrgParam> orgParams) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)orgParams.size());
        for (OrgParam orgParam : orgParams) {
            OrgParam orgParamTemp = map.getOrDefault(orgParam.getId(), orgParam);
            TreeMap<String, OrgDutyView> multiViewMap = orgParamTemp.getMultiViewMap();
            if (multiViewMap == null) {
                multiViewMap = new TreeMap<String, OrgDutyView>();
            }
            multiViewMap.put(orgParam.getDuty(), new OrgDutyView(orgParam.getParentId()));
            orgParamTemp.setMultiViewMap(multiViewMap);
            map.put(orgParam.getId(), orgParamTemp);
        }
        return new ArrayList<OrgParam>(map.values());
    }

    @ExcludeFromJacocoGeneratedReport
    private void makeViewTree(List<OrgParam> paramList, List<OrgParam> sortedParamList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        HashBasedTable orgParamTable = HashBasedTable.create();
        paramList.forEach(arg_0 -> HEBUViewQueryListOp.lambda$makeViewTree$4((Table)orgParamTable, arg_0));
        Set idSet = orgParamTable.rowKeySet();
        Set parentIdSet = orgParamTable.columnKeySet();
        Set rootSet = Sets.difference((Set)parentIdSet, (Set)idSet).copyInto((Set)Sets.newHashSetWithExpectedSize((int)16));
        rootSet.forEach(rootId -> this.makeSingleTree((Long)rootId, paramList, sortedParamList));
    }

    private void makeSingleTree(Long rootId, List<OrgParam> paramList, List<OrgParam> sortedParamList) {
        List<OrgParam> childrenList = paramList.stream().filter(param -> Objects.equals(rootId, param.getParentId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        sortedParamList.addAll(childrenList);
        childrenList.forEach(param -> this.makeSingleTree(param.getId(), paramList, sortedParamList));
    }

    private void syncHrBuViewExt() {
        HEBUViewQueryListOp.saveHRBUExtView(this.saveAllOrgParamToHrBuViewExtDyMap);
    }

    private void diffOrgStructure(DynamicObject[] updateBosStructures, List<DynamicObject> unfreezeChildBosOrgStructures, Map<OrgParam, DynamicObject> saveChildOrgParamToHrBuViewExtDyMap, Map<Long, DynamicObject> structureIdToHrBuExtDyMap, DynamicObject hrBuViewExtDy, DynamicObject childView) {
        String orgId = hrBuViewExtDy.getString("bosorgstructure.org.id");
        String childViewNumber = childView.getString("number");
        String newParentOrgId = hrBuViewExtDy.getString("parentorg");
        boolean isUpdateBosStructure = false;
        for (DynamicObject updateBosStructure : updateBosStructures) {
            String updateBosStructureViewNumber = updateBosStructure.getString("view.number");
            String updateBosStructureOrgId = updateBosStructure.getString("org.id");
            String oldParentOrgId = updateBosStructure.getString("parent.id");
            if (!childViewNumber.equals(updateBosStructureViewNumber) || !orgId.equals(updateBosStructureOrgId)) continue;
            isUpdateBosStructure = true;
            structureIdToHrBuExtDyMap.put(updateBosStructure.getLong("id"), hrBuViewExtDy);
            if (!oldParentOrgId.equals(newParentOrgId)) {
                updateBosStructure.set("parent.id", (Object)newParentOrgId);
            }
            if (!updateBosStructure.getBoolean("isfreeze")) break;
            unfreezeChildBosOrgStructures.add(updateBosStructure);
            break;
        }
        if (!isUpdateBosStructure) {
            OrgParam orgParam = BosOrgServiceHelper.assembleOrgParamByHrBuViewExtDy((DynamicObject)hrBuViewExtDy);
            orgParam.setDuty(childViewNumber);
            saveChildOrgParamToHrBuViewExtDyMap.put(orgParam, hrBuViewExtDy);
        }
    }

    private DynamicObject[] getExistBosOrgStructures(DynamicObject[] hrBuViewExtDys, DynamicObject[] childViews, String levelSort) {
        List childViewIds = Arrays.stream(childViews).map(view -> view.get("id")).collect(Collectors.toList());
        List orgIdList = Arrays.stream(hrBuViewExtDys).map(dy -> dy.get("bosorgstructure.org.id")).collect(Collectors.toList());
        return HRBUExtServiceHelper.getAllBosOrgStructureByViewsAndStructures(childViewIds, orgIdList, (String)levelSort);
    }

    @ExcludeFromJacocoGeneratedReport
    private void dealOperationError(BeginOperationTransactionArgs args, TXHandle txHandle, String errorMsg) {
        txHandle.markRollback();
        this.operationResult.setMessage(errorMsg);
        this.operationResult.setShowMessage(false);
        this.operationResult.setSuccess(false);
        args.setCancelOperation(true);
    }

    @ExcludeFromJacocoGeneratedReport
    private void dealOperationError(BeforeOperationArgs args, String errorMsg) {
        args.setCancelMessage(errorMsg);
        args.setCancel(true);
    }

    private static /* synthetic */ void lambda$makeViewTree$4(Table orgParamTable, OrgParam param) {
        OrgParam cfr_ignored_0 = (OrgParam)orgParamTable.put((Object)param.getId(), (Object)param.getParentId(), (Object)param);
    }
}

