/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.taxunit;

import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hbss.bussiness.servicehelper.LawEntityServiceHelper;

public class TaxUnitLawEntityLoginOp
extends HRDataBaseOp {
    private static final Log logger = LogFactory.getLog(TaxUnitLawEntityLoginOp.class);
    private static final String LAW_ENTITY = "lawentity";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add(LAW_ENTITY);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String currEntityName = this.billEntityType.getName();
        String opKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        if (!this.isInvokeService(currEntityName, opKey, dataEntities)) {
            return;
        }
        LawEntityServiceHelper.relLawEntity((String)currEntityName, (String)opKey, (DynamicObject[])dataEntities);
    }

    private boolean isInvokeService(String currEntityName, String opKey, DynamicObject[] dataEntities) {
        if (!"save".equals(opKey) && !"delete".equals(opKey)) {
            return false;
        }
        switch (opKey) {
            case "save": {
                boolean allLawIdIsEqual = true;
                for (DynamicObject dataEntity : dataEntities) {
                    Long oldLawId;
                    Long newLawId = TaxUnitLawEntityLoginOp.buildNewLawId(dataEntity);
                    if (newLawId.equals(oldLawId = TaxUnitLawEntityLoginOp.buildOldLawId(currEntityName, (Long)dataEntity.getPkValue()))) continue;
                    allLawIdIsEqual = false;
                    break;
                }
                if (allLawIdIsEqual) break;
                return true;
            }
            case "delete": {
                boolean allLawIsNull = true;
                for (DynamicObject dataEntity : dataEntities) {
                    if (Objects.isNull(dataEntity.get(LAW_ENTITY))) continue;
                    allLawIsNull = false;
                    break;
                }
                if (allLawIsNull) break;
                return true;
            }
        }
        return false;
    }

    private static Long buildNewLawId(DynamicObject dataEntity) {
        DynamicObject newLawEntity = (DynamicObject)dataEntity.get(LAW_ENTITY);
        if (!Objects.isNull(newLawEntity)) {
            return (Long)newLawEntity.getPkValue();
        }
        return 0L;
    }

    private static Long buildOldLawId(String currEntityName, Long currOpItemId) {
        DynamicObject oldLawEntity;
        DynamicObject currEntity;
        HRBaseServiceHelper currEntityHelper = new HRBaseServiceHelper(currEntityName);
        if (!(Objects.isNull(currOpItemId) || currOpItemId == 0L || Objects.isNull(currEntity = currEntityHelper.queryOne(LAW_ENTITY, (Object)currOpItemId)) || Objects.isNull(oldLawEntity = (DynamicObject)currEntity.get(LAW_ENTITY)))) {
            return (Long)oldLawEntity.getPkValue();
        }
        return 0L;
    }
}

