/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.validate;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class CostCenterOrgElEnableOpValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(CostCenterOrgElEnableOpValidator.class);

    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        String newBrled = this.getOption().getVariableValue("newBrled");
        Date newDate = null;
        try {
            newDate = HRStringUtils.isEmpty((String)newBrled) ? null : HRDateTimeUtils.parseDate((String)newBrled);
        }
        catch (ParseException e1) {
            log.error((Throwable)e1);
        }
        if (null != newDate) {
            this.handleNewDateNotNull(entities, newDate);
        } else {
            this.handleNewDateIsNull(entities, null);
        }
    }

    private void handleNewDateNotNull(ExtendedDataEntity[] entities, Date newDate) {
        for (ExtendedDataEntity entity : entities) {
            String enable = entity.getDataEntity().getDynamicObject("ccaid").getString("enable");
            if (HRStringUtils.isEmpty((String)enable) || !HRStringUtils.equals((String)enable, (String)"1")) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u5bf9\u5e94\u6210\u672c\u4e2d\u5fc3\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u64cd\u4f5c\uff01", (String)"CostCenterOrgElEnableOpValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                return;
            }
            Date brled = (Date)entity.getValue("brled");
            Date oldBred = (Date)entity.getValue("bred");
            if (null == brled) {
                this.addWarningMessage(entity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5df2\u66f4\u65b0\u4e3a\u65e9\u4e8e\u539f\u6709\u5931\u6548\u65e5\u671f\u3002\u8be5\u7ec4\u7ec7\u53ef\u80fd\u5b58\u5728\u65e0\u5f52\u5c5e\u7684\u6210\u672c\u4e2d\u5fc3\u671f\u95f4\u3002\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"CostCenterOrgElEnableOpValidator_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                return;
            }
            this.validateDate(newDate, entity, brled, oldBred);
        }
    }

    private void handleNewDateIsNull(ExtendedDataEntity[] entities, Date newDate) {
        for (ExtendedDataEntity entity : entities) {
            String enable = entity.getDataEntity().getDynamicObject("ccaid").getString("enable");
            if (HRStringUtils.isEmpty((String)enable) || !HRStringUtils.equals((String)enable, (String)"1")) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u5bf9\u5e94\u6210\u672c\u4e2d\u5fc3\u672a\u542f\u7528\uff0c\u65e0\u6cd5\u64cd\u4f5c\uff01", (String)"CostCenterOrgElEnableOpValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                return;
            }
            Date oldBred = (Date)entity.getValue("bred");
            DynamicObject adminorg = (DynamicObject)entity.getValue("adminorg");
            String adminorgNumber = adminorg.getString("number");
            Long masterid = (Long)entity.getValue("masterid");
            DynamicObject[] rows = this.queryAdminorg(adminorgNumber, masterid);
            this.addErrotMsg(newDate, entity, oldBred, rows);
        }
    }

    private void addErrotMsg(Date newDate, ExtendedDataEntity entity, Date oldBred, DynamicObject[] rows) {
        if (null != rows) {
            for (DynamicObject row : rows) {
                Date rowBrled;
                Date rowBred = row.getDate("bred");
                if (!this.elRepeated(oldBred, rowBred, newDate, rowBrled = row.getDate("brled"))) continue;
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5728\u540c\u4e00\u65f6\u95f4\u5df2\u6709\u6210\u672c\u5f52\u5c5e\u6210\u672c\u4e2d\u5fc3\uff0c\u8bf7\u8c03\u6574\u539f\u6709\u5f52\u5c5e\u5173\u7cfb\u540e\u518d\u542f\u7528", (String)"CostCenterOrgElEnableOpValidator_3", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void validateDate(Date newDate, ExtendedDataEntity entity, Date brled, Date oldBred) {
        if (newDate.compareTo(brled) < 0) {
            if (newDate.compareTo(oldBred) > 0) {
                this.addWarningMessage(entity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5df2\u66f4\u65b0\u4e3a\u65e9\u4e8e\u539f\u6709\u5931\u6548\u65e5\u671f\u3002\u8be5\u7ec4\u7ec7\u53ef\u80fd\u5b58\u5728\u65e0\u5f52\u5c5e\u7684\u6210\u672c\u4e2d\u5fc3\u671f\u95f4\u3002\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"CostCenterOrgElEnableOpValidator_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
            } else {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u751f\u6548\u65e5\u671f", (String)"CostCenterOrgElEnableOpValidator_2", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]));
            }
        } else {
            DynamicObject adminorg = (DynamicObject)entity.getValue("adminorg");
            String adminorgNumber = adminorg.getString("number");
            Long masterid = (Long)entity.getValue("masterid");
            DynamicObject[] rows = this.queryAdminorg(adminorgNumber, masterid);
            this.addErrotMsg(newDate, entity, oldBred, rows);
        }
    }

    private boolean elRepeated(Date newBred, Date bred, Date newBrled, Date brled) {
        if (newBred.compareTo(bred) > 0) {
            if (null == brled) {
                return true;
            }
            return newBred.compareTo(brled) < 0;
        }
        if (newBred.compareTo(bred) == 0) {
            return true;
        }
        return null == newBrled || newBrled.compareTo(bred) > 0;
    }

    private DynamicObject[] queryAdminorg(String adminOrgNumber, Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_costcenterorgel");
        String properties = "bred,brled";
        QFilter filter = new QFilter("adminorg.number", "=", (Object)adminOrgNumber);
        QFilter[] filters = new QFilter[]{};
        ArrayList<QFilter> filtersList = new ArrayList<QFilter>();
        filtersList.add(filter);
        if (null != id && 0L != id) {
            QFilter filterId = new QFilter("id", "!=", (Object)id);
            filtersList.add(filterId);
        }
        filters = filtersList.toArray(filters);
        DynamicObject[] rows = serviceHelper.query(properties, filters);
        return rows;
    }
}

