/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.opplugin.web.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.service.diff.DiffServiceHelper;

public class DiffCustomHandlerSaveOpValidator
extends AbstractValidator {
    public void validate() {
        String selectFields;
        DynamicObjectCollection dynObjs;
        ExtendedDataEntity[] entities = this.getDataEntities();
        if (entities.length <= 0) {
            return;
        }
        ExtendedDataEntity dataEntity = entities[0];
        this.checkOverrideMethod(dataEntity, (String)dataEntity.getValue("targetclassname"), (String)dataEntity.getValue("targetmethodname"));
        DynamicObject dynObj = (DynamicObject)dataEntity.getValue("diffhandler");
        String sourceClassName = dynObj.getString("sourceclassname");
        String sourceMethodName = dynObj.getString("sourcemethodname");
        String sourceMethodSign = dynObj.getString("sourcemethodsign");
        String isvId = ISVServiceHelper.getISVInfo().getId();
        Long id = (Long)dataEntity.getValue("id");
        QFilter[] qFilters = new QFilter[]{new QFilter("diffhandler.sourceclassname", "=", (Object)sourceClassName), new QFilter("diffhandler.sourcemethodname", "=", (Object)sourceMethodName), new QFilter("diffhandler.sourcemethodsign", "=", (Object)sourceMethodSign), new QFilter("isv", "=", (Object)isvId)};
        if (id > 0L) {
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
            qFilterList.addAll(Arrays.asList(qFilters));
            qFilterList.add(new QFilter("id", "!=", (Object)id));
            qFilters = qFilterList.toArray(new QFilter[qFilterList.size()]);
        }
        if ((dynObjs = QueryServiceHelper.query((String)"hbss_diffcusconfig", (String)(selectFields = "id,number,name"), (QFilter[])qFilters, null)).size() > 0) {
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u7ecf\u4e3a\u5f53\u524d\u57cb\u70b9\u7684\u7c7b\u3001\u65b9\u6cd5\u914d\u7f6e\u8fc7\u5dee\u5f02\u5316\u5b9e\u73b0\u7c7b\u3001\u65b9\u6cd5\uff0c\u7f16\u7801\u4e3a[%s]\uff0c\u4e0d\u5bb9\u8bb8\u91cd\u590d\u914d\u7f6e", (String)"DiffCustomHandlerSaveOpValidator_0", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), ((DynamicObject)dynObjs.get(0)).getString("number")));
        }
    }

    private void checkOverrideMethod(ExtendedDataEntity dataEntity, String targetClassName, String targetMethodName) {
        block3: {
            try {
                boolean isDuplicateMethod = DiffServiceHelper.checkClassContainDuplicateMethod((String)targetClassName, (String)targetMethodName);
                if (isDuplicateMethod) {
                    this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u7c7b[%1$s],\u5b58\u5728\u91cd\u547d\u7684\u65b9\u6cd5[%2$s],\u5dee\u5f02\u5316\u4e0d\u652f\u6301\u65b9\u6cd5\u91cd\u8f7d,\u8bf7\u8c03\u6574\u65b9\u6cd5\u547d\u540d.", (String)"DiffCustomHandlerSaveOpValidator_1", (String)"hrmp-hbss-opplugin", (Object[])new Object[0]), targetClassName, targetMethodName));
                }
            }
            catch (RuntimeException exception) {
                if (exception.getCause() instanceof ClassNotFoundException) break block3;
                throw exception;
            }
        }
    }
}

