/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRBdWhiteListServiceHelper {
    private static final Map<String, Object> defValMap = new HashMap<String, Object>(16);
    private static final Map<String, String> confKeyMap = new HashMap<String, String>(16);

    public static String getConfigField(String whiteParamType) {
        return confKeyMap.get(whiteParamType);
    }

    public static boolean existsCircularDep(String baseDataNum, String refBaseDataNum) {
        DynamicObject[] dynamicObjects;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_paramwhitelist");
        QFilter qFliter = new QFilter("refbasedata", "is not null", null);
        HashMap<String, String> depMap = new HashMap<String, String>(16);
        depMap.put(baseDataNum, refBaseDataNum);
        for (DynamicObject dynamicObject : dynamicObjects = serviceHelper.query("basedata.number,refbasedata.number", new QFilter[]{qFliter})) {
            depMap.put(dynamicObject.getString("basedata.number"), dynamicObject.getString("refbasedata.number"));
        }
        boolean hasCircularDep = false;
        for (Map.Entry entry : depMap.entrySet()) {
            HashSet<String> rootKeySet = new HashSet<String>(16);
            rootKeySet.add((String)entry.getKey());
            hasCircularDep = HRBdWhiteListServiceHelper.hasCircularDep(rootKeySet, (String)entry.getValue(), depMap);
            if (!hasCircularDep) continue;
            break;
        }
        return hasCircularDep;
    }

    public static List<String> getAllAppByCloudId(String cloudId) {
        String sql = " select fid from t_meta_bizapp where fbizcloudid = ? ";
        String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
            sql = sql + " and fid not in (" + appBlacklist + ")";
        }
        Object[] filters = new String[]{cloudId};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, rs -> {
            ArrayList<String> result = new ArrayList<String>(10);
            while (rs.next()) {
                result.add(rs.getString("fid"));
            }
            return result;
        });
    }

    public static List<String> getEntityNumByAppId(String appId) {
        String sql = "select fid from t_meta_bizapp where fmasterid = ? ";
        String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
            sql = sql + " and fid not in (" + appBlacklist + ")";
        }
        Object[] filters = new String[]{appId};
        List rtnList = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, rs -> {
            ArrayList<String> result = new ArrayList<String>(10);
            while (rs.next()) {
                result.add(rs.getString("fid"));
            }
            return result;
        });
        rtnList.add(appId);
        return rtnList;
    }

    private static boolean hasCircularDep(Set<String> rootKeySet, String curVal, Map<String, String> map) {
        if (curVal == null) {
            return false;
        }
        if (rootKeySet.contains(curVal)) {
            return true;
        }
        rootKeySet.add(curVal);
        return HRBdWhiteListServiceHelper.hasCircularDep(rootKeySet, map.get(curVal), map);
    }

    public static DynamicObject queryWhiteListByEntityNum(String entityNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_paramwhitelist");
        QFilter qFliter = new QFilter("basedata", "=", (Object)entityNumber);
        return serviceHelper.queryOne("basedata.number,refbasedata.number,entryentity.paramtype,entryentity.modifyenable,entryentity.defval", new QFilter[]{qFliter});
    }

    public static DynamicObject[] queryAllWhiteList() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_paramwhitelist");
        return serviceHelper.query("basedata.number,refbasedata.number,entryentity.paramtype,entryentity.modifyenable,entryentity.defval", new QFilter[0]);
    }

    public static Set<String> queryAllBanModifyBDNum() {
        String sql = "select fbasedata\nfrom t_hbss_paramwhitelist a\nwhere not exists(\n        select fid from t_hbss_paramwhitedet b where a.fid = b.fid and b.fmodifyenable = '1'\n    )";
        return (Set)HRDBUtil.query((DBRoute)DBRoute.of((String)"hmp"), (String)sql, null, rs -> {
            HashSet<String> set = new HashSet<String>(16);
            while (rs.next()) {
                set.add(rs.getString("fbasedata"));
            }
            return set;
        });
    }

    public static Map<String, Object> getDefVal(DynamicObject whiteListDyo) {
        DynamicObjectCollection entryEntity = whiteListDyo.getDynamicObjectCollection("entryentity");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (DynamicObject dynamicObject : entryEntity) {
            String modifyEnable = dynamicObject.getString("modifyenable");
            if (!"0".equals(modifyEnable)) continue;
            Object val = defValMap.get(dynamicObject.getString("defval"));
            String key = confKeyMap.get(dynamicObject.getString("paramtype"));
            result.put(key, val);
        }
        return result;
    }

    static {
        defValMap.put("audit_1", true);
        defValMap.put("audit_0", false);
        defValMap.put("enable_1", "1");
        defValMap.put("enable_0", "10");
        defValMap.put("log_1", true);
        defValMap.put("log_0", false);
        confKeyMap.put("audit", "auditcheck");
        confKeyMap.put("log", "changecheck");
        confKeyMap.put("enable", "enablestatus");
    }
}

