/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.config.HRBdWhiteListServiceHelper;
import org.apache.commons.collections.MapUtils;

public class HRConfigServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRConfigServiceHelper.class);
    private static final int ENTITY_MAP_INITIALCAPACITY = 300;

    public static List<String> getAllExtHrmpEntNums() {
        String sql = "select fnumber from t_meta_entitydesign where finheritpath like '1942c188000065ac,ab7efc31000015ac,2+QPVWEP=LYN%' union\nselect fnumber from t_meta_entitydesign where finheritpath like '1942c188000065ac,5f7203ba00002eac,2+R939/K+92X%' union\nselect fnumber from t_meta_entitydesign where finheritpath like '1942c188000065ac,2+QE4JA9QV27%' union\nselect fnumber from t_meta_entitydesign where finheritpath like '1942c188000065ac,b0d31cea000001ac,2+R7VHVKOQHP%' union\nselect fnumber from t_meta_entitydesign where finheritpath like '1942c188000065ac,5f7203ba00002eac,6138b0d200000eac,2+R8ZH7NO=6T%' union\nselect fnumber from t_meta_entitydesign where finheritpath like '1942c188000065ac,ab7efc31000015ac,2A=C=/GL8Y32%' union\nselect fnumber from t_meta_entitydesign where finheritpath like '1942c188000065ac,b0d31cea000001ac,b0d31cea000006ac,2+R8=BY/RB68%'";
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, rs -> {
            ArrayList<String> result = new ArrayList<String>(16);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
            return result;
        });
    }

    public static List<Map<String, String>> getBizCloud() {
        String localeid = RequestContext.get().getLang().name();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid, al.fname ");
        sql.append(" from t_meta_bizcloud a ");
        sql.append(" inner join t_meta_bizcloud_l al ");
        sql.append(" on a.fid = al.fid ");
        sql.append(" where al.flocaleid = '").append(localeid).append("' ");
        sql.append(" and a.fvisible = '1' ");
        sql.append(" and a.fnumber in (").append(HRConfigServiceHelper.getAllHRCloudIdInStr()).append(")");
        String cloudBlacklist = RunModeServiceHelper.getCloudIdsFromBlackList();
        if (HRStringUtils.isNotEmpty((String)cloudBlacklist)) {
            sql.append(" and a.fid not in (").append(cloudBlacklist).append(") ");
        }
        sql.append(" and ( exists ( ");
        sql.append("   select 1 from t_meta_entitydesign e ");
        sql.append("   left join t_meta_bizunitrelform b ");
        sql.append("   on e.fid = b.fformid ");
        sql.append("   left join t_meta_bizapp c ");
        sql.append("   on b.fbizappid = c.fid  ");
        sql.append("   LEFT JOIN t_meta_mainentityinfo f  ");
        sql.append("   on f.fdentityid = b.fformid  ");
        sql.append("   where e.fmodeltype IN (");
        sql.append("'BillFormModel', 'BaseFormModel', 'QueryListModel'");
        sql.append(") ");
        sql.append("   and  c.fbizcloudid = a.fid ");
        sql.append("   and  c.fvisible = '1' ");
        sql.append("   and  e.fistemplate = '0' ) ");
        sql.append(" ) order by a.fseq asc");
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), null, rs -> {
            ArrayList result = new ArrayList(16);
            while (rs.next()) {
                HashMap<String, String> bizCloudMap = new HashMap<String, String>(16);
                String value = "1_split_" + rs.getString(1);
                bizCloudMap.put("id", value);
                bizCloudMap.put("name", rs.getString(2));
                result.add(bizCloudMap);
            }
            return result;
        });
    }

    private static String getAllHRCloudIdInStr() {
        StringBuilder stringBuffer = new StringBuilder();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_cloud");
        DynamicObject[] clouds = serviceHelper.queryOriginalArray("cloud.number", null);
        Arrays.stream(clouds).forEach(dyn -> stringBuffer.append('\'').append(dyn.getString("cloud.number")).append("',"));
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }

    public static List<String> findBizappExistsEntity(String bizCloudId) {
        Object[] filters = new String[]{bizCloudId};
        String sql = "SELECT A.FID, A.FMASTERID  FROM T_META_BIZAPP A WHERE A.FBIZCLOUDID = ? AND a.fdeploystatus = '2'  AND ( EXISTS (     SELECT 1 FROM T_META_ENTITYDESIGN E   LEFT JOIN T_META_BIZUNITRELFORM B     ON E.FID = B.FFORMID     LEFT JOIN t_meta_mainentityinfo f     on f.fdentityid = b.fformid     WHERE  B.FBIZAPPID = A.FID    AND E.FMODELTYPE IN ('BillFormModel', 'BaseFormModel', 'QueryListModel')    AND e.FISTEMPLATE = '0' )  )";
        Set idSet = (Set)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, rs -> {
            HashSet<String> ids = new HashSet<String>(300);
            while (rs.next()) {
                String id = rs.getString(1);
                String masterid = rs.getString(2);
                if (HRStringUtils.isNotEmpty((String)masterid)) {
                    ids.add(masterid);
                    continue;
                }
                ids.add(id);
            }
            return ids;
        });
        return new ArrayList<String>(idSet);
    }

    public static List<String> getAllExtAppId(String originalAppId) {
        String sb = "select fid from t_meta_bizapp where fmasterid = '" + originalAppId + '\'' + " and fid <> '" + originalAppId + '\'';
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sb, null, rs -> {
            ArrayList<String> result = new ArrayList<String>(16);
            while (rs.next()) {
                result.add(rs.getString("fid"));
            }
            return result;
        });
    }

    public static List<String> getEntityNumByAppId(String appId) {
        StringBuilder sql = new StringBuilder("select a.fnumber from t_meta_entitydesign a left join t_meta_bizunitrelform b on a.fid = b.fformid where a.fistemplate = '0' and b.fbizappid in (?");
        List<String> allExtAppId = HRConfigServiceHelper.getAllExtAppId(appId);
        Object[] filters = new String[allExtAppId.size() + 1];
        for (int index = 0; index < allExtAppId.size() + 1; ++index) {
            if (index == 0) {
                filters[0] = appId;
                continue;
            }
            sql.append(" ,? ");
            filters[index] = allExtAppId.get(index - 1);
        }
        sql.append(" ) ");
        String appNumber = AppMetadataCache.getAppNumberById((String)appId);
        String entityNumBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNumber);
        if (HRStringUtils.isNotEmpty((String)entityNumBlacklist)) {
            sql.append(" and a.fnumber not in (").append(entityNumBlacklist).append(')');
        }
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql.toString(), (Object[])filters, rs -> {
            ArrayList<String> result = new ArrayList<String>(300);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
            return result;
        });
    }

    public static List<String> getEntityNumByCloudId(String cloudId) {
        String sql = "select a.fnumber from t_meta_entitydesign a  left join t_meta_bizunitrelform b on a.fid = b.fformid  left join t_meta_bizapp c on b.fbizappid = c.fid  where c.fbizcloudid = ?  and  c.fvisible = '1' and a.fistemplate = '0' ";
        String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
        if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
            sql = sql + " and c.fid not in (" + appBlacklist + ")";
        }
        Object[] filters = new String[]{cloudId};
        return (List)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])filters, rs -> {
            ArrayList<String> result = new ArrayList<String>(300);
            while (rs.next()) {
                result.add(rs.getString("fnumber"));
            }
            return result;
        });
    }

    public static Map<String, Object> getParamByEntity(String number) {
        HRBaseServiceHelper hbssAppBusinessType = new HRBaseServiceHelper("hbss_parameterconfig");
        QFilter appQFliter = new QFilter("basedatafield", "=", (Object)number);
        DynamicObject dynamicObject = hbssAppBusinessType.queryOriginalOne("auditcheck,changecheck,isopen,enablestatus", new QFilter[]{appQFliter});
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!Objects.isNull(dynamicObject)) {
            result.put("auditcheck", dynamicObject.get("auditcheck"));
            result.put("changecheck", dynamicObject.get("changecheck"));
            result.put("enablestatus", dynamicObject.get("enablestatus"));
        }
        LOGGER.info("HR BaseData:{} ParamConf:{}", (Object)number, result);
        return HRConfigServiceHelper.getWhiteListConf(number, result);
    }

    private static Map<String, Object> getWhiteListConf(String entityNumber, Map<String, Object> param) {
        DynamicObject whiteListDyo = HRBdWhiteListServiceHelper.queryWhiteListByEntityNum(entityNumber);
        if (whiteListDyo == null) {
            return param;
        }
        String refBaseDataNum = whiteListDyo.getString("refbasedata.number");
        if (HRStringUtils.isNotEmpty((String)refBaseDataNum)) {
            return HRConfigServiceHelper.getParamByEntity(refBaseDataNum);
        }
        Map<String, Object> whiteListDefValMap = HRBdWhiteListServiceHelper.getDefVal(whiteListDyo);
        if (MapUtils.isNotEmpty(whiteListDefValMap)) {
            if (MapUtils.isEmpty(param)) {
                param = HRConfigServiceHelper.querySystem();
            }
            param.putAll(whiteListDefValMap);
            LOGGER.info("HR BaseData:{} ParamConf + WhiteList:{}", (Object)entityNumber, param);
        }
        return param;
    }

    private static Map<String, Object> querySystem() {
        long orgId = RequestContext.get().getOrgId() == 0L ? OrgServiceUtil.getHRRootOrgId() : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("XYRL3+A8Z+Z", Long.valueOf(orgId));
        Map sysParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        boolean changeLog = false;
        if (!Objects.isNull(sysParam.get("changecheck"))) {
            changeLog = (Boolean)sysParam.get("changecheck");
        }
        boolean auditcheck = false;
        if (!Objects.isNull(sysParam.get("auditcheck"))) {
            auditcheck = (Boolean)sysParam.get("auditcheck");
        }
        String enablestatus = "1";
        if (!Objects.isNull(sysParam.get("enablestatus"))) {
            enablestatus = (String)sysParam.get("enablestatus");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("auditcheck", auditcheck);
        result.put("changecheck", changeLog);
        result.put("enablestatus", enablestatus);
        return result;
    }
}

