/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.service.hrbu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.service.hrbu.ViewComparator;
import kd.hr.hbss.bussiness.servicehelper.BosOrgServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;

public class HRBUSyncStrategyService {
    private static final Log LOGGER = LogFactory.getLog(HRBUSyncStrategyService.class);
    private static final ExecutorService es = ThreadPools.newExecutorService((String)HRBUSyncStrategyService.class.getName(), (int)10);
    private static final String SELECT_FIELDS = "id,org.name,view,org,parent,enable,longnumber,status,isfreeze";

    public static Map<String, List<OrgParam>> syncValidate(Long oldViewId, Long newViewId) {
        long start = System.currentTimeMillis();
        List<Long> childViewIds = HRBUExtServiceHelper.getChildViewIds(oldViewId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter("view", "in", childViewIds);
        DynamicObject[] viewDys = serviceHelper.query(SELECT_FIELDS, viewFilter.toArray(), "longnumber");
        Map<Long, List<DynamicObject>> oldViewDys = Arrays.stream(viewDys).collect(Collectors.groupingBy(dy -> dy.getLong("view.id")));
        QFilter newViewFilter = new QFilter("view", "=", (Object)newViewId);
        DynamicObject[] newViewStrc = serviceHelper.query(SELECT_FIELDS, newViewFilter.toArray(), "longnumber");
        List<DynamicObject> newViewDys = Arrays.stream(newViewStrc).collect(Collectors.toList());
        ExecutorCompletionService<Map<String, List<OrgParam>>> completionService = new ExecutorCompletionService<Map<String, List<OrgParam>>>(es);
        for (Map.Entry<Long, List<DynamicObject>> entry : oldViewDys.entrySet()) {
            Long childViewId = entry.getKey();
            List<DynamicObject> childViewDys = entry.getValue();
            completionService.submit(new ViewComparator(childViewDys, newViewDys, childViewId));
        }
        HashMap<String, List<OrgParam>> result = new HashMap<String, List<OrgParam>>();
        ArrayList allOrgParams = new ArrayList(16);
        ArrayList freezeOrgParams = new ArrayList(16);
        ArrayList freezeOrgParams2 = new ArrayList(16);
        ArrayList freezeOrgParams3 = new ArrayList(16);
        ArrayList unfreezeOrgParams = new ArrayList(16);
        try {
            for (int i = 0; i < oldViewDys.size(); ++i) {
                Map paramsMap = (Map)completionService.take().get();
                allOrgParams.addAll((Collection)paramsMap.get("all"));
                freezeOrgParams.addAll((Collection)paramsMap.get("freeze"));
                freezeOrgParams2.addAll((Collection)paramsMap.get("freeze2"));
                freezeOrgParams3.addAll((Collection)paramsMap.get("freeze3"));
                unfreezeOrgParams.addAll((Collection)paramsMap.get("unfreeze"));
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error((Throwable)e);
        }
        long end = System.currentTimeMillis();
        LOGGER.info("HRBUcaSyncStrategyTask : HRBUSyncStrategyService.syncValidate execute time : {}", (Object)(end - start));
        result.put("all", allOrgParams);
        result.put("freeze", freezeOrgParams);
        result.put("freeze2", freezeOrgParams2);
        result.put("freeze3", freezeOrgParams3);
        result.put("unfreeze", unfreezeOrgParams);
        return result;
    }

    public static List<DynamicObject> getChildViewDys(long parentId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_hrbuca");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        Set<Long> versionView = HRBUValidationService.getVersionView();
        QFilter idFilter = new QFilter("id", "in", versionView);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("id,parent,number,name", new QFilter[]{enableFilter, statusFilter, idFilter});
        ArrayList<Long> childViewIds = new ArrayList<Long>(dys.length);
        ArrayList<Long> parentIds = new ArrayList<Long>(dys.length);
        parentIds.add(parentId);
        HRBUSyncStrategyService.getChildViews(childViewIds, dys, parentIds);
        childViewIds.add(parentId);
        return Arrays.stream(dys).filter(dy -> childViewIds.contains(dy.getLong("id"))).collect(Collectors.toList());
    }

    private static void getChildViews(List<Long> childViewIds, DynamicObject[] dys, List<Long> parentIds) {
        List childIds;
        if (dys != null && dys.length > 0 && (childIds = Arrays.stream(dys).filter(dy -> parentIds.contains(dy.getLong("parent"))).collect(Collectors.toList())).size() > 0) {
            List<Long> list = childIds.stream().map(dy -> dy.getLong("id")).distinct().collect(Collectors.toList());
            childViewIds.addAll(list);
            HRBUSyncStrategyService.getChildViews(childViewIds, dys, list);
        }
    }

    public static Map<String, List<OrgParam>> compareTreeStructure(List<DynamicObject> oldViewStrc, List<DynamicObject> newParentViewStrc, long oldViewId) {
        DynamicObject oldDyn;
        Map<Long, DynamicObject> oldViewStrcMap = oldViewStrc.stream().collect(Collectors.toMap(dy -> dy.getLong("org.id"), dy -> dy, (oldData, newData) -> newData));
        Map<Long, DynamicObject> newViewStrcMap = newParentViewStrc.stream().collect(Collectors.toMap(dy -> dy.getLong("org.id"), dy -> dy, (oldData, newData) -> newData));
        HashMap<String, List<OrgParam>> map = new HashMap<String, List<OrgParam>>();
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>(16);
        ArrayList<OrgParam> freezeParams = new ArrayList<OrgParam>(16);
        ArrayList<OrgParam> freezeParams2 = new ArrayList<OrgParam>(16);
        ArrayList<OrgParam> freezeParams3 = new ArrayList<OrgParam>(16);
        ArrayList<OrgParam> unFreezeParams = new ArrayList<OrgParam>(16);
        for (DynamicObject dynamicObject : newParentViewStrc) {
            Long orgId = dynamicObject.getLong("org.id");
            if (orgId.equals(0L)) continue;
            DynamicObject newDyn = newViewStrcMap.get(orgId);
            oldDyn = oldViewStrcMap.get(orgId);
            boolean newDynEnable = newDyn.getBoolean("enable");
            boolean newDynIsFreeze = newDyn.getBoolean("isfreeze");
            if (Objects.isNull(oldDyn)) {
                OrgParam orgParam = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.addDuty, newDyn.getString("org.name"));
                orgParams.add(orgParam);
                if (!newDynEnable) {
                    OrgParam orgParam2 = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.disableDuty, newDyn.getString("org.name"));
                    orgParams.add(orgParam2);
                }
                if (!newDynIsFreeze) continue;
                OrgParam orgParam3 = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.freeze, newDyn.getString("org.name"));
                freezeParams.add(orgParam3);
                continue;
            }
            boolean oldDynEnable = oldDyn.getBoolean("enable");
            boolean oldDynIsFreeze = oldDyn.getBoolean("isfreeze");
            if (!HRBUSyncStrategyService.compareOrg(newDyn, oldDyn)) {
                OrgParam orgParam = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.update, newDyn.getString("org.name"));
                orgParams.add(orgParam);
            }
            if (newDynEnable && !oldDynEnable) {
                OrgParam orgParam2 = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.enableDuty, newDyn.getString("org.name"));
                orgParams.add(orgParam2);
            } else if (!newDynEnable && oldDynEnable) {
                OrgParam orgParam3 = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.disableDuty, newDyn.getString("org.name"));
                orgParams.add(orgParam3);
            }
            if (newDynIsFreeze && !oldDynIsFreeze) {
                OrgParam orgParam4 = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.freeze, newDyn.getString("org.name"));
                freezeParams3.add(orgParam4);
                continue;
            }
            if (newDynIsFreeze || !oldDynIsFreeze) continue;
            OrgParam orgParam5 = BosOrgServiceHelper.assembleUpdateOrgParam(newDyn.getLong("org.id"), String.valueOf(oldViewId), newDyn.getLong("parent.id"), OperationType.unfreeze, newDyn.getString("org.name"));
            unFreezeParams.add(orgParam5);
        }
        Set<Long> oldOrgIdSet = oldViewStrcMap.keySet();
        Set<Long> newOrgIdSet = newViewStrcMap.keySet();
        oldOrgIdSet.removeAll(newOrgIdSet);
        for (Long orgId : oldOrgIdSet) {
            oldDyn = oldViewStrcMap.get(orgId);
            boolean isFreeze = oldDyn.getBoolean("isfreeze");
            if (isFreeze) continue;
            OrgParam orgParam = BosOrgServiceHelper.assembleUpdateOrgParam(oldDyn.getLong("org.id"), String.valueOf(oldViewId), oldDyn.getLong("parent.id"), OperationType.freeze, oldDyn.getString("org.name"));
            freezeParams2.add(orgParam);
        }
        map.put("all", orgParams);
        map.put("freeze", freezeParams);
        map.put("freeze2", freezeParams2);
        map.put("freeze3", freezeParams3);
        map.put("unfreeze", unFreezeParams);
        return map;
    }

    private static boolean compareOrg(DynamicObject newDyn, DynamicObject oldDyn) {
        return newDyn.getLong("org.id") == oldDyn.getLong("org.id") && newDyn.getLong("parent.id") == oldDyn.getLong("parent.id");
    }
}

