/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.service.hrbu.capacity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbss.common.util.CapacityUtils;

public class CapacityDictionaryService {
    private static final Log LOGGER = LogFactory.getLog(CapacityDictionaryService.class);

    public static void intiCapacityDimTree(ITreeModel treeModel, IListView view) {
        TreeNode root = CapacityDictionaryService.buildAllDimTreeRoot(false, false);
        treeModel.setRoot(root);
        treeModel.setCurrentNodeId((Object)root.getId());
        Object rootGroupId = view.getFormShowParameter().getCustomParams().get("rootgroupid");
        if (null != rootGroupId) {
            String firstLevelDimId = rootGroupId.toString();
            HRBaseServiceHelper capDimHelper = new HRBaseServiceHelper("hbss_capacitygroup");
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter parenDimFilter = new QFilter("parentdim", "=", (Object)0L);
            DynamicObject[] allFirstLevelDims = capDimHelper.query(new QFilter[]{statusFilter, enableFilter, parenDimFilter});
            for (int i = 0; i < allFirstLevelDims.length; ++i) {
                DynamicObject allFirstLevelDim = allFirstLevelDims[i];
                String currFirstLevelDimId = allFirstLevelDim.getString("id");
                if (firstLevelDimId.equals(currFirstLevelDimId)) continue;
                root.deleteChildNode(currFirstLevelDimId);
            }
            treeModel.setCurrentNodeId((Object)firstLevelDimId);
        }
    }

    public static void hiddenTreeViewBtn(IListView view) {
        view.setVisible(Boolean.valueOf(false), new String[]{"btnnew", "btnedit", "btndel"});
    }

    public static void refreshDimTreeNode(RefreshNodeEvent evt, ITreeModel treeModel, IListView view) {
        String currentNodeId = String.valueOf(treeModel.getCurrentNodeId());
        TreeNode currNode = treeModel.getRoot().getTreeNode(currentNodeId);
        String parentNodeId = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
        if (null != currNode) {
            parentNodeId = currNode.getParentid();
        }
        List<TreeNode> childNodes = null;
        childNodes = "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(currentNodeId) ? CapacityDictionaryService.buildTreeRoot(false, false) : CapacityDictionaryService.buildNode(treeModel, currentNodeId, false, false);
        if (null == childNodes && "hbss_capacitygroup".equals(view.getBillFormId())) {
            treeModel.setCurrentNodeId((Object)parentNodeId);
            evt.setNodeId((Object)parentNodeId);
            view.invokeOperation("refresh");
        }
        evt.setChildNodes(childNodes);
    }

    public static Set<Long> getCurrNodeAllChildrenIds(String currNodeId) {
        TreeNode root = CapacityDictionaryService.buildAllDimTreeRoot(true, true);
        boolean containTreeNode = CapacityUtils.isContainTreeNode((TreeNode)root, (String)currNodeId);
        HashSet<Long> nodeIdList = new HashSet<Long>(16);
        if (containTreeNode) {
            TreeNode currNode = root.getTreeNode(currNodeId, 5);
            if (null == currNode) {
                return nodeIdList;
            }
            return CapacityDictionaryService.buildNodeIds(currNode, nodeIdList);
        }
        return nodeIdList;
    }

    public static Set<Long> getCurrNodeEnableChildrenIds(String currNodeId) {
        TreeNode root = CapacityDictionaryService.buildAllDimTreeRoot(false, false);
        boolean containTreeNode = CapacityUtils.isContainTreeNode((TreeNode)root, (String)currNodeId);
        HashSet<Long> nodeIdList = new HashSet<Long>(16);
        if (containTreeNode) {
            TreeNode currNode = root.getTreeNode(currNodeId, 5);
            if (null == currNode) {
                return nodeIdList;
            }
            return CapacityDictionaryService.buildNodeIds(currNode, nodeIdList);
        }
        return nodeIdList;
    }

    public static List<TreeNode> buildTreeRoot(boolean isIncludeSaveAndSubmitDim, boolean isIncludeDisableDim) {
        QFilter[] qFilterArray;
        ArrayList<TreeNode> dimNodeList = new ArrayList<TreeNode>(16);
        ArrayList<TreeNode> allDimNodeList = new ArrayList<TreeNode>(16);
        HashMap<String, TreeNode> treeMap = new HashMap<String, TreeNode>(16);
        HRBaseServiceHelper capDimHelper = new HRBaseServiceHelper("hbss_capacitygroup");
        QFilter qFilter = null;
        if (!isIncludeDisableDim) {
            qFilter = new QFilter("enable", "=", (Object)"1");
        }
        if (!isIncludeSaveAndSubmitDim) {
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            if (null != qFilter) {
                qFilter.and(statusFilter);
            } else {
                qFilter = statusFilter;
            }
        }
        if (null == qFilter) {
            qFilterArray = new QFilter[]{};
        } else {
            QFilter[] qFilterArray2 = new QFilter[1];
            qFilterArray = qFilterArray2;
            qFilterArray2[0] = qFilter;
        }
        QFilter[] qFilters = qFilterArray;
        DynamicObject[] dims = capDimHelper.query("id,number,name,parentdim,type,description,index", qFilters, "number asc");
        for (DynamicObject dim : dims) {
            String dimId = dim.getString("id");
            TreeNode node = new TreeNode();
            node.setId(dimId);
            node.setText(dim.getString("name"));
            DynamicObject parentDim = dim.getDynamicObject("parentdim");
            if (null == parentDim || parentDim.getLong("id") == 0L) {
                node.setParentid("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
                node.setLeaf(false);
                dimNodeList.add(node);
            } else {
                String parentDimId = parentDim.getString("id");
                node.setLeaf(true);
                node.setParentid(parentDimId);
            }
            treeMap.put(dimId, node);
            allDimNodeList.add(node);
        }
        for (TreeNode currTreeNode : allDimNodeList) {
            TreeNode parentNode;
            String currParentId = currTreeNode.getParentid();
            if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(currParentId) || null == (parentNode = (TreeNode)treeMap.get(currParentId))) continue;
            ArrayList<TreeNode> children = parentNode.getChildren();
            if (null == children) {
                children = new ArrayList<TreeNode>();
            }
            children.add(currTreeNode);
            parentNode.setChildren(children);
        }
        return dimNodeList;
    }

    public static TreeNode buildAllDimTreeRoot(boolean isIncludeSaveAndSubmitDim, boolean isIncludeDisableDim) {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"CapacityDictionaryService_0", (String)"hrmp-hbss-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        root.setIsOpened(true);
        List<TreeNode> dimNodes = CapacityDictionaryService.buildTreeRoot(isIncludeSaveAndSubmitDim, isIncludeDisableDim);
        root.addChildren(dimNodes);
        return root;
    }

    public static int getEndChildrenNodeMaxLevel(TreeNode root, String startNodeId) {
        if (StringUtils.isEmpty((CharSequence)startNodeId)) {
            return 0;
        }
        TreeNode startNode = root.getTreeNode(startNodeId);
        if (startNode == null) {
            return 0;
        }
        if (startNode.getChildren() == null) {
            return 1;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(1);
        map.put("maxDepth", 2);
        int currNodeLevel = root.getNodeLevel(startNodeId, 0);
        CapacityDictionaryService.lookEndChildrenNode(root, startNode, currNodeLevel, map);
        return (Integer)map.get("maxDepth");
    }

    public static List<Long> getParentIds(TreeNode root, TreeNode treeNode) {
        ArrayList<Long> parentIds = new ArrayList<Long>(16);
        CapacityDictionaryService.buildParentIds(root, treeNode, parentIds);
        return parentIds;
    }

    public static QFilter getDataRuleFilter(long userId, String appId, String entityNumber, String permissionItem) {
        QFilter dataRuleFilter = (QFilter)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getDataRule", (Object[])new Object[]{userId, appId, entityNumber, permissionItem, null});
        return dataRuleFilter;
    }

    private static void buildParentIds(TreeNode root, TreeNode treeNode, List<Long> parentIds) {
        String parentId = treeNode.getParentid();
        if (StringUtils.isEmpty((CharSequence)parentId) || "8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(parentId)) {
            return;
        }
        parentIds.add(Long.parseLong(parentId));
        CapacityDictionaryService.buildParentIds(root, root.getTreeNode(parentId), parentIds);
    }

    private static void lookEndChildrenNode(TreeNode root, TreeNode currNode, int startNodeLevel, Map<String, Integer> map) {
        List children;
        int currNodeLevel = root.getNodeLevel(currNode.getId(), 0);
        int currNodeDepth = currNodeLevel - startNodeLevel;
        if (currNodeDepth >= map.get("maxDepth")) {
            Integer maxDepth;
            Integer n = maxDepth = map.get("maxDepth");
            Integer n2 = maxDepth = Integer.valueOf(maxDepth + 1);
            map.put("maxDepth", maxDepth);
        }
        if (null != (children = currNode.getChildren())) {
            for (int i = 0; i < children.size(); ++i) {
                TreeNode treeNode = (TreeNode)children.get(i);
                CapacityDictionaryService.lookEndChildrenNode(root, treeNode, startNodeLevel, map);
            }
        }
    }

    public static Set<String> getAllChildrenNodeIds(TreeNode root, String currNodeId) {
        HashSet<String> childrenDimIds = new HashSet<String>(16);
        CapacityDictionaryService.lookUpCurrNode(root, childrenDimIds, currNodeId);
        return childrenDimIds;
    }

    private static List<TreeNode> buildNode(ITreeModel treeModel, String currentNodeId, boolean isIncludeSaveAndSubmitDim, boolean isIncludeDisableDim) {
        TreeNode currNode = treeModel.getRoot().getTreeNode(currentNodeId, 5);
        if (null == currNode) {
            return null;
        }
        Set<Long> nodeIdList = new HashSet<Long>(16);
        nodeIdList = CapacityDictionaryService.buildNodeIds(currNode, nodeIdList);
        HRBaseServiceHelper capDimHelper = new HRBaseServiceHelper("hbss_capacitygroup");
        QFilter qFilter = new QFilter("parentdim", "in", nodeIdList);
        qFilter.or(new QFilter("id", "in", nodeIdList));
        if (!isIncludeDisableDim) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            qFilter.and(enableFilter);
        }
        if (!isIncludeSaveAndSubmitDim) {
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            qFilter.and(statusFilter);
        }
        DynamicObject[] dims = capDimHelper.query("id,number,name,parentdim,type,description,index", new QFilter[]{qFilter}, "number asc");
        HashMap<String, TreeNode> treeMap = new HashMap<String, TreeNode>(16);
        ArrayList<TreeNode> allTreeNode = new ArrayList<TreeNode>(16);
        for (DynamicObject dim : dims) {
            String dimId = dim.getString("id");
            TreeNode node = new TreeNode();
            node.setId(dimId);
            node.setText(dim.getString("name"));
            DynamicObject parentDim = dim.getDynamicObject("parentdim");
            if (StringUtils.equals((CharSequence)currentNodeId, (CharSequence)dimId)) {
                if (null == parentDim || parentDim.getLong("id") == 0L) {
                    node.setParentid("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
                } else {
                    node.setParentid(parentDim.getString("id"));
                }
            } else {
                node.setParentid(parentDim.getString("id"));
            }
            treeMap.put(dimId, node);
            allTreeNode.add(node);
        }
        for (TreeNode currDimNode : allTreeNode) {
            ArrayList<TreeNode> children;
            String currParentId = currDimNode.getParentid();
            if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(currParentId) || StringUtils.equals((CharSequence)currDimNode.getId(), (CharSequence)currentNodeId)) continue;
            TreeNode parentNode = (TreeNode)treeMap.get(currParentId);
            if (parentNode == null) {
                parentNode = treeModel.getRoot().getTreeNode(currParentId);
            }
            if (null == (children = parentNode.getChildren())) {
                children = new ArrayList<TreeNode>();
            }
            children.add(currDimNode);
            parentNode.setChildren(children);
        }
        CapacityDictionaryService.updateCurrNode(treeModel.getRoot(), (TreeNode)treeMap.get(currentNodeId), currentNodeId);
        if (treeMap.isEmpty() || null == treeMap.get(currentNodeId)) {
            return null;
        }
        List childNodes = ((TreeNode)treeMap.get(currentNodeId)).getChildren();
        return childNodes;
    }

    private static Set<Long> buildNodeIds(TreeNode currNode, Set<Long> nodeIdList) {
        String currNodeId = currNode.getId();
        nodeIdList.add(Long.parseLong(currNodeId));
        List childrenNode = currNode.getChildren();
        if (childrenNode != null) {
            for (int i = 0; i < childrenNode.size(); ++i) {
                TreeNode treeNode = (TreeNode)childrenNode.get(i);
                if (null == treeNode) continue;
                CapacityDictionaryService.buildNodeIds(treeNode, nodeIdList);
            }
        }
        return nodeIdList;
    }

    private static void updateCurrNode(TreeNode selectTreeNode, TreeNode latestCurrNode, String currentNodeId) {
        List children = selectTreeNode.getChildren();
        if (null == children || children.size() == 0) {
            return;
        }
        ListIterator<TreeNode> treeNodeListIterator = children.listIterator();
        while (treeNodeListIterator.hasNext()) {
            TreeNode treeNode = (TreeNode)treeNodeListIterator.next();
            if (null == treeNode) {
                treeNodeListIterator.remove();
                continue;
            }
            String id = treeNode.getId();
            if (StringUtils.equals((CharSequence)id, (CharSequence)currentNodeId)) {
                if (null == latestCurrNode) {
                    treeNodeListIterator.remove();
                    break;
                }
                treeNodeListIterator.set(latestCurrNode);
                break;
            }
            CapacityDictionaryService.updateCurrNode(treeNode, latestCurrNode, currentNodeId);
        }
    }

    private static void lookUpCurrNode(TreeNode startTreeNode, Set<String> childrenNodeIds, String currNodeId) {
        List children = startTreeNode.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            TreeNode currTreeNode = (TreeNode)children.get(i);
            String currTreeNodeId = currTreeNode.getId();
            if (StringUtils.equals((CharSequence)currTreeNodeId, (CharSequence)currNodeId)) {
                CapacityDictionaryService.getChildrenDimIds(currTreeNode, childrenNodeIds);
                break;
            }
            CapacityDictionaryService.lookUpCurrNode(currTreeNode, childrenNodeIds, currNodeId);
        }
    }

    private static void getChildrenDimIds(TreeNode currTreeNode, Set<String> childrenNodeIds) {
        List children = currTreeNode.getChildren();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            TreeNode treeNode = (TreeNode)children.get(i);
            childrenNodeIds.add(treeNode.getId());
            if (null == treeNode.getChildren()) continue;
            CapacityDictionaryService.getChildrenDimIds(treeNode, childrenNodeIds);
        }
    }
}

