/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbss.bussiness.service.hrbu.HRBUSyncStrategyService;
import kd.hr.hbss.common.constants.HRBUConstants;

public class BosOrgServiceHelper {
    private static final Log logger = LogFactory.getLog(BosOrgServiceHelper.class);
    private static final String FIELD_ORG_ID = "org.id";

    public static OrgApiResult batchSyncHROrg(List<OrgParam> orgParamList) {
        return OrgUnitServiceHelper.batchSyncHROrg(orgParamList);
    }

    public static OrgApiResult saveOrUpdateOrgUnit(List<OrgParam> saveList, DynamicObject[] updateStructures, List<DynamicObject> unfreezeChildBosOrgStructures) {
        ArrayList resultOrgParamList = Lists.newArrayListWithExpectedSize((int)unfreezeChildBosOrgStructures.size());
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)updateStructures.length);
        ArrayList enableList = Lists.newArrayListWithExpectedSize((int)unfreezeChildBosOrgStructures.size());
        Arrays.stream(updateStructures).forEach(structure -> updateList.add(BosOrgServiceHelper.assembleUpdateOrgParamByStructure(structure, OperationType.update)));
        unfreezeChildBosOrgStructures.forEach(structure -> enableList.add(BosOrgServiceHelper.assembleUpdateOrgParamByStructure(structure, OperationType.unfreeze)));
        resultOrgParamList.addAll(saveList);
        resultOrgParamList.addAll(updateList);
        resultOrgParamList.addAll(enableList);
        return BosOrgServiceHelper.batchSyncHROrg(resultOrgParamList);
    }

    public static OrgApiResult updateOrgUnit(DynamicObject[] bosOrgStructures, OperationType operationType) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)bosOrgStructures.length);
        Arrays.stream(bosOrgStructures).forEach(bosOrgStructure -> list.add(BosOrgServiceHelper.assembleUpdateOrgParamByStructure(bosOrgStructure, operationType)));
        return BosOrgServiceHelper.batchSyncHROrg(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<OrgParam> saveOrgUnit(DynamicObject dy) {
        try (TXHandle txHandle = TX.requiresNew();){
            List<OrgParam> list = BosOrgServiceHelper.addNewBosOrgUnit(dy);
            return list;
        }
        catch (RuntimeException e1) {
            logger.error("insertRegularPerson() exception:" + e1.getMessage());
            return new ArrayList<OrgParam>();
        }
    }

    private static String orgParamsToString(OrgParam org) {
        return "id=" + org.getId() + ",parentid=" + org.getParentId() + ",number=" + org.getNumber() + ",name=" + org.getName() + ",customId=" + org.getCustomOrgId() + ",duty=" + org.getDuty() + ",multiViewMap" + org.getMultiViewMap();
    }

    private static List<OrgParam> addNewBosOrgUnit(DynamicObject dy) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)16);
        OrgParam orgParam = BosOrgServiceHelper.assembleSaveOrgParamByHRBU(dy);
        paramList.add(orgParam);
        logger.info("addNewBosOrgUnit add org params:{}", (Object)BosOrgServiceHelper.orgParamsToString(orgParam));
        OrgUnitServiceHelper.addOrUpdate((List)paramList);
        return paramList;
    }

    private static void setMultiView(Long parentId, TreeMap<String, OrgDutyView> multiViewMap) {
        List<DynamicObject> childViews = HRBUSyncStrategyService.getChildViewDys(HRBUConstants.HR_VIEW_ID);
        OrgDutyView orgUnitDutyView = new OrgDutyView();
        orgUnitDutyView.setParentId(parentId.longValue());
        multiViewMap.put("15", orgUnitDutyView);
        for (DynamicObject obj : childViews) {
            OrgDutyView view = new OrgDutyView();
            view.setParentId(parentId.longValue());
            multiViewMap.put(obj.getString("id"), view);
        }
    }

    private static OrgParam assembleSaveOrgParamByHRBU(DynamicObject hrbuExtDynObj) {
        DynamicObject parentOrgDynObj = hrbuExtDynObj.getDynamicObject("parentorg");
        long parentId = 0L;
        if (parentOrgDynObj != null) {
            parentId = parentOrgDynObj.getLong("id");
        }
        OrgParam orgParam = new OrgParam();
        orgParam.setName(hrbuExtDynObj.getString("name"));
        orgParam.setNumber(hrbuExtDynObj.getString("number"));
        HashMap<String, String> propertyMap = new HashMap<String, String>(16);
        propertyMap.put("simplename", hrbuExtDynObj.getString("simplename"));
        propertyMap.put("fcomment", hrbuExtDynObj.getString("description"));
        orgParam.setPropertyMap(propertyMap);
        orgParam.setParentId(parentId);
        orgParam.setOrgPatternId(4L);
        orgParam.setDuty("11");
        orgParam.setId(hrbuExtDynObj.getLong("bosorg.id"));
        TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
        OrgDutyView orgUnitDutyView = new OrgDutyView();
        orgUnitDutyView.setParentId(parentId);
        multiViewMap.put("15", orgUnitDutyView);
        BosOrgServiceHelper.setMultiView(parentId, multiViewMap);
        orgParam.setMultiViewMap(multiViewMap);
        return orgParam;
    }

    public static OrgApiResult addNewHRUnit(List<OrgParam> paramList) {
        return BosOrgServiceHelper.batchSyncHROrg(paramList);
    }

    public static List<OrgParam> assembleOrgParamByHrBuViewExtDy(DynamicObject[] hrBuViewExtDys) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)hrBuViewExtDys.length);
        for (DynamicObject hrBuViewExtDy : hrBuViewExtDys) {
            OrgParam orgParam = BosOrgServiceHelper.assembleOrgParamByHrBuViewExtDy(hrBuViewExtDy);
            paramList.add(orgParam);
        }
        return paramList;
    }

    public static OrgParam assembleOrgParamByHrBuViewExtDy(DynamicObject hrBuViewExtDy) {
        long orgDyId = hrBuViewExtDy.getLong("bosorgstructure.org.id");
        long parentId = 0L;
        if (hrBuViewExtDy.get("parentorg") instanceof DynamicObject) {
            DynamicObject parentOrgDynObj = hrBuViewExtDy.getDynamicObject("parentorg");
            if (parentOrgDynObj != null) {
                parentId = parentOrgDynObj.getLong("id");
            }
        } else if (hrBuViewExtDy.get("parentorg") instanceof Long) {
            parentId = hrBuViewExtDy.getLong("parentorg");
        }
        OrgParam orgParam = new OrgParam();
        orgParam.setId(orgDyId);
        orgParam.setCustomOrgId(orgDyId);
        orgParam.setParentId(parentId);
        String orgViewNumber = hrBuViewExtDy.getString("viewnumber");
        orgParam.setDuty(orgViewNumber);
        orgParam.setOperationType(OperationType.addDuty);
        return orgParam;
    }

    public static OrgParam assembleUpdateOrgParamByStructure(DynamicObject bosOrgStructure, OperationType operationType) {
        String name = bosOrgStructure.getString("name");
        String number = bosOrgStructure.getString("number");
        long orgId = bosOrgStructure.getLong(FIELD_ORG_ID);
        String orgViewNumber = bosOrgStructure.getString("view.number");
        Object parent = bosOrgStructure.get("parent");
        long parentOrgId = 0L;
        if (parent != null) {
            parentOrgId = parent instanceof DynamicObject ? ((DynamicObject)parent).getLong("id") : Long.parseLong(parent.toString());
        }
        return BosOrgServiceHelper.assembleUpdateOrgParam(orgId, orgViewNumber, parentOrgId, operationType, name, number);
    }

    public static OrgParam assembleUpdateOrgParam(long orgId, String viewNumber, long parentId, OperationType operationType, String name, String number) {
        OrgParam orgParam = new OrgParam();
        orgParam.setId(orgId);
        orgParam.setCustomOrgId(orgId);
        orgParam.setDuty(viewNumber);
        orgParam.setParentId(parentId);
        orgParam.setName(name);
        orgParam.setNumber(number);
        TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
        OrgDutyView dutyView = new OrgDutyView();
        dutyView.setParentId(parentId);
        multiViewMap.put(viewNumber, dutyView);
        orgParam.setMultiViewMap(multiViewMap);
        orgParam.setOperationType(operationType);
        return orgParam;
    }

    public static OrgParam assembleUpdateOrgParam(long orgId, String viewNumber, long parentId, OperationType operationType, String orgName) {
        OrgParam orgParam = new OrgParam();
        orgParam.setId(orgId);
        orgParam.setCustomOrgId(orgId);
        orgParam.setDuty(viewNumber);
        orgParam.setParentId(parentId);
        orgParam.setName(orgName);
        TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
        OrgDutyView dutyView = new OrgDutyView();
        dutyView.setParentId(parentId);
        multiViewMap.put(viewNumber, dutyView);
        orgParam.setMultiViewMap(multiViewMap);
        if (operationType != null) {
            orgParam.setOperationType(operationType);
        }
        return orgParam;
    }
}

