/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.ext.hr.web.dto.LoginConfigDTO;
import kd.bos.ext.hr.web.dto.LoginOpDTO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HrLoginServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HrLoginServiceHelper.class);
    private static final String HRMP_HBSS_BUSINESS = "hrmp-hbss-business";
    private static final String RADIO_CUSTOM = "99";

    public static boolean isHrlogin(String authInfoEncrypt) {
        String authInfo = Encrypters.decode((String)authInfoEncrypt);
        String[] authInfoArrays = authInfo.split("#");
        String loginType = authInfoArrays[0];
        String value1 = authInfoArrays[2];
        String verifyCode = authInfoArrays[3];
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter("verifyCode", "=", (Object)verifyCode));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        if (HRStringUtils.equals((String)"1", (String)loginType)) {
            qFilterList.add(new QFilter("phone", "=", (Object)value1));
        } else if (HRStringUtils.equals((String)"2", (String)loginType)) {
            qFilterList.add(new QFilter("email", "=", (Object)value1));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_verifycodelog");
        return serviceHelper.count("hbss_verifycodelog", qFilterList.toArray(new QFilter[0])) > 0;
    }

    public static LoginConfigDTO getHrLoginConfig(String loginConfigNumber) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_loginconfig");
        DynamicObject[] dynamicObjects = serviceHelper.query("sysbannerpic,sysbannerpicl,sysbackgroundpic,bannergroup,bannerpic,backgroundgroup,backgroundpic,client,loginscene.number,usertype.id,redirectform.number,redirectappformid.number,privacystmt.id", new QFilter[]{new QFilter("number", "=", (Object)loginConfigNumber), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (dynamicObjects.length > 0) {
            LoginConfigDTO loginConfigDTO = new LoginConfigDTO();
            DynamicObject dynamicObject = dynamicObjects[0];
            loginConfigDTO.setLoginConfigNumber(loginConfigNumber);
            String bannerPic = dynamicObject.getString("bannerpic");
            String bannerGroup = dynamicObject.getString("bannergroup");
            if (!HRStringUtils.equals((String)bannerGroup, (String)RADIO_CUSTOM)) {
                bannerPic = HRStringUtils.equals((String)RequestContext.get().getLang().name(), (String)"zh_CN") || HRStringUtils.equals((String)RequestContext.get().getLang().name(), (String)"zh_TW") ? dynamicObject.getString("sysbannerpic") : dynamicObject.getString("sysbannerpicl");
            }
            loginConfigDTO.setBannerPic(bannerPic);
            String backgroundPic = dynamicObject.getString("backgroundpic");
            String backGroundGroup = dynamicObject.getString("backgroundgroup");
            if (!HRStringUtils.equals((String)backGroundGroup, (String)RADIO_CUSTOM)) {
                backgroundPic = dynamicObject.getString("sysbackgroundpic");
            }
            loginConfigDTO.setBackgroundPic(backgroundPic);
            loginConfigDTO.setClientType(dynamicObject.getString("client"));
            loginConfigDTO.setLoginSceneNumber(dynamicObject.getString("loginscene.number"));
            loginConfigDTO.setUserTypeId(dynamicObject.getLong("usertype.id"));
            loginConfigDTO.setRedirectFormId(dynamicObject.getString("redirectform.number"));
            loginConfigDTO.setPcRedirectFormId(dynamicObject.getString("redirectappformid.number"));
            HRBaseServiceHelper privacyServiceHelper = new HRBaseServiceHelper("privacystatement");
            DynamicObject[] privacyResults = privacyServiceHelper.query("id,locale", new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getLong("privacystmt.id"))});
            DynamicObject privacyDynamicObject = privacyResults[0];
            long privacyId = privacyDynamicObject.getLong("id");
            long localeId = privacyDynamicObject.getLong("locale.id");
            String langCode = privacyDynamicObject.getString("locale.number");
            loginConfigDTO.setPrivacyId(privacyId);
            loginConfigDTO.setLocaleId(localeId);
            loginConfigDTO.setLangCode(langCode);
            return loginConfigDTO;
        }
        return null;
    }

    public static boolean insertLoginOpLog(LoginOpDTO loginOpDTO) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_login_log_new");
        dynamicObject.set("bizappid", (Object)"XYRL3+A8Z+Z");
        dynamicObject.set("bizappname", (Object)ResManager.loadKDString((String)"HR\u57fa\u7840\u670d\u52a1", (String)"HrLoginServiceHelper_5", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]));
        dynamicObject.set("username", (Object)loginOpDTO.getUserName());
        dynamicObject.set("opname", (Object)HrLoginServiceHelper.getLoginOpName(loginOpDTO.getOpType()));
        dynamicObject.set("opdesc", (Object)HrLoginServiceHelper.getLoginOpDescription(loginOpDTO.getOpDetailType()));
        dynamicObject.set("opdate", (Object)new Date());
        dynamicObject.set("clientip", (Object)RequestContext.get().getLoginIP());
        dynamicObject.set("clientname", (Object)loginOpDTO.getClientType());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return true;
    }

    private static String getLoginOpName(String opName) {
        String msg = "";
        msg = opName.equals("login") ? ResManager.loadKDString((String)"\u767b\u5f55", (String)"HrLoginServiceHelper_0", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9000\u51fa", (String)"HrLoginServiceHelper_2", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]);
        return msg;
    }

    private static String getLoginOpDescription(String opName) {
        String msg = "";
        switch (opName) {
            case "login": {
                msg = ResManager.loadKDString((String)"\u767b\u5f55\u6210\u529f", (String)"HrLoginServiceHelper_1", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "logout": {
                msg = ResManager.loadKDString((String)"\u9000\u51fa\u6210\u529f", (String)"HrLoginServiceHelper_3", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "timeout": {
                msg = ResManager.loadKDString((String)"\u8d85\u65f6\u9000\u51fa\u7528\u6237\u6210\u529f", (String)"HrLoginServiceHelper_4", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "verifyCode": {
                msg = ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u767b\u5f55\u5931\u8d25", (String)"HrLoginServiceHelper_6", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]);
                break;
            }
            case "userNameCode": {
                msg = ResManager.loadKDString((String)"\u5bc6\u7801\u9519\u8bef\uff0c\u767b\u5f55\u5931\u8d25", (String)"HrLoginServiceHelper_7", (String)HRMP_HBSS_BUSINESS, (Object[])new Object[0]);
            }
        }
        return msg;
    }
}

