/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.md.AdminOrgBusinesServiceHelper;

public class PermFilesServiceHelper {
    public static DynamicObject[] getPermAdminorgEntrysByUserId(Long userId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permorgentry");
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        QFilter statusEnabel = new QFilter("status", "=", (Object)"1");
        return serviceHelper.query("adminorg, user, status, containssub, id, permfile", new QFilter[]{userFilter, statusEnabel});
    }

    public static DynamicObject[] getPermAdminorgEntrysByPermfileId(Long permfileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permorgentry");
        QFilter userFilter = new QFilter("user", "=", (Object)permfileId);
        QFilter statusEnabel = new QFilter("status", "=", (Object)"1");
        return serviceHelper.query("adminorg, user, status, containssub, id, permfile", new QFilter[]{userFilter, statusEnabel});
    }

    public static DynamicObject[] getPermEmpgrps(Long permfileId, String entityNum, String appId) {
        String fields = "hrempgrp";
        QFilter qFilter = new QFilter("permempgrpdetail.entitytype", "=", (Object)entityNum).and("permempgrpdetail.bizapp", "=", (Object)appId).and("permfile", "=", (Object)permfileId);
        return BusinessDataServiceHelper.load((String)"hrcs_permempgrp", (String)fields, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject getPermFileByUserId(Long userId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permfiles");
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        return serviceHelper.queryOne("user, enable, org", new QFilter[]{userFilter});
    }

    public static List<Long> getEmpgrpListFromPermFiles(Long userId, Boolean isEnabled, String entityNum, String appId) {
        DynamicObject[] empgrps;
        ArrayList<Long> empgrpIds = new ArrayList<Long>(16);
        DynamicObject permFiles = PermFilesServiceHelper.getPermFileByUserId(userId);
        if (permFiles == null || !HRStringUtils.equals((String)"1", (String)permFiles.getString("enable"))) {
            return empgrpIds;
        }
        Long permfileId = permFiles.getLong("id");
        for (DynamicObject empgrp : empgrps = PermFilesServiceHelper.getPermEmpgrps(permfileId, entityNum, appId)) {
            Long empgrpId = empgrp.getLong("hrempgrp.id");
            empgrpIds.add(empgrpId);
        }
        return empgrpIds;
    }

    public static List<Long> getOrgListFromPermFiles(Long userId, Boolean isEnabled) {
        DynamicObject[] orgEntrys;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        ArrayList<Long> containsSubOrgIds = new ArrayList<Long>();
        DynamicObject permFiles = PermFilesServiceHelper.getPermFileByUserId(userId);
        if (permFiles == null || !HRStringUtils.equals((String)"1", (String)permFiles.getString("enable"))) {
            return orgIds;
        }
        for (DynamicObject orgEntry : orgEntrys = PermFilesServiceHelper.getPermAdminorgEntrysByUserId(userId)) {
            boolean containsSub = orgEntry.getBoolean("containssub");
            Long orgId = orgEntry.getLong("adminorg.id");
            if (containsSub) {
                containsSubOrgIds.add(orgId);
                continue;
            }
            orgIds.add(orgId);
        }
        List<Long> containsOrgIds = AdminOrgBusinesServiceHelper.getSubAdminOrgList(containsSubOrgIds, isEnabled);
        orgIds.addAll(containsOrgIds);
        return orgIds;
    }
}

