/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.PersonRelaitionModel;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbss.bussiness.servicehelper.WorkRolesServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class PersonRoleRelServiceHelper {
    private static final Log logger = LogFactory.getLog(PersonRoleRelServiceHelper.class);
    public static final String PAGE_HERS_DEPMP = "hers_depemp";
    public static final int DEFAULTINDEX = 999;
    private static final String FIELD_PERSON = "person";
    private static final String FIELD_IS_EFFECTIVE = "iseffective";
    private static final String FIELD_START_DATE = "startdate";
    private static final String FIELD_CREATOR = "creator";
    private static final String FIELD_CREATE_TIME = "createtime";
    private static final String FIELD_INDEX = "index";
    private static final String DATE_FORMAT_SHORT = "yyyy-MM-dd";
    private static final String MSG_DATE_CONVERT_ERROR = "date format error";
    private static final String FIELD_END_DATE = "enddate";
    private static final String FIELD_START_DATETIME = "startdatetime";
    private static final String FIELD_END_DATETIME = "enddatetime";
    private static final String SELECT_FIELDS = "iseffective, enddate, enddatetime,modifier,modifytime";
    private static final String FIELD_MODIFIER = "modifier";
    private static final String FIELD_MODIFYTIME = "modifytime";
    private static final String FIELD_PERSON_ID = "person.id";

    public static void addNewRelations(Long roleId, List<Map<String, Object>> personList, Date effectDate) {
        Date nowDate = new Date();
        String userId = RequestContext.get().getUserId();
        DynamicObjectCollection relationCollection = new DynamicObjectCollection();
        try (TXHandle txHandle = TX.requiresNew();){
            for (int i = 0; i < personList.size(); ++i) {
                Map<String, Object> personMap = personList.get(i);
                DynamicObject relationObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hrpi_personrolerelhr"));
                if (personMap.get("source") != null) {
                    relationObj.set("source", personMap.get("source"));
                }
                relationObj.set("role", (Object)roleId);
                relationObj.set(FIELD_PERSON, personMap.get(FIELD_PERSON));
                relationObj.set(FIELD_IS_EFFECTIVE, (Object)Boolean.TRUE);
                relationObj.set(FIELD_START_DATE, (Object)effectDate);
                relationObj.set(FIELD_CREATOR, (Object)userId);
                relationObj.set(FIELD_CREATE_TIME, (Object)nowDate);
                relationObj.set(FIELD_INDEX, (Object)999);
                relationObj.set("depemp", personMap.get("depemp"));
                relationObj.set("cmpemp", personMap.get("cmpemp"));
                relationObj.set("employee", personMap.get("employee"));
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_SHORT);
                Date endDate = null;
                try {
                    endDate = sdf.parse("2999-12-31");
                }
                catch (Exception e) {
                    logger.error(MSG_DATE_CONVERT_ERROR);
                }
                relationObj.set(FIELD_END_DATE, (Object)endDate);
                relationObj.set(FIELD_START_DATETIME, (Object)effectDate);
                relationObj.set(FIELD_END_DATETIME, (Object)endDate);
                relationCollection.add((Object)relationObj);
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
            Object[] result = serviceHelper.save(relationCollection);
            PersonRoleRelServiceHelper.syncAddNewRelationsToHis((DynamicObject[])result);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }

    private static boolean checkModel(Map<String, Object> personMap) {
        Object depemp = personMap.get("depemp");
        Object cmemp = personMap.get("cmpemp");
        Object employee = personMap.get("employee");
        return depemp != null && cmemp != null && employee != null;
    }

    public static void addNewRelations(List<Long> roleIds, Map<String, Object> personMap, Date effectDate) {
        Date nowDate = new Date();
        String userId = RequestContext.get().getUserId();
        DynamicObjectCollection relationCollection = new DynamicObjectCollection();
        try (TXHandle txHandle = TX.requiresNew();){
            String source = "";
            if (personMap.get("source") != null) {
                source = (String)personMap.get("source");
            }
            for (int i = 0; i < roleIds.size(); ++i) {
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hrpi_personrolerelhr"));
                dynamicObject.set("source", (Object)source);
                dynamicObject.set("role", (Object)roleIds.get(i));
                dynamicObject.set(FIELD_PERSON, personMap.get(FIELD_PERSON));
                dynamicObject.set(FIELD_IS_EFFECTIVE, (Object)Boolean.TRUE);
                dynamicObject.set(FIELD_START_DATE, (Object)effectDate);
                dynamicObject.set("depemp", personMap.get("depemp"));
                dynamicObject.set("cmpemp", personMap.get("cmpemp"));
                dynamicObject.set("employee", personMap.get("employee"));
                SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_SHORT);
                Date endDate = null;
                try {
                    endDate = sdf.parse("2999-12-31");
                }
                catch (Exception e) {
                    logger.error(MSG_DATE_CONVERT_ERROR);
                }
                dynamicObject.set(FIELD_END_DATE, (Object)endDate);
                dynamicObject.set(FIELD_START_DATETIME, (Object)effectDate);
                dynamicObject.set(FIELD_END_DATETIME, (Object)endDate);
                dynamicObject.set(FIELD_CREATOR, (Object)userId);
                dynamicObject.set(FIELD_CREATE_TIME, (Object)nowDate);
                dynamicObject.set(FIELD_INDEX, (Object)999);
                relationCollection.add((Object)dynamicObject);
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
            Object[] result = serviceHelper.save(relationCollection);
            PersonRoleRelServiceHelper.syncAddNewRelationsToHis((DynamicObject[])result);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }

    public static void batchAddNewRelations(List<PersonRelaitionModel> relations) {
        Date nowDate = new Date();
        String userId = RequestContext.get().getUserId();
        DynamicObjectCollection relationCollection = new DynamicObjectCollection();
        try (TXHandle txHandle = TX.requiresNew();){
            if (CollectionUtils.isNotEmpty(relations)) {
                relations.forEach(relation -> {
                    DynamicObject relationObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hrpi_personrolerelhr"));
                    relationObj.set("source", (Object)relation.getSource());
                    relationObj.set("role", (Object)relation.getRoleId());
                    relationObj.set(FIELD_PERSON, (Object)relation.getPerson());
                    relationObj.set(FIELD_IS_EFFECTIVE, (Object)Boolean.TRUE);
                    relationObj.set(FIELD_START_DATE, (Object)relation.getEffectDate());
                    relationObj.set("depemp", (Object)relation.getDepEmp());
                    relationObj.set("cmpemp", (Object)relation.getCmpEmp());
                    relationObj.set("employee", (Object)relation.getEmployee());
                    SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_SHORT);
                    Date endDate = null;
                    try {
                        endDate = sdf.parse("2999-12-31");
                    }
                    catch (Exception e) {
                        logger.error(MSG_DATE_CONVERT_ERROR);
                    }
                    relationObj.set(FIELD_END_DATE, (Object)endDate);
                    relationObj.set(FIELD_START_DATETIME, (Object)relation.getEffectDate());
                    relationObj.set(FIELD_END_DATETIME, (Object)endDate);
                    relationObj.set(FIELD_CREATOR, (Object)userId);
                    relationObj.set(FIELD_CREATE_TIME, (Object)nowDate);
                    relationObj.set(FIELD_INDEX, (Object)999);
                    relationCollection.add((Object)relationObj);
                });
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
            Object[] result = serviceHelper.save(relationCollection);
            PersonRoleRelServiceHelper.syncAddNewRelationsToHis((DynamicObject[])result);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }

    public static void syncAddNewRelationsToHis(DynamicObject[] relation) {
        DynamicObjectCollection relationHisColl = new DynamicObjectCollection();
        for (int i = 0; i < relation.length; ++i) {
            DynamicObject relationHisObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hrpi_personrolerelhishr"));
            HashMap<String, String> transMap = new HashMap<String, String>();
            transMap.put("id", "id");
            HRDynamicObjectUtils.copy((DynamicObject)relation[i], (DynamicObject)relationHisObj, null, transMap);
            relationHisObj.set("id", (Object)relation[i].getLong("id"));
            relationHisColl.add((Object)relationHisObj);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        serviceHelper.save(relationHisColl);
    }

    public static void deleteRelationsByRowIds(Long[] rowIds) {
        try (TXHandle txHandle = TX.requiresNew();){
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
            serviceHelper.delete((Object[])rowIds);
            PersonRoleRelServiceHelper.syncDeleteRelationsToHisByRowIds(rowIds);
        }
        catch (Exception exception) {
            logger.error((Throwable)exception);
        }
    }

    public static DynamicObjectCollection getRelationsByRowIds(Long[] rowIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter idFilters = new QFilter("id", "in", (Object)rowIds);
        return serviceHelper.queryOriginalCollection("id, iseffective, person.id, role.id, source, role.createtype, role.position.name, depemp.id", new QFilter[]{idFilters});
    }

    public static void syncDeleteRelationsToHisByRowIds(Long[] rowIds) {
        Date nowDate = new Date();
        String userId = RequestContext.get().getUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter filter = new QFilter("id", "in", (Object)rowIds);
        DynamicObject[] rowRelations = serviceHelper.query(SELECT_FIELDS, new QFilter[]{filter});
        Date date = new Date();
        for (int i = 0; i < rowRelations.length; ++i) {
            rowRelations[i].set(FIELD_IS_EFFECTIVE, (Object)Boolean.FALSE);
            rowRelations[i].set(FIELD_END_DATE, (Object)date);
            rowRelations[i].set(FIELD_END_DATETIME, (Object)date);
            rowRelations[i].set(FIELD_MODIFIER, (Object)userId);
            rowRelations[i].set(FIELD_MODIFYTIME, (Object)nowDate);
        }
        serviceHelper.update(rowRelations);
    }

    public static void syncUpdateRelationsToHisByRowId(Long rowId, int index) {
        Date nowDate = new Date();
        String userId = RequestContext.get().getUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter filter = new QFilter("id", "=", (Object)rowId);
        QFilter effectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        String selectFields = "modifier,modifytime,index";
        DynamicObject[] rowRelations = serviceHelper.query(selectFields, new QFilter[]{filter, effectiveFilter});
        for (int i = 0; i < rowRelations.length; ++i) {
            rowRelations[i].set(FIELD_MODIFIER, (Object)userId);
            rowRelations[i].set(FIELD_MODIFYTIME, (Object)nowDate);
            rowRelations[i].set(FIELD_INDEX, (Object)index);
        }
        serviceHelper.update(rowRelations);
    }

    public static void deleteRelation(Long roleId, Long personId, String personModel, Date endData) {
        block19: {
            try (TXHandle txHandle = TX.requiresNew();){
                if (logger.isInfoEnabled()) {
                    logger.info("*****************Entering the Invalidation Person Role Method*****************");
                    logger.info("***personModel--->" + personModel);
                    logger.info("***personId--->" + personId);
                }
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
                QFilter personFilter = new QFilter(personModel, "=", (Object)personId);
                if (roleId != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info("*****************The role ID cannot be empty*****************");
                        logger.info("***roleId--->" + roleId);
                    }
                    QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
                    serviceHelper.deleteByFilter(new QFilter[]{roleFilter, personFilter});
                } else {
                    if (logger.isInfoEnabled()) {
                        logger.info("*****************All roles of employees whose resignation expires*****************");
                    }
                    serviceHelper.deleteByFilter(new QFilter[]{personFilter});
                }
                PersonRoleRelServiceHelper.syncDeleteRelationToHis(roleId, personId, personModel, endData);
            }
            catch (Exception exception) {
                if (!logger.isErrorEnabled()) break block19;
                logger.error((Throwable)exception);
            }
        }
    }

    public static void deleteRelations(List<Long> roleIds, Long personId, String personModel, Date endDate) {
        block19: {
            try (TXHandle txHandle = TX.requiresNew();){
                if (logger.isInfoEnabled()) {
                    logger.info("*****************Entering the Invalidation Person Role Method*****************");
                    logger.info("***personModel--->" + personModel);
                    logger.info("***personId--->" + personId);
                }
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
                QFilter personFilter = new QFilter(personModel, "=", (Object)personId);
                if (roleIds != null && roleIds.size() > 0) {
                    if (logger.isInfoEnabled()) {
                        logger.info("*****************The role ID cannot be empty*****************");
                        logger.info("***roleId--->" + roleIds);
                    }
                    QFilter roleFilter = new QFilter("role", "in", roleIds);
                    serviceHelper.deleteByFilter(new QFilter[]{roleFilter, personFilter});
                } else if (logger.isInfoEnabled()) {
                    logger.info("*****************All roles of employees whose resignation expires*****************");
                    serviceHelper.deleteByFilter(new QFilter[]{personFilter});
                }
                PersonRoleRelServiceHelper.syncDeleteRelationToHis(roleIds, personId, personModel, endDate);
            }
            catch (Exception exception) {
                if (!logger.isErrorEnabled()) break block19;
                logger.error((Throwable)exception);
            }
        }
    }

    public static void syncDeleteRelationToHis(Long roleId, Long personId, String personModel, Date endData) {
        QFilter[] qFilters;
        Date nowDate = new Date();
        String userId = RequestContext.get().getUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter personFilter = new QFilter(personModel, "=", (Object)personId);
        QFilter effectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        if (roleId != null) {
            QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
            qFilters = new QFilter[]{personFilter, roleFilter, effectiveFilter};
        } else {
            qFilters = new QFilter[]{personFilter, effectiveFilter};
        }
        DynamicObject[] rowRelationArray = serviceHelper.query(SELECT_FIELDS, qFilters);
        for (int i = 0; i < rowRelationArray.length; ++i) {
            rowRelationArray[i].set(FIELD_IS_EFFECTIVE, (Object)Boolean.FALSE);
            rowRelationArray[i].set(FIELD_END_DATE, (Object)endData);
            rowRelationArray[i].set(FIELD_END_DATETIME, (Object)nowDate);
            rowRelationArray[i].set(FIELD_MODIFIER, (Object)userId);
            rowRelationArray[i].set(FIELD_MODIFYTIME, (Object)nowDate);
        }
        serviceHelper.update(rowRelationArray);
    }

    public static void syncDeleteRelationToHis(List<Long> roleIds, Long personId, String personModel, Date endData) {
        QFilter[] filters;
        Date nowDate = new Date();
        String userId = RequestContext.get().getUserId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter personFilter = new QFilter(personModel, "=", (Object)personId);
        QFilter effectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        if (roleIds != null && roleIds.size() > 0) {
            QFilter roleFilter = new QFilter("role", "in", roleIds);
            filters = new QFilter[]{personFilter, roleFilter, effectiveFilter};
        } else {
            filters = new QFilter[]{personFilter, effectiveFilter};
        }
        DynamicObject[] rowRelations = serviceHelper.query(SELECT_FIELDS, filters);
        for (int i = 0; i < rowRelations.length; ++i) {
            rowRelations[i].set(FIELD_IS_EFFECTIVE, (Object)Boolean.FALSE);
            rowRelations[i].set(FIELD_END_DATE, (Object)endData);
            rowRelations[i].set(FIELD_END_DATETIME, (Object)nowDate);
            rowRelations[i].set(FIELD_MODIFIER, (Object)userId);
            rowRelations[i].set(FIELD_MODIFYTIME, (Object)nowDate);
        }
        serviceHelper.update(rowRelations);
    }

    public static List<Long> getPersonIdsByRoleId(Long roleId) {
        ArrayList<Long> personIds = new ArrayList<Long>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter effectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection personColl = serviceHelper.queryOriginalCollection(FIELD_PERSON_ID, new QFilter[]{roleFilter, effectiveFilter});
        for (DynamicObject person : personColl) {
            personIds.add(person.getLong(FIELD_PERSON_ID));
        }
        return personIds;
    }

    public static List<Long> getDepEmpIdsByRoleId(Long roleId) {
        ArrayList<Long> personIds = new ArrayList<Long>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter effectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection personColl = serviceHelper.queryOriginalCollection("depemp.id", new QFilter[]{roleFilter, effectiveFilter});
        for (DynamicObject person : personColl) {
            personIds.add(person.getLong("depemp.id"));
        }
        return personIds;
    }

    public static Map<Long, List<Long>> getParentPersonIdsByRoleIds(List<Long> roleIds) {
        HashMap<Long, ArrayList<Long>> parentRoleIdMap = new HashMap<Long, ArrayList<Long>>();
        ArrayList<Long> parentRoleIds = new ArrayList<Long>();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        QFilter roleFilter = new QFilter("role", "in", roleIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter reportType = new QFilter("reportingtype", "=", (Object)Long.valueOf("1010"));
        DynamicObjectCollection reportRelColl = serviceHelper.queryOriginalCollection("parent.id, role.id", new QFilter[]{roleFilter, enableFilter, reportType});
        for (DynamicObject reportRel : reportRelColl) {
            Long roleId = reportRel.getLong("role.id");
            Long parentRoleId = reportRel.getLong("parent.id");
            parentRoleIds.add(parentRoleId);
            Object childroleIds = (ArrayList<Long>)parentRoleIdMap.get(parentRoleId);
            if (childroleIds == null) {
                childroleIds = new ArrayList<Long>();
            }
            childroleIds.add(roleId);
            parentRoleIdMap.put(parentRoleId, (ArrayList<Long>)childroleIds);
        }
        HashMap<Long, ArrayList<Long>> parentPersonIdMap = new HashMap<Long, ArrayList<Long>>();
        serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter roleIdFilter = new QFilter("role", "in", parentRoleIds);
        QFilter effectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        DynamicObjectCollection personColl = serviceHelper.queryOriginalCollection("role.id, person.id", new QFilter[]{roleIdFilter, effectiveFilter});
        for (DynamicObject person : personColl) {
            Long roleId = person.getLong("role.id");
            Long personId = person.getLong(FIELD_PERSON_ID);
            ArrayList<Long> personIds = (ArrayList<Long>)parentPersonIdMap.get(roleId);
            if (personIds == null) {
                personIds = new ArrayList<Long>();
            }
            personIds.add(personId);
            parentPersonIdMap.put(roleId, personIds);
        }
        HashMap<Long, List<Long>> personIdMap = new HashMap<Long, List<Long>>();
        for (Map.Entry parentRoleId : parentPersonIdMap.entrySet()) {
            List personIds = (List)parentRoleId.getValue();
            List childRoleIds = (List)parentRoleIdMap.get(parentRoleId.getKey());
            for (Long childId : childRoleIds) {
                personIdMap.put(childId, personIds);
            }
        }
        return personIdMap;
    }

    public static DynamicObject[] getMainChargePeoByOrgId(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
        QFilter mainchargeFilter = new QFilter("role.mainpeoincharge", "=", (Object)Boolean.TRUE);
        QFilter orgFilter = new QFilter("role.adminorg", "in", orgIdList);
        QFilter enable = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        return serviceHelper.query("person.name, person.headsculpture, person.id, role, role.adminorg", new QFilter[]{mainchargeFilter, orgFilter, enable}, "role.mainpeoincharge desc,index asc,person.number asc");
    }

    public static List<Long> getAdministrativeSuperiorByRoleId(Long roleId) {
        List<Long> superiorIds = new ArrayList<Long>();
        DynamicObject reportRel = WorkRolesServiceHelper.getReportingRelationByRoleId(roleId);
        if (reportRel != null) {
            Long parentRoleId = reportRel.getLong("parent.id");
            superiorIds = PersonRoleRelServiceHelper.getPersonIdsByRoleId(parentRoleId);
        }
        return superiorIds;
    }

    public static DynamicObject[] getPersonRoleRelByPersonIds(List<Long> personIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
        QFilter personIdFilter = new QFilter(FIELD_PERSON, "in", personIds);
        QFilter iseffectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        return serviceHelper.query("person.id, person.name, role.id", new QFilter[]{personIdFilter, iseffectiveFilter});
    }

    public static DynamicObject[] getPersonRoleRelByDepEmpIds(List<Long> depEmpIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
        QFilter personIdFilter = new QFilter("depemp", "in", depEmpIds);
        QFilter iseffectiveFilter = new QFilter(FIELD_IS_EFFECTIVE, "=", (Object)Boolean.TRUE);
        return serviceHelper.query("person.id, person.name, role.id, depemp.id", new QFilter[]{personIdFilter, iseffectiveFilter});
    }
}

