/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import com.google.common.base.Splitter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.hr.web.dto.SafeUrlDTO;
import kd.bos.ext.hr.web.util.SafeUriUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class SafeUrlServiceHelper {
    private static final String ENTITY_HBSS_SAFEURI = "hbss_safeuri";

    public static SafeUrlDTO convertLongToShort(String longUrl, String safeUriConfigNumber, String businessId) {
        URL longURL;
        SafeUrlDTO safeUrlDTO = new SafeUrlDTO();
        if (HRStringUtils.isEmpty((String)longUrl) || HRStringUtils.isEmpty((String)safeUriConfigNumber)) {
            return safeUrlDTO;
        }
        try {
            longURL = new URL(longUrl);
        }
        catch (MalformedURLException e) {
            safeUrlDTO.setErrorMsg("longUrl is invalid");
            return safeUrlDTO;
        }
        DynamicObject[] configDynamicObjects = BusinessDataServiceHelper.load((String)"hbss_safeuriconfig", (String)"expiryduration,expiryunit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)safeUriConfigNumber), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (configDynamicObjects == null || configDynamicObjects.length == 0) {
            safeUrlDTO.setErrorMsg(safeUriConfigNumber + " not found");
            return safeUrlDTO;
        }
        Date currentDate = new Date();
        DynamicObject configDynamicObject = configDynamicObjects[0];
        Date expiryTime = SafeUrlServiceHelper.calExpiryTime(currentDate, configDynamicObject.getInt("expiryduration"), configDynamicObject.getString("expiryunit"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_HBSS_SAFEURI, (String)"number,originuri,safeuri,expirytime,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("originuri", "=", (Object)longUrl), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            safeUrlDTO.setOriginUrl(dynamicObject.getString("originuri"));
            safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, dynamicObject.getString("safeuri")));
            safeUrlDTO.setExpiryTime(expiryTime);
            dynamicObject.set("expirytime", (Object)expiryTime);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)currentDate);
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            return safeUrlDTO;
        }
        String safeUri = SafeUrlServiceHelper.getSafeUri(longURL);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_HBSS_SAFEURI);
        dynamicObject.set("originuri", (Object)longUrl);
        dynamicObject.set("safeuri", (Object)safeUri);
        dynamicObject.set("businessId", (Object)businessId);
        dynamicObject.set("expirytime", (Object)expiryTime);
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)currentDate);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)currentDate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        safeUrlDTO.setOriginUrl(longUrl);
        safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, safeUri));
        safeUrlDTO.setExpiryTime(expiryTime);
        safeUrlDTO.setBusinessId(businessId);
        return safeUrlDTO;
    }

    private static Date calExpiryTime(Date date, int expiryDuration, String expiryUnit) {
        switch (expiryUnit) {
            case "0": {
                return HRDateTimeUtils.addMinute((Date)date, (long)expiryDuration);
            }
            case "1": {
                return HRDateTimeUtils.addHour((Date)date, (long)expiryDuration);
            }
            case "2": {
                return HRDateTimeUtils.addDay((Date)date, (long)expiryDuration);
            }
            case "3": {
                return HRDateTimeUtils.addMonth((Date)date, (int)expiryDuration);
            }
        }
        return date;
    }

    public static SafeUrlDTO convertLongToShort(String longUrl, Date expiryTime, String businessId) {
        URL longURL;
        SafeUrlDTO safeUrlDTO = new SafeUrlDTO();
        if (HRStringUtils.isEmpty((String)longUrl) || expiryTime == null) {
            return safeUrlDTO;
        }
        try {
            longURL = new URL(longUrl);
        }
        catch (MalformedURLException e) {
            safeUrlDTO.setErrorMsg("longUrl is invalid");
            return safeUrlDTO;
        }
        Date currentDate = new Date();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_HBSS_SAFEURI, (String)"number,originuri,safeuri,expirytime,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("originuri", "=", (Object)longUrl), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            dynamicObject.set("expirytime", (Object)expiryTime);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)currentDate);
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            safeUrlDTO.setOriginUrl(dynamicObject.getString("originuri"));
            safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, dynamicObject.getString("safeuri")));
            safeUrlDTO.setExpiryTime(dynamicObject.getDate("expirytime"));
            return safeUrlDTO;
        }
        String safeUri = SafeUrlServiceHelper.getSafeUri(longURL);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_HBSS_SAFEURI);
        dynamicObject.set("originuri", (Object)longUrl);
        dynamicObject.set("safeuri", (Object)safeUri);
        dynamicObject.set("businessId", (Object)businessId);
        dynamicObject.set("expirytime", (Object)expiryTime);
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)currentDate);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)currentDate);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        safeUrlDTO.setOriginUrl(longUrl);
        safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, safeUri));
        safeUrlDTO.setExpiryTime(expiryTime);
        safeUrlDTO.setBusinessId(businessId);
        return safeUrlDTO;
    }

    public static SafeUrlDTO convertShortToLong(String shortUri) {
        SafeUrlDTO safeUrlDTO = new SafeUrlDTO();
        if (HRStringUtils.isEmpty((String)shortUri)) {
            return safeUrlDTO;
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_HBSS_SAFEURI, (String)"number,originuri,safeuri,businessid,expirytime", (QFilter[])new QFilter[]{new QFilter("safeuri", "=", (Object)shortUri), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            safeUrlDTO.setOriginUrl(dynamicObject.getString("originuri"));
            safeUrlDTO.setSafeUrl(UrlService.getDomainContextUrl() + dynamicObject.getString("safeuri"));
            safeUrlDTO.setExpiryTime(dynamicObject.getDate("expirytime"));
            safeUrlDTO.setBusinessId(dynamicObject.getString("businessid"));
        }
        return safeUrlDTO;
    }

    private static String getSafeUri(URL longURL) {
        String safeUri = SafeUriUtil.getSafeUri() + ".do";
        String query = longURL.getQuery();
        Map queryMap = Splitter.onPattern((String)"&").trimResults().withKeyValueSeparator("=").split((CharSequence)query);
        String accountId = (String)queryMap.get("accountId");
        safeUri = "/hr/" + safeUri + "?a=" + accountId;
        return safeUri;
    }

    private static String getSafeUrl(URL longURL, String safeUri) {
        String domainContextUrl = "";
        RequestContext requestContext = RequestContext.get();
        if (null != requestContext) {
            domainContextUrl = requestContext.getClientFullContextPath();
        }
        if (HRStringUtils.isEmpty((String)domainContextUrl)) {
            domainContextUrl = UrlService.getDomainContextUrl();
        }
        if (HRStringUtils.isEmpty((String)domainContextUrl)) {
            String protocol = longURL.getProtocol();
            String host = longURL.getHost();
            int port = longURL.getPort();
            String path = longURL.getPath();
            path = path.replace("/mobile.html", "");
            domainContextUrl = protocol + "://" + host + ":" + port + path;
        }
        if (HRStringUtils.isNotEmpty((String)domainContextUrl) && domainContextUrl.endsWith("/")) {
            domainContextUrl = domainContextUrl.substring(0, domainContextUrl.length() - 1);
        }
        return domainContextUrl + safeUri;
    }

    public static SafeUrlDTO getLongUrlDetail(String longUrl) {
        SafeUrlDTO safeUrlDTO = new SafeUrlDTO();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_HBSS_SAFEURI, (String)"number,originuri,safeuri,businessid,expirytime,args", (QFilter[])new QFilter[]{new QFilter("originuri", "=", (Object)longUrl), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            safeUrlDTO.setSafeUrl(UrlService.getDomainContextUrl() + dynamicObject.getString("safeuri"));
            safeUrlDTO.setExpiryTime(dynamicObject.getDate("expirytime"));
            safeUrlDTO.setOriginUrl(dynamicObject.getString("originuri"));
            safeUrlDTO.setBusinessId(dynamicObject.getString("businessid"));
            safeUrlDTO.setParams(dynamicObject.getString("args"));
        }
        return safeUrlDTO;
    }

    public static SafeUrlDTO convertLongToShortByArg(String longUrl, String safeUriConfigNumber, String businessId, Map<String, Object> arg) {
        URL longURL;
        SafeUrlDTO safeUrlDTO = new SafeUrlDTO();
        if (HRStringUtils.isEmpty((String)longUrl) || HRStringUtils.isEmpty((String)safeUriConfigNumber)) {
            return safeUrlDTO;
        }
        try {
            longURL = new URL(longUrl);
        }
        catch (MalformedURLException e) {
            safeUrlDTO.setErrorMsg("longUrl is invalid");
            return safeUrlDTO;
        }
        DynamicObject[] configDynamicObjects = BusinessDataServiceHelper.load((String)"hbss_safeuriconfig", (String)"expiryduration,expiryunit", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)safeUriConfigNumber), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (configDynamicObjects == null || configDynamicObjects.length == 0) {
            safeUrlDTO.setErrorMsg(safeUriConfigNumber + " not found");
            return safeUrlDTO;
        }
        Date currentDate = new Date();
        DynamicObject configDynamicObject = configDynamicObjects[0];
        Date expiryTime = SafeUrlServiceHelper.calExpiryTime(currentDate, configDynamicObject.getInt("expiryduration"), configDynamicObject.getString("expiryunit"));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_HBSS_SAFEURI, (String)"number,originuri,safeuri,expirytime,modifier,modifytime,args", (QFilter[])new QFilter[]{new QFilter("originuri", "=", (Object)longUrl), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            safeUrlDTO.setOriginUrl(dynamicObject.getString("originuri"));
            safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, dynamicObject.getString("safeuri")));
            safeUrlDTO.setExpiryTime(expiryTime);
            dynamicObject.set("expirytime", (Object)expiryTime);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)currentDate);
            dynamicObject.set("args", (Object)SerializationUtils.toJsonString(arg));
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            return safeUrlDTO;
        }
        String safeUri = SafeUrlServiceHelper.getSafeUri(longURL);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_HBSS_SAFEURI);
        dynamicObject.set("originuri", (Object)longUrl);
        dynamicObject.set("safeuri", (Object)safeUri);
        dynamicObject.set("businessId", (Object)businessId);
        dynamicObject.set("expirytime", (Object)expiryTime);
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)currentDate);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)currentDate);
        dynamicObject.set("args", (Object)SerializationUtils.toJsonString(arg));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        safeUrlDTO.setOriginUrl(longUrl);
        safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, safeUri));
        safeUrlDTO.setExpiryTime(expiryTime);
        safeUrlDTO.setBusinessId(businessId);
        return safeUrlDTO;
    }

    public static SafeUrlDTO convertLongToShortByArg(String longUrl, Date expiryTime, String businessId, Map<String, Object> arg) {
        URL longURL;
        SafeUrlDTO safeUrlDTO = new SafeUrlDTO();
        if (HRStringUtils.isEmpty((String)longUrl) || expiryTime == null) {
            return safeUrlDTO;
        }
        try {
            longURL = new URL(longUrl);
        }
        catch (MalformedURLException e) {
            safeUrlDTO.setErrorMsg("longUrl is invalid");
            return safeUrlDTO;
        }
        Date currentDate = new Date();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_HBSS_SAFEURI, (String)"number,originuri,safeuri,expirytime,modifier,modifytime,args", (QFilter[])new QFilter[]{new QFilter("originuri", "=", (Object)longUrl), new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)1);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            DynamicObject dynamicObject = dynamicObjects[0];
            dynamicObject.set("expirytime", (Object)expiryTime);
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)currentDate);
            dynamicObject.set("args", (Object)SerializationUtils.toJsonString(arg));
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            safeUrlDTO.setOriginUrl(dynamicObject.getString("originuri"));
            safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, dynamicObject.getString("safeuri")));
            safeUrlDTO.setExpiryTime(dynamicObject.getDate("expirytime"));
            return safeUrlDTO;
        }
        String safeUri = SafeUrlServiceHelper.getSafeUri(longURL);
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_HBSS_SAFEURI);
        dynamicObject.set("originuri", (Object)longUrl);
        dynamicObject.set("safeuri", (Object)safeUri);
        dynamicObject.set("businessId", (Object)businessId);
        dynamicObject.set("expirytime", (Object)expiryTime);
        dynamicObject.set("enable", (Object)"1");
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("createtime", (Object)currentDate);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)currentDate);
        dynamicObject.set("args", (Object)SerializationUtils.toJsonString(arg));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        safeUrlDTO.setOriginUrl(longUrl);
        safeUrlDTO.setSafeUrl(SafeUrlServiceHelper.getSafeUrl(longURL, safeUri));
        safeUrlDTO.setExpiryTime(expiryTime);
        safeUrlDTO.setBusinessId(businessId);
        return safeUrlDTO;
    }
}

