/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.servicehelper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.md.AdminOrgBusinesServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.PersonRoleRelServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class WorkRolesServiceHelper {
    private static final String FIELD_ADMINORG_ID = "adminorg.id";
    private static final String FIELD_ROLE_ID = "role.id";
    private static final String FIELD_PARENT_ID = "parent.id";
    private static final String FIELD_WORKROLE_ID = "workrole.id";
    private static final String FIELD_PERSON = "person";
    private static final String FIELD_PERSON_ID = "person.id";

    public static DynamicObject getMainChargeRoleByRoleId(Long roleId) {
        Long orgId = WorkRolesServiceHelper.getOrgIdByRoleId(roleId);
        return WorkRolesServiceHelper.getMainChargeRoleByOrgId(orgId);
    }

    public static Long getOrgIdByRoleId(Long roleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        String selectFields = FIELD_ADMINORG_ID;
        QFilter idFilter = new QFilter("id", "=", (Object)roleId);
        DynamicObject adminOrg = serviceHelper.queryOne(selectFields, new QFilter[]{idFilter});
        return adminOrg.getLong(FIELD_ADMINORG_ID);
    }

    public static DynamicObject[] getInfoByRoleId(List<Long> roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        String selectFields = "id, adminorg.id, adminorg.enable, mainpeoincharge";
        QFilter idFilter = new QFilter("id", "in", roleIds);
        DynamicObject[] adminOrgs = serviceHelper.query(selectFields, new QFilter[]{idFilter});
        return adminOrgs;
    }

    public static DynamicObject getRoleByRoleId(Long roleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        String selectFields = "number, name, mainpeoincharge, roletype, createtype, teamtype, adminorg, enable";
        QFilter idFilter = new QFilter("id", "=", (Object)roleId);
        return serviceHelper.queryOne(selectFields, new QFilter[]{idFilter});
    }

    public static DynamicObject getMainChargeRoleByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        String selectFields = "name, mainpeoincharge, id, adminorg.id";
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter mainChargeFilter = new QFilter("mainpeoincharge", "=", (Object)Boolean.TRUE);
        return serviceHelper.queryOne(selectFields, new QFilter[]{orgFilter, enableFilter, mainChargeFilter});
    }

    public static DynamicObject[] getRoleByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        String selectFields = "name, mainpeoincharge, id";
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return serviceHelper.query(selectFields, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getRoleByPositionId(List<Long> orgId, String selProps) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        QFilter orgFilter = new QFilter("position", "in", orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return serviceHelper.query(selProps, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getAllRoleByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        String selectFields = "name, mainpeoincharge, id";
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgId);
        return serviceHelper.query(selectFields, new QFilter[]{orgFilter});
    }

    public static void createNewReportingRelation(DynamicObject role, Long adminorgId, DynamicObject parentRole, String enable) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        if (role != null && parentRole != null) {
            DynamicObject position;
            Long orgId = role.getLong(FIELD_ADMINORG_ID);
            if (adminorgId != null && adminorgId != 0L) {
                orgId = adminorgId;
            }
            Long parentOrgId = parentRole.getLong(FIELD_ADMINORG_ID);
            DynamicObject company = AdminOrgBusinesServiceHelper.getCompanyByAdminOrgId(orgId);
            Long companyId = 0L;
            if (company != null) {
                companyId = company.getLong("id");
            }
            Long parentCompanyId = WorkRolesServiceHelper.getParentCompanyId(orgId, parentOrgId, companyId);
            DynamicObject reportRel = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hbss_reportingrelation"));
            reportRel.set("role", (Object)role.getLong("id"));
            reportRel.set("company", (Object)companyId);
            reportRel.set("reportingtype", (Object)"1010");
            reportRel.set("adminorg", (Object)orgId);
            reportRel.set("parent", (Object)parentRole.getLong("id"));
            reportRel.set("parentadmin", (Object)parentOrgId);
            reportRel.set("parentcompany", (Object)parentCompanyId);
            if (HRStringUtils.equals((String)role.getString("createtype"), (String)"2")) {
                position = WorkRolesServiceHelper.getPositionByRoleId(role.getLong("id"));
                reportRel.set("position", (Object)position.getLong("id"));
            }
            if (HRStringUtils.equals((String)parentRole.getString("createtype"), (String)"2")) {
                position = WorkRolesServiceHelper.getPositionByRoleId(parentRole.getLong("id"));
                reportRel.set("parentposition", (Object)position.getLong("id"));
            }
            reportRel.set("enable", (Object)enable);
            if (HRStringUtils.equals((String)"1", (String)enable)) {
                reportRel.set("enabledate", (Object)new Date());
            } else if (HRStringUtils.equals((String)"0", (String)enable)) {
                reportRel.set("disabledate", (Object)new Date());
            }
            reportRel.set("createtype", (Object)"1");
            serviceHelper.saveOne(reportRel);
        }
    }

    private static Long getParentCompanyId(Long orgId, Long parentOrgId, Long companyId) {
        DynamicObject parentCompany;
        Long parentCompanyId = !orgId.equals(parentOrgId) ? ((parentCompany = AdminOrgBusinesServiceHelper.getCompanyByAdminOrgId(parentOrgId)) != null ? Long.valueOf(parentCompany.getLong("id")) : Long.valueOf(0L)) : companyId;
        return parentCompanyId;
    }

    public static DynamicObject getPositionByRoleId(Long roleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_position");
        QFilter roleFilter = new QFilter("workrole", "=", (Object)roleId);
        return serviceHelper.queryOne(new QFilter[]{roleFilter});
    }

    public static void enableReportingRelation(Long roleId) {
        String roleStatus;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        String selectFileds = "id, enable,parent, enabledate, disabledate";
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter reportTypeFilter = new QFilter("reportingtype", "=", (Object)"1010");
        DynamicObject reportRel = serviceHelper.queryOne(selectFileds, new QFilter[]{roleFilter, reportTypeFilter}, "disabledate desc");
        if (null != reportRel && HRStringUtils.equals((String)"1", (String)(roleStatus = reportRel.getString("parent.enable")))) {
            reportRel.set("enable", (Object)"1");
            reportRel.set("disabledate", null);
            reportRel.set("enabledate", (Object)new Date());
            serviceHelper.updateOne(reportRel);
        }
    }

    public static void batchEnableReportingRelation(List<Long> roleIds) {
        DynamicObject[] reportRels;
        ArrayList<String> enableStatus = new ArrayList<String>();
        enableStatus.add("0");
        enableStatus.add("2");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        QFilter reportRelFilter = new QFilter("role", "in", roleIds);
        QFilter enableStatusFilter = new QFilter("enable", "in", enableStatus);
        QFilter reportTypeFilter = new QFilter("reportingtype", "=", (Object)"1010");
        String selectFileds = "id,enable,role.id,parent, enabledate,disabledate";
        Date nowDate = new Date();
        DynamicObject[] dys = serviceHelper.query(selectFileds, new QFilter[]{reportRelFilter, enableStatusFilter, reportTypeFilter});
        HashMap<Long, List<Pair<Long, Date>>> reportRelDataMap = new HashMap<Long, List<Pair<Long, Date>>>();
        WorkRolesServiceHelper.reportRelDataFilter(dys, reportRelDataMap);
        Iterator reportRelEntries = reportRelDataMap.entrySet().iterator();
        ArrayList<Object> ids = new ArrayList<Object>(reportRelDataMap.size());
        while (reportRelEntries.hasNext()) {
            Map.Entry reportRelEntry = reportRelEntries.next();
            ids.add(((Pair)((List)reportRelEntry.getValue()).get(0)).getLeft());
        }
        QFilter reportRelIdFilter = new QFilter("id", "in", ids);
        for (DynamicObject reportRel : reportRels = serviceHelper.query(selectFileds, new QFilter[]{reportRelIdFilter})) {
            String roleStatus = reportRel.getString("parent.enable");
            if (!HRStringUtils.equals((String)"1", (String)roleStatus)) continue;
            reportRel.set("enable", (Object)"1");
            reportRel.set("enabledate", (Object)nowDate);
            reportRel.set("disabledate", null);
        }
        serviceHelper.update(reportRels);
    }

    private static void reportRelDataFilter(DynamicObject[] dys, Map<Long, List<Pair<Long, Date>>> reportRelDataMap) {
        for (DynamicObject dyc : dys) {
            Long roleId = dyc.getLong(FIELD_ROLE_ID);
            Long reportRelId = dyc.getLong("id");
            Date disableDate = dyc.getDate("disabledate");
            Pair dataPair = Pair.of((Object)reportRelId, (Object)disableDate);
            if (!reportRelDataMap.containsKey(roleId)) {
                reportRelDataMap.put(roleId, Lists.newArrayList((Object[])new Pair[]{dataPair}));
                continue;
            }
            WorkRolesServiceHelper.handleDate(reportRelDataMap, roleId, (Pair<Long, Date>)dataPair);
        }
    }

    private static void handleDate(Map<Long, List<Pair<Long, Date>>> reportRelDataMap, Long roleId, Pair<Long, Date> dataPair) {
        Date newDate = (Date)dataPair.getRight();
        Date oldDate = (Date)reportRelDataMap.get(roleId).get(0).getRight();
        if (null != newDate) {
            if (null != oldDate) {
                if (newDate.compareTo(oldDate) >= 0) {
                    reportRelDataMap.put(roleId, Lists.newArrayList((Object[])new Pair[]{dataPair}));
                }
            } else {
                reportRelDataMap.put(roleId, Lists.newArrayList((Object[])new Pair[]{dataPair}));
            }
        }
    }

    public static DynamicObject getReportingRelationByRoleId(Long roleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
        QFilter reportTypeFilter = new QFilter("reportingtype", "=", (Object)Long.valueOf("1010"));
        String selectFields = "parent, parentadmin, enable";
        return serviceHelper.queryOne(selectFields, new QFilter[]{roleFilter, enableFilter, reportTypeFilter});
    }

    public static void disableReportingRelation(Long roleId) {
        DynamicObject[] reportingRelations;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        String selectFields = "id, enable, adminorg, disabledate";
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter parentRoleFilter = new QFilter(FIELD_PARENT_ID, "=", (Object)roleId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        for (DynamicObject reportingRelation : reportingRelations = serviceHelper.query(selectFields, new QFilter[]{roleFilter, enableFilter})) {
            reportingRelation.set("enable", (Object)"0");
            reportingRelation.set("disabledate", (Object)new Date());
        }
        serviceHelper.update(reportingRelations);
        reportingRelations = serviceHelper.query(selectFields, new QFilter[]{parentRoleFilter, enableFilter});
        if (reportingRelations.length > 0) {
            for (DynamicObject reportingRelation : reportingRelations) {
                reportingRelation.set("enable", (Object)"0");
                reportingRelation.set("disabledate", (Object)new Date());
            }
            serviceHelper.update(reportingRelations);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void batchDisableReportingRelation(List<Long> roleIds) {
        void var11_14;
        Object[] subReportRelations;
        Object[] reportingRelations;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        String selectFields = "id, enable, adminorg, disabledate";
        QFilter roleFilter = new QFilter("role", "in", roleIds);
        QFilter parentRoleFilter = new QFilter(FIELD_PARENT_ID, "in", roleIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Date nowDate = new Date();
        for (DynamicObject dynamicObject : reportingRelations = serviceHelper.query(selectFields, new QFilter[]{roleFilter, enableFilter})) {
            dynamicObject.set("enable", (Object)"0");
            dynamicObject.set("disabledate", (Object)nowDate);
        }
        Object[] objectArray = subReportRelations = serviceHelper.query(selectFields, new QFilter[]{parentRoleFilter, enableFilter});
        int n = objectArray.length;
        boolean bl = false;
        while (var11_14 < n) {
            DynamicObject dynamicObject = objectArray[var11_14];
            dynamicObject.set("enable", (Object)"0");
            dynamicObject.set("disabledate", (Object)nowDate);
            ++var11_14;
        }
        DynamicObject[] reportRelations = (DynamicObject[])ObjectArrays.concat((Object[])reportingRelations, (Object[])subReportRelations, DynamicObject.class);
        serviceHelper.update(reportRelations);
    }

    public static HashMap<String, String> getSubRoleOfNowWorkRole(List<Long> roleIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        QFilter nowRoleFilter = new QFilter(FIELD_ROLE_ID, "in", roleIds);
        QFilter parentRoleFilter = new QFilter(FIELD_PARENT_ID, "in", roleIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] subRoles = serviceHelper.query("role,parent", new QFilter[]{parentRoleFilter, enableFilter});
        DynamicObject[] nowRoles = serviceHelper.query("role", new QFilter[]{nowRoleFilter, enableFilter});
        HashMap<String, String> roleNameMap = new HashMap<String, String>();
        for (DynamicObject nowRole : nowRoles) {
            StringBuilder subRoleNames = new StringBuilder();
            String nowRoleName = nowRole.getString("role.name");
            Long nowRoleId = nowRole.getLong(FIELD_ROLE_ID);
            for (DynamicObject subRole : subRoles) {
                Long subRoleId = subRole.getLong(FIELD_PARENT_ID);
                if (!nowRoleId.equals(subRoleId)) continue;
                subRoleNames.append(subRole.get("role.name")).append(',');
            }
            if (subRoleNames.length() <= 0) continue;
            roleNameMap.put(nowRoleName, subRoleNames.toString());
        }
        return roleNameMap;
    }

    public static void deleteReportingRelation(Long roleId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        QFilter roleFilter = new QFilter("role", "=", (Object)roleId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"2");
        serviceHelper.deleteByFilter(new QFilter[]{roleFilter, enableFilter});
    }

    public static Long getRoleIdByPositionId(Long positionId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_position");
        String selectFields = FIELD_WORKROLE_ID;
        QFilter idFilter = new QFilter("id", "=", (Object)positionId);
        DynamicObject position = serviceHelper.queryOne(selectFields, new QFilter[]{idFilter});
        if (position != null) {
            return position.getLong(FIELD_WORKROLE_ID);
        }
        return 0L;
    }

    public static DynamicObjectCollection getRolesByPersonId(Long personId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
        QFilter personFilter = new QFilter(FIELD_PERSON, "=", (Object)personId);
        return serviceHelper.queryOriginalCollection(FIELD_ROLE_ID, new QFilter[]{personFilter});
    }

    public static DynamicObjectCollection getRolesHisByPersonId(Long personId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhishr");
        QFilter personFilter = new QFilter(FIELD_PERSON, "=", (Object)personId);
        return serviceHelper.queryOriginalCollection("role.id, iseffective, startdate, enddate", new QFilter[]{personFilter});
    }

    public static Map<Long, List<Long>> getSuperiorByAdministrativeReport(Long personId, Long roleId, Long empposorgrelId) {
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        ArrayList<Long> superiorIds = new ArrayList<Long>();
        DynamicObjectCollection roleColl = WorkRolesServiceHelper.getRolesByPersonId(personId);
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (DynamicObject roleDyn : roleColl) {
            roleIds.add(roleDyn.getLong(FIELD_ROLE_ID));
        }
        Map<Long, List<Long>> personIdMap = PersonRoleRelServiceHelper.getParentPersonIdsByRoleIds(roleIds);
        if (WorkRolesServiceHelper.getSuperiorIdsByRoleId(roleId, result, roleIds, personIdMap)) {
            return result;
        }
        superiorIds = new ArrayList();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_empposorgrel");
        QFilter idFilter = new QFilter(FIELD_PERSON, "=", (Object)personId);
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter mainQFilter = null;
        mainQFilter = empposorgrelId != null ? new QFilter("id", "=", (Object)empposorgrelId) : new QFilter("isprimary", "=", (Object)Boolean.TRUE);
        DynamicObject dynamicObject = serviceHelper.queryOne("position, adminorg", new QFilter[]{idFilter, statusFilter, mainQFilter});
        if (dynamicObject != null) {
            if (WorkRolesServiceHelper.getSuperiorIdsByPositionId(result, roleIds, personIdMap, dynamicObject)) {
                return result;
            }
            if (WorkRolesServiceHelper.getSuperiorIdsByOrgId(result, roleIds, personIdMap, dynamicObject)) {
                return result;
            }
            ArrayList<Long> orgIds = new ArrayList<Long>();
            superiorIds = new ArrayList();
            orgIds.add(dynamicObject.getLong(FIELD_ADMINORG_ID));
            DynamicObject[] personDyn = PersonRoleRelServiceHelper.getMainChargePeoByOrgId(orgIds);
            if (WorkRolesServiceHelper.getSuperiorIdsByPersonId(result, superiorIds, personDyn)) {
                return result;
            }
        }
        return result;
    }

    private static boolean getSuperiorIdsByPersonId(Map<Long, List<Long>> result, List<Long> superiorIds, DynamicObject[] personDyn) {
        if (personDyn != null) {
            Long mainRoleId = 0L;
            for (DynamicObject person : personDyn) {
                Long mainChargePersonId = person.getLong(FIELD_PERSON_ID);
                superiorIds.add(mainChargePersonId);
                mainRoleId = person.getLong(FIELD_ROLE_ID);
            }
            if (mainRoleId.equals(0L)) {
                return true;
            }
            result.put(mainRoleId, superiorIds);
        }
        return false;
    }

    private static boolean getSuperiorIdsByOrgId(Map<Long, List<Long>> result, List<Long> roleIds, Map<Long, List<Long>> personIdMap, DynamicObject dynamicObject) {
        DynamicObject[] roleDys;
        List<Object> superiorIds = new ArrayList();
        Long orgId = dynamicObject.getLong(FIELD_ADMINORG_ID);
        for (DynamicObject roleDyn : roleDys = WorkRolesServiceHelper.getRoleByOrgId(orgId)) {
            Long orgRoleId = roleDyn.getLong("id");
            superiorIds = personIdMap.get(orgRoleId);
            Boolean mainCharge = roleDyn.getBoolean("mainpeoincharge");
            if (mainCharge.booleanValue() && roleIds.contains(orgRoleId) && superiorIds != null && superiorIds.size() > 0) {
                result.put(orgRoleId, superiorIds);
                return true;
            }
            if (!roleIds.contains(orgRoleId) || !mainCharge.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean getSuperiorIdsByPositionId(Map<Long, List<Long>> result, List<Long> roleIds, Map<Long, List<Long>> personIdMap, DynamicObject dynamicObject) {
        Long positionId = dynamicObject.getLong("position.id");
        if (positionId != null && !positionId.equals(0L)) {
            Long positionRoleId = WorkRolesServiceHelper.getRoleIdByPositionId(positionId);
            List<Long> superiorIds = personIdMap.get(positionRoleId);
            if (roleIds.contains(positionRoleId) && superiorIds != null && superiorIds.size() > 0) {
                result.put(positionRoleId, superiorIds);
                return true;
            }
        }
        return false;
    }

    private static boolean getSuperiorIdsByRoleId(Long roleId, Map<Long, List<Long>> result, List<Long> roleIds, Map<Long, List<Long>> personIdMap) {
        if (roleId != null) {
            List<Long> superiorIds = personIdMap.get(roleId);
            if (roleIds.contains(roleId) && superiorIds != null && superiorIds.size() > 0) {
                result.put(roleId, superiorIds);
                return true;
            }
        }
        return false;
    }

    public static Map<Long, Map<Long, List<Long>>> getSuperiors(List<Long> sourcePersonIds, List<Long> sourceRoleIds, List<Long> sourceEmpposorgrelIds) {
        HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>();
        HashMap<Long, List<Long>> innerResult = new HashMap<Long, List<Long>>();
        if (sourcePersonIds == null || sourcePersonIds.size() == 0) {
            return result;
        }
        ArrayList<Long> copyPersonIds = new ArrayList<Long>(sourcePersonIds);
        DynamicObjectCollection dys = WorkRolesServiceHelper.getRolesByPersonIds(sourcePersonIds);
        HashMap<Long, List<Long>> rolePersonMap = new HashMap<Long, List<Long>>();
        ArrayList<Long> allRoles = new ArrayList<Long>();
        Long personId = -1L;
        Long roleId = -1L;
        for (DynamicObject dy : dys) {
            WorkRolesServiceHelper.addToRolePersonMap(rolePersonMap, allRoles, dy);
        }
        Map<Long, List<Long>> roleSuperiorMap = PersonRoleRelServiceHelper.getParentPersonIdsByRoleIds(allRoles);
        WorkRolesServiceHelper.handleSourceRoleIds(sourcePersonIds, sourceRoleIds, result, innerResult, copyPersonIds, rolePersonMap, allRoles, roleSuperiorMap);
        if (copyPersonIds.size() == 0) {
            return result;
        }
        ArrayList<Long> findOrgRelPersons = new ArrayList<Long>();
        ArrayList<Long> findOrgRelIds = new ArrayList<Long>();
        WorkRolesServiceHelper.sourceEmpOrgRelIds(sourcePersonIds, sourceEmpposorgrelIds, copyPersonIds, findOrgRelPersons, findOrgRelIds);
        QFilter filter = new QFilter("id", "in", findOrgRelIds);
        WorkRolesServiceHelper.putSuperiorByOrgRel(sourceRoleIds, result, innerResult, findOrgRelPersons, rolePersonMap, roleSuperiorMap, allRoles, filter);
        filter = new QFilter("isprimary", "=", (Object)Boolean.TRUE);
        WorkRolesServiceHelper.putSuperiorByOrgRel(sourceRoleIds, result, innerResult, copyPersonIds, rolePersonMap, roleSuperiorMap, allRoles, filter);
        return result;
    }

    private static void handleSourceRoleIds(List<Long> sourcePersonIds, List<Long> sourceRoleIds, Map<Long, Map<Long, List<Long>>> result, Map<Long, List<Long>> innerResult, List<Long> copyPersonIds, Map<Long, List<Long>> rolePersonMap, List<Long> allRoles, Map<Long, List<Long>> roleSuperiorMap) {
        if (Objects.isNull(sourceRoleIds)) {
            return;
        }
        int index = 0;
        for (Long sourceRoleId : sourceRoleIds) {
            List<Long> superiorIds = roleSuperiorMap.get(sourceRoleId);
            if (allRoles.contains(sourceRoleId) && superiorIds != null && superiorIds.size() > 0) {
                WorkRolesServiceHelper.handleSourceRoleIdsDetail(rolePersonMap, sourceRoleId, sourcePersonIds, index, copyPersonIds, innerResult, superiorIds, result);
            }
            ++index;
        }
    }

    private static void handleSourceRoleIdsDetail(Map<Long, List<Long>> rolePersonMap, Long sourceRoleId, List<Long> sourcePersonIds, int index, List<Long> copyPersonIds, Map<Long, List<Long>> innerResult, List<Long> superiorIds, Map<Long, Map<Long, List<Long>>> result) {
        List<Long> tempList = rolePersonMap.get(sourceRoleId);
        for (Long person : tempList) {
            if (!person.equals(sourcePersonIds.get(index))) continue;
            copyPersonIds.remove(person);
            innerResult.put(sourceRoleId, superiorIds);
            result.put(person, innerResult);
            innerResult.clear();
            break;
        }
    }

    private static void addToRolePersonMap(Map<Long, List<Long>> rolePersonMap, List<Long> allRoles, DynamicObject dy) {
        Long personId = dy.getLong(FIELD_PERSON_ID);
        Long roleId = dy.getLong(FIELD_ROLE_ID);
        allRoles.add(roleId);
        List<Long> personTempList = rolePersonMap.get(roleId);
        if (personTempList != null) {
            List<Long> tempList = personTempList;
            tempList.add(personId);
            rolePersonMap.put(roleId, tempList);
        } else {
            ArrayList<Long> tempList = new ArrayList<Long>();
            tempList.add(personId);
            rolePersonMap.put(roleId, tempList);
        }
    }

    private static void sourceEmpOrgRelIds(List<Long> sourcePersonIds, List<Long> sourceEmpposorgrelIds, List<Long> copyPersonIds, List<Long> findOrgRelPersons, List<Long> findOrgRelIds) {
        if (sourceEmpposorgrelIds != null) {
            Long empty = -2L;
            int notExsit = -1;
            for (Long copyPersonId : copyPersonIds) {
                Long curOrgRelId;
                int index = sourcePersonIds.indexOf(copyPersonId);
                if (index == notExsit || empty.equals(curOrgRelId = sourceEmpposorgrelIds.get(index))) continue;
                findOrgRelPersons.add(copyPersonId);
                findOrgRelIds.add(curOrgRelId);
            }
        }
        copyPersonIds.removeAll(findOrgRelPersons);
    }

    public static Map<Long, Map<Long, List<Long>>> getSuperiors(List<Map<String, Object>> params) {
        ArrayList<Long> personIds = new ArrayList<Long>();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<Long> empposorgrelIds = new ArrayList<Long>();
        int pernum = 0;
        int rolenum = 0;
        int relnum = 0;
        Long empty = -2L;
        for (Map<String, Object> param : params) {
            Object personId = param.get("id");
            pernum = WorkRolesServiceHelper.getLongParam(personIds, pernum, empty, personId);
            Object roleId = param.get("roleid");
            rolenum = WorkRolesServiceHelper.getLongParam(roleIds, rolenum, empty, roleId);
            Object empposorgrelId = param.get("empposorgrelid");
            relnum = WorkRolesServiceHelper.getLongParam(empposorgrelIds, relnum, empty, empposorgrelId);
        }
        if (pernum == 0) {
            personIds = null;
        }
        if (rolenum == 0) {
            roleIds = null;
        }
        if (relnum == 0) {
            empposorgrelIds = null;
        }
        return WorkRolesServiceHelper.getSuperiors(personIds, roleIds, empposorgrelIds);
    }

    private static int getLongParam(List<Long> roleIds, int rolenum, Long empty, Object roleId) {
        if (roleId instanceof Long) {
            if (!roleId.equals(0L)) {
                roleIds.add((Long)roleId);
                ++rolenum;
            } else {
                roleIds.add(empty);
            }
        } else {
            roleIds.add(empty);
        }
        return rolenum;
    }

    private static void putSuperiorByOrgRel(List<Long> sourceRoleIds, Map<Long, Map<Long, List<Long>>> result, Map<Long, List<Long>> innerResult, List<Long> personIds, Map<Long, List<Long>> rolePersonMap, Map<Long, List<Long>> roleSuperiorMap, List<Long> allRoles, QFilter filter) {
        List orgPersonList;
        if (personIds.size() == 0) {
            return;
        }
        DynamicObject[] orgRelDys = WorkRolesServiceHelper.queryOrgRelDys(personIds, filter);
        ArrayList positionList = Lists.newArrayListWithExpectedSize((int)orgRelDys.length);
        ArrayList orgList = Lists.newArrayListWithExpectedSize((int)orgRelDys.length);
        HashMap orgPersonMap = Maps.newHashMapWithExpectedSize((int)orgRelDys.length);
        for (DynamicObject orgRelDy : orgRelDys) {
            WorkRolesServiceHelper.handleOrgRelDy(positionList, orgList, orgPersonMap, orgRelDy);
        }
        List<Long> positionRoleIds = WorkRolesServiceHelper.getRoleIdsByPositionIds(positionList);
        for (Long positionRoleId : positionRoleIds) {
            WorkRolesServiceHelper.handlePostitionRoleId(sourceRoleIds, result, innerResult, personIds, rolePersonMap, roleSuperiorMap, positionRoleId);
        }
        if (personIds.size() == 0) {
            return;
        }
        ArrayList<Long> superiorIds = new ArrayList<Long>();
        DynamicObject[] mainChargeDys = WorkRolesServiceHelper.getMainChargePeoByOrgId(orgList);
        if (mainChargeDys == null || mainChargeDys.length == 0) {
            return;
        }
        long dyOrgId = -1L;
        long dyRoleId = 0L;
        long currentOrgId = mainChargeDys[0].getLong("role.adminorg.id");
        for (DynamicObject mainChargeDy : mainChargeDys) {
            dyOrgId = mainChargeDy.getLong("role.adminorg.id");
            dyRoleId = mainChargeDy.getLong(FIELD_ROLE_ID);
            if (currentOrgId == dyOrgId && dyOrgId != 0L) {
                superiorIds.add(mainChargeDy.getLong(FIELD_PERSON_ID));
                continue;
            }
            orgPersonList = (List)orgPersonMap.get(currentOrgId);
            WorkRolesServiceHelper.handleOrgPersonList(result, innerResult, personIds, roleSuperiorMap, superiorIds, dyRoleId, orgPersonList);
            superiorIds = new ArrayList();
            superiorIds.add(mainChargeDy.getLong(FIELD_PERSON_ID));
            currentOrgId = dyOrgId;
        }
        orgPersonList = (List)orgPersonMap.get(dyOrgId);
        WorkRolesServiceHelper.handleOrgPersonList(result, innerResult, personIds, roleSuperiorMap, superiorIds, dyRoleId, orgPersonList);
    }

    private static DynamicObject[] queryOrgRelDys(List<Long> personIds, QFilter filter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_empposorgrel");
        QFilter idFilter = new QFilter(FIELD_PERSON, "in", personIds);
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        return serviceHelper.query("position.id, adminorg.id,person.id", new QFilter[]{idFilter, statusFilter, filter});
    }

    private static void handleOrgRelDy(List<Long> positionList, List<Long> orgList, Map<Long, List<Long>> orgPersonMap, DynamicObject orgReldy) {
        Long tempPositionId = orgReldy.getLong("position.id");
        Long tempPersonId = orgReldy.getLong(FIELD_PERSON_ID);
        Long tempOrgId = orgReldy.getLong(FIELD_ADMINORG_ID);
        positionList.add(tempPositionId);
        orgList.add(tempOrgId);
        if (!orgPersonMap.containsKey(tempOrgId)) {
            ArrayList<Long> personValues = new ArrayList<Long>();
            personValues.add(tempPersonId);
            orgPersonMap.put(tempOrgId, personValues);
        }
    }

    private static void handlePostitionRoleId(List<Long> sourceRoleIds, Map<Long, Map<Long, List<Long>>> result, Map<Long, List<Long>> innerResult, List<Long> personIds, Map<Long, List<Long>> rolePersonMap, Map<Long, List<Long>> roleSuperiorMap, Long positionRoleId) {
        List<Long> superiorIds = roleSuperiorMap.get(positionRoleId);
        if (sourceRoleIds != null && sourceRoleIds.contains(positionRoleId) && superiorIds != null && superiorIds.size() > 0) {
            List<Long> tempPersonList = rolePersonMap.get(positionRoleId);
            for (Long personId : tempPersonList) {
                if (!personIds.contains(personId)) continue;
                personIds.remove(personId);
                innerResult.put(positionRoleId, superiorIds);
                result.put(personId, innerResult);
                innerResult.clear();
            }
        }
    }

    private static void handleOrgPersonList(Map<Long, Map<Long, List<Long>>> result, Map<Long, List<Long>> innerResult, List<Long> personIds, Map<Long, List<Long>> roleSuperiorMap, List<Long> superiorIds, long dyRoleId, List<Long> orgPersonList) {
        if (Objects.isNull(orgPersonList)) {
            return;
        }
        for (Long personId : orgPersonList) {
            if (!personIds.contains(personId)) continue;
            WorkRolesServiceHelper.handleOrgPersonListDetail(superiorIds, personId, innerResult, dyRoleId, result, roleSuperiorMap, personIds);
        }
    }

    private static void handleOrgPersonListDetail(List<Long> superiorIds, Long personId, Map<Long, List<Long>> innerResult, long dyRoleId, Map<Long, Map<Long, List<Long>>> result, Map<Long, List<Long>> roleSuperiorMap, List<Long> personIds) {
        if (!superiorIds.contains(personId)) {
            innerResult.put(dyRoleId, superiorIds);
            result.put(personId, innerResult);
            innerResult.clear();
        } else {
            List<Long> mainSuperiorIds = roleSuperiorMap.get(dyRoleId);
            if (mainSuperiorIds != null && mainSuperiorIds.size() != 0) {
                personIds.remove(personId);
                innerResult.put(dyRoleId, mainSuperiorIds);
                result.put(personId, innerResult);
                innerResult.clear();
            }
        }
    }

    private static DynamicObject[] getMainChargePeoByOrgId(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
        QFilter mainchargeFilter = new QFilter("role.mainpeoincharge", "=", (Object)Boolean.TRUE);
        QFilter orgFilter = new QFilter("role.adminorg", "in", orgIdList);
        QFilter enable = new QFilter("iseffective", "=", (Object)Boolean.TRUE);
        return serviceHelper.query("person.id,role.adminorg.id", new QFilter[]{mainchargeFilter, orgFilter, enable}, "role.adminorg");
    }

    private static List<Long> getRoleIdsByPositionIds(List<Long> positionList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_position");
        String selectFields = FIELD_WORKROLE_ID;
        QFilter idFilter = new QFilter("id", "in", positionList);
        DynamicObject[] positions = serviceHelper.query(selectFields, new QFilter[]{idFilter});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)positions.length);
        for (DynamicObject position : positions) {
            result.add(position.getLong(selectFields));
        }
        return result;
    }

    private static DynamicObjectCollection getRolesByPersonIds(List<Long> personIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_personrolerelhr");
        QFilter personFilter = new QFilter(FIELD_PERSON, "in", personIds);
        String orderFiled = FIELD_PERSON_ID;
        DynamicObjectCollection dys = serviceHelper.queryOriginalCollection("role.id,person.id", new QFilter[]{personFilter}, orderFiled);
        return dys == null ? new DynamicObjectCollection() : dys;
    }

    public static DynamicObject[] getReportRelByRoleIdsAndReportType(Long[] roleIds, String reportType) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_reportingrelation");
        QFilter roleIdFilter = new QFilter("role", "in", (Object)roleIds);
        QFilter typeFilter = new QFilter("reportingtype", "=", (Object)reportType);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return serviceHelper.query("role.id, parent.id", new QFilter[]{roleIdFilter, typeFilter, enableFilter});
    }

    public static DynamicObject[] getNotMainChargeRoleByOrgId(Long orgId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_workroles");
        String selectFields = "name, mainpeoincharge, id, createtype, adminorg";
        QFilter orgFilter = new QFilter("adminorg", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter mainChargeFilter = new QFilter("mainpeoincharge", "=", (Object)false);
        return serviceHelper.query(selectFields, new QFilter[]{orgFilter, enableFilter, mainChargeFilter});
    }
}

