/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class CapacityDimUpgradeTask
extends AbstractTask {
    private static final String NEW_PROPERTIES = "longnumber,fullname,isleaf,level,masterid,createorg,number,name,parentdim.longnumber,parentdim.level,parentdim.fullname,parentdim.isleaf,type,ctrlstrategy,description,createtime,modifytime,modifier,org,parent";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.upgrade();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    public void upgrade() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_capacitygroup");
        DynamicObject[] originalArray = helper.query(NEW_PROPERTIES, new QFilter[0]);
        if (null == originalArray || originalArray.length == 0) {
            return;
        }
        Arrays.stream(originalArray).forEach(dynamicObject -> dynamicObject.set("isleaf", (Object)true));
        this.dealTree(originalArray);
        helper.update(originalArray);
    }

    private void dealTree(DynamicObject[] originalArray) {
        List parentIdList = Arrays.stream(originalArray).map(dynamicObject -> dynamicObject.getLong("parentdim_id")).collect(Collectors.toList());
        Map<Long, DynamicObject> dyMap = Arrays.stream(originalArray).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (v1, v2) -> v1));
        parentIdList.remove(0L);
        Arrays.stream(originalArray).forEach(dynamicObject -> {
            long parent = dynamicObject.getLong("parentdim_id");
            ArrayList<String> longNumberList = new ArrayList<String>();
            longNumberList.add(dynamicObject.getString("number"));
            ArrayList<String> fullNameList = new ArrayList<String>();
            fullNameList.add(dynamicObject.getString("name"));
            if (parent > 0L) {
                int level = 0;
                this.getParent(parent, longNumberList, fullNameList, dyMap, level);
            }
            Collections.reverse(longNumberList);
            Collections.reverse(fullNameList);
            String longNumber = String.join((CharSequence)".", longNumberList);
            String fullName = String.join((CharSequence)".", fullNameList);
            dynamicObject.set("level", (Object)longNumberList.size());
            dynamicObject.set("longnumber", (Object)longNumber);
            dynamicObject.set("fullname", (Object)fullName);
            dynamicObject.set("parent", (Object)parent);
            long id = dynamicObject.getLong("id");
            if (!parentIdList.contains(id)) {
                dynamicObject.set("isleaf", (Object)true);
            } else {
                dynamicObject.set("isleaf", (Object)false);
            }
        });
    }

    private void getParent(long parent, List<String> longNumber, List<String> fullName, Map<Long, DynamicObject> dyMap, int level) {
        if (level > 10) {
            return;
        }
        if (parent == 0L) {
            return;
        }
        DynamicObject dynamicObject = dyMap.get(parent);
        if (null == dynamicObject) {
            return;
        }
        String name = dynamicObject.getString("name");
        String number = dynamicObject.getString("number");
        longNumber.add(number);
        fullName.add(name);
        long parentId = dynamicObject.getLong("parentdim_id");
        this.getParent(parentId, longNumber, fullName, dyMap, ++level);
    }
}

