/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbss.bussiness.service.hrbu.HRBUSyncStrategyService;
import kd.hr.hbss.bussiness.service.hrbu.HRBUValidationService;
import kd.hr.hbss.bussiness.servicehelper.BosOrgServiceHelper;
import kd.hr.hbss.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hbss.common.constants.HRBUConstants;

public class HRBuSync {
    private static final Log LOGGER = LogFactory.getLog(HRBuSync.class);
    private static final Map<Long, String> tagMap = new HashMap<Long, String>(){
        private static final long serialVersionUID = -3036043921860314035L;
        {
            this.put(11L, "fishr");
            this.put(21L, "fishrod");
            this.put(22L, "fishrop");
            this.put(23L, "fishrbg");
            this.put(24L, "fishrtr");
            this.put(25L, "fishrpa");
            this.put(26L, "fishrwt");
            this.put(27L, "fishrcmp");
            this.put(28L, "fishrbs");
            this.put(29L, "fishrpay");
            this.put(30L, "fishrtax");
            this.put(31L, "fishrsi");
            this.put(32L, "fishrlti");
            this.put(33L, "fishrbm");
            this.put(34L, "fishrtd");
            this.put(35L, "fishrtl");
            this.put(36L, "fishrip");
            this.put(37L, "fishrssc");
            this.put(38L, "fishrlc");
            this.put(39L, "fishrab");
        }
    };
    private static final String SELECT_FIELDS = "id,view,org,parent,enable,longnumber,status,isfreeze";

    public static Map<Long, String> getViewMap() {
        return new HashMap<Long, String>(tagMap);
    }

    public static void syncHrBu() {
        long start = System.currentTimeMillis();
        LOGGER.info("syncHrBu start......");
        HRBuSync.syncView(HRBUExtServiceHelper.getChildViewIds(HRBUConstants.HR_VIEW_ID));
        LOGGER.info("syncHrBu end......{}", (Object)(System.currentTimeMillis() - start));
    }

    private static void syncView(List<Long> childViewIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter viewFilter = new QFilter("view", "in", childViewIds);
        DynamicObject[] viewDys = serviceHelper.query(SELECT_FIELDS, viewFilter.toArray(), "longnumber");
        Map<Long, List<DynamicObject>> collect = Arrays.stream(viewDys).collect(Collectors.groupingBy(dy -> dy.getLong("view.id")));
        List<DynamicObject> hrBuViewDys = collect.remove(HRBUConstants.HR_VIEW_ID);
        ArrayList<OrgParam> orgParams = new ArrayList<OrgParam>(16);
        for (Map.Entry<Long, List<DynamicObject>> entry : collect.entrySet()) {
            Long childViewId = entry.getKey();
            List<DynamicObject> childViewDys = entry.getValue();
            Map<String, List<OrgParam>> paramsMap = HRBUSyncStrategyService.compareTreeStructure(childViewDys, hrBuViewDys, childViewId);
            List<OrgParam> params = paramsMap.get("all");
            orgParams.addAll(params);
        }
        if (orgParams.size() > 0) {
            HRBuSync.syncTree(orgParams);
        }
    }

    private static void syncTree(List<OrgParam> orgParams) {
        if (CollectionUtils.isEmpty(orgParams)) {
            LOGGER.info("HRBuSync.syncTree not result");
            return;
        }
        OrgApiResult result = BosOrgServiceHelper.batchSyncHROrg(orgParams);
        if (!result.isSuccess()) {
            LOGGER.info("HRBuSync.syncTree result:{}", (Object)result.getErrorMsg());
            for (OrgApiResult res : result.getResultList()) {
                LOGGER.info("HRBuSync.syncTree result:{}", (Object)res.getErrorMsg());
            }
        }
    }

    public static void addHRRoot() {
        Set<Long> viewSet = HRBUValidationService.getVersionView();
        for (Long viewId : viewSet) {
            HRBuSync.initRoot(viewId);
        }
    }

    private static void initRoot(Long viewId) {
        try {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_org_structure");
            boolean exists = helper.isExists(new QFilter[]{new QFilter("parent", "=", (Object)0L), new QFilter("view", "=", (Object)viewId)});
            if (!exists) {
                HRBuSync.addRoot(viewId);
            }
        }
        catch (Exception ex) {
            LOGGER.info("HRBuSync.initRoot error:", (Object)ex);
        }
    }

    private static void addRoot(Long viewId) {
        DynamicObject rootDy = HRBUExtServiceHelper.queryChildrenViewRootByViewId(HRBUConstants.HR_VIEW_ID);
        OrgParam orgParam = new OrgParam();
        orgParam.setParentId(0L);
        orgParam.setId(rootDy.getLong("org.id"));
        orgParam.setName(rootDy.getString("name"));
        orgParam.setSimpleName(rootDy.getString("name"));
        orgParam.setNumber(rootDy.getString("number"));
        orgParam.setDuty(String.valueOf(viewId));
        orgParam.setOperationType(OperationType.addDuty);
        TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
        multiViewMap.put(String.valueOf(viewId), new OrgDutyView(0L));
        orgParam.setMultiViewMap(multiViewMap);
        OrgUnitServiceHelper.addDutyRoot((OrgParam)orgParam);
        LOGGER.info("HRBuSync.addRoot(),orgParam:{}", (Object)orgParam);
    }
}

