/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbss.bussiness.task.HrVerifyCodeClearTask;

public class HrSafeUriClearTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HrVerifyCodeClearTask.class);
    private static final String DAY_AGO = "dayAgo";
    private static final int DAY_AGO_DEFAULT = 30;
    private static final String ENTITY_HBSS_SAFEUTI = "hbss_safeuri";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int day = 30;
        if (map.containsKey(DAY_AGO)) {
            String dayAgo = map.get(DAY_AGO).toString();
            try {
                int dayAgoParam = Integer.parseInt(dayAgo);
                if (dayAgoParam > 0) {
                    day = dayAgoParam;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("errorParam,key:{},value:{}", new Object[]{DAY_AGO, dayAgo, e});
            }
        }
        Date beforeDate = HRDateTimeUtils.addDay((Date)new Date(), (long)(-day));
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(ENTITY_HBSS_SAFEUTI);
        QFilter qFilter = new QFilter("expiryTime", "<", (Object)beforeDate);
        int deleteSize = hrBaseServiceHelper.deleteByFilter(new QFilter[]{qFilter});
        LOGGER.info("clearSafeUri,dayAgo:{},dataSize:{}", (Object)day, (Object)deleteSize);
    }
}

