/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class HrbuDeleteTask
extends AbstractTask {
    private Log logger = LogFactory.getLog(HrbuDeleteTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        try (TXHandle txHandle = TX.required();){
            DynamicObject[] bosOrgStructDys = this.getAllBosOrgStructAboutHR();
            if (null != bosOrgStructDys) {
                ArrayList<Long> hrbuExtList = new ArrayList<Long>();
                ArrayList<Long> hrbuViewExtList = new ArrayList<Long>();
                for (DynamicObject bosOrgStructDy : bosOrgStructDys) {
                    Long viewId = bosOrgStructDy.getLong("view.id");
                    if (Long.compare(11L, viewId) == 0) {
                        Long bosOrgId = bosOrgStructDy.getLong("org.id");
                        hrbuExtList.add(bosOrgId);
                        continue;
                    }
                    hrbuViewExtList.add(bosOrgStructDy.getLong("id"));
                }
                this.logger.info("**** begin delete Dirty Read ****");
                int hrbuExtCount = this.deleteHrbuExtDirtyRead(hrbuExtList);
                this.logger.info("hbss_hrbuext success count : " + hrbuExtCount);
                int hrbuViewExtCount = this.deleteHrbuViewExtDirtyRead(hrbuViewExtList);
                this.logger.info("hbss_hrbuviewext success count : " + hrbuViewExtCount);
                this.logger.info("**** end delete Dirty Read ****");
            }
        }
    }

    private DynamicObject[] getAllBosOrgStructAboutHR() {
        HRBaseServiceHelper bosOrgStructHelper = new HRBaseServiceHelper("bos_org_structure");
        QFilter hrViewFilter = new QFilter("view.treetype", "=", (Object)"11");
        return bosOrgStructHelper.query("org, view", new QFilter[]{hrViewFilter});
    }

    private int deleteHrbuExtDirtyRead(List<Long> hrbuExtList) {
        HRBaseServiceHelper hrbuExtStructHelper = new HRBaseServiceHelper("hbss_hrbuext");
        QFilter filter = new QFilter("bosorg.id", "not in", hrbuExtList);
        return hrbuExtStructHelper.deleteByFilter(new QFilter[]{filter});
    }

    private int deleteHrbuViewExtDirtyRead(List<Long> hrbuViewExtList) {
        HRBaseServiceHelper hrbuExtStructHelper = new HRBaseServiceHelper("hbss_hrbuviewext");
        QFilter filter = new QFilter("bosorgstructure.id", "not in", hrbuViewExtList);
        return hrbuExtStructHelper.deleteByFilter(new QFilter[]{filter});
    }
}

