/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class DuplicateCodeUtil {
    private static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String FIELD_JOB_SEQ_ID = "jobseqid.id";
    private static final String FIELD_JOB_CLASS_LEVEL = "jobclasslevel";
    private static final String FIELD_JOB_FAMILY_ID = "jobfamilyid.id";
    private static final String FIELD_PARENT_ID = "parent.id";

    public static List<TreeNode> getJobSeqTreeNode(boolean isShowDisable) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hjms_jobseq");
        QFilter seqFilter = new QFilter("1", "=", (Object)"1");
        if (!isShowDisable) {
            seqFilter.and("enable", "=", (Object)"1");
        }
        DynamicObject[] seqObjArrays = hrBaseServiceHelper.query("id, name, number", new QFilter[]{seqFilter});
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>(seqObjArrays.length);
        Map<String, List<TreeNode>> familyMap = DuplicateCodeUtil.getJobFamilyTreeNode(isShowDisable);
        for (DynamicObject seqObj : seqObjArrays) {
            TreeNode treeNode = new TreeNode(ROOT_NODE_ID, "1" + seqObj.getString("id"), seqObj.getString("name"));
            List<TreeNode> familyList = familyMap.get(seqObj.getString("id"));
            if (null != familyList && !familyList.isEmpty()) {
                treeNode.addChildren(familyList);
                treeNode.setIsOpened(true);
            }
            treeNodeList.add(treeNode);
        }
        return treeNodeList;
    }

    private static Map<String, List<TreeNode>> getJobFamilyTreeNode(boolean isShowDisable) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hjms_jobfamily");
        QFilter familyFilter = new QFilter("1", "=", (Object)"1");
        if (!isShowDisable) {
            familyFilter.and("enable", "=", (Object)"1");
        }
        DynamicObject[] familyObjArrays = hrBaseServiceHelper.query("id, name, number, jobseqid", new QFilter[]{familyFilter});
        HashMap<String, List<TreeNode>> familyMap = new HashMap<String, List<TreeNode>>();
        Map<String, List<TreeNode>> classMap = DuplicateCodeUtil.getJobClassTreeNode(isShowDisable);
        for (DynamicObject familyObj : familyObjArrays) {
            List<TreeNode> classList;
            TreeNode treeNode;
            ArrayList<TreeNode> familyList = (ArrayList<TreeNode>)familyMap.get(familyObj.getString(FIELD_JOB_SEQ_ID));
            if (null == familyList) {
                familyList = new ArrayList<TreeNode>();
                treeNode = new TreeNode("1" + familyObj.getString(FIELD_JOB_SEQ_ID), "2" + familyObj.getString("id"), familyObj.getString("name"));
                classList = classMap.get(familyObj.getString("id"));
                if (null != classList && !classList.isEmpty()) {
                    treeNode.addChildren(classList);
                    treeNode.setIsOpened(true);
                }
                familyList.add(treeNode);
                familyMap.put(familyObj.getString(FIELD_JOB_SEQ_ID), familyList);
                continue;
            }
            treeNode = new TreeNode("1" + familyObj.getString(FIELD_JOB_SEQ_ID), "2" + familyObj.getString("id"), familyObj.getString("name"));
            classList = classMap.get(familyObj.getString("id"));
            if (null != classList && !classList.isEmpty()) {
                treeNode.setIsOpened(true);
                treeNode.addChildren(classList);
            }
            familyList.add(treeNode);
        }
        return familyMap;
    }

    private static Map<String, List<TreeNode>> getJobClassTreeNode(boolean isShowDisable) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hjms_jobclass");
        QFilter classFilter = new QFilter(FIELD_JOB_CLASS_LEVEL, "=", (Object)1);
        classFilter.and("1", "=", (Object)"1");
        if (!isShowDisable) {
            classFilter.and("enable", "=", (Object)"1");
        }
        DynamicObject[] classObjArrays = hrBaseServiceHelper.query("id, name, number, jobfamilyid", new QFilter[]{classFilter});
        HashMap<String, List<TreeNode>> classMap = new HashMap<String, List<TreeNode>>();
        Map<String, List<TreeNode>> subClassMap = DuplicateCodeUtil.getSubJobClassTreeNode(isShowDisable);
        for (DynamicObject classObj : classObjArrays) {
            List<TreeNode> subClassList;
            TreeNode treeNode;
            ArrayList<TreeNode> classList = (ArrayList<TreeNode>)classMap.get(classObj.getString(FIELD_JOB_FAMILY_ID));
            if (null == classList) {
                classList = new ArrayList<TreeNode>();
                treeNode = new TreeNode("2" + classObj.getString(FIELD_JOB_FAMILY_ID), "3" + classObj.getString("id"), classObj.getString("name"));
                subClassList = subClassMap.get(classObj.getString("id"));
                if (null != subClassList && !subClassList.isEmpty()) {
                    treeNode.addChildren(subClassList);
                }
                classList.add(treeNode);
                classMap.put(classObj.getString(FIELD_JOB_FAMILY_ID), classList);
                continue;
            }
            treeNode = new TreeNode("2" + classObj.getString(FIELD_JOB_FAMILY_ID), "3" + classObj.getString("id"), classObj.getString("name"));
            subClassList = subClassMap.get(classObj.getString("id"));
            if (null != subClassList && !subClassList.isEmpty()) {
                treeNode.addChildren(subClassList);
            }
            classList.add(treeNode);
        }
        return classMap;
    }

    private static Map<String, List<TreeNode>> getSubJobClassTreeNode(boolean isShowDisable) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hjms_jobclass");
        QFilter subClassFilter = new QFilter(FIELD_JOB_CLASS_LEVEL, "=", (Object)2);
        subClassFilter.and("1", "=", (Object)"1");
        if (!isShowDisable) {
            subClassFilter.and("enable", "=", (Object)"1");
        }
        DynamicObject[] subClassObjArrays = hrBaseServiceHelper.query("id, name, number, parent", new QFilter[]{subClassFilter});
        HashMap<String, List<TreeNode>> subClassMap = new HashMap<String, List<TreeNode>>();
        for (DynamicObject subClassObj : subClassObjArrays) {
            TreeNode treeNode;
            ArrayList<TreeNode> subClassList = (ArrayList<TreeNode>)subClassMap.get(subClassObj.getString(FIELD_PARENT_ID));
            if (null == subClassList) {
                subClassList = new ArrayList<TreeNode>();
                treeNode = new TreeNode("3" + subClassObj.getString(FIELD_PARENT_ID), "4" + subClassObj.getString("id"), subClassObj.getString("name"));
                subClassList.add(treeNode);
                subClassMap.put(subClassObj.getString(FIELD_PARENT_ID), subClassList);
                continue;
            }
            treeNode = new TreeNode("3" + subClassObj.getString(FIELD_PARENT_ID), "4" + subClassObj.getString("id"), subClassObj.getString("name"));
            subClassList.add(treeNode);
        }
        return subClassMap;
    }
}

