/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.util;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class HRTermWordReplaceMergeUtil {
    private static final Log logger = LogFactory.getLog(HRTermWordReplaceMergeUtil.class);

    public void mergeTermWordData() {
        this.clearCacheByPromptAppProject();
        this.mergeMetaData();
    }

    private void clearCacheByPromptAppProject() {
        String metaSelectSql = "select fid from t_hbss_metadesign_term";
        DataSet metaDataSet = HRDBUtil.queryDataSet((String)"TermWordReplaceMergeUtil.mergePromptData.getMetaID", (DBRoute)DBRoute.of((String)"hmp"), (String)metaSelectSql, null);
        HashSet<String> metaIdSet = new HashSet<String>(16);
        while (metaDataSet.hasNext()) {
            Row row = metaDataSet.next();
            metaIdSet.add(row.getString("fid"));
        }
        metaDataSet.close();
        if (metaIdSet.isEmpty()) {
            return;
        }
        HRBaseServiceHelper metaServiceHelper = new HRBaseServiceHelper("bos_formmeta");
        QFilter[] metaIdQFilter = new QFilter[]{new QFilter("id", "in", metaIdSet)};
        DataSet appDataSet = metaServiceHelper.queryDataSet("TermWordReplaceMergeUtil.mergePromptData.getAppID", "bizappid", metaIdQFilter);
        HashSet<String> appIdSet = new HashSet<String>(16);
        while (appDataSet.hasNext()) {
            Row row = appDataSet.next();
            appIdSet.add(row.getString("bizappid"));
        }
        appDataSet.close();
        if (appIdSet.isEmpty()) {
            return;
        }
        HashSet<String> projectNums = new HashSet<String>(16);
        HRBaseServiceHelper prjServiceHelper = new HRBaseServiceHelper("cts_termproject");
        QFilter[] appIdQFilter = new QFilter[]{new QFilter("appid", "in", appIdSet)};
        DataSet prjDataSet = prjServiceHelper.queryDataSet("TermWordReplaceMergeUtil.mergePromptData.getPrjNumber", "number", appIdQFilter);
        while (prjDataSet.hasNext()) {
            Row row = prjDataSet.next();
            projectNums.add(row.getString("number"));
        }
        prjDataSet.close();
        logger.info("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.clearCacheByPromptAppProject,begin removeProjectKey all project:{}", (Object)projectNums.size());
        logger.info("ApplyPromptWordService instanceId: " + Instance.getInstanceId());
        PromptWordCacheNew promptWordCacheNew = new PromptWordCacheNew();
        boolean removeAll = promptWordCacheNew.removeAll();
        if (!removeAll) {
            logger.error("clearCacheByPromptAppProject \u5e94\u7528\u6210\u529f\uff0c\u7f13\u5b58\u5f02\u5e38\u53ef\u80fd\u65e0\u6cd5\u52a0\u8f7d\u63d0\u793a\u8bed\u91cd\u547d\u540d");
        }
        promptWordCacheNew.removeProjectKey(projectNums);
        logger.info("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.clearCacheByPromptAppProject,end removeProjectKey all project:{}", (Object)projectNums.size());
    }

    private void mergeMetaData() {
        HashSet<String> metaDataSet = new HashSet<String>(16);
        Set<String> entityIdSet = this.getEntityIdSet();
        String selectSql = "select fpkid,fid,flocaleid,fdata from t_hbss_metadesign_term where ftype=?";
        DataSet entityDataSet = HRDBUtil.queryDataSet((String)"WordReplaceMergeHelper.entity.mergeData", (DBRoute)DBRoute.of((String)"hmp"), (String)selectSql, (Object[])new String[]{"entity"});
        logger.info("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.mergeMetaData operate DB begin: entityDesign");
        while (entityDataSet.hasNext()) {
            String bizData;
            Row row = entityDataSet.next();
            String pkId = row.getString("fpkid");
            String id = row.getString("fid");
            String localeId = row.getString("flocaleid");
            String newData = bizData = row.getString("fdata");
            boolean existRec = entityIdSet.contains(id);
            if (existRec) {
                Pair<String, String> pkIdDataPair = this.getMergeDataPair("t_meta_entitydesign_term", pkId, id, bizData);
                newData = (String)pkIdDataPair.getRight();
                pkId = (String)pkIdDataPair.getLeft();
            }
            this.updateTableData("T_META_ENTITYDESIGN_TERM", pkId, id, localeId, newData);
            metaDataSet.add(id);
        }
        logger.info("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.mergeMetaData operate DB end:entityDesign");
        logger.info("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.mergeMetaData operate DB begin: formDesign");
        DataSet bizFormDataSet = HRDBUtil.queryDataSet((String)"WordReplaceMergeHelper.form.mergeData", (DBRoute)DBRoute.of((String)"hmp"), (String)selectSql, (Object[])new String[]{"form"});
        Set<String> formIdSet = this.getFormIdSet();
        while (bizFormDataSet.hasNext()) {
            String bizData;
            Row row = bizFormDataSet.next();
            String pkId = row.getString("fpkid");
            String id = row.getString("fid");
            String localeId = row.getString("flocaleid");
            String newData = bizData = row.getString("fdata");
            boolean existRec = formIdSet.contains(id);
            if (existRec) {
                Pair<String, String> pkIdDataPair = this.getMergeDataPair("t_meta_formdesign_term", pkId, id, bizData);
                newData = (String)pkIdDataPair.getRight();
                pkId = (String)pkIdDataPair.getLeft();
            }
            this.updateTableData("T_META_FORMDESIGN_TERM", pkId, id, localeId, newData);
            metaDataSet.add(id);
        }
        logger.info("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.mergeMetaData operate DB end: formDesign");
        int metaDataNum = metaDataSet.size();
        int currentNum = 0;
        for (String metaDataId : metaDataSet) {
            try {
                MetadataDao.rebuildRuntimeMetaById((String)metaDataId);
                logger.info("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.mergeMetaData call MetadataDao.rebuildRuntimeMetaById:{},No:{},All:{}", new Object[]{metaDataId, ++currentNum, metaDataNum});
            }
            catch (Exception exception) {
                logger.error(String.format("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.mergeMetaData call MetadataDao.rebuildRuntimeMetaById error,\u3010metadataId:%s\u3011", metaDataId), (Throwable)exception);
            }
        }
    }

    private Pair<String, String> getMergeDataPair(String metaTblName, String pkId, String id, String bizData) {
        Pair pkIdDataPair = Pair.of((Object)pkId, (Object)bizData);
        String newData = "";
        String selectExistSql = "select fpkid,fdata from " + metaTblName + " where fid=?";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"WordReplaceMergeHelper.getEntityIdSet", (DBRoute)DBRoute.meta, (String)selectExistSql, (Object[])new String[]{id});
        while (dataSet.hasNext()) {
            Row dataRow = dataSet.next();
            String existData = dataRow.getString(1);
            if ("{}".equals(existData) || HRStringUtils.isEmpty((String)existData)) {
                newData = bizData;
            } else {
                String bizDataContent = bizData.substring(1, bizData.length() - 1);
                if (!existData.contains(bizDataContent)) {
                    newData = bizData.replace("}", ",");
                    newData = newData + existData.replace("{", "");
                }
            }
            pkIdDataPair = Pair.of((Object)dataRow.getString(0), (Object)newData);
        }
        dataSet.close();
        return pkIdDataPair;
    }

    private Set<String> getEntityIdSet() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select designterm.fid").append(" from t_meta_formdesign_term designterm inner join t_meta_entitydesign metadesign on designterm.fid=metadesign.fid ").append(" inner join t_meta_bizapp app on app.fid=metadesign.fbizappid").append(" inner join t_meta_bizcloud cloud on app.fbizcloudid= cloud.fid").append(" where cloud.fnumber in ('ODC','TSC','HR','WTC','TDC','SWC','SIT','HRMP','ESC','HROS','HDTC','OPMC') ").append("  group by designterm.fid having count(designterm.fpkid)>=1");
        DataSet dataSet = HRDBUtil.queryDataSet((String)"WordReplaceMergeHelper.getEntityIdSet", (DBRoute)DBRoute.meta, (String)stringBuilder.toString(), null);
        return this.getIdSet(dataSet);
    }

    private Set<String> getFormIdSet() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select designterm.fid").append(" from t_meta_formdesign_term designterm inner join t_meta_formdesign metadesign on designterm.fid=metadesign.fid ").append(" inner join t_meta_bizapp app on app.fid=metadesign.fbizappid").append(" inner join t_meta_bizcloud cloud on app.fbizcloudid= cloud.fid").append(" where cloud.fnumber in ('ODC','TSC','HR','WTC','TDC','SWC','SIT','HRMP','ESC','HROS','HDTC','OPMC') ").append("  group by designterm.fid having count(designterm.fpkid)>=1");
        DataSet dataSet = HRDBUtil.queryDataSet((String)"WordReplaceMergeHelper.getFormIdSet", (DBRoute)DBRoute.meta, (String)stringBuilder.toString(), null);
        return this.getIdSet(dataSet);
    }

    private Set<String> getIdSet(DataSet dataSet) {
        HashSet<String> entityIdSet = new HashSet<String>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            entityIdSet.add(row.getString(0));
        }
        dataSet.close();
        return entityIdSet;
    }

    private void updateTableData(String metaTermTblName, String pkId, String id, String localeId, String data) {
        if (HRStringUtils.isEmpty((String)data)) {
            return;
        }
        String deleteSql = "delete from " + metaTermTblName + " where fid = ? and flocaleid = ?";
        Object[] parameters = new Object[]{new SqlParameter(":fid", -9, (Object)id), new SqlParameter(":flocaleid", -9, (Object)localeId)};
        SqlBuilder sbBuilder = new SqlBuilder();
        sbBuilder.append(deleteSql, parameters);
        DB.execute((DBRoute)DBRoute.meta, (SqlBuilder)sbBuilder);
        String strSQL = "insert into " + metaTermTblName + "(fpkid,fid,fdata,flocaleid) values (?, ?, ?,?)";
        Object[] params = new SqlParameter[]{new SqlParameter(":fpkid", -15, (Object)pkId), new SqlParameter(":fid", -15, (Object)id), new SqlParameter(":fdata", 2011, (Object)data), new SqlParameter(":flocaleid", -15, (Object)localeId)};
        try {
            DB.execute((DBRoute)DBRoute.meta, (String)strSQL, (Object[])params);
        }
        catch (Exception exception) {
            logger.error(String.format("kd.hr.hbss.bussiness.util.HRTermWordReplaceMergeUtil.updateTableData,\u3010metadataId:%s\u3011", id), (Throwable)exception);
        }
    }
}

