/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbss.bussiness.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.lang.Lang;
import kd.bos.list.ListColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbss.bussiness.IHRCSTipService;

public class ShowConfigTipsUtils {
    private static final Log LOG = LogFactory.getLog(ShowConfigTipsUtils.class);
    private static final IHRCSTipService SERVICE = IHRCSTipService.getInstance();

    public static void showListColumnTips(ListColumn listColumn, String key, String fromId) {
        String tipsText = ShowConfigTipsUtils.getTips(fromId, key);
        if (HRStringUtils.isEmpty((String)tipsText)) {
            LOG.error(MessageFormat.format("key:{0} fromId:{1} get tips is empty!", key, fromId));
        } else {
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(tipsText));
            listColumn.setCtlTips(textTips);
        }
    }

    public static void showPanelOrControlTips(IFormView formView, String key, String fromId) {
        ShowConfigTipsUtils.showPanelOrControlTips(formView, key, key, fromId);
    }

    public static void showPanelOrControlTips(IFormView formView, String key, String targetKey, String fromId) {
        String tipsText = ShowConfigTipsUtils.getTips(fromId, key);
        if (HRStringUtils.isEmpty((String)tipsText)) {
            LOG.error(MessageFormat.format("key:{0} fromId:{1} get tips is empty!", key, fromId));
        } else {
            HashMap<String, Tips> textProps = new HashMap<String, Tips>(16);
            Tips textTips = new Tips();
            textTips.setType("text");
            textTips.setContent(new LocaleString(tipsText));
            textProps.put("tips", textTips);
            formView.updateControlMetadata(targetKey, textProps);
        }
    }

    public static void setColumnTips(IFormView formView, String key, String entryId, String fromId) {
        String tipContent = ShowConfigTipsUtils.getTips(fromId, key);
        EntryGrid entryGrid = (EntryGrid)formView.getControl(entryId);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HashMap<String, String> contentMap = new HashMap<String, String>(16);
        contentMap.put(Lang.get().toString(), tipContent);
        map.put("content", contentMap);
        map.put("type", "text");
        entryGrid.setColumnProperty(key, "tips", map);
    }

    private static String getTips(String formId, String key) {
        List<String> tips = SERVICE.getTips(formId, key);
        return !ObjectUtils.isEmpty(tips) ? tips.get(0) : "";
    }
}

