/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.api;

import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.sdk.annotation.SdkService;
import org.apache.commons.lang3.ObjectUtils;

@SdkService(name="HR\u81ea\u5b9a\u4e49\u5bfc\u5165\u9875\u9762\u6269\u5c55\u4fe1\u606f\u5e2e\u52a9\u65b9\u6cd5")
public class HRCustomTaskServiceHelper {
    private static Log log = LogFactory.getLog(HRCustomTaskServiceHelper.class);

    public static void initTaskStatus(String serviceAppId, String taskId, String type, String cacheKey) {
        if (ObjectUtils.isEmpty((Object)serviceAppId) || ObjectUtils.isEmpty((Object)taskId) || ObjectUtils.isEmpty((Object)type) || ObjectUtils.isEmpty((Object)cacheKey)) {
            throw new KDBizException("params is null");
        }
        IHRAppCache cache = HRAppCache.get((String)serviceAppId);
        cache.put(cacheKey, (Object)"run");
    }

    public static void setTaskStatus(String serviceAppId, String taskId, String type, String cacheKey, String status) {
        if (ObjectUtils.isEmpty((Object)serviceAppId) || ObjectUtils.isEmpty((Object)taskId) || ObjectUtils.isEmpty((Object)type) || ObjectUtils.isEmpty((Object)cacheKey)) {
            throw new KDBizException("params is null");
        }
        IHRAppCache cache = HRAppCache.get((String)serviceAppId);
        cache.put(cacheKey, (Object)status);
    }

    public static String getTaskStatus(String serviceAppId, String taskId, String type, String cacheKey) {
        if (ObjectUtils.isEmpty((Object)serviceAppId) || ObjectUtils.isEmpty((Object)taskId) || ObjectUtils.isEmpty((Object)type) || ObjectUtils.isEmpty((Object)cacheKey)) {
            throw new KDBizException("params is null");
        }
        IHRAppCache cache = HRAppCache.get((String)serviceAppId);
        return (String)cache.get(cacheKey, String.class);
    }

    public static boolean isTaskStoped(String serviceAppId, String taskId, String type, String cacheKey) {
        if (ObjectUtils.isEmpty((Object)serviceAppId) || ObjectUtils.isEmpty((Object)taskId) || ObjectUtils.isEmpty((Object)type) || ObjectUtils.isEmpty((Object)cacheKey)) {
            throw new KDBizException("params is null");
        }
        IHRAppCache cache = HRAppCache.get((String)serviceAppId);
        String status = (String)cache.get(cacheKey, String.class);
        return "stop".equals(status);
    }

    public static void feedbackProgress(String serviceAppId, String taskId, String type, Map<String, String> customData, String cacheKey) {
        if (ObjectUtils.isEmpty((Object)serviceAppId) || ObjectUtils.isEmpty((Object)taskId) || ObjectUtils.isEmpty((Object)type) || ObjectUtils.isEmpty(customData) || ObjectUtils.isEmpty((Object)cacheKey)) {
            throw new KDBizException("params is null");
        }
        try {
            Integer progress = Integer.valueOf(customData.get("progress"));
            IHRAppCache appCache = HRAppCache.get((String)serviceAppId);
            appCache.put(cacheKey, customData);
            IEGlobalTaskUtil.feedbackProgress((String)taskId, (int)progress, (String)type);
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    public static void finishTask(String serviceAppId, String taskId, String type, Map<String, String> customData, String cacheKey) {
        if (ObjectUtils.isEmpty((Object)serviceAppId) || ObjectUtils.isEmpty((Object)taskId) || ObjectUtils.isEmpty((Object)type) || ObjectUtils.isEmpty(customData) || ObjectUtils.isEmpty((Object)cacheKey)) {
            throw new KDBizException("params is null");
        }
        try {
            IHRAppCache appCache = HRAppCache.get((String)serviceAppId);
            appCache.put(cacheKey, customData);
            IEGlobalTaskUtil.feedbackProgress((String)taskId, (int)100, (String)type);
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    public static boolean terminatorTask(String serviceAppId, String taskId, String type, String cacheKey) {
        IHRAppCache cache = HRAppCache.get((String)serviceAppId);
        String status = (String)cache.get(cacheKey, String.class);
        if ("run".equalsIgnoreCase(status) || "stop".equalsIgnoreCase(status)) {
            cache.put(cacheKey, (Object)"stop");
            return true;
        }
        return false;
    }
}

