/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.api.demo;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPools;
import kd.hr.hies.api.HRCustomTaskServiceHelper;
import kd.hr.hies.api.tpl.HRImportStartCommonPlugin;

public class HAOSImportStartPlugin
extends HRImportStartCommonPlugin {
    private static final Log logger = LogFactory.getLog(HAOSImportStartPlugin.class);

    @Override
    protected boolean fireStartImportTaskEvent() {
        this.setTaskPKId(UUID.randomUUID().toString());
        HRCustomTaskServiceHelper.initTaskStatus(this.getServiceAppId(), this.getTaskPKId(), "import", this.getTaskCachePath("status"));
        ThreadPools.executeOnce((String)"1111", (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    boolean taskStoped;
                    for (int i = 0; i < 100 && !(taskStoped = HRCustomTaskServiceHelper.isTaskStoped(HAOSImportStartPlugin.this.getServiceAppId(), HAOSImportStartPlugin.this.getTaskPKId(), "import", HAOSImportStartPlugin.this.getTaskCachePath("status"))); ++i) {
                        HashMap customData = Maps.newHashMapWithExpectedSize((int)16);
                        customData.put("progress", String.valueOf(i));
                        customData.put("timeRemaining", String.valueOf(100 - i));
                        customData.put("totalBillCount", "100");
                        customData.put("finishedBillCount", String.valueOf(i));
                        HRCustomTaskServiceHelper.feedbackProgress(HAOSImportStartPlugin.this.getServiceAppId(), HAOSImportStartPlugin.this.getTaskPKId(), "import", customData, HAOSImportStartPlugin.this.getTaskCachePath("processing"));
                        TimeUnit.MILLISECONDS.sleep(1000L);
                    }
                }
                catch (InterruptedException e) {
                    logger.error((Throwable)e);
                }
                HAOSImportStartPlugin.this.notifyResultData();
            }
        });
        return true;
    }

    @Override
    protected void fireClickBtndownstepEvent() {
    }

    @Override
    protected void fireAfterLoadStartPageEvent() {
    }

    @Override
    protected void fireAfterUploadFileEvent() {
    }

    @Override
    protected void fireClickTplDownloadEvent() {
    }

    @Override
    protected void fireTemplateValidateEvent() {
    }

    private void notifyResultData() {
        HashMap customData = Maps.newHashMapWithExpectedSize((int)2);
        customData.put("spendTotalTime", "10000");
        customData.put("finishedBillCount", "100");
        customData.put("totalBillCount", "100");
        customData.put("userHasTerminator", "false");
        customData.put("sysTerminator", "false");
        customData.put("userStartTime", String.valueOf(System.currentTimeMillis() - 10000L));
        customData.put("userEndTime", String.valueOf(System.currentTimeMillis()));
        HRCustomTaskServiceHelper.finishTask(this.getServiceAppId(), this.getTaskPKId(), "import", customData, this.getTaskCachePath("result"));
    }
}

