/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.api.tpl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.sdk.annotation.SdkPlugin;

@SdkPlugin(name="HR\u57fa\u7840\u5bfc\u5165\u8d77\u59cb\u9875\u6a21\u677f\u7ee7\u627f\u63d2\u4ef6")
public abstract class HRImportStartBasePlugin
extends HRDataBaseEdit
implements UploadListener {
    protected static final Log LOGGER = LogFactory.getLog(HRImportStartBasePlugin.class);
    protected static final String PROGRESSBARAP = "progressbarap";
    protected static final String FILE_SERVER_URL = "serverUrl";
    protected static final String CACHEKEY_ISSTART = "isstart";
    protected static final String CONCURRENT = "concurrent";
    protected static final String CHECK_TEMPLATE_CALLBACK = "checkTemplate_callBack";
    protected static final String CURRENT_STATUS = "currentStatus";
    protected static final String BACK_RUN = "backRun";
    protected static final String INIT = "init";
    protected static final String UPLOAD = "upload";
    protected static final String INSTORE = "instore";
    protected static final String FINISHED = "finished";
    protected static final String TERMINATOR = "terminator";
    protected static final String NO_FAIL_BILL = "noFailBill";
    protected static final String NO_SUCCESS_BILL = "noSuccessBill";
    protected static final String NO_SUCCESS_AND_FAIL_BILL = "noSuccessAndFailBill";
    protected boolean canClosePage = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btndowntpl", "lblviewhis", "btnupstep", "btndownstep", "btnstart", "btnstop", "btnbackground", "btndownerror", "btndownall", "btnreupload", "lblfilename1", "lblfilename3", "lblfilename4", "lblfilename5", "lblfilename6", "lblfilename7"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("fileupload");
        attachmentPanel.addUploadListener((UploadListener)this);
        Button btnreupload = (Button)this.getView().getControl("btnreupload");
        btnreupload.addUploadListener((UploadListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165", (String)"HRImportStartBasePlugin_0", (String)"hrmp-hies-common", (Object[])new Object[0]));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.statusControlDisplay(INIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(UploadEvent evt) {
        if (!this.validatePerm()) {
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String filesize;
            String filename;
            String localPath;
            block13: {
                localPath = "";
                filename = "";
                filesize = "";
                try {
                    if (urls[0] instanceof Map) {
                        Map map = (Map)urls[0];
                        String url = (String)map.get("url");
                        try {
                            localPath = ImportFileUtil.downloadTempFile((String)url);
                        }
                        catch (Exception e) {
                            LOGGER.error((Throwable)e);
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u7a33\u5b9a\u5bfc\u81f4\u4e34\u65f6\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HRImportStartPlugin_11", (String)"hrmp-hies-import", (Object[])new Object[0]));
                            return;
                        }
                        filename = (String)map.get("name");
                        filesize = String.valueOf(map.get("size"));
                        break block13;
                    }
                    this.statusControlDisplay(INIT);
                    String url = String.valueOf(urls[0]);
                    if (url.lastIndexOf("/") != -1) {
                        filename = url.substring(url.lastIndexOf("/") + 1);
                    }
                    localPath = ImportFileUtil.downloadFile((String)url);
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    service.delete(url);
                    File file = new File(localPath);
                    filesize = String.valueOf(file.length());
                }
                catch (IOException ioException) {
                    LOGGER.error((Throwable)ioException);
                    this.getView().showErrorNotification(ioException.getMessage());
                    return;
                }
            }
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)filename);
            model.setValue("filesize", (Object)filesize);
            model.setValue("filelocalpath", (Object)localPath);
            try {
                Map ret = ImportFileUtil.uploadFile((String)filename, (String)localPath);
                model.setValue(FILE_SERVER_URL, ret.get(FILE_SERVER_URL));
                model.setValue("fileuploadid", ret.get("uploadId"));
                model.setValue("clientUrl", ret.get("clientUrl"));
                this.getView().getPageCache().put("uploadId", (String)ret.get("uploadId"));
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            finally {
                this.deleteLocalFile();
            }
            this.statusControlDisplay(UPLOAD);
        }
    }

    public void click(EventObject evt) {
        if (!this.validatePerm()) {
            return;
        }
        switch (((Control)evt.getSource()).getKey()) {
            case "btnreupload": {
                this.statusControlDisplay(INIT);
                break;
            }
        }
    }

    protected void statusControlDisplay(String type) {
        switch (type) {
            case "init": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefleupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flestate"});
                this.getModel().setValue(FILE_SERVER_URL, (Object)"");
                this.removeAttachmentPanel(this.getView());
                break;
            }
            case "upload": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinishedupload", "btnreupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "fleselectmodel", "flevalidata2", "fleinstore", "flestop", "flefinished", "btnupstep", "btnstop", "btnbackground", "btndownerror", "btndownall", "flevalidatefail", "lblfilename1"});
                break;
            }
        }
    }

    protected String getEntityNumber() {
        String formId = this.getPageCache().get("formId");
        if (StringUtils.isEmpty((CharSequence)formId)) {
            formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        }
        return formId;
    }

    protected boolean validatePerm() {
        FormShowParameter parentP = this.getView().getFormShowParameter();
        String formId = (String)parentP.getCustomParam("formId");
        boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)parentP.getAppId(), (String)formId, (String)"4730fc9f000003ae");
        if (!checkPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u5bfc\u5165\u6743\u9650\uff0c\u5982\u9700\u5bfc\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_10", (String)"hrmp-hies-import", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void removeAttachmentPanel(IFormView view) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("fileupload");
        List attachmentData = attachmentPanel.getAttachmentData();
        if (CollectionUtils.isNotEmpty((Collection)attachmentData)) {
            attachmentPanel.remove((Map)attachmentData.get(0));
        }
    }

    protected void deleteLocalFile() {
        try {
            ImportFileUtil.deleteLocalTempFile((String)((String)this.getModel().getValue("filelocalpath")));
        }
        catch (FileSystemException e) {
            LOGGER.info("file can't delete.");
        }
        catch (Throwable e) {
            LOGGER.error(e);
        }
    }
}

