/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hies.api.tpl;

import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.api.tpl.HRImportStartBasePlugin;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.enu.OprType;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.ExcelUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.sdk.annotation.SdkPlugin;
import org.apache.commons.lang3.ObjectUtils;

@SdkPlugin(name="HR\u901a\u7528\u5bfc\u5165\u8d77\u59cb\u9875\u6a21\u677f\u7ee7\u627f\u63d2\u4ef6")
public abstract class HRImportStartCommonPlugin
extends HRImportStartBasePlugin
implements ProgresssListener {
    protected static final Log LOGGER = LogFactory.getLog(HRImportStartCommonPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btndowntpl", "lblviewhis", "btnupstep", "btndownstep", "btnstart", "btnstop", "btnbackground", "btndownerror", "btndownall", "btnreupload", "lblfilename1", "lblfilename3", "lblfilename4", "lblfilename5"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("fileupload");
        attachmentPanel.addUploadListener((UploadListener)this);
        Button btnreupload = (Button)this.getView().getControl("btnreupload");
        btnreupload.addUploadListener((UploadListener)this);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.statusControlDisplay("init");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fireAfterLoadStartPageEvent();
    }

    public void onProgress(ProgressEvent evt) {
        try {
            this.dealOnProgress(evt);
            if (evt.getProgress() == 0) {
                evt.setProgress(1);
            }
        }
        catch (Throwable e) {
            LOGGER.error("dealOnProgress_exception.", e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5f02\u5e38\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(UploadEvent evt) {
        if (!this.validatePerm()) {
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String filesize;
            String filename;
            String localPath;
            block15: {
                localPath = "";
                filename = "";
                filesize = "";
                try {
                    if (urls[0] instanceof Map) {
                        Map map = (Map)urls[0];
                        String url = (String)map.get("url");
                        try {
                            localPath = ImportFileUtil.downloadTempFile((String)url);
                        }
                        catch (Exception e) {
                            LOGGER.error((Throwable)e);
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e0d\u7a33\u5b9a\u5bfc\u81f4\u4e34\u65f6\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HRImportStartPlugin_11", (String)"hrmp-hies-import", (Object[])new Object[0]));
                            return;
                        }
                        filename = (String)map.get("name");
                        filesize = String.valueOf(map.get("size"));
                        break block15;
                    }
                    this.statusControlDisplay("init");
                    String url = String.valueOf(urls[0]);
                    if (url.lastIndexOf("/") != -1) {
                        filename = url.substring(url.lastIndexOf("/") + 1);
                    }
                    localPath = ImportFileUtil.downloadFile((String)url);
                    FileService service = FileServiceFactory.getAttachmentFileService();
                    service.delete(url);
                    File file = new File(localPath);
                    filesize = String.valueOf(file.length());
                }
                catch (IOException ioException) {
                    LOGGER.error((Throwable)ioException);
                    this.getView().showErrorNotification(ioException.getMessage());
                    return;
                }
            }
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)filename);
            model.setValue("filesize", (Object)filesize);
            model.setValue("filelocalpath", (Object)localPath);
            this.displayFilename(filename);
            try {
                Map ret = ImportFileUtil.uploadFile((String)filename, (String)localPath);
                model.setValue("serverUrl", ret.get("serverUrl"));
                model.setValue("fileuploadid", ret.get("uploadId"));
                model.setValue("clientUrl", ret.get("clientUrl"));
                this.getView().getPageCache().put("uploadId", (String)ret.get("uploadId"));
                this.fireAfterUploadFileEvent();
            }
            catch (Throwable e) {
                LOGGER.error("", e);
                this.getView().showErrorNotification(e.getMessage());
                return;
            }
            finally {
                this.deleteLocalFile();
            }
            try {
                this.checkTemplate();
            }
            catch (Throwable exception) {
                LOGGER.error(exception);
                this.deleteLocalFile();
                HIESUtil.showMessage((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u6821\u9a8c\u5f02\u5e38\u3002", (String)"HRImportStartPlugin_1", (String)"hrmp-hies-import", (Object[])new Object[0]), (String)exception.getMessage(), (ConfirmCallBackListener)new ConfirmCallBackListener("checkTemplate_callBack", (IFormPlugin)this));
                this.statusControlDisplay("init");
                return;
            }
            this.statusControlDisplay("upload");
        }
    }

    @Override
    public void click(EventObject evt) {
        if (!this.validatePerm()) {
            return;
        }
        switch (((Control)evt.getSource()).getKey()) {
            case "btnreupload": {
                this.statusControlDisplay("init");
                break;
            }
            case "btnupstep": {
                this.statusControlDisplay("upload");
                break;
            }
            case "btndownstep": {
                break;
            }
            case "btndowntpl": {
                this.fireClickTplDownloadEvent();
                break;
            }
            case "btnstart": {
                String path = (String)this.getModel().getValue("serverUrl");
                if (StringUtils.isEmpty((CharSequence)path)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"HRImportStartPlugin_2", (String)"hrmp-hies-import", (Object[])new Object[0]));
                    return;
                }
                boolean ret = this.startImportTask();
                if (ret) {
                    this.startProcesser();
                    this.statusControlDisplay("instore");
                    break;
                }
                this.statusControlDisplay("init");
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"HRImportStartPlugin_12", (String)"hrmp-hies-import", (Object[])new Object[0]));
                break;
            }
            case "btnstop": {
                IHRAppCache cache;
                Map data;
                boolean terminatorFlag = this.terminatorTask(this.getServiceAppId(), this.getTaskPKId(), "import", this.getTaskCachePath("status"));
                if (terminatorFlag) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u901a\u77e5\u7cfb\u7edf\u7ec8\u6b62\u5bfc\u5165\u3002", (String)"HRImportStartPlugin_5", (String)"hrmp-hies-import", (Object[])new Object[0]));
                    break;
                }
                ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
                if (bar.getPercent() < 90 && (data = (Map)(cache = HRAppCache.get((String)this.getServiceAppId())).get(this.getTaskCachePath("processing"), Map.class)) != null) {
                    Map virtualProcess = MethodUtil.getVirtualProcess((int)bar.getPercent(), (int)Integer.parseInt((String)data.get("timeRemaining")), (float)Float.parseFloat((String)data.get("finishedBillCount")), (int)Integer.parseInt((String)data.get("totalBillCount")));
                    data.put("progress", String.valueOf(virtualProcess.get("progress")));
                    data.put("timeRemaining", String.valueOf(virtualProcess.get("timeRemaining")));
                    Integer finishedBillCount = (Integer)virtualProcess.get("finishedBillCount");
                    if (ObjectUtils.isNotEmpty((Object)finishedBillCount)) {
                        data.put("finishedBillCount", String.valueOf(virtualProcess.get("finishedBillCount")));
                    }
                    this.displayInfo(data);
                    bar.setPercent(Integer.parseInt((String)data.get("progress")));
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5373\u5c06\u5b8c\u6210\uff0c\u65e0\u6cd5\u7ec8\u6b62\u3002", (String)"HRImportStartPlugin_4", (String)"hrmp-hies-import", (Object[])new Object[0]));
                break;
            }
            case "btnbackground": {
                IHRAppCache cache2 = HRAppCache.get((String)this.getServiceAppId());
                cache2.put(this.getCurrentAppCacheKey(), (Object)this.getCurrentAppCacheKey());
                this.setStart(true);
                this.closeForm();
                break;
            }
            case "lblfilename1": 
            case "lblfilename3": 
            case "lblfilename4": 
            case "lblfilename5": {
                String url = this.getDownloadUrl(this.getPageCache().get("uploadId"));
                this.getView().download(url);
                break;
            }
            case "btndownall": {
                this.downErrorFile("btndownall");
                break;
            }
            case "btndownerror": {
                this.downErrorFile("btndownerror");
                break;
            }
            case "lblviewhis": {
                ListShowParameter showParameterHis = new ListShowParameter();
                showParameterHis.setBillFormId("hies_taskinfo");
                ListFilterParameter list = new ListFilterParameter();
                list.setFilter(new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId()));
                showParameterHis.setListFilterParameter(list);
                showParameterHis.setCustomParam("oprtype", (Object)OprType.IMPORT.getValue());
                showParameterHis.setCustomParam("isHyperlink4Oprtype", (Object)Boolean.FALSE);
                showParameterHis.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameterHis.getCustomParams().putAll(this.getView().getFormShowParameter().getCustomParams());
                showParameterHis.setCustomParam("checkRightAppId", (Object)"15NPDX/GJFOO");
                this.getView().showForm((FormShowParameter)showParameterHis);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        String status = this.getPageCache().get("currentStatus");
        this.canClosePage = !"instore".equalsIgnoreCase(status);
        if (!this.canClosePage && StringUtils.isNotBlank((CharSequence)this.getTaskPKId())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u8981\u628a\u5bfc\u5165\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"HRImportStartPlugin_6", (String)"hrmp-hies-import", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btnback", (IFormPlugin)this));
            event.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (StringUtils.equals((CharSequence)"btnback", (CharSequence)messageboxclosedevent.getCallBackId())) {
            if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u8f6c\u5165\u540e\u53f0\u3002", (String)"HRImportStartPlugin_3", (String)"hrmp-hies-import", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                }
                this.stopProcesser();
                this.toBackground();
            }
        } else if (messageboxclosedevent.getCallBackId().equalsIgnoreCase("checkTemplate_callBack")) {
            this.removeAttachmentPanel(this.getView());
        }
    }

    @Override
    protected void statusControlDisplay(String type) {
        LOGGER.info("statusControlDisplay=" + type);
        switch (type) {
            case "init": {
                Label lblprogress = (Label)this.getControl("lblprogress");
                lblprogress.setText("1%");
                Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
                lblinstorevalue.setText("");
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefleupload", "lblremainingtip", "lblremainingtip1", "flexmini", "flexmini2", "flefail1", "flefail2", "flefailed", "flefail3", "flesuccess1", "flesuccess2", "flesuccess3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flestate", "fleremaintime", "lblinstorevalue", "fleremaintime1"});
                this.getModel().setValue("serverUrl", (Object)"");
                this.removeAttachmentPanel(this.getView());
                this.getPageCache().put("currentStatus", "init");
                break;
            }
            case "upload": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"btnstart"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"btndownstep"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinishedupload", "btnreupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "fleselectmodel", "flevalidata2", "fleinstore", "flestop", "flefinished", "btnupstep", "btnstop", "btnbackground", "btndownerror", "btndownall", "flevalidatefail"});
                this.getPageCache().put("currentStatus", "upload");
                break;
            }
            case "instore": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "fleinstore", "btnstop", "btnbackground", "lblinstorevalue"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata2", "flestop", "flefinished", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btndownerror", "btndownall", "btnreupload"});
                this.getPageCache().put("currentStatus", "instore");
                break;
            }
            case "finished": {
                this.stopProcesser();
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flefinished", "btndownerror", "btndownall", "btnreupload", "flefinished2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata2", "flestop", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "btnbackground", "flefailed"});
                this.getPageCache().put("currentStatus", "finished");
                break;
            }
            case "terminator": {
                this.stopProcesser();
                this.getView().setVisible(Boolean.TRUE, new String[]{"flestate", "flestop", "btnreupload"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefleupload", "flefinishedupload", "fleselectmodel", "flevalidata2", "flefinished", "fleinstore", "btndownstep", "btnupstep", "btnstart", "flevalidatefail", "btnstop", "btnbackground", "btndownerror", "btndownall"});
                this.getPageCache().put("currentStatus", "terminator");
                break;
            }
            case "noSuccessBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefail1", "flefail2", "flefailed"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flesuccess1", "flesuccess2", "btndownall", "flefinished2"});
                break;
            }
            case "noFailBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flesuccess1", "flesuccess2"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefail1", "flefail2", "btndownerror", "btndownall"});
                break;
            }
            case "noSuccessAndFailBill": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flefail1", "flefail2", "flesuccess1", "flesuccess2"});
                break;
            }
            case "validateNoSuccessBill": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flefail3"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flesuccess3", "btndownall"});
                break;
            }
            case "hasTimeRemaining": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fleremaintime"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lblremainingtip"});
                break;
            }
            case "hasValidateTimeRemaining": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"fleremaintime1"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"lblremainingtip1"});
                break;
            }
        }
    }

    protected void toBackground() {
        this.getPageCache().put("currentStatus", "backRun");
        this.closeForm();
        String taskPKId = this.getTaskPKId();
        if (!StringUtils.isBlank((CharSequence)taskPKId)) {
            String key = this.getTaskCachePath("ball");
            IHRAppCache appCache = HRAppCache.get((String)this.getServiceAppId());
            TaskInfo taskInfo = (TaskInfo)appCache.get(key, TaskInfo.class);
            IHRAppCache cache = HRAppCache.get((String)this.getServiceAppId());
            Map result = (Map)cache.get(this.getTaskCachePath("result"), Map.class);
            if (taskInfo == null && result == null) {
                Object filename = this.getModel().getValue("filename");
                IEGlobalTaskUtil.createNewGlobalTask((String)"import", (IFormView)this.getView(), (String)taskPKId, (String)((String)filename), (String)"kd.hr.impt.business.ImportTaskClick", null);
            }
        }
    }

    protected void closeForm() {
        this.getView().close();
    }

    protected void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    protected void displayInfo(Map<String, String> data) {
        Integer progress = Integer.parseInt(data.get("progress"));
        Label lblprogress = (Label)this.getControl("lblprogress");
        lblprogress.setText(progress + "%");
        String finishedBillCount = data.get("finishedBillCount");
        String totalBillCount = data.get("totalBillCount");
        if (StringUtils.isNotBlank((CharSequence)finishedBillCount) && Integer.parseInt(finishedBillCount) > 0) {
            String sta = this.getPageCache().get("currentStatus");
            if (!"instore".equalsIgnoreCase(sta)) {
                this.statusControlDisplay("instore");
            }
            Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
            lblinstorevalue.setText("(" + finishedBillCount.concat("/").concat(totalBillCount) + ")");
        }
        Label lblremainingm = (Label)this.getControl("lblremainingm");
        Label lblremainings = (Label)this.getControl("lblremainings");
        Integer timeRemaining = Integer.parseInt(data.get("timeRemaining"));
        if (timeRemaining != null && timeRemaining > 0) {
            this.statusControlDisplay("hasTimeRemaining");
            String minite = String.valueOf(timeRemaining / 60);
            String second = String.valueOf(timeRemaining % 60);
            lblremainingm.setText(minite);
            lblremainings.setText(second);
            if ("0".equalsIgnoreCase(minite)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexmini"});
            }
        }
        this.getView().getPageCache().put("totalBillCount", totalBillCount);
    }

    protected String getTaskPKId() {
        return this.getPageCache().get("import_taskPKid");
    }

    protected void setTaskPKId(String taskPKId) {
        this.getPageCache().put("import_taskPKid", taskPKId);
    }

    protected String getCurrentAppCacheKey() {
        String taskId = StringUtils.isNotBlank((CharSequence)this.getTaskPKId()) ? "_" + this.getTaskPKId() : "";
        return "EXPT_SUSPEND_" + this.getEntityNumber() + taskId;
    }

    protected void checkTemplate() throws Exception {
        this.fireTemplateValidateEvent();
    }

    protected boolean startImportTask() {
        return this.fireStartImportTaskEvent();
    }

    protected void downErrorFile(String type) {
        IHRAppCache cache = HRAppCache.get((String)this.getServiceAppId());
        Map result = (Map)cache.get(this.getTaskCachePath("result"), Map.class);
        Map customData = (Map)cache.get(this.getTaskCachePath("urls"), Map.class);
        if ("true".equalsIgnoreCase(result.getOrDefault("sysTerminator", "false"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\u5df2\u88ab\u8feb\u7ec8\u6b62\uff0c\u65e0\u6cd5\u751f\u6210\u7ed3\u679c\u62a5\u544a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_8", (String)"hrmp-hies-import", (Object[])new Object[0]));
            return;
        }
        String fileId = null;
        if ("btndownall".equals(type)) {
            if (customData == null || StringUtils.isBlank((CharSequence)((CharSequence)customData.get("errorFileForAllData")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u7ed3\u679c\u62a5\u544a\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HRImportStartPlugin_7", (String)"hrmp-hies-import", (Object[])new Object[0]));
                return;
            }
            fileId = (String)customData.get("errorFileForAllData");
        } else {
            if (customData == null || StringUtils.isBlank((CharSequence)((CharSequence)customData.get("errorFileForErrorData")))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210\u7ed3\u679c\u62a5\u544a\u6570\u636e\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"HRImportStartPlugin_7", (String)"hrmp-hies-import", (Object[])new Object[0]));
                return;
            }
            fileId = (String)customData.get("errorFileForErrorData");
        }
        String url = this.getDownloadUrl(fileId);
        this.getView().download(url);
    }

    protected void displayResultData(Map<String, String> result) {
        String successedBillCount;
        Label lblinstorevalue = (Label)this.getControl("lblinstorevalue");
        Label lblresultstatics54 = (Label)this.getControl("lblresultstatics54");
        Label lblresultstatics541 = (Label)this.getControl("lblresultstatics541");
        String totalBillCount = result.get("totalBillCount");
        lblinstorevalue.setText("(" + totalBillCount.concat("/").concat(totalBillCount) + ")");
        String userStartTime = result.get("userStartTime");
        String userEndTime = result.get("userEndTime");
        if (StringUtils.isNotBlank((CharSequence)userEndTime)) {
            String costTimeStr = TaskInfoHelper.costTimeIgnoreMs((Long)Long.parseLong(userEndTime), (Long)Long.parseLong(userStartTime));
            String remainingTime = String.format(ResManager.loadKDString((String)"\u5171\u8017\u65f6 %s", (String)"HRImportStartPlugin_9", (String)"hrmp-hies-import", (Object[])new Object[0]), costTimeStr);
            lblresultstatics54.setText(remainingTime);
            lblresultstatics541.setText(remainingTime);
        }
        successedBillCount = (successedBillCount = result.get("successedBillCount")) == null ? "0" : successedBillCount;
        int lostCount = Integer.parseInt(totalBillCount) - Integer.parseInt(successedBillCount);
        Label lblsuccesscount1 = (Label)this.getControl("lblsuccesscount1");
        Label lblsuccesscount2 = (Label)this.getControl("lblsuccesscount2");
        Label lblfailcount1 = (Label)this.getControl("lblfailcount1");
        Label lblfailcount2 = (Label)this.getControl("lblfailcount2");
        Label lbtotalcount1 = (Label)this.getControl("lbtotalcount1");
        Label lbtotalcount2 = (Label)this.getControl("lbtotalcount2");
        if (StringUtils.isNotBlank((CharSequence)successedBillCount) && StringUtils.isNotBlank((CharSequence)totalBillCount)) {
            lblsuccesscount1.setText(successedBillCount);
            lblsuccesscount2.setText(successedBillCount);
            lblfailcount1.setText(String.valueOf(lostCount));
            lblfailcount2.setText(String.valueOf(lostCount));
            lbtotalcount1.setText(totalBillCount);
            lbtotalcount2.setText(totalBillCount);
        }
        if (successedBillCount.equals("0")) {
            LOGGER.info("noSuccessBill_from_concurrentModel");
            this.statusControlDisplay("noSuccessBill");
        }
        if (successedBillCount.equals(totalBillCount)) {
            LOGGER.info("nofailBill_from_concurrentModel");
            this.statusControlDisplay("noFailBill");
        }
        String finishedBillCount = result.get("finishedBillCount");
        String userHasTerminator = result.getOrDefault("userHasTerminator", "false");
        if ("false".equalsIgnoreCase(userHasTerminator)) {
            LOGGER.info("userHasTerminator_from_concurrentModel");
            this.statusControlDisplay("terminator");
            Label lblterminatorcount = (Label)this.getControl("lblterminatorcount");
            int terminatorcount = Integer.parseInt(totalBillCount) - Integer.parseInt(finishedBillCount);
            lblterminatorcount.setText(String.valueOf(terminatorcount));
            int errorCount = Integer.parseInt(finishedBillCount) - Integer.parseInt(successedBillCount);
            lblfailcount1.setText(String.valueOf(errorCount));
            if (totalBillCount.equals(String.valueOf(terminatorcount))) {
                LOGGER.info("noSuccessAndFailBill_from_concurrentModel");
                this.statusControlDisplay("noSuccessAndFailBill");
            }
        }
        if ("true".equalsIgnoreCase(result.getOrDefault("sysTerminator", "false"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38\u5df2\u88ab\u8feb\u7ec8\u6b62\uff0c\u65e0\u6cd5\u751f\u6210\u7ed3\u679c\u62a5\u544a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HRImportStartPlugin_8", (String)"hrmp-hies-import", (Object[])new Object[0]));
        }
    }

    protected void displayFilename(String filename) {
        Label lblfilename1 = (Label)this.getControl("lblfilename1");
        Label lblfilename3 = (Label)this.getControl("lblfilename3");
        Label lblfilename4 = (Label)this.getControl("lblfilename4");
        Label lblfilename5 = (Label)this.getControl("lblfilename5");
        lblfilename1.setText(filename);
        lblfilename3.setText(filename);
        lblfilename4.setText(filename);
        lblfilename5.setText(filename);
    }

    protected void displayImporttype(DynamicObject tpl, String val) {
        DynamicProperty prop = tpl.getDynamicObjectType().getProperty("importtype");
        ComboProp temp = (ComboProp)prop;
        String name = "";
        for (ValueMapItem item : temp.getComboItems()) {
            if (!item.getValue().equals(val)) continue;
            name = item.getName().getLocaleValue();
            break;
        }
        Label lblimporttype = (Label)this.getControl("lblimporttype");
        lblimporttype.setText(name);
    }

    protected void dealOnProgress(ProgressEvent evt) {
        IHRAppCache cache = HRAppCache.get((String)this.getServiceAppId());
        Map result = (Map)cache.get(this.getTaskCachePath("result"), Map.class);
        String status = this.getPageCache().get("currentStatus");
        if (result != null && "instore".equalsIgnoreCase(status)) {
            evt.setProgress(99);
            this.statusControlDisplay("finished");
            this.displayResultData(result);
        } else if (result == null) {
            String stat;
            Map data = (Map)cache.get(this.getTaskCachePath("processing"), Map.class);
            if (data == null) {
                return;
            }
            Map virtualProcess = null;
            Integer progress = Integer.valueOf((String)data.get("progress"));
            if (progress >= 100) {
                progress = 99;
            } else if (progress < 90 && "canotstop".equals(stat = (String)cache.get(this.getTaskCachePath("status"), String.class))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btnstop"});
                virtualProcess = MethodUtil.getVirtualProcess((int)progress, (int)Integer.parseInt((String)data.get("timeRemaining")), (float)Float.parseFloat((String)data.get("finishedBillCount")), (int)Integer.parseInt((String)data.get("totalBillCount")));
                data.put("progress", String.valueOf(virtualProcess.get("progress")));
                data.put("timeRemaining", String.valueOf(virtualProcess.get("timeRemaining")));
                Integer finishedBillCount = (Integer)virtualProcess.get("finishedBillCount");
                if (ObjectUtils.isNotEmpty((Object)finishedBillCount)) {
                    data.put("finishedBillCount", String.valueOf(virtualProcess.get("finishedBillCount")));
                }
            }
            evt.setProgress(progress.intValue());
            this.displayInfo(data);
        }
    }

    protected void startProcesser() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.setPercent(0);
        bar.start();
    }

    protected void stopProcesser() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    protected String getServiceAppId() {
        return this.getView().getFormShowParameter().getServiceAppId();
    }

    protected String getTaskCachePath(String taskCacheDataType) {
        return this.getServiceAppId() + "_" + ImportCacheKeyType.IMPORT + "_task_".concat(this.getTaskPKId()).concat("_").concat(taskCacheDataType);
    }

    protected boolean terminatorTask(String serviceAppId, String taskId, String type, String cacheKey) {
        IHRAppCache cache = HRAppCache.get((String)serviceAppId);
        String status = (String)cache.get(cacheKey, String.class);
        if ("run".equalsIgnoreCase(status) || "stop".equalsIgnoreCase(status)) {
            cache.put(cacheKey, (Object)"stop");
            return true;
        }
        return false;
    }

    private String getDownloadUrl(String surl) {
        return ExcelUtil.getDownloadUrl((String)surl, (String)this.getEntityNumber(), (String)"4730fc9f000003ae");
    }

    protected abstract void fireClickBtndownstepEvent();

    protected abstract void fireAfterLoadStartPageEvent();

    protected abstract void fireAfterUploadFileEvent();

    protected abstract void fireClickTplDownloadEvent();

    protected abstract void fireTemplateValidateEvent();

    protected abstract boolean fireStartImportTaskEvent();
}

