/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.business;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.ext.hr.entity.property.HisModelBasedataProp;
import kd.bos.ext.hr.entity.property.MulHisModelBasedataProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.service.OrgService;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hies.common.constant.HIESConstant;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.common.plugin.AfterLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.validate.dto.DataValidateParams;
import kd.hr.impt.core.validate.dto.DistinctionWrapping;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class ImportServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(ImportServiceHelper.class);
    private static final Set<Long> LABORREL_STATUS = new HashSet<Long>();

    @ExcludeFromJacocoGeneratedReport
    public static Map<Object, DynamicObject> analysisComposeDataNewOrUpdate(List<ImportBillData> billDataList, Map<String, Map<String, DynamicObject>> tplFieldConfig, Set<ImportBillData> noAdaptBilldatas, Set<ImportBillData> dbRepeatBilldatas, DataValidateParams dataValidateParams, Set<Integer> formatFailedRowIndex) {
        HashMap existsDysMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)6);
        for (int i = 0; i < billDataList.size(); ++i) {
            ImportBillData billData = billDataList.get(i);
            billData.getData().put("$groupId", (Object)UUID.randomUUID().toString());
            for (Map.Entry next : billData.getData().entrySet()) {
                if (((String)next.getKey()).equalsIgnoreCase("$groupId")) continue;
                ArrayList<ImportBillData> listdata = (ArrayList<ImportBillData>)groupMap.get(next.getKey());
                if (CollectionUtils.isEmpty((Collection)listdata)) {
                    listdata = new ArrayList<ImportBillData>(billDataList.size());
                    groupMap.put(next.getKey(), listdata);
                }
                List<ImportBillData> childBillDatas = ImportServiceHelper.splitImportBillData(billData, (String)next.getKey());
                listdata.addAll(childBillDatas);
            }
        }
        HashMap groupIdMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
        for (Map.Entry next : groupMap.entrySet()) {
            Map<Object, DynamicObject> longDynamicObjectMap = ImportServiceHelper.analysisSimpleDataNewOrUpdate((List)next.getValue(), tplFieldConfig, noAdaptBilldatas, dbRepeatBilldatas, dataValidateParams, formatFailedRowIndex);
            for (ImportBillData bd : (List)next.getValue()) {
                LinkedList<ImportBillData> dblist = (LinkedList<ImportBillData>)groupIdMap.get(bd.getData().get((Object)"$groupId"));
                if (dblist == null) {
                    dblist = new LinkedList<ImportBillData>();
                    groupIdMap.put((String)bd.getData().get((Object)"$groupId"), dblist);
                }
                dblist.add(bd);
            }
            existsDysMap.putAll(longDynamicObjectMap);
        }
        billDataList.forEach(data -> {
            List childList = (List)groupIdMap.get(data.getData().get((Object)"$groupId"));
            childList.forEach(item -> {
                if (item.getMainEntityId().equalsIgnoreCase(data.getMainEntityId())) {
                    data.setOpType(item.getOpType());
                    data.setPkId(item.getPkId());
                    data.getData().getJSONObject(data.getMainEntityId()).put("id", item.getPkId());
                } else {
                    JSONArray jsonArray = data.getData().getJSONArray(item.getMainEntityId());
                    Iterator iterator1 = jsonArray.stream().iterator();
                    while (iterator1.hasNext()) {
                        JSONObject next = (JSONObject)iterator1.next();
                        if (item.getData().getString("$itemId").equals(next.getString("$itemId"))) {
                            next.put("$opType", (Object)item.getOpType());
                            next.put("id", item.getPkId());
                        }
                        next.remove((Object)"$itemId");
                    }
                }
            });
            data.getData().remove((Object)"$groupId");
        });
        return existsDysMap;
    }

    public static Map<Object, DynamicObject> analysisSimpleDataNewOrUpdate(List<ImportBillData> billDataList, Map<String, Map<String, DynamicObject>> tplFieldConfig, Set<ImportBillData> noAdaptBilldatas, Set<ImportBillData> dbRepeatBilldatas, DataValidateParams dataValidateParams, Set<Integer> formatFailedRowIndex) {
        if (billDataList == null || billDataList.size() == 0) {
            return null;
        }
        ImportStart importStart = dataValidateParams.getImportStart();
        boolean isDeleteOpType = "delete".equals(billDataList.get(0).getOpType());
        HashMap existsDysMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
        Map<String, List<ImportBillData>> sheetGroupDataList = billDataList.stream().collect(Collectors.groupingBy(ImportBillData::getMainEntityId));
        sheetGroupDataList.forEach((entityId, sheetDataList) -> {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
            List entryList = mainEntityType.getAllEntities().entrySet().stream().filter(entry -> entry.getValue() instanceof EntryType).map(Map.Entry::getKey).collect(Collectors.toList());
            HashMap uniqueValMap = Maps.newHashMapWithExpectedSize((int)billDataList.size());
            ArrayList uniqueKeyBuilder = Lists.newArrayListWithExpectedSize((int)billDataList.size());
            ArrayList qFilterList = Lists.newArrayListWithCapacity((int)sheetDataList.size());
            sheetDataList.forEach(rowData -> {
                QFilter tempQFilter = null;
                JSONObject rowDataJson = rowData.getData().getJSONObject(entityId);
                StringBuilder uniqueValBuilder = new StringBuilder();
                List<String> uniqueKeyFields = dataValidateParams.getUniqueKeyFieldsMap().get(entityId);
                String entityExtUniqueVal = "";
                if (ObjectUtils.isNotEmpty(dataValidateParams.getEntityExtUniqueValMap()) && StringUtils.isNotEmpty((CharSequence)(entityExtUniqueVal = dataValidateParams.getEntityExtUniqueValMap().get(entityId)))) {
                    entityExtUniqueVal = entityExtUniqueVal + ",";
                    String[] split = StringUtils.split((String)entityExtUniqueVal, (String)",");
                    uniqueKeyFields.addAll(Arrays.asList(split));
                }
                if (uniqueKeyBuilder.size() == 0) {
                    uniqueKeyFields.forEach(key -> {
                        DynamicProperty property = mainEntityType.getProperty(key);
                        if (property instanceof BasedataProp) {
                            DynamicObject fieldDy = (DynamicObject)((Map)tplFieldConfig.get(entityId)).get(key);
                            ImportServiceHelper.addBasedataPropAttrs(property, fieldDy.getString("imptattr"), uniqueKeyBuilder, key);
                        } else {
                            uniqueKeyBuilder.add(key);
                        }
                    });
                }
                for (String key2 : uniqueKeyBuilder) {
                    DynamicProperty property = mainEntityType.getProperty(MethodUtil.getLevelOneKey((String)key2));
                    Object[] objectValue = new Object[1];
                    if (property instanceof MuliLangTextProp) {
                        objectValue[0] = ImportServiceHelper.getObjectValue(rowDataJson, key2.concat(".").concat(Lang.get().toString()));
                    } else if (property instanceof ComboProp) {
                        objectValue[0] = ImportServiceHelper.getObjectValue(rowDataJson, key2);
                        ((ComboProp)property).getComboItems().forEach(valueMapItem -> {
                            if (valueMapItem.getName().getLocaleValue().equals(String.valueOf(objectValue[0]))) {
                                objectValue[0] = valueMapItem.getValue();
                            }
                        });
                    } else {
                        objectValue[0] = ImportServiceHelper.getObjectValue(rowDataJson, key2);
                    }
                    if (objectValue[0] == null && "number".equals(key2)) {
                        ImportServiceHelper.setRuleNumber(rowData, dataValidateParams.getEntityToNumberKey());
                        objectValue[0] = ImportServiceHelper.getObjectValue(rowDataJson, key2);
                    }
                    String queryKey = key2;
                    if (property instanceof IQueryProp) {
                        String baseEntityId = ((IBasedataField)property).getComplexType().getName();
                        Map queryField = MethodUtil.getHRPersonQueryField((String)baseEntityId, (String)property.getName());
                        queryKey = (String)queryField.get(MethodUtil.getLastKey((String)key2));
                    }
                    uniqueValBuilder.append(",").append(objectValue[0]);
                    if (formatFailedRowIndex.contains(rowData.getStartIndex())) break;
                    if (!StringUtils.isEmpty((CharSequence)entityExtUniqueVal) && entityExtUniqueVal.contains(key2 + ",") || ObjectUtils.isEmpty((Object)objectValue[0])) continue;
                    if (tempQFilter == null) {
                        tempQFilter = new QFilter(queryKey, "=", objectValue[0]);
                        continue;
                    }
                    tempQFilter.and(new QFilter(queryKey, "=", objectValue[0]));
                }
                if (tempQFilter != null) {
                    qFilterList.add(tempQFilter);
                }
                List importBillDataList = uniqueValMap.computeIfAbsent(uniqueValBuilder.toString(), val -> new LinkedList());
                importBillDataList.add(rowData);
            });
            LinkedList<QFilter> commonFilters = new LinkedList<QFilter>();
            if (ImportServiceHelper.hasHis(entityId)) {
                QFilter isCurQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
                commonFilters.add(isCurQFilter);
            }
            if (ImportServiceHelper.isBillEntityType(entityId) && ImportServiceHelper.hasBillStatus(entityId)) {
                commonFilters.add(new QFilter("billstatus", "!=", (Object)"F"));
            }
            BeforeLoadEntityEventArgs args = new BeforeLoadEntityEventArgs(importStart.getImportContext());
            args.setBillDatas((List<ImportBillData>)sheetDataList);
            args.setqFilters(qFilterList);
            args.setCommonFilters(commonFilters);
            HRImpPluginEngine.fireImptPluginEvent(importStart, "beforeLoadEntity", (AbstractEventArgs)args);
            MethodUtil.printQfilters((QFilter[])args.getqFilters().toArray(new QFilter[0]), (String)("analysisSimpleDataNewOrUpdate_commonFilters_" + entityId));
            List<DynamicObject[]> listDys = ImportServiceHelper.smartLoadDynamicObjectArray(entityId, args.getqFilters(), args.getCommonFilters(), dataValidateParams);
            AfterLoadEntityEventArgs args1 = new AfterLoadEntityEventArgs(importStart.getImportContext());
            args1.setBillDatas((List<ImportBillData>)sheetDataList);
            args1.setListDys(listDys);
            HRImpPluginEngine.fireImptPluginEvent(importStart, "afterLoadEntity", (AbstractEventArgs)args1);
            HashSet existsUniqueVal = Sets.newHashSetWithExpectedSize((int)1000);
            HashMap entryToEntryId = Maps.newHashMapWithExpectedSize((int)16);
            HashMap entryIdToLine = Maps.newHashMapWithExpectedSize((int)sheetDataList.size());
            args1.getListDys().forEach(arrays -> {
                for (DynamicObject dy : arrays) {
                    StringBuilder uniqueValBuilderDy = new StringBuilder();
                    uniqueKeyBuilder.forEach(key -> {
                        DynamicProperty property = mainEntityType.getProperty(MethodUtil.getLevelOneKey((String)key));
                        if (property instanceof IQueryProp) {
                            String baseEntityId = ((IBasedataField)property).getComplexType().getName();
                            Map queryField = MethodUtil.getHRPersonQueryField((String)baseEntityId, (String)property.getName());
                            key = (String)queryField.get(MethodUtil.getLastKey((String)key));
                        }
                        String valStr = dy.getString(key);
                        uniqueValBuilderDy.append(",").append(valStr == null ? "" : valStr);
                    });
                    List importBillDataList = (List)uniqueValMap.get(uniqueValBuilderDy.toString());
                    if (!ObjectUtils.isNotEmpty((Object)importBillDataList)) continue;
                    AtomicInteger index = new AtomicInteger();
                    importBillDataList.forEach(importBillData -> {
                        importBillData.setPkId(dy.getPkValue());
                        if (existsUniqueVal.contains(uniqueValBuilderDy.toString())) {
                            dbRepeatBilldatas.add((ImportBillData)importBillData);
                        } else if (entryList.size() > 0) {
                            ImportServiceHelper.checkEntryIdExists(importStart, entityId, entryList, dy, importBillData, entryToEntryId, entryIdToLine);
                        }
                        if (isDeleteOpType) {
                            importBillData.setOpType("delete");
                        } else {
                            importBillData.setOpType("update");
                        }
                        if (index.get() > 0) {
                            String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u53d6\u6d88\u8be5\u6761\u6570\u636e\u5165\u5e93\u3002\u539f\u56e0:\u66f4\u65b0\u573a\u666f\u4e0b\u4e0d\u80fd\u91cd\u590d\u66f4\u65b0\uff0c\u4e0e\u6e90\u6587\u4ef6\u7b2c%1$s\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ImportServiceHelper_0", (String)"hrmp-hies-import", (Object[])new Object[0]), ((ImportBillData)importBillDataList.get(0)).getStartIndex());
                            ImportRowErrorLog errorLog = new ImportRowErrorLog(importBillData.getSheetName(), importBillData.getStartIndex(), importBillData.getEndIndex(), importBillData.getStartIndex(), tip, importStart.getImportContext().getImportLog());
                            importStart.writeRowErrorLog(errorLog);
                        }
                        index.getAndIncrement();
                    });
                    existsUniqueVal.add(uniqueValBuilderDy.toString());
                    DataValidateServiceHelper.dealBillstatusJudge(importBillDataList, importStart.getImportContext(), dy);
                    if (dataValidateParams.isSerialModel()) continue;
                    Object pkid = dy.get("id");
                    existsDysMap.put(pkid, dy);
                }
            });
            uniqueValMap.forEach((key, value) -> {
                if (!existsUniqueVal.contains(key)) {
                    if (isDeleteOpType) {
                        value.forEach(importBillData -> importBillData.setOpType("delete"));
                    } else {
                        value.forEach(importBillData -> {
                            importBillData.setOpType("new");
                            DataValidateServiceHelper.dealBillstatusJudge(Collections.singletonList(importBillData), importStart.getImportContext(), null);
                            ImportServiceHelper.checkEntryIdExistsOfNew(mainEntityType, entityId, entryList, importBillData, entryToEntryId, entryIdToLine, importStart.getImportContext().getImportLog());
                        });
                        ImportServiceHelper.setRuleNumber(value, dataValidateParams.getEntityToNumberKey());
                    }
                    noAdaptBilldatas.addAll((Collection<ImportBillData>)value);
                }
            });
            ImportServiceHelper.tipEntryIdExists(importStart, sheetDataList, mainEntityType, entryToEntryId, entryIdToLine);
        });
        return existsDysMap;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void tipEntryIdExists(ImportStart importStart, List<ImportBillData> sheetDataList, MainEntityType mainEntityType, Map<String, Set<Long>> entryToEntryId, Map<Long, Integer> entryIdToLine) {
        if (entryToEntryId.size() == 0) {
            return;
        }
        DBRoute dbRoute = new DBRoute(mainEntityType.getDBRouteKey());
        String sql = "select fentryid from %s where fentryid in (%s)";
        StringBuilder filter = new StringBuilder();
        for (Map.Entry<String, Set<Long>> entry : entryToEntryId.entrySet()) {
            filter.reverse();
            entry.getValue().forEach(key -> filter.append(key).append(","));
            filter.deleteCharAt(filter.length() - 1);
            DataSet dataSet = DB.queryDataSet((String)"ImportServiceHelper.analysisSimpleDataNewOrUpdate", (DBRoute)dbRoute, (String)String.format(sql, entry.getKey(), filter.toString()));
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Integer index = entryIdToLine.get(row.getLong(0));
                DataValidateServiceHelper.writeRowErrorLog(31, importStart.getImportContext().getImportLog(), sheetDataList.get(0).getSheetName(), index, index, index, row.getLong(0));
            }
        }
    }

    public static void setRuleNumber(List<ImportBillData> billDataList, Map<String, String> entityToNumberKey) {
        billDataList.stream().forEach(data -> ImportServiceHelper.setRuleNumber(data, entityToNumberKey));
    }

    private static void setRuleNumber(ImportBillData billData, Map<String, String> entityToNumberKey) {
        List allCodeRule;
        String mainEntityId = billData.getMainEntityId();
        String number = entityToNumberKey.getOrDefault(mainEntityId, "number");
        if (billData.getData().getJSONObject(mainEntityId) != null && StringUtils.isBlank((CharSequence)billData.getData().getJSONObject(mainEntityId).getString(number)) && (allCodeRule = CodeRuleCache.getAllCodeRuleByEntity((String)mainEntityId)) != null && !allCodeRule.isEmpty()) {
            billData.getData().getJSONObject(billData.getMainEntityId()).put(number, (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)((CodeRuleInfo)allCodeRule.get(0)), (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)mainEntityId)));
        }
    }

    private static void checkEntryIdExists(ImportStart importStart, String entityId, List<String> entryList, DynamicObject dy, ImportBillData importBillData, Map<String, Set<Long>> entryToEntryId, Map<Long, Integer> entryIdToLine) {
        entryList.stream().filter(entryNum -> importBillData.getData().getJSONObject(entityId).containsKey(entryNum)).forEach(entryNum2 -> {
            DynamicObjectCollection entryCollection = dy.getDynamicObjectCollection(entryNum2);
            JSONArray jsonArray = importBillData.getData().getJSONObject(entityId).getJSONArray(entryNum2);
            if (jsonArray != null) {
                jsonArray.forEach(jsonOb -> {
                    int index = ((JSONObject)jsonOb).getIntValue("$excelIndex");
                    try {
                        Long aLong = ((JSONObject)jsonOb).getLong(entryNum2 + "_id");
                        if (aLong == null) {
                            if (importBillData.getOpType().equals("update")) {
                                DataValidateServiceHelper.writeRowErrorLog(20, importStart.getImportContext().getImportLog(), importBillData.getSheetName(), index, index, index, new Object[0]);
                            }
                            return;
                        }
                        if (entryCollection.size() == 0 || entryCollection.stream().noneMatch(dyTemp -> dyTemp.getLong("id") == aLong.longValue())) {
                            if (dy.getDynamicObjectType().getProperty(entryNum2) instanceof TreeEntryProp) {
                                String tableName = ((EntityType)((MainEntityType)dy.getDynamicObjectType()).getAllEntities().get(entryNum2)).getAlias();
                                Set ids = entryToEntryId.getOrDefault(tableName, new HashSet());
                                ids.add(aLong);
                                entryToEntryId.put(tableName, ids);
                                if (entryIdToLine.containsKey(aLong)) {
                                    DataValidateServiceHelper.writeRowErrorLog(32, importStart.getImportContext().getImportLog(), importBillData.getSheetName(), index, index, index, aLong, entryIdToLine.get(aLong));
                                } else {
                                    entryIdToLine.put(aLong, index);
                                }
                                return;
                            }
                            DataValidateServiceHelper.writeRowErrorLog(20, importStart.getImportContext().getImportLog(), importBillData.getSheetName(), index, index, index, new Object[0]);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.info("ImportServiceHelper.checkEntryIdExists(),error:{}", (Object)exception.getMessage());
                        DataValidateServiceHelper.writeRowErrorLog(20, importStart.getImportContext().getImportLog(), importBillData.getSheetName(), index, index, index, new Object[0]);
                    }
                });
            }
        });
    }

    public static void checkEntryIdExistsOfNew(MainEntityType mainEntityType, String entityId, List<String> entryList, ImportBillData importBillData, Map<String, Set<Long>> entryToEntryId, Map<Long, Integer> entryIdToLine, ImportLog importLog) {
        entryList.stream().filter(entryNum -> importBillData.getData().getJSONObject(entityId).containsKey(entryNum)).forEach(entryNum2 -> {
            JSONArray jsonArray = importBillData.getData().getJSONObject(entityId).getJSONArray(entryNum2);
            if (jsonArray != null) {
                jsonArray.forEach(jsonOb -> {
                    Long aLong = ((JSONObject)jsonOb).getLong(entryNum2 + "_id");
                    int index = ((JSONObject)jsonOb).getIntValue("$excelIndex");
                    if (aLong == null) {
                        return;
                    }
                    if (mainEntityType.getAllEntities().get(entryNum2) instanceof TreeEntryType) {
                        String tableName = ((EntityType)mainEntityType.getAllEntities().get(entryNum2)).getAlias();
                        Set ids = entryToEntryId.getOrDefault(tableName, new HashSet());
                        ids.add(aLong);
                        entryToEntryId.put(tableName, ids);
                        if (entryIdToLine.containsKey(aLong)) {
                            DataValidateServiceHelper.writeRowErrorLog(32, importLog, importBillData.getSheetName(), index, index, index, aLong, entryIdToLine.get(aLong));
                        } else {
                            entryIdToLine.put(aLong, index);
                        }
                    }
                });
            }
        });
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<ImportBillData> splitImportBillData(ImportBillData data, String entityId) {
        Object groupId = data.getData().get((Object)"$groupId");
        LinkedList<ImportBillData> list = new LinkedList<ImportBillData>();
        Object sourceobj = data.getData().get((Object)entityId);
        if (sourceobj instanceof JSONObject) {
            ImportBillData newbill = ImportServiceHelper.createNewImportBillData(data, entityId);
            JSONObject newobj = new JSONObject();
            newobj.put(entityId, sourceobj);
            newobj.put("$groupId", groupId);
            newbill.setData(newobj);
            list.add(newbill);
        } else if (sourceobj instanceof JSONArray) {
            JSONArray sour = (JSONArray)sourceobj;
            for (Object so : sour) {
                JSONObject next = (JSONObject)so;
                next.put("$itemId", (Object)UUID.randomUUID().toString());
                ImportBillData newbill = ImportServiceHelper.createNewImportBillData(data, entityId);
                JSONObject newobj = new JSONObject();
                newobj.put(entityId, (Object)next);
                newobj.put("$groupId", groupId);
                newobj.put("$itemId", next.get((Object)"$itemId"));
                newbill.setData(newobj);
                list.add(newbill);
            }
        }
        return list;
    }

    @ExcludeFromJacocoGeneratedReport
    private static ImportBillData createNewImportBillData(ImportBillData data, String entityId) {
        ImportBillData newbill = new ImportBillData();
        newbill.setOpType(data.getOpType());
        newbill.setBillIndex(data.getBillIndex());
        newbill.setEndIndex(data.getEndIndex());
        newbill.setMainEntityId(entityId);
        newbill.setSheetName(data.getSheetName());
        newbill.setStartIndex(data.getStartIndex());
        return newbill;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Object getObjectValue(JSONObject rowDataJson, String key) {
        String[] split;
        Object value = key.contains(".") ? (rowDataJson.getJSONObject((split = key.split("\\."))[0]) == null ? "" : rowDataJson.getJSONObject(split[0]).get((Object)split[1])) : rowDataJson.get((Object)key);
        return value;
    }

    public static List<QFilter> getDefaultQFilter(String entityName, IDataEntityProperty prop, String basedataEntityId, boolean isAllowDisableData) {
        QFilter f7BdCondQFilter;
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        if (ImportServiceHelper.hasHis(basedataEntityId)) {
            qFilters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        Map bdMainProp = MethodUtil.getBdMainProp((String)basedataEntityId);
        String enableProp = bdMainProp.getOrDefault("enable", null);
        String statusProp = (String)bdMainProp.get("status");
        if (StringUtils.isNotEmpty((CharSequence)enableProp)) {
            QFilter enableFilter = new QFilter(enableProp, "=", (Object)"1");
            if (isAllowDisableData) {
                enableFilter.or(new QFilter(enableProp, "=", (Object)"0"));
            }
            qFilters.add(enableFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)statusProp)) {
            qFilters.add(new QFilter(statusProp, "=", (Object)"C"));
        }
        if (ImportServiceHelper.hasInitstatus(basedataEntityId)) {
            qFilters.add(new QFilter("initstatus", "=", (Object)"2"));
        }
        if (!ObjectUtils.isEmpty((Object)(f7BdCondQFilter = MethodUtil.getF7BdCondQFilter((String)entityName, (IDataEntityProperty)prop)))) {
            qFilters.add(f7BdCondQFilter);
        }
        if ("hrpi_personf7query".equals(basedataEntityId) || "hrpi_depempf7query".equals(basedataEntityId) || "hrpi_employeef7query".equals(basedataEntityId)) {
            qFilters.add(new QFilter("datastatus", "=", (Object)"1"));
            if ("hrpi_depempf7query".equals(basedataEntityId)) {
                qFilters.add(new QFilter("otclassify", "=", (Object)HIESConstant.OTCLASSIFY_1010));
            } else if ("hrpi_employeef7query".equals(basedataEntityId)) {
                qFilters.add(new QFilter("businessstatus", "=", (Object)"1"));
                qFilters.add(new QFilter("islatestrecord", "=", (Object)"1"));
                qFilters.add(new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1"));
                qFilters.add(new QFilter("hrpi_empposorgrel.iscurrentversion", "=", (Object)"1"));
            } else if ("hrpi_personf7query".equals(basedataEntityId)) {
                qFilters.add(new QFilter("hrpi_empentrel.islatestrecord", "=", (Object)"1"));
                qFilters.add(new QFilter("hrpi_empposorgrel.empposing", "=", (Object)"1"));
                qFilters.add(new QFilter("hrpi_empentrel.laborrelstatus", "in", LABORREL_STATUS));
                qFilters.add(new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1"));
            }
        }
        MethodUtil.printQfilters((QFilter[])qFilters.toArray(new QFilter[0]), (String)("f7Query_getDefaultQFilter_" + basedataEntityId));
        return qFilters;
    }

    public static QFilter[] getRefBillDefaultQFilter(DistinctionWrapping distinctionWrapping, Set<String> values) {
        QFilter confQFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("billno", "in", values));
        if (distinctionWrapping.getProperty().isShowOnlyAudited() && ImportServiceHelper.hasBillStatus(distinctionWrapping.getBdType())) {
            qFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        if (!ObjectUtils.isEmpty((Object)(confQFilter = MethodUtil.getF7BdCondQFilter((String)distinctionWrapping.getEntityId(), (IDataEntityProperty)distinctionWrapping.getProperty())))) {
            qFilters.add(confQFilter);
        }
        QFilter[] filters = qFilters.toArray(new QFilter[0]);
        MethodUtil.printQfilters((QFilter[])filters, (String)("Query_getRefBillDefaultQFilter_" + distinctionWrapping.getBdType()));
        return filters;
    }

    private static boolean hasInitstatus(String basedataEntityId) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)basedataEntityId);
        return mainType.getProperties().stream().filter(field -> StringUtils.isNotBlank((CharSequence)field.getAlias())).map(IMetadata::getName).anyMatch(pro -> pro.equals("initstatus"));
    }

    private static boolean hasBillStatus(String basedataEntityId) {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)basedataEntityId);
        return mainType.getProperties().stream().filter(field -> StringUtils.isNotBlank((CharSequence)field.getAlias())).map(IMetadata::getName).anyMatch(pro -> pro.equals("billstatus"));
    }

    public static boolean hasHis(String basedataEntityId) {
        String entityType = HisCommonService.getInstance().entityInhRelation(basedataEntityId);
        return EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType);
    }

    public static boolean isBillEntityType(String entityId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        return dataEntityType instanceof BillEntityType && !(dataEntityType instanceof BasedataEntityType);
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean isContainHisModelBD(String basedataEntityId) {
        Map allFields = MetadataServiceHelper.getDataEntityType((String)basedataEntityId).getAllFields();
        for (Map.Entry entityPropertyEntry : allFields.entrySet()) {
            IDataEntityProperty value = (IDataEntityProperty)entityPropertyEntry.getValue();
            if (!(value instanceof HisModelBasedataProp) && !(value instanceof MulHisModelBasedataProp)) continue;
            return true;
        }
        return false;
    }

    public static Map<String, String> getCountries() {
        ORM orm = ORM.create();
        DynamicObjectCollection dynamicObjects = orm.query("bd_country", "id,number,areacode,twocountrycode", new QFilter[]{new QFilter("enable", "=", (Object)"1")}, "id asc");
        HashMap<String, String> countries = new HashMap<String, String>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            countries.put(dynamicObject.getString("areacode"), dynamicObject.getString("number"));
            countries.put(dynamicObject.getString("twocountrycode"), dynamicObject.getString("number"));
        }
        return countries;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Object getPutWhereKey(JSONObject valueJson, String baseDataFormatValue, Map<String, Object> bdFieldMainPropName) {
        if (valueJson == null) {
            return "";
        }
        if ("number_name".equalsIgnoreCase(baseDataFormatValue)) {
            String realNumber = (String)bdFieldMainPropName.get("number");
            String realName = (String)bdFieldMainPropName.get("name");
            return valueJson.getOrDefault((Object)realNumber, (Object)"").toString() + valueJson.getOrDefault((Object)"$bdSplit", (Object)"").toString() + valueJson.getOrDefault((Object)realName, (Object)"").toString();
        }
        Object val = bdFieldMainPropName.get(baseDataFormatValue);
        if (val instanceof String) {
            String realProName = (String)val;
            return valueJson.getString(realProName);
        }
        if (val instanceof LongProp) {
            return Long.parseLong(valueJson.getString("id"));
        }
        if (val instanceof TextProp) {
            return valueJson.getString("id");
        }
        return null;
    }

    public static DynamicObject[] loadDynamicObjects(List<Object> ids, String enitynumber) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)enitynumber);
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)type);
    }

    public static HasPermOrgResult getEntityHasPermOrg(String enitytId, String appId) {
        String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)enitytId);
        return PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)enitytId, (String)"47150e89000000ac");
    }

    public static List<Long> getEntityHasPermOrgId(String enitytId) {
        String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)enitytId);
        return OrgUnitServiceHelper.getAllOrg((String)orgViewType);
    }

    public static boolean checkOrgFunction(Long orgID, String orgFunction) {
        OrgService service = new OrgService();
        return service.checkOrgFunction(orgID, orgFunction);
    }

    public static QFilter getMainOrgQfilter(List<Long> orgIds) {
        return new QFilter("id", "in", orgIds);
    }

    public static QFilter getDataRuleForBdProp(String entityId, String appId, String permItemId, IDataEntityProperty prop) {
        return DataValidateServiceHelper.getDataRuleForBdProp(entityId, appId, prop.getName(), permItemId);
    }

    private static List<DynamicObject[]> smartLoadDynamicObjectArray(String entityId, List<QFilter> qFilterList, List<QFilter> commonFilters, DataValidateParams dataValidateParams) {
        LinkedList<DynamicObject[]> listDys = new LinkedList<DynamicObject[]>();
        if (ObjectUtils.isEmpty(qFilterList)) {
            return listDys;
        }
        String tempUniValStr = dataValidateParams.getImportStart().getImportContext().getEntityIdToUniqueValMap().get(entityId);
        String entityExtUniqueVal = null;
        if (ObjectUtils.isNotEmpty(dataValidateParams.getEntityExtUniqueValMap())) {
            entityExtUniqueVal = dataValidateParams.getEntityExtUniqueValMap().get(entityId);
        }
        boolean isSingleUniqueVal = true;
        if (ObjectUtils.isNotEmpty(entityExtUniqueVal) || StringUtils.split((String)tempUniValStr, (String)",").length > 1) {
            isSingleUniqueVal = false;
        }
        List<Object> temps = ImportServiceHelper.parseSingleUniqueValQFilter(qFilterList, isSingleUniqueVal);
        QFilter qFilter = null;
        if (CollectionUtils.isNotEmpty(temps)) {
            qFilter = new QFilter(qFilterList.get(0).getProperty(), "in", temps);
        } else {
            for (QFilter qf : qFilterList) {
                if (qFilter == null) {
                    qFilter = qf.copy();
                    continue;
                }
                qFilter.or(qf);
            }
        }
        if (qFilter == null) {
            qFilter = new QFilter("1", "!=", (Object)1);
        }
        ArrayList<QFilter> tempList = new ArrayList<QFilter>(2);
        tempList.add(qFilter);
        if (CollectionUtils.isNotEmpty(commonFilters)) {
            tempList.addAll(commonFilters);
        }
        try {
            MethodUtil.printQfilters((QFilter[])qFilterList.toArray(new QFilter[0]), (String)("smartLoadDy_load_qFilterList_" + entityId));
            long start = System.currentTimeMillis();
            DynamicObject[] dynamicObjects = new HRBaseServiceHelper(entityId).loadDynamicObjectArray(tempList.toArray(new QFilter[0]));
            dataValidateParams.getImportStart().getMonitor().addExistsValidatorStat("smartLoadDy_load_" + entityId, System.currentTimeMillis() - start, false);
            listDys.add(dynamicObjects);
        }
        catch (Throwable e) {
            LOGGER.info("smartLoadDynamicObjectArray_qFilterList.size=" + qFilterList.size());
            if (qFilterList.size() < 100) {
                throw e;
            }
            List averageAssignList = MethodUtil.averageAssign(qFilterList, (int)2);
            averageAssignList.forEach(list -> {
                List<DynamicObject[]> subDys = ImportServiceHelper.smartLoadDynamicObjectArray(entityId, list, commonFilters, dataValidateParams);
                listDys.addAll(subDys);
            });
        }
        return listDys;
    }

    private static List<Object> parseSingleUniqueValQFilter(List<QFilter> qFilterList, boolean isSingleUniqueVal) {
        LinkedList<Object> temps = new LinkedList<Object>();
        if (isSingleUniqueVal) {
            qFilterList.forEach(qFilter -> temps.add(qFilter.getValue()));
        }
        return temps;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void addBasedataPropAttrs(DynamicProperty property, String baseDataFormatValue, List<String> uniqueKeyBuilder, String key) {
        if (property instanceof QueryProp) {
            switch (baseDataFormatValue) {
                case "number": {
                    uniqueKeyBuilder.add(key.concat(".").concat("number"));
                    break;
                }
                case "name": {
                    uniqueKeyBuilder.add(key.concat(".").concat("name"));
                    break;
                }
                case "number_name": {
                    uniqueKeyBuilder.add(key.concat(".").concat("name"));
                    uniqueKeyBuilder.add(key.concat(".").concat("number"));
                    break;
                }
            }
        } else {
            BasedataProp bdProp = (BasedataProp)property;
            Map bdMainProp = MethodUtil.getBdMainProp((String)bdProp.getComplexType().getName());
            String number = (String)bdMainProp.get("number");
            String name = (String)bdMainProp.get("name");
            switch (baseDataFormatValue) {
                case "number": {
                    uniqueKeyBuilder.add(key.concat(".").concat(number));
                    break;
                }
                case "name": {
                    uniqueKeyBuilder.add(key.concat(".").concat(name));
                    break;
                }
                case "number_name": {
                    uniqueKeyBuilder.add(key.concat(".").concat(name));
                    uniqueKeyBuilder.add(key.concat(".").concat(number));
                    break;
                }
            }
        }
    }

    public static boolean isBuBaseData(String entityId) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
        IDataEntityProperty property = (IDataEntityProperty)dataEntityType.getProperties().get((Object)"useorg");
        boolean isBuBd = property instanceof OrgProp;
        return isBuBd;
    }

    public static void setUseOrgFieldValue(DynamicObject[] dynamicObjects) {
        for (DynamicObject dy : dynamicObjects) {
            dy.set("useorg", dy.get("createorg"));
            dy.set("org", dy.get("createorg"));
        }
    }

    static {
        QFilter qFilter = new QFilter("labrelstatusprd", "=", (Object)HIESConstant.LABRELSTATUSPRD_ING);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{qFilter, enableFilter});
        if (entityCfMap != null) {
            entityCfMap.values().forEach(labrel -> LABORREL_STATUS.add(labrel.getLong("id")));
        }
    }
}

