/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.business.template;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.ReflectUtil;
import kd.hr.hies.business.excel.SheetStyle;
import kd.hr.hies.business.export.ExportDataWriterFormat;
import kd.hr.hies.business.export.ExportHeaderWriterFormat;
import kd.hr.hies.business.export.ExportSheetStyle;
import kd.hr.hies.business.export.GenExportTplHeaderWriter;
import kd.hr.hies.business.impt.GenImportTplHeaderWriter;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.hies.common.util.ExcelStyleUtil;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.template.ExportByTplDataWriter;
import kd.hr.impt.business.template.ExportTplDataConvertParam;
import kd.hr.impt.business.template.ExportWriterBuilder;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.impt.common.plugin.HRImpPluginEngine;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.common.plugin.UserImportPluginUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ExcelTemplateGenerate {
    private static final Log log = LogFactory.getLog(ExcelTemplateGenerate.class);
    private static final String[] sources = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    @ExcludeFromJacocoGeneratedReport
    @Deprecated
    public static String genExtentTpl(IFormView view, Map<String, Map<String, DynamicObject[]>> conditionDataMap, Map<String, List<Map<Integer, Map<String, Object>>>> userCustomDatas) throws Exception {
        Object tplId = view.getFormShowParameter().getCustomParam("tplId");
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("tplId", tplId);
        map.put("formId", view.getFormShowParameter().getCustomParam("formId"));
        map.put("appId", view.getFormShowParameter().getAppId());
        map.put("importPlugin", view.getFormShowParameter().getCustomParam("importPlugin"));
        map.put("extParam", view.getFormShowParameter().getCustomParam("extParam"));
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle(map.get("tplId"), (String)"hies_diaetplconf");
        return ExcelTemplateGenerate.gen(templateData, map, conditionDataMap);
    }

    @ExcludeFromJacocoGeneratedReport
    @Deprecated
    public static String genStandardTpl(Map<String, Object> map, Map<String, Map<String, DynamicObject[]>> conditionDataMap) throws Exception {
        DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)map.get("tplId"), (String)"hies_diaetplconf");
        return ExcelTemplateGenerate.gen(templateData, map, conditionDataMap);
    }

    public static String genPreView(DynamicObject templateData, Map<String, Object> mapParam) throws Exception {
        return ExcelTemplateGenerate.gen(templateData, mapParam, null);
    }

    private static String gen(DynamicObject templateData, Map<String, Object> mapParam, Map<String, Map<String, DynamicObject[]>> conditionDataMap) throws Exception {
        List localAttachments = AttachmentServiceHelper.getAttachments((String)"hies_diaetplconf", (Object)templateData.getPkValue(), (String)"attpanelapcustomtpl");
        if (CollectionUtils.isNotEmpty((Collection)localAttachments)) {
            return (String)((Map)localAttachments.get(0)).get("url");
        }
        String sheetTplUrl = (String)mapParam.get("sheetTplUrl");
        XSSFWorkbook wb0 = null;
        String localPath = null;
        if (StringUtils.isEmpty((CharSequence)sheetTplUrl) || !sheetTplUrl.contains("configKey")) {
            List attachments = AttachmentServiceHelper.getAttachments((String)"hies_diaetplconf", (Object)templateData.getPkValue(), (String)"attpanelapdescsheet");
            if (CollectionUtils.isNotEmpty((Collection)attachments)) {
                localPath = ImportFileUtil.downloadAttachPanelFileToDisk((String)((String)((Map)attachments.get(0)).get("url")));
            }
        } else {
            localPath = ImportFileUtil.downloadTempFile((String)sheetTplUrl);
        }
        if (StringUtils.isNotEmpty((CharSequence)localPath)) {
            wb0 = new XSSFWorkbook(localPath);
        }
        QFilter[] qFilters = null;
        DynamicObject sysparam = BusinessDataServiceHelper.loadSingle((String)"hies_diaesysparam", qFilters);
        String templatePlugins = templateData.getString("plugin");
        List tplAllEntitys = MethodUtil.getTplAllEntitys((DynamicObject)templateData);
        List<HRImportPlugin> hrTemplatePlugin = UserImportPluginUtil.getHRImportPlugin((String)mapParam.get("importPlugin"), templatePlugins, null, (String)mapParam.get("extParam"), null, tplAllEntitys);
        ExportWriterBuilder builder = new ExportWriterBuilder();
        mapParam.put("userPlugins", hrTemplatePlugin);
        List<ExportHeaderWriterFormat> headerWriterFormats = builder.build(templateData, sysparam, mapParam);
        BeforeCreateHeaderColumnEventArgs args = new BeforeCreateHeaderColumnEventArgs((String)mapParam.get("extParam"));
        args.setHeaderWriterFormats(headerWriterFormats);
        HRImpPluginEngine.fireImptPluginEvent(hrTemplatePlugin, "beforeCreateHeaderColumn", (AbstractEventArgs)args);
        boolean isPreView = "preView".equalsIgnoreCase((String)mapParam.get("source"));
        SXSSFWorkbook wb = wb0 != null ? new SXSSFWorkbook(wb0, 5000) : new SXSSFWorkbook(5000);
        wb.setCompressTempFiles(true);
        ExportSheetStyle styles = isPreView ? ExcelStyleUtil.getPreViewExportSheetStyle((DynamicObject)templateData, (SXSSFWorkbook)wb, (String)((String)mapParam.get("fieldstyle")), (String)((String)mapParam.get("fieldmerge"))) : ExcelStyleUtil.getExportSheetStyle((DynamicObject)templateData, (SXSSFWorkbook)wb);
        ExcelTemplateGenerate.writerExcel(conditionDataMap, headerWriterFormats, templateData, wb, styles, mapParam);
        String uploadFilePath = ExcelTemplateGenerate.saveAndUploadFile(wb, templateData, mapParam);
        if (StringUtils.isNotEmpty((CharSequence)localPath)) {
            ImportFileUtil.deleteLocalTempFile((String)localPath);
        }
        return uploadFilePath;
    }

    public static String getColumnLabel(int columnNo) {
        StringBuilder sb = new StringBuilder(5);
        int remainder = columnNo % 26;
        if (remainder == 0) {
            sb.append('Z');
            remainder = 26;
        } else {
            sb.append(sources[remainder - 1]);
        }
        while ((columnNo = (columnNo - remainder) / 26 - 1) > -1) {
            remainder = columnNo % 26;
            sb.append(sources[remainder]);
        }
        return sb.reverse().toString();
    }

    private static SXSSFWorkbook writerExcel(Map<String, Map<String, DynamicObject[]>> conditionDataMap, List<ExportHeaderWriterFormat> headerWriterFormats, DynamicObject templateData, SXSSFWorkbook wb, ExportSheetStyle styles, Map<String, Object> mapParam) throws ParseException {
        boolean existMergeCol = false;
        String tmpltype = templateData.getString("tmpltype");
        String entitytype = templateData.getString("entitytype");
        ArrayList<ExportDataWriterFormat> dataWriterFormats = new ArrayList<ExportDataWriterFormat>(headerWriterFormats.size());
        if ("SE".equals(entitytype) || "MESS".equals(entitytype)) {
            int headerTotalOffset = 0;
            String name = templateData.getString("entity.name");
            name = HIESUtil.getLegalSheetName((String)name, (String)tmpltype);
            name = MethodUtil.checkSheetRepeatName((String)name, (String)name, (int)0, (SXSSFWorkbook)wb);
            SXSSFSheet sheet = wb.createSheet(name);
            String dropName = name.replace("-", "");
            dropName = MethodUtil.checkSheetRepeatName((String)dropName, (String)dropName, (int)0, (SXSSFWorkbook)wb) + "DDM";
            dropName = HIESUtil.getLegalSheetName((String)dropName, (String)tmpltype);
            SXSSFSheet dropdownSheet = wb.createSheet(dropName);
            if ("MESS".equals(entitytype) && "IMPT".equalsIgnoreCase(tmpltype)) {
                ExcelTemplateGenerate.dealHasFieldimportdesc(headerWriterFormats);
            }
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                if (!styles.isExistMergeCol(format.getEnityName())) continue;
                existMergeCol = true;
                break;
            }
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                ExportDataWriterFormat dataWriterFormat = new ExportDataWriterFormat();
                dataWriterFormat.setEnityName(format.getEnityName());
                dataWriterFormat.setMainEntity(format.isMainEntity());
                dataWriterFormat.setEntryentity(format.isEntryentity());
                if (existMergeCol) {
                    format.setDropDownStartIndex(format.getDropDownStartIndex() + 1);
                }
                if ("IMPT".equalsIgnoreCase(tmpltype)) {
                    headerTotalOffset = GenImportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (SXSSFSheet)dropdownSheet, (ExportSheetStyle)styles, (ExportHeaderWriterFormat)format, (int)headerTotalOffset, (DynamicObject)templateData, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol);
                    dataWriterFormats.add(dataWriterFormat);
                } else {
                    headerTotalOffset = GenExportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportHeaderWriterFormat)format, (int)headerTotalOffset, null, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol);
                }
                dataWriterFormat.setF7BdWriteFormats(format.getF7BdWriteFormats());
                String entityDisplayName = "MESS".equals(entitytype) ? format.getDisplayName() : null;
                GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)entityDisplayName, (List)format.getF7BdWriteFormats(), (ExportSheetStyle)styles);
                for (ExportHeaderWriterFormat subEntryWriteFormat : format.getNext()) {
                    GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)entityDisplayName, (List)subEntryWriteFormat.getF7BdWriteFormats(), (ExportSheetStyle)styles);
                }
            }
            wb.setSheetHidden(wb.getSheetIndex((Sheet)dropdownSheet), true);
            if ("IMPT".equalsIgnoreCase(tmpltype)) {
                BeforeWriteDataEventArgs args = new BeforeWriteDataEventArgs((String)mapParam.get("extParam"));
                args.setEntityFieldsIndex(ExcelTemplateGenerate.getEntityFieldIndex(dataWriterFormats));
                args.setSheetStyle((SheetStyle)ReflectUtil.newInstance(SheetStyle.class, (Object[])new Object[]{wb}));
                HRImpPluginEngine.fireImptPluginEvent((List)mapParam.get("userPlugins"), "beforeWriteData", (AbstractEventArgs)args);
                ExcelTemplateGenerate.writeTplData(sheet, args.getData(), dataWriterFormats, existMergeCol, entitytype);
            }
            CTWorksheet ctSheet = wb.getXSSFWorkbook().getSheet(sheet.getSheetName()).getCTWorksheet();
            ctSheet.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel(headerTotalOffset) + sheet.getPhysicalNumberOfRows());
        } else if ("MEMS".equals(entitytype)) {
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                int headerTotalOffset = 0;
                String displayName = format.getDisplayName();
                displayName = HIESUtil.getLegalSheetName((String)displayName, (String)tmpltype);
                if (styles.isExistMergeCol(format.getEnityName())) {
                    existMergeCol = true;
                }
                displayName = MethodUtil.checkSheetRepeatName((String)displayName, (String)displayName, (int)0, (SXSSFWorkbook)wb);
                SXSSFSheet sheet = wb.createSheet(displayName);
                ExportDataWriterFormat dataWriterFormat = new ExportDataWriterFormat();
                dataWriterFormat.setEnityName(format.getEnityName());
                dataWriterFormat.setMainEntity(format.isMainEntity());
                dataWriterFormat.setEntryentity(format.isEntryentity());
                if (!format.isMainEntity()) {
                    format.setDropDownStartIndex(5);
                }
                if (existMergeCol) {
                    format.setDropDownStartIndex(format.getDropDownStartIndex() + 1);
                }
                if ("IMPT".equalsIgnoreCase(tmpltype)) {
                    String dropdownSheetName = displayName.replace("-", "");
                    dropdownSheetName = MethodUtil.checkSheetRepeatName((String)dropdownSheetName, (String)dropdownSheetName, (int)0, (SXSSFWorkbook)wb) + "DDM";
                    dropdownSheetName = HIESUtil.getLegalSheetName((String)dropdownSheetName, (String)tmpltype);
                    SXSSFSheet dropdownSheet = wb.createSheet(dropdownSheetName);
                    headerTotalOffset = GenImportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (SXSSFSheet)dropdownSheet, (ExportSheetStyle)styles, (ExportHeaderWriterFormat)format, (int)headerTotalOffset, (DynamicObject)templateData, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol);
                    dataWriterFormats.add(dataWriterFormat);
                    wb.setSheetHidden(wb.getSheetIndex((Sheet)dropdownSheet), true);
                    BeforeWriteDataEventArgs args = new BeforeWriteDataEventArgs((String)mapParam.get("extParam"));
                    List<ExportDataWriterFormat> currentDataWriterFormat = Collections.singletonList(dataWriterFormat);
                    args.setEntityFieldsIndex(ExcelTemplateGenerate.getEntityFieldIndex(currentDataWriterFormat));
                    args.setSheetStyle((SheetStyle)ReflectUtil.newInstance(SheetStyle.class, (Object[])new Object[]{wb}));
                    HRImpPluginEngine.fireImptPluginEvent((List)mapParam.get("userPlugins"), "beforeWriteData", (AbstractEventArgs)args);
                    ExcelTemplateGenerate.writeTplData(sheet, args.getData(), currentDataWriterFormat, existMergeCol, entitytype);
                } else {
                    GenExportTplHeaderWriter.writeHeader((SXSSFWorkbook)wb, (SXSSFSheet)sheet, (ExportSheetStyle)styles, (ExportHeaderWriterFormat)format, (int)headerTotalOffset, null, (ExportDataWriterFormat)dataWriterFormat, (boolean)existMergeCol);
                }
                dataWriterFormat.setF7BdWriteFormats(format.getF7BdWriteFormats());
                CTWorksheet ctSheet = wb.getXSSFWorkbook().getSheet(sheet.getSheetName()).getCTWorksheet();
                ctSheet.getDimension().setRef("A1:" + ExcelTemplateGenerate.getColumnLabel(headerTotalOffset) + sheet.getPhysicalNumberOfRows());
            }
            for (ExportHeaderWriterFormat format : headerWriterFormats) {
                GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)format.getDisplayName(), (List)format.getF7BdWriteFormats(), (ExportSheetStyle)styles);
                for (ExportHeaderWriterFormat subEntryWriteFormat : format.getNext()) {
                    GenImportTplHeaderWriter.toWriteHeaderForBaseDataF7((SXSSFWorkbook)wb, (String)format.getDisplayName(), (List)subEntryWriteFormat.getF7BdWriteFormats(), (ExportSheetStyle)styles);
                }
            }
        }
        return wb;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void writeTplData(SXSSFSheet sheet, Map<String, List<Map<Integer, Map<String, Object>>>> userCustomDatas, List<ExportDataWriterFormat> dataWriterFormats, boolean existMergeCol, String entitytype) {
        int currentRowNumber = 5;
        if (existMergeCol) {
            ++currentRowNumber;
        }
        if (userCustomDatas != null && userCustomDatas.size() > 0) {
            for (ExportDataWriterFormat format : dataWriterFormats) {
                List<Map<Integer, Map<String, Object>>> entityDatas;
                if (!format.isMainEntity() && "MEMS".equals(entitytype)) {
                    --currentRowNumber;
                }
                if (!CollectionUtils.isNotEmpty(entityDatas = userCustomDatas.get(format.getEnityName()))) continue;
                ExportByTplDataWriter dataWriter = new ExportByTplDataWriter(sheet, entityDatas);
                dataWriter.write(currentRowNumber);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static Map<String, List<Map<Integer, Map<String, Object>>>> convertConditionDataMap(Map<String, Map<String, DynamicObject[]>> conditionDataMap, List<ExportDataWriterFormat> dataWriterFormats, ExportSheetStyle styles, DynamicObject templateData) throws ParseException {
        HashMap entityDatas = Maps.newHashMapWithExpectedSize((int)6);
        if (conditionDataMap != null && conditionDataMap.size() > 0) {
            for (ExportDataWriterFormat format : dataWriterFormats) {
                Map<String, DynamicObject[]> entityFields = conditionDataMap.get(format.getEnityName());
                if (entityFields == null || entityFields.size() <= 0) continue;
                ExcelTemplateGenerate.removeNoNeedFillFields(format, entityFields);
                List<DynamicObject> objects = ExcelTemplateGenerate.composeEntityData(entityFields, format.getEnityName());
                LinkedList tempDatas = new LinkedList();
                ExportTplDataConvertParam para = new ExportTplDataConvertParam(objects.toArray(new DynamicObject[0]), format, styles, templateData, null, null, false);
                para.setEntityData(true);
                entityDatas.put(format.getEnityName(), tempDatas);
            }
        }
        return entityDatas;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<DynamicObject> composeEntityData(Map<String, DynamicObject[]> data, String entityId) {
        LinkedList<DynamicObject> list = new LinkedList<DynamicObject>();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
        for (Map.Entry<String, DynamicObject[]> next : data.entrySet()) {
            DynamicObject[] da;
            for (DynamicObject dy : da = next.getValue()) {
                DynamicObject dynamicObject = helper.generateEmptyDynamicObject();
                dynamicObject.set(next.getKey(), (Object)dy);
                list.add(dynamicObject);
            }
        }
        return list;
    }

    @ExcludeFromJacocoGeneratedReport
    private static ExportDataWriterFormat removeNoNeedFillFields(ExportDataWriterFormat format, Map<String, DynamicObject[]> entityFields) {
        Iterator iterator1 = format.getFields().entrySet().iterator();
        while (iterator1.hasNext()) {
            String[] split;
            boolean canRemove = true;
            Map.Entry next = iterator1.next();
            String type = (String)((Map)next.getValue()).get("InputType");
            if ("basedata".equalsIgnoreCase(type) && ((split = ((String)next.getKey()).split("\\.")).length > 1 && entityFields.containsKey(split[1]) || entityFields.containsKey(split[0]))) {
                canRemove = false;
            }
            if (!canRemove) continue;
            iterator1.remove();
        }
        ExcelTemplateGenerate.clearEntry(format.getNext());
        return format;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void clearEntry(List<ExportDataWriterFormat> nextFormats) {
        for (ExportDataWriterFormat format : nextFormats) {
            format.getFields().clear();
            if (!CollectionUtils.isNotEmpty((Collection)format.getNext())) continue;
            ExcelTemplateGenerate.clearEntry(format.getNext());
        }
    }

    /*
     * Exception decompiling
     */
    private static String saveAndUploadFile(SXSSFWorkbook book, DynamicObject templateData, Map<String, Object> map) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void dealHasFieldimportdesc(List<ExportHeaderWriterFormat> headerWriterFormats) {
        AtomicBoolean hasFieldimportdesc = new AtomicBoolean(false);
        headerWriterFormats.forEach(format -> {
            if (format.isHasFieldimportdesc()) {
                hasFieldimportdesc.set(true);
            }
        });
        if (hasFieldimportdesc.get()) {
            headerWriterFormats.forEach(format -> format.setHasFieldimportdesc(true));
        }
    }

    private static LinkedHashMap<String, LinkedHashMap<String, Integer>> getEntityFieldIndex(List<ExportDataWriterFormat> dataWriterFormats) {
        LinkedHashMap<String, LinkedHashMap<String, Integer>> entityFieldsMap = new LinkedHashMap<String, LinkedHashMap<String, Integer>>();
        for (ExportDataWriterFormat format : dataWriterFormats) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            LinkedList indexList = new LinkedList();
            format.getFields().forEach((x, y) -> {
                Integer index = (Integer)y.get("ColumnSeq");
                indexList.add(index);
                map.put(index, x);
            });
            format.getNext().forEach(ft -> ft.getFields().forEach((x, y) -> {
                Integer index = (Integer)y.get("ColumnSeq");
                indexList.add(index);
                map.put(index, x);
                map.put((Integer)y.get("ColumnSeq"), x);
            }));
            Collections.sort(indexList);
            LinkedHashMap ret = new LinkedHashMap();
            indexList.forEach(item -> ret.put(map.get(item), item));
            entityFieldsMap.put(format.getEnityName(), ret);
        }
        return entityFieldsMap;
    }
}

