/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.business.template;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class ExportByTplDataWriter {
    private static final Log log = LogFactory.getLog(ExportByTplDataWriter.class);
    private final SXSSFSheet sheet;
    private final List<Map<Integer, Map<String, Object>>> dataRows;

    public ExportByTplDataWriter(SXSSFSheet sheet, List<Map<Integer, Map<String, Object>>> dataRows) {
        this.sheet = sheet;
        this.dataRows = dataRows;
    }

    public int write(int rowNumber) {
        Iterator<Map<Integer, Map<String, Object>>> iterator = this.dataRows.iterator();
        while (iterator.hasNext()) {
            Map<Integer, Map<String, Object>> row = iterator.next();
            SXSSFRow dataRow = ExportByTplDataWriter.getRow(this.sheet, ++rowNumber);
            for (Map.Entry<Integer, Map<String, Object>> next : row.entrySet()) {
                Map<String, Object> map = next.getValue();
                if (dataRow == null) continue;
                String val = (String)map.get("val");
                CellStyle style = (CellStyle)map.get("style");
                SXSSFCell cell = ExportByTplDataWriter.createCell(dataRow, (Integer)map.get("col"), style);
                if (StringUtils.isNotBlank((CharSequence)val) && "Y".equals(map.get("isNumber"))) {
                    try {
                        cell.setCellValue(new BigDecimal(val).doubleValue());
                        continue;
                    }
                    catch (Exception ex) {
                        log.warn("tran BigDecimal fail", (Throwable)ex);
                    }
                }
                cell.setCellValue(val);
            }
            iterator.remove();
        }
        return rowNumber;
    }

    private static SXSSFCell createCell(SXSSFRow row, int column, CellStyle style) {
        SXSSFCell cell = row.createCell(column);
        cell.setCellStyle(style);
        return cell;
    }

    private static SXSSFRow getRow(SXSSFSheet sheet, int r) {
        try {
            SXSSFRow row = sheet.getRow(r);
            if (row == null) {
                row = sheet.createRow(r);
            }
            return row;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }
}

