/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.common.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.dto.AbstractEventArgs;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.plugin.AfterCallOperationEventArgs;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.AfterDataTempStoreArgs;
import kd.hr.impt.common.plugin.AfterDbTanRollbackEventArgs;
import kd.hr.impt.common.plugin.AfterF7MatchedEventArgs;
import kd.hr.impt.common.plugin.AfterImportCompleteArgs;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterLoadEntityEventArgs;
import kd.hr.impt.common.plugin.AfterLoadStartPageEventArgs;
import kd.hr.impt.common.plugin.AfterLoadUserPluginEventArgs;
import kd.hr.impt.common.plugin.AfterParseBillDataEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.AfterTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.AfterUploadFileEventArgs;
import kd.hr.impt.common.plugin.AfterValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.impt.common.plugin.BeforeInitValidatorEventArgs;
import kd.hr.impt.common.plugin.BeforeLoadEntityEventArgs;
import kd.hr.impt.common.plugin.BeforeQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeShowTemplateSelectListEventArgs;
import kd.hr.impt.common.plugin.BeforeTempStoreInstoreArgs;
import kd.hr.impt.common.plugin.BeforeTemplateValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;
import kd.hr.impt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.impt.common.plugin.HRImportPlugin;
import kd.hr.impt.common.plugin.ImportContextArgsDto;
import kd.hr.impt.core.init.ImportStart;

@ExcludeFromJacocoGeneratedReport
public class HRImpPluginEngine {
    private static Log log = LogFactory.getLog(HRImpPluginEngine.class);
    private static final Map<String, BiConsumer<List<HRImportPlugin>, AbstractEventArgs>> imptPluginMappings = new HashMap<String, BiConsumer<List<HRImportPlugin>, AbstractEventArgs>>(){
        private static final long serialVersionUID = -2968592180970395648L;
        {
            this.put("afterLoadUserPlugin", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterLoadUserPlugin((AfterLoadUserPluginEventArgs)((Object)params))));
            this.put("afterLoadStartPage", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterLoadStartPage((AfterLoadStartPageEventArgs)((Object)params))));
            this.put("afterUploadFile", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterUploadFile((AfterUploadFileEventArgs)((Object)params))));
            this.put("beforeShowTemplateSelectList", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeShowTemplateSelectList((BeforeShowTemplateSelectListEventArgs)((Object)params))));
            this.put("beforeWriteData", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeWriteData((BeforeWriteDataEventArgs)((Object)params))));
            this.put("beforeTemplateValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeTemplateValidate((BeforeTemplateValidateEventArgs)((Object)params))));
            this.put("afterTemplateValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterTemplateValidate((AfterTemplateValidateEventArgs)((Object)params))));
            this.put("beforeCreateHeaderColumn", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeCreateHeaderColumn((BeforeCreateHeaderColumnEventArgs)((Object)params))));
            this.put("afterInitContext", (plugins, params) -> {
                for (HRImportPlugin userImportPlugin : plugins) {
                    ImportContextArgsDto dto = (ImportContextArgsDto)((Object)params);
                    ImportContext importContext = dto.getImportContext();
                    AfterInitContextArgs args = new AfterInitContextArgs(dto.getImportContext());
                    args.setEntityIdToUniqueValMap(importContext.getEntityIdToUniqueValMap());
                    args.setMultiEntityDbTranSeq(importContext.getMultiEntityDbTranSeq());
                    args.setExcludeMultiEntityDbTran(importContext.getExcludeMultiEntityDbTran());
                    args.setSubmitOP((String)importContext.getExtOption().get("submitOP"));
                    args.setCallopStandExpense((Integer)importContext.getExtOption().get("callopStandExpense"));
                    args.setDisableRepeatDataValidator((Boolean)importContext.getExtOption().get("disableRepeatDataValidator"));
                    args.setEnableBatchMultiCallOp(importContext.isEnableBatchMultiCallOp());
                    args.setCustomInstoreParam(importContext.getCustomInstoreParam());
                    args.setEnableSequenceInstore(importContext.isEnableSequenceInstore());
                    args.setEnableRowStatistics(importContext.isEnableRowStatistics());
                    args.setCusValidateBatchSize(importContext.getCusValidateBatchSize());
                    args.setCusValidateMaxThread(importContext.getCusValidateMaxThread());
                    args.setCusQueueSize(importContext.getCusQueueSize());
                    userImportPlugin.afterInitContext(args);
                    importContext.setEntityIdToUniqueValMap(args.getEntityIdToUniqueValMap());
                    importContext.setMultiEntityDbTranSeq(args.getMultiEntityDbTranSeq());
                    importContext.setExcludeMultiEntityDbTran(args.getExcludeMultiEntityDbTran());
                    importContext.getExtOption().put("submitOP", args.getSubmitOP());
                    importContext.getExtOption().put("callopStandExpense", args.getCallopStandExpense());
                    importContext.getExtOption().put("disableRepeatDataValidator", args.getDisableRepeatDataValidator());
                    importContext.setEnableBatchMultiCallOp(args.getEnableBatchMultiCallOp());
                    importContext.setEnableSequenceInstore(args.isEnableSequenceInstore());
                    importContext.setEnableRowStatistics(args.isEnableRowStatistics());
                    importContext.setCusValidateBatchSize(args.getCusValidateBatchSize());
                    importContext.setCusValidateMaxThread(args.getCusValidateMaxThread());
                    importContext.setCusQueueSize(args.getCusQueueSize());
                    if (!importContext.isSerialModel()) continue;
                    importContext.setCustomInstoreParam(args.getCustomInstoreParam());
                }
            });
            this.put("afterParseBillData", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterParseBillData((AfterParseBillDataEventArgs)((Object)params))));
            this.put("beforeValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeValidate((BeforeValidateEventArgs)((Object)params))));
            this.put("beforeInitValidator", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeInitValidator((BeforeInitValidatorEventArgs)((Object)params))));
            this.put("beforeLoadEntity", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeLoadEntity((BeforeLoadEntityEventArgs)((Object)params))));
            this.put("afterLoadEntity", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterLoadEntity((AfterLoadEntityEventArgs)((Object)params))));
            this.put("beforeQueryRefBd", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeQueryRefBd((BeforeQueryRefBdEventArgs)((Object)params))));
            this.put("AfterQueryRefBd", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterQueryRefBd((AfterQueryRefBdEventArgs)((Object)params))));
            this.put("AfterF7Matched", (plugins, params) -> {
                for (HRImportPlugin userImportPlugin : plugins) {
                    userImportPlugin.afterF7Matched((AfterF7MatchedEventArgs)((Object)params));
                }
            });
            this.put("afterValidate", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterValidate((AfterValidateEventArgs)((Object)params))));
            this.put("AfterConvertDynamicObjects", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterConvertDynamicObjects((AfterConvertDynamicObjectsEventArgs)((Object)params))));
            this.put("beforeCallOperation", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeCallOperation((BeforeCallOperationEventArgs)((Object)params))));
            this.put("afterCallOperation", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterCallOperation((AfterCallOperationEventArgs)((Object)params))));
            this.put("afterDataTempStore", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterDataTempStore((AfterDataTempStoreArgs)((Object)params))));
            this.put("beforeTempStoreInstore", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.beforeTempStoreInstore((BeforeTempStoreInstoreArgs)((Object)params))));
            this.put("afterDbTanRollback", (plugins, params) -> plugins.forEach((? super T userImportPlugin) -> userImportPlugin.afterDbTanRollback((AfterDbTanRollbackEventArgs)((Object)params))));
            this.put("afterImportComplete", (plugins, params) -> {
                for (HRImportPlugin userImportPlugin : plugins) {
                    ImportContextArgsDto dto = (ImportContextArgsDto)((Object)params);
                    ImportContext importContext = dto.getImportContext();
                    AfterImportCompleteArgs args = new AfterImportCompleteArgs(dto.getImportContext());
                    args.setFinishedBillCount(importContext.getFinishedBillCount().get());
                    args.setFinishedRowCount(importContext.getFinishedRowCount());
                    args.setFinishedValidateBillCount(importContext.getFinishedValidateBillCount().get());
                    args.setSuccessedBillCount(importContext.getSuccessedBillCount().get());
                    args.setSuccessedValidateBillCount(importContext.getSuccessedValidateBillCount().get());
                    args.setTaskPkId(importContext.getTaskPkId());
                    args.setTotalBillCount(importContext.getTotalBillCount());
                    args.setTotalRowCount(importContext.getTotalRowCount());
                    userImportPlugin.afterImportComplete(args);
                }
            });
        }
    };

    public static void fireImptPluginEvent(ImportStart importStart, String eventMethod, AbstractEventArgs params) {
        List<HRImportPlugin> userPluginInstances = importStart.getImportContext().getUserPluginInstances();
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        try {
            imptPluginMappings.get(eventMethod).accept(userPluginInstances, params);
        }
        catch (Throwable e) {
            importStart.getMonitor().addOtherTotalCount("pluginExceptionCount", 1);
            throw e;
        }
        finally {
            long spense = System.currentTimeMillis() - start;
            if (spense > 100L) {
                importStart.getMonitor().addExpenseStatistics(eventMethod, (Long)spense, false);
            }
        }
    }

    public static void fireImptPluginEvent(List<HRImportPlugin> userPluginInstances, String eventMethod, AbstractEventArgs params) {
        if (CollectionUtils.isEmpty(userPluginInstances)) {
            return;
        }
        long start = System.currentTimeMillis();
        imptPluginMappings.get(eventMethod).accept(userPluginInstances, params);
        long spense = System.currentTimeMillis() - start;
        if (spense > 100L) {
            log.info("fireUserPluginEvent_expense:" + spense);
        }
    }
}

