/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.common.util;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.constant.BaseInfoFormatConstant;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.impt.core.end.LocalTplReadSheetHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@ExcludeFromJacocoGeneratedReport
public class LocalTplCheckUtil {
    private static final Log log = LogFactory.getLog(LocalTplCheckUtil.class);
    private static final String SPLIT_KEY = "##";

    public static String check(LocalTplReadSheetHandler sheetHandler, List<String> entityNumbers, DynamicObjectCollection fieldEntryCollection, boolean isMESS) {
        List<String> errMsgs = sheetHandler.getErrMsgs();
        if (CollectionUtils.isNotEmpty(errMsgs)) {
            return Joiner.on((String)"\r\n").join(errMsgs);
        }
        Map<String, String> sheetEntityMap = sheetHandler.getSheetEntityMap();
        String errMsg = LocalTplCheckUtil.checkEntityAmount(entityNumbers, sheetEntityMap, isMESS);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            return errMsg;
        }
        LinkedHashMap<String, List<DynamicObject>> groupChildEntityMap = new LinkedHashMap<String, List<DynamicObject>>(4);
        LinkedHashMap<String, List<String>> isMustGroupChildEntityMap = new LinkedHashMap<String, List<String>>(4);
        LinkedHashMap<String, List<String>> entityToNonField = new LinkedHashMap<String, List<String>>(4);
        Map<String, List<String>> entityToMustFillNonField = LocalTplCheckUtil.buildTplInfo(fieldEntryCollection, groupChildEntityMap, isMustGroupChildEntityMap, entityToNonField);
        if (MapUtils.isEmpty(entityToNonField)) {
            log.warn("\u9875\u9762\u6a21\u677f\u672a\u9009\u62e9\u4efb\u4f55\u5b57\u6bb5");
            return ResManager.loadKDString((String)"\u60a8\u4e0a\u4f20\u6587\u4ef6\u4e2d\u7684\u5b57\u6bb5\u5217\u4e0e\u5f53\u524d\u7cfb\u7edf\u9875\u9762\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"LocalTplCheckUtil_9", (String)"hrmp-hies-import", (Object[])new Object[0]);
        }
        LinkedMultiValueMap localEntityFieldMapping = new LinkedMultiValueMap(4);
        errMsg = LocalTplCheckUtil.buildLocalFileInfo(sheetHandler, (MultiValueMap<String, Object>)localEntityFieldMapping, entityToNonField, entityToMustFillNonField, isMESS);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            return errMsg;
        }
        String currLang = RequestContext.getOrCreate().getLang().name();
        for (Map.Entry tplEntityFieldMap : groupChildEntityMap.entrySet()) {
            String messEntityNameKey;
            String key = (String)tplEntityFieldMap.getKey();
            String[] splitEntryNumber = key.split(SPLIT_KEY);
            String curEntityNumber = splitEntryNumber[0];
            boolean isEntity = splitEntryNumber.length == 1;
            Map allFields = ((EntityType)EntityMetadataCache.getDataEntityType((String)curEntityNumber).getAllEntities().get(isEntity ? curEntityNumber : splitEntryNumber[1])).getFields();
            List tplEntityFields = (List)tplEntityFieldMap.getValue();
            String entityName = isMESS ? (String)sheetEntityMap.keySet().stream().findFirst().get() : LocalTplCheckUtil.getMapKey(sheetEntityMap, curEntityNumber);
            List entitys = (List)localEntityFieldMapping.get((Object)key);
            if (CollectionUtils.isEmpty((Collection)entitys)) continue;
            String string = messEntityNameKey = isEntity ? (String)entitys.get(0) : ((List)localEntityFieldMapping.get((Object)curEntityNumber)).get(0) + SPLIT_KEY + entitys.get(0);
            if (entitys.size() != 2) {
                errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201dSheet\u9875\u7684\u201c%2$s\u201d\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u3002", (String)"LocalTplCheckUtil_0", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, messEntityNameKey));
                continue;
            }
            Collection values = (Collection)entitys.get(1);
            HashSet<String> localFiledSet = new HashSet<String>(values.size());
            LocalTplCheckUtil.checkRepeatField(errMsgs, entityName, messEntityNameKey, values, localFiledSet);
            HashMap<String, String> tranMap = new HashMap<String, String>(8);
            Set<String> tplEntityFieldSet = LocalTplCheckUtil.checkOverLimitField(errMsgs, currLang, allFields, tplEntityFields, entityName, messEntityNameKey, localFiledSet, tranMap);
            LocalTplCheckUtil.checkNonTplField(errMsgs, tplEntityFieldSet, entityName, messEntityNameKey, localFiledSet, tranMap, isEntity);
            List isMustFields = (List)isMustGroupChildEntityMap.get(key);
            LocalTplCheckUtil.checkMustField(errMsgs, isMustFields, entityName, messEntityNameKey, localFiledSet, tranMap);
        }
        if (CollectionUtils.isNotEmpty(errMsgs)) {
            return Joiner.on((String)"\r\n").join(errMsgs);
        }
        return "";
    }

    private static void checkNonTplField(List<String> errMsgs, Set<String> tplEntityFieldSet, String entityName, String messEntityNameKey, Set<String> localFiledSet, Map<String, String> tranMap, boolean isEntity) {
        if (!isEntity) {
            return;
        }
        if (CollectionUtils.isNotEmpty(tplEntityFieldSet)) {
            tplEntityFieldSet = tplEntityFieldSet.stream().map(item -> {
                String targetField = (String)tranMap.get(item);
                if (StringUtils.isBlank((CharSequence)targetField)) {
                    targetField = item;
                }
                return targetField;
            }).collect(Collectors.toSet());
            for (String localFiled : localFiledSet) {
                String targetField = tranMap.get(localFiled);
                if (StringUtils.isBlank((CharSequence)targetField)) {
                    targetField = localFiled;
                }
                if (!tplEntityFieldSet.contains(targetField)) continue;
                return;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)messEntityNameKey)) {
            errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201dSheet\u9875\u7684\u201c%2$s\u201d\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u3002", (String)"LocalTplCheckUtil_0", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, messEntityNameKey));
        } else {
            errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201dSheet\u9875\u6ca1\u6709\u53ef\u5bfc\u5165\u7684\u5b57\u6bb5\uff0c\u8bf7\u5b8c\u5584\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"LocalTplCheckUtil_2", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName));
        }
    }

    private static void checkMustField(List<String> errMsgs, List<String> isMustFields, String entityName, String messEntityNameKey, Set<String> localFiledSet, Map<String, String> tranMap) {
        HashSet<String> lostMustInputFields = new HashSet<String>(4);
        if (CollectionUtils.isNotEmpty(isMustFields)) {
            for (String isMustField : isMustFields) {
                String targetField = tranMap.get(isMustField);
                if (StringUtils.isBlank((CharSequence)targetField)) {
                    targetField = isMustField;
                }
                if (localFiledSet.contains(targetField)) continue;
                lostMustInputFields.add(targetField);
            }
        }
        if (lostMustInputFields.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)messEntityNameKey)) {
                errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%2$s\u201d\u7cfb\u7edf\u7684\u5fc5\u5f55\u5b57\u6bb5\u201c%3$s\u201d\u5728\u4e0a\u4f20\u6587\u4ef6\u201c%1$s\u201dSheet\u9875\u4e2d\u672a\u627e\u5230\uff0c\u8bf7\u5b8c\u5584\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"LocalTplCheckUtil_3", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, messEntityNameKey, Joiner.on((String)"\u3001").join(lostMustInputFields)));
            } else {
                errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u7684\u5fc5\u5f55\u5b57\u6bb5\u201c%2$s\u201d\u5728\u4e0a\u4f20\u6587\u4ef6\u201c%1$s\u201dSheet\u9875\u4e2d\u672a\u627e\u5230\uff0c\u8bf7\u5b8c\u5584\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"LocalTplCheckUtil_4", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, Joiner.on((String)"\u3001").join(lostMustInputFields)));
            }
        }
    }

    private static Set<String> checkOverLimitField(List<String> errMsgs, String currLang, Map<String, IDataEntityProperty> allFields, List<DynamicObject> tplEntityFields, String entityName, String messEntityNameKey, Set<String> localFiledSet, Map<String, String> tranMap) {
        HashMap imptAttrMap = new HashMap(8);
        Set<String> tplEntityFieldSet = tplEntityFields.stream().map(dyn -> {
            String imptAttr = dyn.getString("imptattr");
            String field = dyn.getString("fieldnumber");
            if (StringUtils.isNotBlank((CharSequence)imptAttr)) {
                imptAttrMap.put(field, imptAttr);
            }
            return field;
        }).collect(Collectors.toSet());
        HashSet<String> overLimitFields = new HashSet<String>(4);
        for (Map.Entry<String, IDataEntityProperty> dataEntityProperty : allFields.entrySet()) {
            boolean tplContains;
            boolean localFiledContains;
            String field = dataEntityProperty.getKey();
            IDataEntityProperty prop = dataEntityProperty.getValue();
            if (prop instanceof IBasedataField) {
                String imptAttr = (String)imptAttrMap.get(field);
                if (StringUtils.isNotBlank((CharSequence)imptAttr)) {
                    BasedataEntityType refPropType = (BasedataEntityType)((IBasedataField)prop).getComplexType();
                    String targetField = BaseInfoFormatConstant.tran((String)field, (String)imptAttr, (BasedataEntityType)refPropType, (boolean)(prop instanceof IQueryProp));
                    tranMap.put(field, targetField);
                    localFiledContains = localFiledSet.contains(targetField);
                } else {
                    localFiledContains = localFiledSet.contains(field);
                }
            } else if (prop instanceof MuliLangTextProp) {
                String targetField = field + "." + currLang;
                tranMap.put(field, targetField);
                localFiledContains = localFiledSet.contains(targetField);
            } else {
                localFiledContains = localFiledSet.contains(field);
            }
            if ((tplContains = tplEntityFieldSet.contains(field)) || !localFiledContains) continue;
            overLimitFields.add(field);
        }
        if (overLimitFields.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)messEntityNameKey)) {
                errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201dSheet\u9875\u7684\u201c%2$s\u201d\u7684\u201c%3$s\u201d\u5b57\u6bb5\u5728\u7cfb\u7edf\u4e2d\u672a\u914d\u7f6e\u4e3a\u5bfc\u5165\u5b57\u6bb5\uff0c\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u7ef4\u62a4\u5f85\u672c\u5730\u4e0a\u4f20\u6a21\u677f\u3002", (String)"LocalTplCheckUtil_5", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, messEntityNameKey, Joiner.on((String)"\u3001").join(overLimitFields)));
            } else {
                errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201dSheet\u9875\u7684\u201c%2$s\u201d\u5b57\u6bb5\u5728\u7cfb\u7edf\u4e2d\u672a\u914d\u7f6e\u4e3a\u5bfc\u5165\u5b57\u6bb5\uff0c\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u7ef4\u62a4\u5f85\u672c\u5730\u4e0a\u4f20\u6a21\u677f\u3002", (String)"LocalTplCheckUtil_6", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, Joiner.on((String)"\u3001").join(overLimitFields)));
            }
        }
        return tplEntityFieldSet;
    }

    private static void checkRepeatField(List<String> errMsgs, String entityName, String messEntityNameKey, Collection<String> values, Set<String> localFiledSet) {
        HashSet<String> tplRepeatFields = new HashSet<String>(4);
        for (String value : values) {
            if (localFiledSet.add(value)) continue;
            tplRepeatFields.add(value);
        }
        if (tplRepeatFields.size() > 0) {
            if (StringUtils.isNotBlank((CharSequence)messEntityNameKey)) {
                errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201dSheet\u9875\u7684\u201c%2$s\u201d\u201c%3$s\u201d\u5b57\u6bb5\u91cd\u590d\u3002", (String)"LocalTplCheckUtil_7", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, messEntityNameKey, Joiner.on((String)"\u3001").join(tplRepeatFields)));
            } else {
                errMsgs.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201dSheet\u9875\u7684\u201c%2$s\u201d\u5b57\u6bb5\u91cd\u590d\u3002", (String)"LocalTplCheckUtil_8", (String)"hrmp-hies-import", (Object[])new Object[0]), entityName, Joiner.on((String)"\u3001").join(tplRepeatFields)));
            }
        }
    }

    private static Map<String, List<String>> buildTplInfo(DynamicObjectCollection fieldEntryCollection, Map<String, List<DynamicObject>> groupChildEntityMap, Map<String, List<String>> isMustGroupChildEntityMap, Map<String, List<String>> entityToNonField) {
        String childEntity = "";
        String mainEntity = "";
        for (DynamicObject fieldDyn : fieldEntryCollection) {
            boolean isField = fieldDyn.getBoolean("isfield");
            if (isField) {
                boolean isImport = fieldDyn.getBoolean("isimport");
                if (!isImport) continue;
                List<DynamicObject> groupList = groupChildEntityMap.get(childEntity);
                if (CollectionUtils.isEmpty(groupList)) {
                    groupList = new ArrayList<DynamicObject>();
                    groupChildEntityMap.put(childEntity, groupList);
                }
                groupList.add(fieldDyn);
                boolean isMustInput = fieldDyn.getBoolean("ismustinput");
                if (!isMustInput) continue;
                List<String> isMustGroupList = isMustGroupChildEntityMap.get(childEntity);
                if (CollectionUtils.isEmpty(isMustGroupList)) {
                    isMustGroupList = new ArrayList<String>();
                    isMustGroupChildEntityMap.put(childEntity, isMustGroupList);
                }
                isMustGroupList.add(fieldDyn.getString("fieldnumber"));
                continue;
            }
            long pid = fieldDyn.getLong("pid");
            if (0L == pid) {
                childEntity = mainEntity = fieldDyn.getString("childentity");
                ArrayList<String> entrys = new ArrayList<String>(4);
                entrys.add(childEntity);
                entityToNonField.put(childEntity, entrys);
                continue;
            }
            String entryNumber = fieldDyn.getString("fieldnumber");
            if (!StringUtils.isNotBlank((CharSequence)entryNumber)) continue;
            entityToNonField.get(mainEntity).add(entryNumber);
            childEntity = childEntity.concat(SPLIT_KEY).concat(entryNumber);
        }
        entityToNonField.clear();
        LinkedHashMap collect = groupChildEntityMap.entrySet().stream().filter(item -> CollectionUtils.isNotEmpty((Collection)((Collection)item.getValue()))).collect(Collectors.groupingBy(item -> ((String)item.getKey()).split(SPLIT_KEY)[0], LinkedHashMap::new, Collectors.mapping(item -> {
            String[] split = ((String)item.getKey()).split(SPLIT_KEY);
            return split.length == 2 ? split[1] : split[0];
        }, Collectors.toList())));
        entityToNonField.putAll(collect);
        if (MapUtils.isEmpty(isMustGroupChildEntityMap)) {
            return new HashMap<String, List<String>>(0);
        }
        return isMustGroupChildEntityMap.entrySet().stream().filter(item -> CollectionUtils.isNotEmpty((Collection)((Collection)item.getValue()))).collect(Collectors.groupingBy(item -> ((String)item.getKey()).split(SPLIT_KEY)[0], LinkedHashMap::new, Collectors.mapping(item -> {
            String[] split = ((String)item.getKey()).split(SPLIT_KEY);
            return split.length == 2 ? split[1] : split[0];
        }, Collectors.toList())));
    }

    private static String checkEntityAmount(List<String> entityNumbers, Map<String, String> sheetEntityMap, boolean isMESS) {
        boolean tplMainInfoErr = false;
        if (isMESS) {
            Optional<String> firstItem = sheetEntityMap.values().stream().findFirst();
            if (!firstItem.isPresent()) {
                tplMainInfoErr = true;
                log.warn("\u672a\u5339\u914d\u5230\u4efb\u4f55\u5b9e\u4f53");
            } else {
                String mainEntityNumber = firstItem.get();
                String[] uploadFileEntityNumbers = mainEntityNumber.split(",");
                if (uploadFileEntityNumbers.length != entityNumbers.size()) {
                    tplMainInfoErr = true;
                    log.warn("\u5b9e\u4f53\u6570\u91cf\u4e0d\u5bf9");
                } else if (!entityNumbers.get(0).equals(uploadFileEntityNumbers[0])) {
                    tplMainInfoErr = true;
                    log.warn("\u4e3b\u5b9e\u4f53\u7f16\u7801\u4e0d\u5bf9\uff08\u586b\u5199\u4e0d\u6b63\u786e\u6216\u8005\u4e0d\u662f\u7b2c\u4e00\u4e2a\u6570\u636e\u9875\uff09");
                }
            }
        } else if (sheetEntityMap.size() != entityNumbers.size()) {
            tplMainInfoErr = true;
            log.warn("\u5b9e\u4f53\u6570\u91cf\u4e0d\u5bf9");
        } else {
            Optional<String> firstItem = sheetEntityMap.values().stream().findFirst();
            String mainEntityNumber = firstItem.get();
            if (!entityNumbers.get(0).equals(mainEntityNumber)) {
                tplMainInfoErr = true;
                log.warn("\u4e3b\u5b9e\u4f53\u7f16\u7801\u4e0d\u5bf9\uff08\u586b\u5199\u4e0d\u6b63\u786e\u6216\u8005\u4e0d\u662f\u7b2c\u4e00\u4e2a\u6570\u636e\u9875\uff09");
            }
        }
        if (tplMainInfoErr) {
            return ResManager.loadKDString((String)"\u60a8\u4e0a\u4f20\u6587\u4ef6\u4e2d\u7684\u5b57\u6bb5\u5217\u4e0e\u5f53\u524d\u7cfb\u7edf\u9875\u9762\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"LocalTplCheckUtil_9", (String)"hrmp-hies-import", (Object[])new Object[0]);
        }
        return "";
    }

    private static String buildLocalFileInfo(LocalTplReadSheetHandler sheetHandler, MultiValueMap<String, Object> localEntityFieldMapping, Map<String, List<String>> entityToNonField, Map<String, List<String>> entityToMustFillNonField, boolean isMESS) {
        MultiValueMap<String, Map<Integer, String>> templateValidater = sheetHandler.getTemplateValidater();
        for (Map.Entry listEntry : templateValidater.entrySet()) {
            HashMap<Integer, String> entityIndexMap = new HashMap<Integer, String>(8);
            List value = (List)listEntry.getValue();
            TreeMap<Integer, String> localEntityIndexs = (TreeMap<Integer, String>)value.get(0);
            String errMsg = LocalTplCheckUtil.checkEntity(localEntityFieldMapping, entityToNonField, entityToMustFillNonField, localEntityIndexs = new TreeMap<Integer, String>((Map<Integer, String>)localEntityIndexs), entityIndexMap, isMESS);
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                return errMsg;
            }
            TreeMap localFields = (TreeMap)value.get(1);
            localFields = new TreeMap(localFields);
            String curEntityNumber = "";
            for (Map.Entry localFieldEntry : localFields.entrySet()) {
                Integer localFieldEntryKey = (Integer)localFieldEntry.getKey();
                String field = (String)localFieldEntry.getValue();
                String localEntityFieldMappingKey = (String)entityIndexMap.get(localFieldEntryKey);
                if (StringUtils.isNotBlank((CharSequence)localEntityFieldMappingKey)) {
                    ArrayList<String> fields = new ArrayList<String>(8);
                    fields.add(field);
                    curEntityNumber = localEntityFieldMappingKey;
                    localEntityFieldMapping.add((Object)curEntityNumber, fields);
                    continue;
                }
                ((Collection)((List)localEntityFieldMapping.get((Object)curEntityNumber)).get(1)).add(field);
            }
        }
        return "";
    }

    private static String checkEntity(MultiValueMap<String, Object> localEntityFieldMapping, Map<String, List<String>> entityToNonField, Map<String, List<String>> entityToMustFillNonField, Map<Integer, String> localEntityIndexs, Map<Integer, String> entityIndexMap, boolean isMESS) {
        ArrayList<String> entityToNonFields = new ArrayList<String>(8);
        ArrayList<String> entityToMustFillNonFields = new ArrayList<String>(8);
        ArrayList<String> localEntitys = new ArrayList<String>(8);
        if (isMESS) {
            List<String> value;
            for (Map.Entry<String, List<String>> entry : entityToNonField.entrySet()) {
                String string = entry.getKey();
                entityToNonFields.add(string);
                value = entry.getValue();
                value.stream().filter(item -> !key.equals(item)).forEach(item -> entityToNonFields.add(key.concat(SPLIT_KEY).concat((String)item)));
            }
            for (Map.Entry<String, List<String>> entry : entityToMustFillNonField.entrySet()) {
                String string = entry.getKey();
                entityToMustFillNonFields.add(string);
                value = entry.getValue();
                value.stream().filter(item -> !key.equals(item)).forEach(item -> entityToMustFillNonFields.add(key.concat(SPLIT_KEY).concat((String)item)));
            }
        } else {
            String curEntityNumber = HIESUtil.getSplitValue((String)localEntityIndexs.get(0));
            for (String string : entityToNonField.get(curEntityNumber)) {
                if (string.equals(curEntityNumber)) {
                    entityToNonFields.add(curEntityNumber);
                    continue;
                }
                entityToNonFields.add(curEntityNumber.concat(SPLIT_KEY).concat(string));
            }
            List<String> mustFields = entityToMustFillNonField.get(curEntityNumber);
            if (CollectionUtils.isNotEmpty(mustFields)) {
                for (String entry : mustFields) {
                    if (entry.equals(curEntityNumber)) {
                        entityToMustFillNonFields.add(curEntityNumber);
                        continue;
                    }
                    entityToMustFillNonFields.add(curEntityNumber.concat(SPLIT_KEY).concat(entry));
                }
            }
        }
        String preEntityNumber = "";
        for (Map.Entry<Integer, String> entry : localEntityIndexs.entrySet()) {
            String curEntityNumber = HIESUtil.getSplitValue((String)entry.getValue());
            List<String> subEntitys = entityToNonField.get(curEntityNumber);
            if (CollectionUtils.isNotEmpty(subEntitys)) {
                preEntityNumber = curEntityNumber;
                localEntityFieldMapping.add((Object)curEntityNumber, (Object)entry.getValue());
                entityIndexMap.put(entry.getKey(), curEntityNumber);
                localEntitys.add(curEntityNumber);
                continue;
            }
            String entityKey = preEntityNumber.concat(SPLIT_KEY).concat(curEntityNumber);
            localEntityFieldMapping.add((Object)entityKey, (Object)entry.getValue());
            entityIndexMap.put(entry.getKey(), entityKey);
            localEntitys.add(entityKey);
        }
        return LocalTplCheckUtil.checkEntity(localEntitys, entityToMustFillNonFields, entityToNonFields);
    }

    private static String checkEntity(List<String> localEntitys, List<String> entityToMustFillNonFields, List<String> entityToNonFields) {
        boolean isOverEntityNum;
        boolean isLessMustEntityNum = localEntitys.size() < entityToMustFillNonFields.size();
        boolean bl = isOverEntityNum = localEntitys.size() > entityToNonFields.size();
        if (isLessMustEntityNum || isOverEntityNum) {
            log.warn("\u5339\u914d\u5fc5\u987b\u5b9e\u4f53\u6570\u5c0f\u4e8e\u5fc5\u9009\u5b9e\u4f53\u6570\u6216\u8005\u5339\u914d\u5b9e\u4f53\u6570\u5927\u4e8e\u6a21\u677f\u603b\u5b9e\u4f53\u6570\uff0c\u6a21\u677f\u88ab\u7be1\u6539 entityToMustFillNonFields:{} entityToNonFields:{} localEntitys:{}", new Object[]{entityToMustFillNonFields, entityToNonFields, localEntitys});
            return ResManager.loadKDString((String)"\u60a8\u4e0a\u4f20\u6587\u4ef6\u4e2d\u7684\u5b57\u6bb5\u5217\u4e0e\u5f53\u524d\u7cfb\u7edf\u9875\u9762\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"LocalTplCheckUtil_9", (String)"hrmp-hies-import", (Object[])new Object[0]);
        }
        HashSet<String> result = new HashSet<String>(localEntitys);
        if (result.size() != localEntitys.size()) {
            log.warn("\u5b58\u5728\u91cd\u590d\u7684\u5b9e\u4f53\uff0c\u6a21\u677f\u88ab\u7be1\u6539 localEntitys:{} distinct result:{}", localEntitys, result);
            return ResManager.loadKDString((String)"\u60a8\u4e0a\u4f20\u6587\u4ef6\u4e2d\u7684\u5b57\u6bb5\u5217\u4e0e\u5f53\u524d\u7cfb\u7edf\u9875\u9762\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"LocalTplCheckUtil_9", (String)"hrmp-hies-import", (Object[])new Object[0]);
        }
        result = new HashSet<String>(entityToMustFillNonFields);
        result.removeAll(localEntitys);
        if (result.size() > 0) {
            log.warn("\u5339\u914d\u5fc5\u987b\u5b9e\u4f53\u6570\u5c0f\u4e8e\u5fc5\u9009\u5b9e\u4f53\u6570\uff0c\u6a21\u677f\u88ab\u7be1\u6539 entityToMustFillNonFields:{} localEntitys:{}  nonMatchEntitys:{}", new Object[]{entityToMustFillNonFields, localEntitys, result});
            return ResManager.loadKDString((String)"\u60a8\u4e0a\u4f20\u6587\u4ef6\u4e2d\u7684\u5b57\u6bb5\u5217\u4e0e\u5f53\u524d\u7cfb\u7edf\u9875\u9762\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"LocalTplCheckUtil_9", (String)"hrmp-hies-import", (Object[])new Object[0]);
        }
        result = new HashSet<String>(localEntitys);
        result.removeAll(entityToNonFields);
        if (result.size() > 0) {
            log.warn("\u672c\u5730\u6a21\u677f\u5b9e\u4f53\u8ddf\u6a21\u677f\u8981\u6c42\u7684\u4e0d\u4e00\u81f4\uff0c\u6a21\u677f\u88ab\u7be1\u6539 entityToNonFields:{} localEntitys:{}  nonMatchEntitys:{}", new Object[]{entityToNonFields, localEntitys, result});
            return ResManager.loadKDString((String)"\u60a8\u4e0a\u4f20\u6587\u4ef6\u4e2d\u7684\u5b57\u6bb5\u5217\u4e0e\u5f53\u524d\u7cfb\u7edf\u9875\u9762\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"LocalTplCheckUtil_9", (String)"hrmp-hies-import", (Object[])new Object[0]);
        }
        return "";
    }

    private static String getMapKey(Map<String, String> map, String value) {
        String key = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            key = entry.getKey();
        }
        return key;
    }
}

