/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.end;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.impt.core.parse.SheetHandler;
import kd.hr.impt.formplugin.DiaeDataDownPlugin;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@ExcludeFromJacocoGeneratedReport
public class LocalTplReadSheetHandler
extends SheetHandler {
    private static final Log LOGGER = LogFactory.getLog(DiaeDataDownPlugin.class);
    private final String tplNumber;
    private final List<String> entityNumbers;
    private final boolean isMESS;
    private final MultiValueMap<String, Map<Integer, String>> templateValidater = new LinkedMultiValueMap();
    private final Map<String, String> sheetEntityMap = new LinkedHashMap<String, String>(3);
    private boolean isMainEntitySheet;
    private boolean isEntitySheet = true;
    private String curSheetName = "";
    private final List<String> errMsgs = new ArrayList<String>(8);
    private int onlyParserCount = 4;

    public LocalTplReadSheetHandler(String tplNumber, List<String> entityNumbers, boolean isMESS) {
        this.tplNumber = tplNumber;
        this.entityNumbers = entityNumbers;
        this.isMESS = isMESS;
    }

    @Override
    protected boolean isSkipEmptyRow() {
        return false;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        int curRowNum = this.getRowHolder().getRowNum();
        if (curRowNum >= this.onlyParserCount) {
            throw new KDBizException(new ErrorCode("908", "sheet_parse_terminal."), new Object[0]);
        }
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void handleRow(SheetHandler.ParsedRow row) {
        String currentSheetName = this.getCurrentSheetName();
        int currRowNum = row.getRowNum();
        if (currRowNum > 4) {
            return;
        }
        if (!currentSheetName.equals(this.curSheetName)) {
            this.isEntitySheet = true;
            this.curSheetName = currentSheetName;
        }
        if (!this.isEntitySheet) {
            return;
        }
        if (currRowNum == 0) {
            String numberRow = row.get(0);
            String number = HIESUtil.getSplitValue((String)numberRow);
            if (this.tplNumber.equals(number)) {
                this.isEntitySheet = true;
                this.isMainEntitySheet = true;
                this.onlyParserCount = 5;
            } else if (this.entityNumbers.contains(number)) {
                this.isEntitySheet = true;
                this.isMainEntitySheet = false;
                this.onlyParserCount = 4;
                String entityNumbers = this.sheetEntityMap.get(currentSheetName);
                if (StringUtils.isBlank((CharSequence)entityNumbers)) {
                    this.sheetEntityMap.put(currentSheetName, number);
                    this.templateValidater.add((Object)currentSheetName, row.getData());
                } else {
                    this.sheetEntityMap.put(currentSheetName, entityNumbers + ',' + number);
                }
            } else {
                this.isEntitySheet = false;
            }
        } else if (currRowNum < this.onlyParserCount && currRowNum > 0) {
            if (this.isMainEntitySheet && currRowNum == 1) {
                String numberRow = row.get(0);
                String entityNumber = HIESUtil.getSplitValue((String)numberRow);
                if (!this.entityNumbers.get(0).equals(entityNumber)) {
                    LOGGER.warn("\u7cfb\u7edf\u68c0\u6d4b\u5230{}\u9875\u7b2c{}\u884c\u7684\u5b9e\u4f53\u7f16\u7801{}\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u6587\u4ef6\u3002", new Object[]{currentSheetName, 2, entityNumber});
                    this.isEntitySheet = false;
                    return;
                }
                Map<Integer, String> data = row.getData();
                if (this.isMESS) {
                    data.forEach((key, numberRow2) -> {
                        String entityNumber2 = HIESUtil.getSplitValue((String)numberRow2);
                        if (!this.entityNumbers.contains(entityNumber2)) {
                            return;
                        }
                        String entityNumbers = this.sheetEntityMap.get(currentSheetName);
                        if (StringUtils.isBlank((CharSequence)entityNumbers)) {
                            this.sheetEntityMap.put(currentSheetName, entityNumber2);
                        } else {
                            this.sheetEntityMap.put(currentSheetName, entityNumbers + ',' + entityNumber2);
                        }
                    });
                } else {
                    this.sheetEntityMap.put(currentSheetName, entityNumber);
                }
                this.templateValidater.add((Object)currentSheetName, data);
            }
            if (currRowNum == this.onlyParserCount - 1) {
                this.templateValidater.add((Object)currentSheetName, row.getData());
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.getRowHolder().getRowNum() < this.onlyParserCount) {
            super.endElement(uri, localName, name);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    public MultiValueMap<String, Map<Integer, String>> getTemplateValidater() {
        return this.templateValidater;
    }

    public List<String> getErrMsgs() {
        return this.errMsgs;
    }

    public Map<String, String> getSheetEntityMap() {
        return this.sheetEntityMap;
    }
}

