/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.end;

import java.io.File;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.util.ImportFileUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.end.ExcelImportFailedSheetHandler;
import kd.hr.impt.core.end.MergeCellReadSheetHandler;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.parse.ExcelReader;

public class Reporter
extends ImportWorker {
    private static final Log LOGGER = LogFactory.getLog(Reporter.class);

    public Reporter(ImportStart importStart) {
        super("Reporter", importStart, null, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        ImportContext importContext = this.importStart.getImportContext();
        MethodUtil.syncRequestTraceId((Object)importContext.getRc());
        LOGGER.info("Reporter_started.");
        try {
            File file = new File(importContext.getFileLocalPath());
            if (!file.exists()) {
                String localPatch = ImportFileUtil.downloadFile((String)importContext.getFilePath());
                importContext.setFileLocalPath(localPatch);
                file = new File(localPatch);
            }
            MergeCellReadSheetHandler mergeCellReadSheetHandler = new MergeCellReadSheetHandler();
            new ExcelReader(this.importStart).readByWayType(file, mergeCellReadSheetHandler, "mergeCell");
            ExcelImportFailedSheetHandler excelImportFailedSheetHandler = new ExcelImportFailedSheetHandler(this, mergeCellReadSheetHandler.getStylesTable());
            excelImportFailedSheetHandler.getMergeCellList().putAll(mergeCellReadSheetHandler.getMergeCellList());
            excelImportFailedSheetHandler.setActiveTab(mergeCellReadSheetHandler.getActiveTab());
            Map<String, Integer> sheetRowCountMap = importContext.getSheetRowCountMap();
            int totalCount = sheetRowCountMap.values().stream().mapToInt(count -> count).sum();
            if (totalCount > 50000) {
                excelImportFailedSheetHandler.setIgnoreStyle(true);
            }
            LOGGER.info("Reporter_begin_write.");
            new ExcelReader(this.importStart).readByWayType(file, excelImportFailedSheetHandler, "fail");
            LOGGER.info("Reporter_end_cost_time:{}", (Object)(System.currentTimeMillis() - start));
        }
        catch (Throwable exception) {
            LOGGER.error("Reporter-call() error:", exception);
            this.importStart.writeErrorLog(exception);
        }
        finally {
            this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
            this.updateFileUrl(this.importStart);
            ImportFileUtil.deleteLocalTempFile((String)this.importStart.getImportContext().getFileLocalPath());
        }
        return null;
    }

    private void updateFileUrl(ImportStart importStart) {
        try {
            TaskInfo info = new TaskInfo();
            ImportContext importContext = importStart.getImportContext();
            info.setId(importContext.getTaskPkId());
            info.setAlldatafileurl(importStart.getImportContext().getErrorFileForAllData());
            info.setErrdatafileurl(importStart.getImportContext().getErrorFileForErrorData());
            info.setSystemerrlog(SerializationUtils.toJsonString(importContext.getImportLog().getErrorLogs()));
            TaskInfoHelper.doUpdate((TaskInfo)info);
        }
        catch (Throwable e) {
            LOGGER.error("saveTaskInfo_exception.", e);
            importStart.writeErrorLog(e);
        }
    }
}

