/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.init;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.Result;
import kd.hr.impt.core.init.BigExcelImportTask;

@ExcludeFromJacocoGeneratedReport
public class ImportTaskDispatcher {
    private static final Log log = LogFactory.getLog(ImportTaskDispatcher.class);
    private static volatile ImportTaskDispatcher instance;
    protected AtomicInteger childThreadMonitor;
    protected Semaphore childThreadSemaphore;
    private static ThreadPool pool;

    private ImportTaskDispatcher() {
        pool = ThreadPools.newCachedThreadPool((String)(ImportTaskDispatcher.class.getSimpleName() + RequestContext.get().getTraceId()), (int)0, (int)MCConfigConstant.getTaskDispatcherMaxThread());
        this.childThreadMonitor = new AtomicInteger(0);
        this.childThreadSemaphore = new Semaphore(MCConfigConstant.getTaskDispatcherMaxThread());
        log.info("MCConfigConstant:" + JSONObject.toJSONString((Object)MCConfigConstant.getAllConfigInfo()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImportTaskDispatcher getInstance() {
        if (instance != null) return instance;
        Class<ImportTaskDispatcher> clazz = ImportTaskDispatcher.class;
        synchronized (ImportTaskDispatcher.class) {
            if (instance != null) return instance;
            instance = new ImportTaskDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Semaphore getChildThreadSemaphore() {
        return this.childThreadSemaphore;
    }

    public Result receivedNewTask(Map<String, Object> params) {
        Result result = new Result();
        long taskPKId = TaskService.saveTaskParams(params);
        result.setSuccess(true);
        result.setData((Object)taskPKId);
        params.put("taskPkId", taskPKId);
        params.put("isRecoveryTask", false);
        BigExcelImportTask task = new BigExcelImportTask(params, this, this.childThreadMonitor);
        boolean ret = MCConfigConstant.debugOffLineTask() ? false : this.submitWithTimeOut(task);
        if (!ret) {
            TaskService.updateTaskScheduleStatus((Long)taskPKId, (String)"waiting");
            result.setSuccess(false);
            result.setCode("900");
            result.setMsg(ResManager.loadKDString((String)"\u5bfc\u5165\u4efb\u52a1\u540e\u53f0\u6b63\u5728\u8fd0\u884c\uff0c\u5b8c\u6210\u540e\uff0c\u53ef\u5728\u76d1\u63a7\u4e2d\u5fc3\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"ImportTaskDispatcher_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
        }
        return result;
    }

    public Result recoveryTask(Long taskPkid) {
        DynamicObject dynamicObject = TaskService.getSomeAttrsById((Long)taskPkid);
        String reqparam = dynamicObject.getString("reqparam");
        Map params = (Map)JSONObject.parseObject((String)reqparam, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        params.put("taskPkId", taskPkid);
        params.put("isRecoveryTask", true);
        BigExcelImportTask task = new BigExcelImportTask(params, this, this.childThreadMonitor);
        boolean ret = this.submitWithTimeOut(task);
        Result result = new Result();
        result.setSuccess(true);
        result.setData((Object)taskPkid);
        if (!ret) {
            result.setSuccess(false);
            result.setCode("900");
            result.setMsg(ResManager.loadKDString((String)"\u5bfc\u5165\u4efb\u52a1\u540e\u53f0\u6b63\u5728\u8fd0\u884c\uff0c\u5b8c\u6210\u540e\uff0c\u53ef\u5728\u76d1\u63a7\u4e2d\u5fc3\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"ImportTaskDispatcher_0", (String)"hrmp-hies-import", (Object[])new Object[0]));
        } else {
            TaskService.updateTaskScheduleStatus((Long)taskPkid, (String)"started");
        }
        return null;
    }

    protected boolean submitWithTimeOut(Callable<Object> task) {
        try {
            if (this.childThreadSemaphore.tryAcquire(5L, TimeUnit.SECONDS)) {
                pool.submit(task);
                return true;
            }
            throw new KDException(new ErrorCode("900", "waiteHasFreePoolThread_timeout."), new Object[0]);
        }
        catch (Throwable e) {
            log.error(e);
            return false;
        }
    }
}

