/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.monitor;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.hr.hies.business.TaskInfoHelper;
import kd.hr.hies.business.TaskService;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.dto.TaskInfo;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ExistsValidatorPerformance;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportPerformance;
import kd.hr.impt.common.dto.ImportSampling;
import kd.hr.impt.common.dto.ImportTrace;
import kd.hr.impt.core.ImportQueue;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.end.Reporter;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.InstoreDataFlowSuggester;
import kd.hr.impt.core.save.InstoreDispatcher;
import kd.hr.impt.core.tempstore.TempStoreDispatcher;
import kd.hr.impt.core.validate.DataValidateManager;
import kd.hr.impt.core.validate.ValidateDataFlowSuggester;
import kd.hr.impt.core.validate.dto.BaseDataContainer;

public class Monitor
extends ImportWorker {
    private static Log log = LogFactory.getLog(Reporter.class);
    private long lastRunTimeStap = System.currentTimeMillis();
    private ReentrantLock expenseLock = new ReentrantLock();
    private ReentrantLock queueLock = new ReentrantLock();
    private ReentrantLock cacheLock = new ReentrantLock();
    private ReentrantLock otherLock = new ReentrantLock();
    private ReentrantLock memsLock = new ReentrantLock();
    private ReentrantLock existValiLock = new ReentrantLock();
    private ImportPerformance importPerformance = new ImportPerformance();
    private ImportSampling importSampling = new ImportSampling();
    private ImportTrace importTrace = new ImportTrace();
    private ExistsValidatorPerformance existsValidatorPerformance = new ExistsValidatorPerformance();

    public ImportPerformance getImportPerformance() {
        return this.importPerformance;
    }

    public ImportSampling getImportSampling() {
        return this.importSampling;
    }

    public ImportTrace getImportTrace() {
        return this.importTrace;
    }

    public ExistsValidatorPerformance getExistsValidatorPerformance() {
        return this.existsValidatorPerformance;
    }

    public Monitor(ImportStart importStart) {
        super(Monitor.class.getSimpleName(), importStart);
    }

    @Override
    public Object call() throws Exception {
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        log.info(this.name + "_started.");
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                BaseDataContainer baseDataContainer;
                ImportWorker importWorker3;
                ImportWorker importWorker2;
                TimeUnit.MILLISECONDS.sleep(2000L);
                ImportQueue<ImportBillData> paserQueue = this.importStart.getPaserQueue();
                this.addSamplingData(paserQueue.getName(), paserQueue.getQueue().size());
                ImportQueue<ImportBillData> tempStoreQueue = this.importStart.getTempStoreQueue();
                if (this.importStart.getImportContext().isSerialModel()) {
                    this.addSamplingData(tempStoreQueue.getName(), tempStoreQueue.getQueue().size());
                }
                ImportQueue<ImportBillData> bdValidateresultQueue = this.importStart.getWaitInStoreQueue();
                this.addSamplingData(bdValidateresultQueue.getName(), bdValidateresultQueue.getQueue().size());
                InstoreDispatcher importWorker = this.importStart.getInstoreDispatcher();
                if (importWorker != null) {
                    InstoreDispatcher instoreDispatcher = importWorker;
                    InstoreDataFlowSuggester suggester = instoreDispatcher.getSuggester();
                    this.addSamplingData("instoreSuggestBatchSize", suggester.getSuggestBatchSize());
                    this.addSamplingData("instoreSuggestThreads", suggester.getSuggestThreads());
                    this.addSamplingData(instoreDispatcher.getName() + "_workingThreadCount", instoreDispatcher.getChildThreadMonitor().get());
                }
                if ((importWorker2 = this.importStart.getWorkers().get(TempStoreDispatcher.class.getSimpleName())) != null) {
                    TempStoreDispatcher tempStoreDispatcher = (TempStoreDispatcher)importWorker2;
                    this.addSamplingData(tempStoreDispatcher.getName() + "_workingThreadCount", tempStoreDispatcher.getChildThreadMonitor().get());
                }
                if ((importWorker3 = this.importStart.getWorkers().get(DataValidateManager.class.getSimpleName())) != null) {
                    DataValidateManager dataValidateManager = (DataValidateManager)importWorker3;
                    ValidateDataFlowSuggester suggester = dataValidateManager.getSuggester();
                    this.addSamplingData("validatorSuggestThreads", suggester.getSuggestThreads());
                    this.addSamplingData(dataValidateManager.getName() + "_workingThreadCount", dataValidateManager.getChildThreadMonitor().get());
                }
                if ((baseDataContainer = this.importStart.getImportContext().getBaseDataContainer()) != null && System.currentTimeMillis() - this.lastRunTimeStap > 30000L) {
                    this.collectBillCount(this.importStart.getImportContext());
                    this.collectBdCacheCount(this.importStart.getImportContext());
                    this.computeAverageExpense();
                }
                Map samplingCpuMem = MethodUtil.samplingCpuMem();
                this.addSamplingData("memory", samplingCpuMem.get("memory"));
                this.addSamplingData("cpu", samplingCpuMem.get("cpu"));
                if (baseDataContainer != null) {
                    this.addSamplingData("existsEntityDyMapCount", this.importStart.getImportContext().getBaseDataContainer().getExistsEntityDyMap().size());
                }
                if (!"true".equals(MCConfigConstant.isPrintMonitorLog()) || System.currentTimeMillis() - this.lastRunTimeStap <= 60000L) continue;
                TaskService.updateTaskPerformance((Long)this.importStart.getImportContext().getTaskPkId(), (String)this.getPerformancelog());
                this.lastRunTimeStap = System.currentTimeMillis();
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
            }
        }
        log.info(this.name + "_timeOut_started.");
        Date start = new Date();
        while (!this.isEnd) {
            LinkedList alives = new LinkedList();
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
                Map<String, ImportWorker> workers = this.importStart.getWorkers();
                workers.values().forEach(worker -> {
                    if (!worker.isEnd() && !this.name.equalsIgnoreCase(worker.getName())) {
                        alives.add(worker);
                    }
                });
                if (System.currentTimeMillis() - start.getTime() <= 600000L) continue;
                alives.forEach(worker -> {
                    worker.setEnd(true);
                    try {
                        MethodUtil.shutdownNowThreadPool((ThreadPool)worker.getPool());
                    }
                    catch (Throwable e) {
                        log.error(e);
                    }
                });
                List names = alives.stream().map(de -> de.getName()).collect(Collectors.toList());
                this.importTrace.getOther().put("timeOutWorkers", names);
                this.updatePerformancelog();
                this.isEnd = true;
            }
            catch (Throwable e) {
                log.error(e);
            }
        }
        this.end();
        return null;
    }

    public String getPerformancelog() {
        LinkedHashMap<String, Object> jsonMap = new LinkedHashMap<String, Object>();
        jsonMap.put("trace", this.importStart.getMonitor().getImportTrace());
        jsonMap.put("performance", this.importStart.getMonitor().getImportPerformance());
        jsonMap.put("exiValiPerf", this.importStart.getMonitor().getExistsValidatorPerformance());
        jsonMap.put("sampling", this.importStart.getMonitor().getImportSampling());
        return JSONObject.toJSONString(jsonMap);
    }

    public void addExpenseStatistics(Class obj, Long value, boolean isSingle) {
        String simpleName = obj.getSimpleName();
        this.addExpenseStatistics(simpleName, value, isSingle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExpenseStatistics(String key, Long value, boolean isSingle) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.expenseLock.lock();
            ConcurrentHashMap<String, Integer> totalExpense = this.importPerformance.getTotalExpense();
            Integer oldValue = (Integer)totalExpense.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalExpense.put(key, Math.toIntExact(value));
            } else {
                totalExpense.put(key, Math.toIntExact((long)oldValue.intValue() + value));
            }
            if (isSingle) {
                return;
            }
            this.addMaxExpense(key, value);
            this.addTotalExcuteCount(key);
        }
        finally {
            this.expenseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueStatistics(String key, Integer value, Integer total) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.queueLock.lock();
            ConcurrentHashMap<String, Integer> totalQueueCount = this.importPerformance.getTotalQueueCount();
            Integer oldValue = (Integer)totalQueueCount.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalQueueCount.put(key, value);
            } else {
                totalQueueCount.put(key, oldValue + value);
            }
            if (total != null) {
                this.addMaxQueueCount(key, total);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTotalCachedCount(String key, Integer value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.cacheLock.lock();
            ConcurrentHashMap<String, Integer> totalCachedCount = this.importPerformance.getTotalCachedCount();
            Integer oldValue = (Integer)totalCachedCount.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalCachedCount.put(key, value);
            } else {
                totalCachedCount.put(key, oldValue + value);
            }
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherTotalCount(String key, Integer value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.otherLock.lock();
            ConcurrentHashMap<String, Object> other = this.importTrace.getOther();
            Integer oldValue = (Integer)other.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                other.put(key, value);
            } else {
                other.put(key, oldValue + value);
            }
        }
        finally {
            this.otherLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMEMSTotalCount(String key, Integer value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.memsLock.lock();
            ConcurrentHashMap<String, Object> other = this.importTrace.getMems();
            Integer oldValue = (Integer)other.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                other.put(key, value);
            } else {
                other.put(key, oldValue + value);
            }
        }
        finally {
            this.memsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOtherListData(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.otherLock.lock();
            ConcurrentHashMap<String, Object> other = this.importTrace.getOther();
            List logs = (List)other.computeIfAbsent(key, val -> new LinkedList());
            logs.add(value);
        }
        finally {
            this.otherLock.unlock();
        }
    }

    public void addSamplingData(String key, Object value) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        Map<String, List<Object>> sampling = this.importSampling.getSampling();
        List logs = sampling.computeIfAbsent(key, val -> new LinkedList());
        logs.add(value);
    }

    public synchronized void computeAverageExpense() {
        for (Map.Entry<String, Integer> next : this.importPerformance.getTotalExpense().entrySet()) {
            Integer count = this.importPerformance.getTotalExcuteCount().get(next.getKey());
            if (ObjectUtils.isEmpty((Object)count)) continue;
            int avg = next.getValue() / count;
            this.importPerformance.getAverageExpense().put(next.getKey(), avg);
        }
        for (Map.Entry<String, Integer> next : this.existsValidatorPerformance.getTotalExpense().entrySet()) {
            Integer count = this.existsValidatorPerformance.getTotalExcuteCount().get(next.getKey());
            if (ObjectUtils.isEmpty((Object)count)) continue;
            int avg = next.getValue() / count;
            this.existsValidatorPerformance.getAverageExpense().put(next.getKey(), avg);
        }
    }

    private void addMaxExpense(String key, Long value) {
        ConcurrentHashMap<String, Integer> maxExpense = this.importPerformance.getMaxExpense();
        Integer oldValue = (Integer)maxExpense.get(key);
        if (ObjectUtils.isEmpty((Object)oldValue) || value.equals(-1L)) {
            maxExpense.put(key, Math.toIntExact(value));
        } else if (value > (long)oldValue.intValue()) {
            maxExpense.put(key, Math.toIntExact(value));
        }
    }

    private void addTotalExcuteCount(String key) {
        ConcurrentHashMap<String, Integer> totalExcuteCount = this.importPerformance.getTotalExcuteCount();
        Integer count = (Integer)totalExcuteCount.get(key);
        if (ObjectUtils.isEmpty((Object)count)) {
            totalExcuteCount.put(key, 1);
        } else {
            count = count + 1;
            totalExcuteCount.put(key, count);
        }
    }

    private void addMaxQueueCount(String key, Integer value) {
        ConcurrentHashMap<String, Integer> maxQueueCount = this.importPerformance.getMaxQueueCount();
        Integer oldValue = (Integer)maxQueueCount.get(key);
        if (ObjectUtils.isEmpty((Object)oldValue) || value.equals(-1)) {
            maxQueueCount.put(key, value);
        } else if (!oldValue.equals(-1) && value > oldValue) {
            maxQueueCount.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExistsValidatorStat(String key, Long value, boolean isSingle) {
        if (StringUtils.isEmpty((CharSequence)key) || value == null) {
            return;
        }
        try {
            this.existValiLock.lock();
            ConcurrentHashMap<String, Integer> totalExpense = this.existsValidatorPerformance.getTotalExpense();
            Integer oldValue = (Integer)totalExpense.get(key);
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                totalExpense.put(key, Math.toIntExact(value));
            } else {
                totalExpense.put(key, Math.toIntExact((long)oldValue.intValue() + value));
            }
            if (isSingle) {
                return;
            }
            this.addExistsValidatorMaxExpense(key, value);
            this.addExistsValidatorTotalExcuteCount(key);
        }
        finally {
            this.existValiLock.unlock();
        }
    }

    public void collectBillCount(ImportContext importContext) {
        HashMap<String, Integer> billCount = this.getImportTrace().getBillCount();
        int successedBillCount = this.importStart.getImportContext().getSuccessedBillCount().get();
        int finishedBillCount = this.importStart.getImportContext().getFinishedBillCount().get();
        int totalBillCount = this.importStart.getImportContext().getTotalBillCount();
        int totalRowCount = this.importStart.getImportContext().getTotalRowCount();
        int finishedValidateBillCount = importContext.getFinishedValidateBillCount().get();
        int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
        billCount.put("totalRowCount", totalRowCount);
        billCount.put("totalBillCount", totalBillCount);
        billCount.put("successedBillCount", successedBillCount);
        billCount.put("finishedBillCount", finishedBillCount);
        billCount.put("finishedValidateBillCount", finishedValidateBillCount);
        billCount.put("successedValidateBillCount", successedValidateBillCount);
    }

    public void collectBdCacheCount(ImportContext importContext) {
        BaseDataContainer baseDataContainer = importContext.getBaseDataContainer();
        if (baseDataContainer == null) {
            return;
        }
        HashMap<String, Integer> bdCacheCount = this.getImportTrace().getBdCacheCount();
        AtomicInteger basedataIdMapCount = new AtomicInteger(0);
        baseDataContainer.getBasedataIdMap().values().forEach(map -> basedataIdMapCount.getAndAdd(map.size()));
        bdCacheCount.put("bdIdMapCount", basedataIdMapCount.get());
        AtomicInteger basedataTableCount = new AtomicInteger(0);
        baseDataContainer.getBasedataTable().values().forEach(map -> basedataTableCount.getAndAdd(map.size()));
        this.addSamplingData("bdTableCount", basedataTableCount);
        bdCacheCount.put("bdByteDyCount", baseDataContainer.getByteDyCount().get());
        bdCacheCount.put("bdByteDyMemory", baseDataContainer.getByteDyLength().get() / 1024 / 1024);
        bdCacheCount.put("outJVMHeapCount", baseDataContainer.getOutJVMHeapCount().get());
        bdCacheCount.put("bdOutJVMHeapUseSize", baseDataContainer.getOutJVMHeapUseSize() / 1024 / 1024);
        bdCacheCount.put("diskCacheCount", baseDataContainer.getDiskCacheCount().get());
        bdCacheCount.put("existsEntityDyMapCount", baseDataContainer.getExistsEntityDyMap().size());
    }

    private void addExistsValidatorMaxExpense(String key, Long value) {
        ConcurrentHashMap<String, Integer> maxExpense = this.existsValidatorPerformance.getMaxExpense();
        Integer oldValue = (Integer)maxExpense.get(key);
        if (ObjectUtils.isEmpty((Object)oldValue) || value.equals(-1L)) {
            maxExpense.put(key, Math.toIntExact(value));
        } else if (value > (long)oldValue.intValue()) {
            maxExpense.put(key, Math.toIntExact(value));
        }
    }

    private void addExistsValidatorTotalExcuteCount(String key) {
        ConcurrentHashMap<String, Integer> totalExcuteCount = this.existsValidatorPerformance.getTotalExcuteCount();
        Integer count = (Integer)totalExcuteCount.get(key);
        if (ObjectUtils.isEmpty((Object)count)) {
            totalExcuteCount.put(key, 1);
        } else {
            count = count + 1;
            totalExcuteCount.put(key, count);
        }
    }

    private void updatePerformancelog() {
        TaskInfo info = new TaskInfo();
        ImportContext importContext = this.importStart.getImportContext();
        info.setId(importContext.getTaskPkId());
        this.importStart.getMonitor().computeAverageExpense();
        info.setPerformancelog(this.getPerformancelog());
        info.setSystemerrlog(SerializationUtils.toJsonString(importContext.getImportLog().getErrorLogs()));
        TaskInfoHelper.doUpdate((TaskInfo)info);
    }
}

