/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.monitor;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hies.common.constant.ImportCacheKeyType;
import kd.hr.hies.common.task.IEGlobalTaskUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.end.Reporter;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.monitor.TimeRemainingAnalyser;
import kd.hr.impt.core.parse.Parser;

public class Progresser
extends ImportWorker {
    private static Log log = LogFactory.getLog(Reporter.class);
    private int lastProgressUpload;

    public Progresser(ImportStart importStart) {
        super(Progresser.class.getSimpleName(), importStart);
    }

    @Override
    public Object call() throws Exception {
        ImportContext importContext = this.importStart.getImportContext();
        MethodUtil.syncRequestTraceId((Object)importContext.getRc());
        log.info("Progresser_started.");
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("hasGetAllAssessTotalBillCount", false);
        while (!this.importStart.isStoped() && !this.isEnd) {
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                int totalBillCount = importContext.getTotalBillCount();
                int totalRowCount = importContext.getTotalRowCount();
                int finishedRowCount = importContext.getFinishedRowCount();
                int finishedValidateBillCount = importContext.getFinishedValidateBillCount().get();
                int successedValidateBillCount = importContext.getSuccessedValidateBillCount().get();
                float finishedBillCount = importContext.getFinishedBillCount().floatValue();
                ImportWorker importWorker = this.importStart.getWorkers().get(Parser.class.getSimpleName());
                if (importWorker != null && !importWorker.isEnd()) {
                    TimeRemainingAnalyser.getAssessTotalBillCount(importContext, params);
                    int assessTotalBillCount = (Integer)params.get("assessTotalBillCount");
                    if (assessTotalBillCount > importContext.getTotalBillCount()) {
                        totalBillCount = assessTotalBillCount;
                        this.importStart.getMonitor().getImportTrace().getOther().put("progUsedAssessCount", true);
                    }
                }
                HashMap customData = Maps.newHashMapWithExpectedSize((int)16);
                customData.put("totalRowCount", String.valueOf(totalRowCount));
                customData.put("finishedRowCount", String.valueOf(finishedRowCount));
                customData.put("totalBillCount", String.valueOf(totalBillCount));
                customData.put("finishedBillCount", String.valueOf((int)finishedBillCount));
                customData.put("finishedValidateBillCount", String.valueOf(finishedValidateBillCount));
                customData.put("successedValidateBillCount", String.valueOf(successedValidateBillCount));
                TimeRemainingAnalyser timeRemainingAnalyser = (TimeRemainingAnalyser)this.importStart.getWorkers().get(TimeRemainingAnalyser.class.getSimpleName());
                customData.put("validateTimeRemaining", timeRemainingAnalyser.getValidateTimeRemaining());
                int progressUpload = this.getAnalysisProgress(finishedBillCount, totalBillCount);
                int timeRemaining = timeRemainingAnalyser.getTimeRemaining();
                if (!importContext.isCanUserTerminate()) {
                    Map virtualProcess = MethodUtil.getVirtualProcess((int)progressUpload, (int)timeRemainingAnalyser.getTimeRemaining(), (float)finishedBillCount, (int)totalBillCount);
                    progressUpload = (Integer)virtualProcess.get("progress");
                    timeRemaining = (Integer)virtualProcess.get("timeRemaining");
                    Integer finishedBillCount2 = (Integer)virtualProcess.get("finishedBillCount");
                    if (finishedBillCount2 != null) {
                        customData.put("finishedBillCount", String.valueOf(finishedBillCount2));
                    }
                }
                customData.put("timeRemaining", timeRemaining);
                customData.put("progress", progressUpload);
                String taskPKId = String.valueOf(this.importStart.getImportContext().getTaskPkId());
                IHRAppCache cache = HRAppCache.get((String)"hies");
                cache.put(MethodUtil.getTaskCachePath((String)taskPKId, (String)ImportCacheKeyType.IMPORT, (String)"processing"), (Object)customData);
                if (progressUpload <= 0 || progressUpload == this.lastProgressUpload) continue;
                this.lastProgressUpload = progressUpload;
                IEGlobalTaskUtil.feedbackProgress((String)taskPKId, (int)progressUpload, (String)ImportCacheKeyType.IMPORT);
            }
            catch (Throwable e) {
                log.error(e);
                this.importStart.writeErrorLog(e);
            }
        }
        this.end();
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private int getAnalysisProgress(float finishedBillCount, int totalBillCount) {
        float progress = 0.0f;
        if (finishedBillCount > 0.0f) {
            progress = finishedBillCount / (float)totalBillCount * 100.0f;
        } else if (totalBillCount <= 1000) {
            progress = 50.0f;
        } else if (totalBillCount <= 2000) {
            progress = 40.0f;
        } else if (totalBillCount <= 3000) {
            progress = 30.0f;
        } else if (totalBillCount <= 4000) {
            progress = 20.0f;
        } else if (totalBillCount <= 5000) {
            progress = 10.0f;
        } else if (totalBillCount <= 6000) {
            progress = 5.0f;
        }
        if (progress < 1.0f) {
            progress = 1.0f;
        }
        return (int)progress;
    }
}

