/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.parse;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.core.ImportWorker;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.parse.EasyExcelReader;

public class Parser
extends ImportWorker {
    private static final Log LOGGER = LogFactory.getLog(Parser.class);
    private Semaphore fileDownloadSemaphore = new Semaphore(1);
    private Map<String, String> entityEntryFields;
    private Map<String, List<ImportBillData>> sheetDataSamplingMap = new HashMap<String, List<ImportBillData>>(6);

    public Parser(ImportStart importStart) {
        super(Parser.class.getSimpleName(), importStart, null, importStart.getPaserQueue(), 0);
    }

    public Semaphore getFileDownloadSemaphore() {
        return this.fileDownloadSemaphore;
    }

    public Map<String, String> getEntityEntryFields() {
        return this.entityEntryFields;
    }

    public Map<String, List<ImportBillData>> getSheetDataSamplingMap() {
        return this.sheetDataSamplingMap;
    }

    public void setSheetDataSamplingMap(Map<String, List<ImportBillData>> sheetDataSamplingMap) {
        this.sheetDataSamplingMap = sheetDataSamplingMap;
    }

    @Override
    public Object call() throws Exception {
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        ImportContext importContext = this.importStart.getImportContext();
        LOGGER.info("Parser_started.");
        try {
            this.initEntityEntryFields();
            this.resolveExcel();
            super.end();
        }
        catch (Throwable exception) {
            LOGGER.error("Parser-call() error:", exception);
            this.importStart.writeErrorLog(exception);
            super.interruptMainThread();
        }
        this.importStart.getMonitor().addExpenseStatistics(this.getName(), (Long)(System.currentTimeMillis() - start), true);
        return null;
    }

    private Map<String, IFormView> initEntityAllFormView(DynamicObject tpl) {
        long start = System.currentTimeMillis();
        String mainEntityId = tpl.getString("entity.id");
        IFormView mainEntityFormView = HIESUtil.createEntityFormView((String)mainEntityId);
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        HashMap formIdEntityFormViewMap = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
        formIdEntityFormViewMap.put(mainEntityId, mainEntityFormView);
        for (DynamicObject child : entityrelation) {
            String formid = child.getString("rentity.id");
            IFormView entityFormView = HIESUtil.createEntityFormView((String)formid);
            formIdEntityFormViewMap.put(formid, entityFormView);
        }
        this.importStart.getMonitor().addExpenseStatistics("initEntityAllFormView", (Long)(System.currentTimeMillis() - start), true);
        return formIdEntityFormViewMap;
    }

    protected void resolveExcel() throws Exception {
        ImportContext importContext = this.importStart.getImportContext();
        this.fileDownloadSemaphore.acquire();
        this.fileDownloadSemaphore.release();
        File file = new File(importContext.getFileLocalPath());
        if (importContext.getFileType().equalsIgnoreCase(".xlsx")) {
            new EasyExcelReader(this).read(file);
        }
    }

    private void initEntityEntryFields() {
        DynamicObject tpl = this.importStart.getImportContext().getTpl();
        String mainid = tpl.getString("entity.id");
        DynamicObjectCollection entityrelation = tpl.getDynamicObjectCollection("entityrelation");
        this.entityEntryFields = Maps.newHashMapWithExpectedSize((int)(entityrelation.size() + 1));
        this.addEntityEntryFields(mainid);
        for (DynamicObject child : entityrelation) {
            String childId = child.getString("rentity.id");
            this.addEntityEntryFields(childId);
        }
    }

    private void addEntityEntryFields(String entityId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        StringBuilder builder = new StringBuilder();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        properties.forEach(pro -> {
            if (pro instanceof EntryProp) {
                builder.append(pro.getName()).append(",");
            }
        });
        this.entityEntryFields.put(entityId, builder.toString());
    }
}

