/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.save;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.lang.STConverter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.HIESUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportRowErrorLog;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.save.InstoreDispatcher;

public class DataConvertDynamicObject {
    private static Log log = LogFactory.getLog(DataConvertDynamicObject.class);
    public static final String NO_CACHE_ERROR = "can not find dynamicObject from cache";
    protected ImportStart importStart;
    private InstoreDispatcher dispatcher;
    protected String importtype;

    public DataConvertDynamicObject(ImportStart importStart, InstoreDispatcher dispatcher) {
        this.importStart = importStart;
        this.dispatcher = dispatcher;
        this.importtype = this.importStart.getImportContext().getTpl().getString("importtype");
    }

    @ExcludeFromJacocoGeneratedReport
    public DynamicObject[] toDynamicObject(List<ImportBillData> tempBilldatas, String groupType, DynamicObject blankDynamicObject) {
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>(tempBilldatas.size());
        if ("new".equals(this.importtype) || "new".equals(groupType)) {
            long[] ids = DB.genGlobalLongIds((int)tempBilldatas.size());
            for (int i = 0; i < tempBilldatas.size(); ++i) {
                DynamicObject newDynamicObject;
                ImportBillData data = tempBilldatas.get(i);
                if (null == data.getPkId()) {
                    data.setPkId(ids[i]);
                }
                if ((newDynamicObject = this.createNewDynamicObject(data, blankDynamicObject)) == null) continue;
                billObjs.add(newDynamicObject);
            }
        } else if ("update".equals(this.importtype) || "update".equals(groupType)) {
            List<DynamicObject> updateDatas = this.createUpdateDynamicObject(tempBilldatas);
            billObjs.addAll(updateDatas);
        } else if ("updateandnew".equals(this.importtype)) {
            List<ImportBillData> billDatas;
            Map groupBilldatas = tempBilldatas.stream().collect(Collectors.groupingBy(item -> item.getOpType(), Collectors.toList()));
            List<ImportBillData> updateBillDatas = groupBilldatas.get("update");
            if (CollectionUtils.isNotEmpty(updateBillDatas)) {
                DynamicObject[] updateDynamicObjects = this.toDynamicObject(updateBillDatas, "update", blankDynamicObject);
                billObjs.addAll(Arrays.asList(updateDynamicObjects));
            }
            if (CollectionUtils.isNotEmpty(billDatas = groupBilldatas.get("new"))) {
                DynamicObject[] newDynamicObjects = this.toDynamicObject(billDatas, "new", blankDynamicObject);
                billObjs.addAll(Arrays.asList(newDynamicObjects));
            }
        }
        return billObjs.toArray(new DynamicObject[billObjs.size()]);
    }

    @ExcludeFromJacocoGeneratedReport
    public List<DynamicObject> createUpdateDynamicObject(List<ImportBillData> tempBilldatas) {
        ImportContext importContext = this.importStart.getImportContext();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(tempBilldatas.size());
        Map<Object, Object> map = null;
        if (importContext.isSerialModel()) {
            DynamicObject[] dynamicObjects;
            map = Maps.newHashMapWithExpectedSize((int)tempBilldatas.size());
            List<Object> ids = tempBilldatas.stream().map(de -> de.getPkId()).collect(Collectors.toList());
            for (DynamicObject oldBill : dynamicObjects = ImportServiceHelper.loadDynamicObjects(ids, tempBilldatas.get(0).getMainEntityId())) {
                map.put(oldBill.getPkValue(), oldBill);
            }
        } else {
            map = importContext.getBaseDataContainer().getExistsEntityDyMap();
        }
        for (ImportBillData data : tempBilldatas) {
            DynamicObject oldBill = (DynamicObject)map.get(data.getPkId());
            map.remove(data.getPkId());
            List<String> errors = this.setValues(oldBill, data);
            if (CollectionUtils.isEmpty(errors)) {
                list.add(oldBill);
                continue;
            }
            for (String error : errors) {
                ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), error, this.importStart.getImportContext().getImportLog());
                this.importStart.writeRowErrorLog(errResult);
            }
        }
        return list;
    }

    @ExcludeFromJacocoGeneratedReport
    public DynamicObject createNewDynamicObject(ImportBillData data, DynamicObject blankDynamicObject) {
        OperationResult result = new OperationResult();
        DynamicObject newBill = null;
        try {
            newBill = (DynamicObject)OrmUtils.clone((IDataEntityBase)blankDynamicObject, (boolean)false, (boolean)true);
            List<String> errors = this.setValues(newBill, data);
            newBill.set("id", data.getPkId());
            if (CollectionUtils.isEmpty(errors)) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                for (String error : errors) {
                    ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), error, this.importStart.getImportContext().getImportLog());
                    this.importStart.writeRowErrorLog(errResult);
                }
            }
        }
        catch (Throwable e) {
            log.error("DataConvertDynamicObject_createNewDynamicObject exception.", e);
            result.setSuccess(false);
            result.setMessage(ImportRowErrorLog.getExceptionInfoWithSys(e));
        }
        if (!result.isSuccess() && StringUtils.isNotBlank((CharSequence)result.getMessage())) {
            ImportRowErrorLog errResult = new ImportRowErrorLog(data.getSheetName(), data.getStartIndex(), data.getEndIndex(), result.getMessage(), this.importStart.getImportContext().getImportLog());
            this.importStart.writeRowErrorLog(errResult);
        }
        if (result.isSuccess()) {
            return newBill;
        }
        return null;
    }

    protected List<String> setValues(DynamicObject bill, ImportBillData importBillData) {
        LinkedList<String> errors = new LinkedList<String>();
        DataEntityPropertyCollection properties = bill.getDynamicObjectType().getProperties();
        JSONObject jsonObject1 = importBillData.getData().getJSONObject(bill.getDataEntityType().getName());
        for (Map.Entry next : jsonObject1.entrySet()) {
            String fieldKey = (String)next.getKey();
            Object prop = properties.get((Object)fieldKey);
            if (ObjectUtils.isEmpty((Object)prop)) continue;
            try {
                Object old;
                Object propValue = this.getPropValue(prop, fieldKey, next.getValue(), bill, importBillData.getOpType());
                if (!"ignore".equals(propValue)) {
                    bill.set(fieldKey, propValue);
                }
                if (!(prop instanceof ItemClassTypeProp) || !"update".equals(importBillData.getOpType()) || !propValue.equals(String.valueOf(old = bill.get(fieldKey)))) continue;
                properties.stream().filter(prop2 -> prop2 instanceof ItemClassProp && !jsonObject1.containsKey((Object)prop2.getName()) && ((ItemClassProp)prop2).getTypePropName().equals(fieldKey)).forEach(prop3 -> bill.set(prop3.getName(), null));
            }
            catch (Throwable e) {
                log.info("DataConvertDynamicObject_setValues_fieldKey={}", (Object)fieldKey);
                log.error("DataConvertDynamicObject_setValues exception.", e);
                errors.add(ImportRowErrorLog.getExceptionInfoWithSys(e));
            }
        }
        return errors;
    }

    private Object getPropValue(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        if (this.importStart.getImportContext().isSerialModel()) {
            return this.getPropValueUsedBySerialModel(prop, key, val, bill, opType);
        }
        return this.getPropValueUsedByConcurrentModel(prop, key, val, bill, opType);
    }

    @ExcludeFromJacocoGeneratedReport
    private Object getPropValueUsedBySerialModel(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        Object commonPropValue = this.getCommonPropValue(prop, key, val, bill, opType);
        if (commonPropValue != null) {
            return commonPropValue;
        }
        if (prop instanceof DateProp) {
            Timestamp timestamp = new Timestamp((Long)val);
            return timestamp;
        }
        if (prop instanceof DateTimeProp) {
            DateTimeProp dateTimeProp = (DateTimeProp)prop;
            return HIESUtil.tranImptDateTimeProp((Object)val, (IDataEntityProperty)dateTimeProp, (DynamicObject)bill);
        }
        if (prop instanceof TimeProp) {
            return LocalTime.parse((String)val);
        }
        if (prop instanceof IBasedataField) {
            return "ignore";
        }
        return val;
    }

    private Object getPropValueUsedByConcurrentModel(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        Object commonPropValue = this.getCommonPropValue(prop, key, val, bill, opType);
        if (commonPropValue != null) {
            return commonPropValue;
        }
        if (prop instanceof BigDecimal) {
            BigDecimal bigDecimal = new BigDecimal((String)val);
            return bigDecimal;
        }
        if (prop instanceof TimeProp) {
            LocalTime localTime = (LocalTime)val;
            return localTime.getHour() * 60 * 60 + localTime.getMinute() * 60 + localTime.getSecond();
        }
        if (prop instanceof DateTimeProp) {
            DateTimeProp dateTimeProp = (DateTimeProp)prop;
            return HIESUtil.tranImptDateTimeProp((Object)val, (IDataEntityProperty)dateTimeProp, (DynamicObject)bill);
        }
        if (prop instanceof IBasedataField) {
            return "ignore";
        }
        return val;
    }

    @ExcludeFromJacocoGeneratedReport
    private Object getCommonPropValue(Object prop, String key, Object val, DynamicObject bill, String opType) throws Exception {
        if (prop instanceof PKFieldProp) {
            if (val == null) {
                return null;
            }
            return prop instanceof LongProp ? (val instanceof Long ? val : Long.valueOf((String)val)) : (String)val;
        }
        if (prop instanceof AdminDivisionProp) {
            String temp = (String)val;
            String[] split = StringUtils.split((String)temp, (String)"##");
            if (split.length == 2) {
                return split[1];
            }
        } else {
            if (prop instanceof RefBillProp) {
                if (val == null) {
                    return null;
                }
                JSONObject map = (JSONObject)val;
                Object id = map.get((Object)"id");
                if (ObjectUtils.isEmpty((Object)id)) {
                    return null;
                }
                if (id instanceof Integer) {
                    id = ((Integer)id).longValue();
                }
                HRBaseServiceHelper helper = new HRBaseServiceHelper(map.getString("$refbillentity"));
                DynamicObject basedataentity = helper.generateEmptyDynamicObject();
                basedataentity.set("id", id);
                return basedataentity;
            }
            if (prop instanceof BasedataProp) {
                DynamicObject basedataentity;
                if (val == null) {
                    return null;
                }
                if (!(val instanceof JSONObject)) {
                    return val;
                }
                JSONObject map = (JSONObject)val;
                Object id = map.get((Object)"id");
                if (ObjectUtils.isEmpty((Object)id)) {
                    return null;
                }
                if (id instanceof Integer) {
                    id = ((Integer)id).longValue();
                }
                String name = ((BasedataProp)prop).getName();
                String relBDFieldNumber = map.getString("$relBDFieldNumber");
                if (StringUtils.isNotBlank((CharSequence)relBDFieldNumber)) {
                    name = relBDFieldNumber;
                }
                if ((basedataentity = this.importStart.getImportContext().getBaseDataContainer().getBasedataIdMap(map.getString("$basedataBelongEntity"), map.getString("$basedataentity"), name, id)) == null) {
                    log.info("basedata_not_find,map=" + map.toJSONString());
                    throw new KDBizException("basedata not find.");
                }
                return basedataentity;
            }
            if (prop instanceof MulBasedataProp) {
                if (val == null) {
                    return null;
                }
                MulBasedataDynamicObjectCollection collection = new MulBasedataDynamicObjectCollection();
                DynamicObjectType dynamicCollectionItemPropertyType = ((MulBasedataProp)prop).getDynamicCollectionItemPropertyType();
                JSONArray items = (JSONArray)val;
                ListIterator objectListIterator = items.listIterator();
                while (objectListIterator.hasNext()) {
                    DynamicObject basedataentity;
                    JSONObject next = (JSONObject)objectListIterator.next();
                    String key0 = next.getString("$basedataentity");
                    if (StringUtils.isEmpty((CharSequence)key0)) continue;
                    DynamicObject entryitem = new DynamicObject(dynamicCollectionItemPropertyType);
                    Object id = next.get((Object)"id");
                    if (ObjectUtils.isEmpty((Object)id)) continue;
                    if (id instanceof Integer) {
                        id = ((Integer)id).longValue();
                    }
                    if ((basedataentity = this.importStart.getImportContext().getBaseDataContainer().getBasedataIdMap(next.getString("$basedataBelongEntity"), key0, ((MulBasedataProp)prop).getName(), id)) == null) {
                        log.info("basedata_not_find,next=" + next.toJSONString());
                        throw new KDBizException("basedata not find.");
                    }
                    entryitem.set("fbasedataid", (Object)basedataentity);
                    entryitem.set("fbasedataid_id", basedataentity.getPkValue());
                    collection.add(entryitem);
                }
                return collection;
            }
            if (prop instanceof ComboProp) {
                if (prop instanceof MulComboProp) {
                    String temp = (String)val;
                    String[] split = temp.split(",");
                    ArrayList list = new ArrayList(split.length);
                    for (String item : split) {
                        Map itemsMap = (Map)this.dispatcher.getComboItems().get((Object)this.findTopParentId(bill), (Object)key);
                        list.add(itemsMap.get(item));
                    }
                    return String.join((CharSequence)",", list);
                }
                Map itemsMap = (Map)this.dispatcher.getComboItems().get((Object)this.findTopParentId(bill), (Object)key);
                String combo = (String)itemsMap.get(val);
                return combo;
            }
            if (prop instanceof MuliLangTextProp) {
                JSONObject map = (JSONObject)val;
                ILocaleString localeString = bill.getLocaleString(key);
                for (Map.Entry next : map.entrySet()) {
                    localeString.setItem((String)next.getKey(), (Object)String.valueOf(next.getValue()));
                }
                if ("new".equalsIgnoreCase(opType) && StringUtils.isBlank((CharSequence)localeString.getLocaleValue_zh_TW()) && StringUtils.isNotBlank((CharSequence)localeString.getLocaleValue_zh_CN())) {
                    String tw = STConverter.sc2tc((String)((String)map.get((Object)"zh_CN")));
                    localeString.setLocaleValue_zh_TW(tw);
                }
                localeString.setItem("GLang", (Object)localeString.getLocaleValue());
                return localeString;
            }
            if (prop instanceof EntryProp) {
                DynamicObjectCollection collection = null;
                HashMap oldEntryMap = Maps.newHashMapWithExpectedSize((int)16);
                if ("update".equalsIgnoreCase(opType)) {
                    collection = bill.getDynamicObjectCollection(key);
                    for (DynamicObject item : collection) {
                        oldEntryMap.put(item.getLong("id"), item);
                    }
                } else {
                    collection = new DynamicObjectCollection();
                }
                JSONArray entryEntity = (JSONArray)val;
                DynamicObjectType dynamicCollectionItemPropertyType = ((EntryProp)prop).getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection properties = ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties();
                int seq = 1;
                ListIterator objectListIterator = entryEntity.listIterator();
                while (objectListIterator.hasNext()) {
                    JSONObject next = (JSONObject)objectListIterator.next();
                    DynamicObject entryitem = null;
                    if ("update".equalsIgnoreCase(opType)) {
                        String entryid = (String)next.get((Object)(key + "_id"));
                        if (StringUtils.isNotBlank((CharSequence)entryid)) {
                            entryitem = (DynamicObject)oldEntryMap.get(Long.parseLong(entryid));
                            if (entryitem == null && prop instanceof TreeEntryProp) {
                                entryitem = this.createNewEntryRow(dynamicCollectionItemPropertyType);
                            } else if (entryitem == null) {
                                continue;
                            }
                        } else {
                            entryitem = this.createNewEntryRow(dynamicCollectionItemPropertyType);
                        }
                    } else {
                        entryitem = this.createNewEntryRow(dynamicCollectionItemPropertyType);
                    }
                    if (entryitem.getLong("id") == 0L) {
                        collection.add((Object)entryitem);
                        entryitem.setParent((Object)bill);
                    }
                    for (Map.Entry next1 : next.entrySet()) {
                        Object propValue;
                        String key1 = (String)next1.getKey();
                        IDataEntityProperty property = null;
                        if (prop instanceof TreeEntryProp && (key1.endsWith("_id") || key1.endsWith("_pid")) && (property = (IDataEntityProperty)properties.get((Object)key1.replace("_id", ".id").replace("_pid", ".pid"))) == null) {
                            key1 = key1.substring(key1.lastIndexOf("_") + 1);
                        }
                        if (ObjectUtils.isEmpty((Object)(property = (IDataEntityProperty)properties.get((Object)key1))) || "ignore".equals(propValue = this.getPropValue(property, key1, next1.getValue(), entryitem, opType))) continue;
                        entryitem.set(key1, propValue);
                    }
                    entryitem.set("seq", (Object)seq);
                    ++seq;
                }
                return collection;
            }
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private DynamicObject createNewEntryRow(DynamicObjectType type) {
        DynamicObject entryitem = new DynamicObject(type);
        type.getProperties().forEach(pro -> {
            if (pro instanceof TimeProp) {
                entryitem.set(pro.getName(), (Object)-1);
            }
        });
        return entryitem;
    }

    @ExcludeFromJacocoGeneratedReport
    private String findTopParentId(DynamicObject dy) {
        IDataEntityType parent = dy.getDataEntityType().getParent();
        if (parent == null) {
            return dy.getDataEntityType().getName();
        }
        IDataEntityType parent1 = parent.getParent();
        if (parent1 == null) {
            return parent.getName();
        }
        IDataEntityType parent2 = parent1.getParent();
        if (parent2 == null) {
            return parent1.getName();
        }
        return "";
    }
}

