/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.save;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.constant.MCConfigConstant;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.core.init.ImportStart;

public class InstoreDataFlowSuggester {
    private static Log log = LogFactory.getLog(InstoreDataFlowSuggester.class);
    private ImportStart importStart;
    private List<Long> lastExpenseTimes = new ArrayList<Long>(10);
    private long avgExpenseTimes;
    private int suggestBatchSize;
    private int suggestThreads;
    private int workerMaxThread;
    private int maxBatchSize;
    private ReentrantLock lock = new ReentrantLock();

    public InstoreDataFlowSuggester(ImportStart importStart, int workerMaxThread) {
        this.importStart = importStart;
        this.workerMaxThread = workerMaxThread;
        this.maxBatchSize = InstoreDataFlowSuggester.getMaxBatchSize(importStart);
    }

    public void addExpenseTimes(Long expenseTimes) {
        Integer callopStandExpense = (Integer)this.importStart.getImportContext().getExtOption().get("callopStandExpense");
        if (expenseTimes.intValue() > callopStandExpense) {
            this.importStart.getMonitor().addOtherTotalCount("callOp_timeOut", 1);
        }
        if (this.lock.tryLock()) {
            try {
                if (this.lastExpenseTimes.size() >= 10) {
                    this.lastExpenseTimes.remove(0);
                }
                this.lastExpenseTimes.add(expenseTimes);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public int getSuggestBatchSize() {
        if (this.suggestBatchSize < 100) {
            this.suggestBatchSize = 100;
        }
        return this.suggestBatchSize;
    }

    public int getSuggestThreads() {
        if (this.suggestThreads < 1) {
            this.suggestThreads = 1;
        }
        return this.suggestThreads;
    }

    @ExcludeFromJacocoGeneratedReport
    public void runDataFlowSuggest() {
        if (this.lastExpenseTimes.size() == 0) {
            return;
        }
        this.computeAvgExpenseTime();
        Integer callopStandExpense = (Integer)this.importStart.getImportContext().getExtOption().get("callopStandExpense");
        if (this.avgExpenseTimes > (long)callopStandExpense.intValue()) {
            if (this.suggestBatchSize > 100) {
                this.suggestBatchSize = (int)((double)this.suggestBatchSize * 0.66);
            }
            if (this.suggestThreads > 1) {
                this.suggestThreads = (int)((double)this.suggestThreads * 0.66);
            }
        } else {
            this.suggestBatchSize *= 2;
            if (this.suggestBatchSize > this.maxBatchSize) {
                this.suggestBatchSize = this.maxBatchSize;
            }
            this.suggestThreads = ++this.suggestThreads;
            if (this.suggestThreads > this.workerMaxThread) {
                this.suggestThreads = this.workerMaxThread;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void initDataFlowSuggest() {
        int totalRowCount = this.importStart.getImportContext().getTotalRowCount();
        if (totalRowCount <= 5000) {
            this.suggestThreads = 1;
            this.suggestBatchSize = 100;
        } else if (totalRowCount <= 10000) {
            this.suggestThreads = 2;
            this.suggestBatchSize = 500;
        } else if (totalRowCount <= 100000) {
            this.suggestThreads = 3;
            this.suggestBatchSize = 800;
        } else {
            this.suggestThreads = this.workerMaxThread;
            this.suggestBatchSize = this.maxBatchSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExcludeFromJacocoGeneratedReport
    private void computeAvgExpenseTime() {
        long total = 0L;
        this.lock.lock();
        try {
            for (Long item : this.lastExpenseTimes) {
                total += item.longValue();
            }
            this.avgExpenseTimes = total / (long)this.lastExpenseTimes.size();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int getWorkerMaxThread(ImportStart importStart) {
        ImportContext importContext = importStart.getImportContext();
        int workerMaxThread = MCConfigConstant.getWorkerMaxThread();
        boolean needDbTransaction = InstoreDataFlowSuggester.isNeedDbTransaction(importStart.getImportContext());
        log.info("getWorkerMaxThread_isNeedDbTransaction=" + needDbTransaction);
        if (needDbTransaction) {
            workerMaxThread = InstoreDataFlowSuggester.getOnDbTranWorkerMaxThread(importStart);
        } else {
            Map<String, Integer> sheetRowCountMap = importContext.getSheetRowCountMap();
            int totaolRows = sheetRowCountMap.values().stream().mapToInt(c -> c).sum();
            if (totaolRows > 200000) {
                workerMaxThread *= 2;
            }
        }
        if (importContext.isEnableSequenceInstore()) {
            workerMaxThread = 1;
        }
        importStart.getMonitor().getImportTrace().getOther().put(InstoreDataFlowSuggester.class.getSimpleName() + "_workerMaxThread", workerMaxThread);
        return workerMaxThread;
    }

    private static boolean isNeedDbTransaction(ImportContext importContext) {
        String entitytype = importContext.getTpl().getString("entitytype");
        return "MESS".equals(entitytype) || "MEMS".equals(entitytype) && importContext.isNeedRelationInStoreForMEMS();
    }

    private static int getMaxBatchSize(ImportStart importStart) {
        ImportContext importContext = importStart.getImportContext();
        int maxBatchSize = MCConfigConstant.getCallOpMaxBatchSize();
        String entitytype = importContext.getTpl().getString("entitytype");
        if ("MESS".equals(entitytype) || "MEMS".equals(entitytype) && importContext.isNeedRelationInStoreForMEMS()) {
            maxBatchSize = 50;
            if (importContext.isEnableSequenceInstore() && (maxBatchSize = 1000 / importContext.getEntityIdToUniqueValMap().size()) < 50) {
                maxBatchSize = 50;
            }
        }
        importStart.getMonitor().getImportTrace().getOther().put(InstoreDataFlowSuggester.class.getSimpleName() + "_maxBatchSize", maxBatchSize);
        return maxBatchSize;
    }

    @ExcludeFromJacocoGeneratedReport
    private static int getOnDbTranWorkerMaxThread(ImportStart importStart) {
        ImportContext importContext = importStart.getImportContext();
        String entitytype = importContext.getTpl().getString("entitytype");
        Map<String, Integer> sheetRowCountMap = importContext.getSheetRowCountMap();
        int totaolRows = 0;
        if ("MEMS".equals(entitytype)) {
            Map entitySheetMap = MethodUtil.reversalMap(importContext.getSheetEntityMap());
            for (String entityId : importContext.getEntityRelationField().keySet()) {
                String sheetName = (String)entitySheetMap.get(entityId);
                totaolRows += sheetRowCountMap.getOrDefault(sheetName, 0).intValue();
            }
        } else if ("MESS".equals(entitytype)) {
            totaolRows = sheetRowCountMap.values().stream().mapToInt(c -> c).sum();
            totaolRows *= importContext.getEntityIdToUniqueValMap().size();
        }
        log.info("getOnDbTranWorkerMaxThread_sheetRowCountMap.size=" + sheetRowCountMap.size() + ",sheetEntityMap.sieze=" + importContext.getSheetEntityMap().size() + "entityRelationField.size=" + importContext.getEntityRelationField().size());
        log.info("getOnDbTranWorkerMaxThread_totaolRows=" + totaolRows);
        int finalCount = MCConfigConstant.getWorkerMaxThread();
        int addOnceCount = 4;
        int workerMaxThread = MCConfigConstant.getWorkerMaxThread();
        if (totaolRows > 900000) {
            finalCount = workerMaxThread + addOnceCount * 6;
        } else if (totaolRows > 600000) {
            finalCount = workerMaxThread + addOnceCount * 5;
        } else if (totaolRows > 300000) {
            finalCount = workerMaxThread + addOnceCount * 4;
        } else if (totaolRows > 100000) {
            finalCount = workerMaxThread + addOnceCount * 3;
        } else if (totaolRows > 10000) {
            finalCount = workerMaxThread + addOnceCount * 2;
        }
        return finalCount;
    }
}

