/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.tempstore;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.tempstore.TempStoreDispatcher;

public class PutTempDataToOutQueueTask
implements Callable<Object> {
    private static Log log = LogFactory.getLog(PutTempDataToOutQueueTask.class);
    private ImportStart importStart;
    private AtomicInteger childThreadMonitor;
    private String sheet;
    private TempStoreDispatcher dispatcher;

    public PutTempDataToOutQueueTask(String sheet, ImportStart importStart, TempStoreDispatcher dispatcher, AtomicInteger childThreadMonitor) {
        this.childThreadMonitor = childThreadMonitor;
        this.importStart = importStart;
        this.dispatcher = dispatcher;
        this.sheet = sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        this.childThreadMonitor.getAndIncrement();
        long start = System.currentTimeMillis();
        MethodUtil.syncRequestTraceId((Object)this.importStart.getImportContext().getRc());
        log.info("PutTempDataToOutQueueTask_started.");
        try {
            this.dispatcher.getAlgoManager().putToOutQueue(this.sheet, this.dispatcher);
        }
        catch (Throwable e) {
            log.error(e);
            this.importStart.writeErrorLog(e);
        }
        finally {
            long end = System.currentTimeMillis() - start;
            this.importStart.getMonitor().addExpenseStatistics(PutTempDataToOutQueueTask.class.getSimpleName(), (Long)end, false);
            this.childThreadMonitor.getAndDecrement();
            this.dispatcher.getChildThreadSemaphore().release();
        }
        return null;
    }
}

