/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.service.OrgService;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class ControlledBDPermValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(ControlledBDPermValidator.class);
    private OrgService service = new OrgService();

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        if (!this.isEnable()) {
            return;
        }
        BaseDataContainer baseDataContainer = this.getDataValidateParams().getBaseDataContainer();
        Map<Object, DynamicObject> existsEntityDyMap = this.getDataValidateParams().getBaseDataContainer().getExistsEntityDyMap();
        for (ImportBillData billData : billDataList) {
            billData.getData().forEach((entity, jsonValue) -> {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
                if (jsonValue instanceof JSONArray) {
                    for (Object data : (JSONArray)jsonValue) {
                        this.handleBaseDataCtrl(importLog, baseDataContainer, billData, (JSONObject)data, billData.getPkId() == null ? null : (DynamicObject)existsEntityDyMap.get(billData.getPkId()), entityType);
                    }
                } else {
                    this.handleBaseDataCtrl(importLog, baseDataContainer, billData, (JSONObject)jsonValue, billData.getPkId() == null ? null : (DynamicObject)existsEntityDyMap.get(billData.getPkId()), entityType);
                }
            });
            if (this.getDataValidateParams().isDeleteTemplate()) continue;
            this.ControlBDF7Validate(importLog, baseDataContainer, billData);
        }
    }

    private void ControlBDF7Validate(ImportLog importLog, BaseDataContainer baseDataContainer, ImportBillData billData) {
        JSONObject allBaseDataJson = billData.getAllBaseDataJson();
        for (Object basedata : allBaseDataJson.values()) {
            if (basedata instanceof JSONObject && ((JSONObject)basedata).containsKey((Object)"$isBaseDataCtrl")) {
                this.checkControlledRefBD(importLog, billData, baseDataContainer, (JSONObject)basedata);
                continue;
            }
            if (!(basedata instanceof JSONArray) || !((JSONArray)basedata).getJSONObject(0).containsKey((Object)"$isBaseDataCtrl")) continue;
            JSONArray basedataJsonArray = (JSONArray)basedata;
            basedataJsonArray.forEach(jsonObject -> this.checkControlledRefBD(importLog, billData, baseDataContainer, (JSONObject)jsonObject));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void handleBaseDataCtrl(ImportLog importLog, BaseDataContainer baseDataContainer, ImportBillData billData, JSONObject data, DynamicObject dy, MainEntityType entityType) {
        String entityNumber = entityType.getName();
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(entityNumber, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        JSONObject mainOrgValue = data.getJSONObject(entityType.getMainOrg());
        List<Long> permBU = this.getPermMainBU(baseDataContainer, entityType, entityNumber);
        if (permBU.get(0) != -2L) {
            if (this.getDataValidateParams().isDeleteTemplate()) {
                DynamicObject mainOrgDy = dy.getDynamicObject(entityType.getMainOrg());
                if (!permBU.contains(mainOrgDy.getLong("id"))) {
                    DataValidateServiceHelper.writeRowErrorLog(10, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), new Object[0]);
                }
            } else if (mainOrgValue == null || !permBU.contains(mainOrgValue.getLong("id"))) {
                String mainOrgFieldKey;
                String cellIndex = mainOrgValue == null ? this.getCellIndex(entityType.getMainOrg(), entityNumber) : (StringUtils.isEmpty((CharSequence)(mainOrgFieldKey = mainOrgValue.getString("$basedataFieldKey"))) ? this.getCellIndex(entityType.getMainOrg(), entityNumber) : this.getCellIndex(mainOrgFieldKey, entityNumber));
                if (mainOrgValue != null) {
                    Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
                    String mainOrgFieldKey2 = mainOrgValue.getString("$basedataFieldKey");
                    if (StringUtils.isNotEmpty((CharSequence)mainOrgFieldKey2)) {
                        DynamicObject fieldDy = tplFieldConfig.get(entityNumber).get(MethodUtil.getLevelOneKey((String)mainOrgFieldKey2));
                        String baseDataFormat = fieldDy.getString("imptattr");
                        Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
                        Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityNumber).get(MethodUtil.getLevelOneKey((String)mainOrgFieldKey2));
                        DataValidateServiceHelper.writeRowErrorLog(7, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), cellIndex, this.getCellName(cellIndex, entityNumber), this.getPutWhereKey(mainOrgValue, baseDataFormat, bdFieldMainPropName, data, this.getExtF7UniqueVal(entityNumber, MethodUtil.getLevelOneKey((String)mainOrgFieldKey2)), (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(MethodUtil.getLevelOneKey((String)mainOrgFieldKey2)))));
                    }
                }
            }
        } else if (mainOrgValue != null) {
            this.checkOrgPermForHasAllPerm(importLog, baseDataContainer, billData, data, entityType);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkControlledRefBD(ImportLog importLog, ImportBillData billData, BaseDataContainer baseDataContainer, JSONObject basedata) {
        String entityNum = basedata.getString("$basedataBelongEntity");
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(entityNum, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        String baseDataEntity = basedata.getString("$basedataentity");
        Long useOrgId = basedata.getLong("$useOrgId");
        Long bdId = basedata.getLong("id");
        if (useOrgId == null) {
            useOrgId = 0L;
            LOGGER.info("ControlledBDPermValidator_checkControlledRefBD(),useOrgId is null,basedata:{}", (Object)basedata);
        }
        if (StringUtils.isBlank((CharSequence)baseDataEntity)) {
            LOGGER.info("ControlledBDPermValidator_checkControlledRefBD(),baseDataEntity is null,basedata:{}", (Object)basedata);
        }
        LOGGER.info("ControlledBDPermValidator_checkControlledRefBD(),entityNumber:{},useOrgId:{},bdId:{}", new Object[]{baseDataEntity, useOrgId, bdId});
        List<Long> controlledBDPermIds = baseDataContainer.getControlledBDPermTable(baseDataEntity, useOrgId);
        if (controlledBDPermIds == null) {
            controlledBDPermIds = baseDataContainer.getControlledBDPermTable(baseDataEntity, RequestContext.get().getCurrUserId());
            LOGGER.info("ControlledBDPermValidator_checkControlledRefBD(),currUserId:{}", (Object)RequestContext.get().getCurrUserId());
        }
        if (controlledBDPermIds != null && !controlledBDPermIds.contains(bdId)) {
            LOGGER.info("ControlledBDPermValidator_checkControlledRefBD(),controlledBDPermIds:{}", controlledBDPermIds);
            String cellIndex = this.getCellIndex(basedata.getString("$basedataFieldKey"), billData.getMainEntityId());
            Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
            String fieldKey = basedata.getString("$basedataFieldKey");
            DynamicObject fieldDy = tplFieldConfig.get(entityNum).get(MethodUtil.getLevelOneKey((String)fieldKey));
            String baseDataFormat = fieldDy.getString("imptattr");
            Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
            Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityNum).get(MethodUtil.getLevelOneKey((String)fieldKey));
            DataValidateServiceHelper.writeRowErrorLog(7, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), basedata.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, billData.getMainEntityId()), this.getPutWhereKey(basedata, baseDataFormat, bdFieldMainPropName, billData.getData().getJSONObject(entityNum), this.getExtF7UniqueVal(entityNum, MethodUtil.getLevelOneKey((String)fieldKey)), (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(MethodUtil.getLevelOneKey((String)fieldKey)))));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkOrgPermForHasAllPerm(ImportLog importLog, BaseDataContainer baseDataContainer, ImportBillData billData, JSONObject data, MainEntityType entityType) {
        JSONObject mainOrgValue;
        String entityNumber = entityType.getName();
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(entityNumber, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        if ((mainOrgValue = data.getJSONObject(entityType.getMainOrg())) != null) {
            Long orgid = mainOrgValue.getLong("id");
            if (orgid == null) {
                return;
            }
            String permOrgFuncId = PermCommonUtil.getPermOrgFuncId((String)entityNumber);
            Map map = baseDataContainer.getMainOrgPerm().computeIfAbsent(permOrgFuncId, val -> Maps.newConcurrentMap());
            Boolean ret = (Boolean)map.get(orgid);
            if (ret == null) {
                ret = this.service.checkOrgFunction(orgid, permOrgFuncId);
                map.put(orgid, ret);
                LOGGER.info("checkOrgPermForHasAllPerm_orgid=" + orgid + ",ret=" + ret);
            }
            if (!ret.booleanValue()) {
                String mainOrgFieldKey = mainOrgValue.getString("$basedataFieldKey");
                String cellIndex = StringUtils.isBlank((CharSequence)mainOrgFieldKey) ? this.getCellIndex(entityType.getMainOrg(), entityNumber) : this.getCellIndex(mainOrgFieldKey, entityNumber);
                Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
                DynamicObject fieldDy = tplFieldConfig.get(entityNumber).get(MethodUtil.getLevelOneKey((String)mainOrgFieldKey));
                String baseDataFormat = fieldDy.getString("imptattr");
                Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
                Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityNumber).get(MethodUtil.getLevelOneKey((String)mainOrgFieldKey));
                DataValidateServiceHelper.writeRowErrorLog(7, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), cellIndex, this.getCellName(cellIndex, entityNumber), this.getPutWhereKey(mainOrgValue, baseDataFormat, bdFieldMainPropName, billData.getData().getJSONObject(entityNumber), this.getExtF7UniqueVal(entityNumber, MethodUtil.getLevelOneKey((String)mainOrgFieldKey)), (Map<String, String>)((Map)f7ExtUniqueValFieldMap.get(MethodUtil.getLevelOneKey((String)mainOrgFieldKey)))));
            }
        }
    }

    private String[] getExtF7UniqueVal(String mainEntityNum, String fieldNum) {
        Map<String, String> entityMap;
        Map<String, Map<String, String>> f7UniqueValMap = this.getDataValidateParams().getF7ExtUniqueValMap();
        if (ObjectUtils.isNotEmpty(f7UniqueValMap) && ObjectUtils.isNotEmpty(entityMap = f7UniqueValMap.get(mainEntityNum))) {
            return StringUtils.split((String)entityMap.get(fieldNum), (String)",");
        }
        return null;
    }
}

