/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.property.EntryProp;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class DataRulePermValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(DataRulePermValidator.class);

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        if (!this.isEnable()) {
            return;
        }
        Map<Object, DynamicObject> existsEntityDyMap = this.getDataValidateParams().getBaseDataContainer().getExistsEntityDyMap();
        for (ImportBillData billData : billDataList) {
            billData.getData().forEach((key, value) -> {
                if (value instanceof JSONArray) {
                    for (Object json : (JSONArray)value) {
                        this.handleDataJson((String)key, (JSONObject)json, importLog, billData, billData.getPkId() == null ? null : (DynamicObject)existsEntityDyMap.get(billData.getPkId()));
                    }
                } else {
                    this.handleDataJson((String)key, (JSONObject)value, importLog, billData, billData.getPkId() == null ? null : (DynamicObject)existsEntityDyMap.get(billData.getPkId()));
                }
            });
            this.hasF7BdPermit(billData, importLog);
        }
    }

    private void handleDataJson(String entityId, JSONObject dataJson, ImportLog importLog, ImportBillData billData, DynamicObject existsEntityDy) {
        String opType = dataJson.containsKey((Object)"$opType") ? dataJson.getString("$opType") : billData.getOpType();
        BOSExpression bosExpression = this.getDataValidateParams().getEntity2DataRuleScript(entityId, DataValidateServiceHelper.getPermissionStatus(opType));
        if (bosExpression == null || "1=1".equals(bosExpression.getExpression())) {
            return;
        }
        String dataRuleScript = bosExpression.getExpression();
        AtomicBoolean validateResult = new AtomicBoolean(true);
        if ("1!=1".equals(dataRuleScript)) {
            validateResult.set(false);
        } else {
            Set vars = bosExpression.getVars();
            HashMap<String, Object> varValues = new HashMap<String, Object>(vars.size());
            LOGGER.info("DataRulePermValidator_handleDataJson(),entityId:{},isError:{},bosExpression\uff1a{}", new Object[]{entityId, bosExpression.isError(), bosExpression.toString()});
            if (bosExpression.isError() || StringUtils.isBlank((CharSequence)bosExpression.toString())) {
                return;
            }
            if (this.getDataValidateParams().isDeleteTemplate()) {
                this.validateOfDelType(existsEntityDy, bosExpression, validateResult, vars, varValues);
                if (!validateResult.get()) {
                    DataValidateServiceHelper.writeRowErrorLog(10, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), new Object[0]);
                    return;
                }
            } else {
                this.validateOfCommonType(dataJson, billData, bosExpression, validateResult, vars, varValues);
            }
        }
        if (!validateResult.get()) {
            DataValidateServiceHelper.writeRowErrorLog(11, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), new Object[0]);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void validateOfCommonType(JSONObject dataJson, ImportBillData billData, BOSExpression bosExpression, AtomicBoolean validateResult, Set<String> vars, Map<String, Object> varValues) {
        dataJson.entrySet().forEach(entry -> DataValidateServiceHelper.containsKey(vars, varValues, entry));
        List collects = dataJson.values().stream().filter(value -> value instanceof JSONArray && vars.stream().anyMatch(key -> ((JSONArray)value).getJSONObject(0).containsKey(key))).collect(Collectors.toList());
        if (collects.size() > 1) {
            LOGGER.warn("DataRulePermValidator_validateOfCommonType() sheetName:{},index:{} warn:{},", new Object[]{billData.getSheetName(), billData.getStartIndex(), ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u914d\u7f6e\u9519\u8bef\uff0c\u63a7\u5236\u5b57\u6bb5\u4e0d\u5141\u8bb8\u6765\u81ea\u4e8e\u591a\u4e2a\u5355\u636e\u4f53\u3002", (String)"DataRulePermValidator_1", (String)"hrmp-hies-import", (Object[])new Object[0])});
        } else if (collects.size() == 1) {
            JSONArray entryJson = (JSONArray)collects.get(0);
            for (int index = 0; index < entryJson.size(); ++index) {
                entryJson.getJSONObject(index).entrySet().forEach(entry -> DataValidateServiceHelper.containsKey(vars, varValues, entry));
                LOGGER.info("DataRulePermValidator.validateOfCommonType(),vars:{},varValues:{}", vars, varValues);
                if (((Boolean)FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), varValues)).booleanValue()) continue;
                validateResult.set(false);
                break;
            }
        } else {
            LOGGER.info("DataRulePermValidator.validateOfCommonType(),vars:{},varValues:{}", vars, varValues);
            if (bosExpression.getExpr() != null && !((Boolean)FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), varValues)).booleanValue()) {
                validateResult.set(false);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void hasF7BdPermit(ImportBillData billData, ImportLog importLog) {
        JSONObject allBaseDataJson = billData.getAllBaseDataJson();
        for (Object basedata : allBaseDataJson.values()) {
            if (basedata instanceof JSONObject) {
                String errorF7BdKey = this.getErrorF7BdKey((JSONObject)basedata, billData);
                if (!StringUtils.isNotEmpty((CharSequence)errorF7BdKey)) continue;
                if (((JSONObject)basedata).containsKey((Object)"$isDefaultValue")) {
                    DataValidateServiceHelper.writeRowErrorLog(27, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), ((JSONObject)basedata).getString("$fieldNameOfDefaultValue"), ((JSONObject)basedata).getString("name"));
                    continue;
                }
                String cellIndex = this.getCellIndex(errorF7BdKey, billData.getMainEntityId());
                this.writeF7BdPermitLog(billData, importLog, (JSONObject)basedata, cellIndex);
                continue;
            }
            if (!(basedata instanceof JSONArray)) continue;
            JSONArray jsonArray = (JSONArray)basedata;
            jsonArray.forEach(item -> {
                String errorF7BdKey = this.getErrorF7BdKey((JSONObject)item, billData);
                if (StringUtils.isNotEmpty((CharSequence)errorF7BdKey)) {
                    String cellIndex = this.getCellIndex(errorF7BdKey, billData.getMainEntityId());
                    this.writeF7BdPermitLog(billData, importLog, (JSONObject)item, cellIndex);
                }
            });
        }
    }

    private void writeF7BdPermitLog(ImportBillData billData, ImportLog importLog, JSONObject basedata, String cellIndex) {
        String fieldKey = MethodUtil.getLevelOneKey((String)basedata.getString("$basedataFieldKey"));
        String entityNum = basedata.getString("$basedataBelongEntity");
        Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
        DynamicObject fieldDy = tplFieldConfig.get(entityNum).get(fieldKey);
        String baseDataFormat = fieldDy.getString("imptattr");
        Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
        Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityNum).get(fieldKey);
        DataValidateServiceHelper.writeRowErrorLog(24, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), billData.getStartIndex(), cellIndex, this.getCellName(cellIndex, billData.getMainEntityId()), this.getPutWhereKey(basedata, baseDataFormat, bdFieldMainPropName, billData.getData().getJSONObject(entityNum), this.getExtF7UniqueVal(entityNum, fieldKey), this.getExtF7UniqueValFieldMap(entityNum, fieldKey)));
    }

    private String getErrorF7BdKey(JSONObject basedata, ImportBillData billData) {
        String fieldKey = MethodUtil.getLevelOneKey((String)basedata.getString("$basedataFieldKey"));
        BaseDataContainer baseDataContainer = this.getDataValidateParams().getBaseDataContainer();
        Set<Long> dataRulePermBasedata = baseDataContainer.getDataRulePermBasedata(billData.getMainEntityId(), basedata.getString("$basedataentity"), fieldKey);
        if (dataRulePermBasedata != null && !dataRulePermBasedata.contains(basedata.getLong("id"))) {
            return basedata.getString("$basedataFieldKey");
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    private void validateOfDelType(DynamicObject existsEntityDy, BOSExpression bosExpression, AtomicBoolean validateResult, Set<String> vars, Map<String, Object> varValues) {
        if (existsEntityDy == null) {
            return;
        }
        ArrayList varsTemp = Lists.newArrayListWithExpectedSize((int)vars.size());
        varsTemp.addAll(vars);
        vars.stream().filter(key -> existsEntityDy.containsProperty(key.split("\\.")[0])).forEach(key2 -> {
            varValues.put((String)key2, existsEntityDy.get(key2));
            varsTemp.remove(key2);
        });
        if (varValues.size() < vars.size()) {
            List collectionProperties = existsEntityDy.getDataEntityType().getProperties().getCollectionProperties(true);
            collectionProperties.stream().filter(prop -> prop instanceof EntryProp).forEach(prop2 -> {
                DynamicObjectCollection dynamicObjectCollection = existsEntityDy.getDynamicObjectCollection(prop2.getName());
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0 && ((DynamicObject)dynamicObjectCollection.get(0)).containsProperty(((String)varsTemp.get(0)).split("\\.")[0])) {
                    for (DynamicObject dy : dynamicObjectCollection) {
                        varsTemp.forEach(key -> varValues.put((String)key, dy.get(key)));
                        if (((Boolean)FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), (Map)varValues)).booleanValue()) continue;
                        validateResult.set(false);
                        break;
                    }
                }
            });
        } else if (!((Boolean)FormulaEngine.execExcelFormula((Expr)bosExpression.getExpr(), varValues)).booleanValue()) {
            validateResult.set(false);
        }
    }

    private String[] getExtF7UniqueVal(String mainEntityNum, String fieldNum) {
        Map<String, String> entityMap;
        Map<String, Map<String, String>> f7UniqueValMap = this.getDataValidateParams().getF7ExtUniqueValMap();
        if (ObjectUtils.isNotEmpty(f7UniqueValMap) && ObjectUtils.isNotEmpty(entityMap = f7UniqueValMap.get(mainEntityNum))) {
            return StringUtils.split((String)entityMap.get(fieldNum), (String)",");
        }
        return null;
    }

    private Map<String, String> getExtF7UniqueValFieldMap(String mainEntityNum, String fieldNum) {
        Map f7ExtUniqueValFieldMap = Maps.newHashMapWithExpectedSize((int)0);
        Map<String, Map<String, Map<String, String>>> f7ExtUniqueValFieldMap0 = this.getDataValidateParams().getF7ExtUniqueValFieldMap();
        if (!ObjectUtils.isEmpty(f7ExtUniqueValFieldMap0)) {
            f7ExtUniqueValFieldMap = f7ExtUniqueValFieldMap0.computeIfAbsent(mainEntityNum, val -> Maps.newHashMapWithExpectedSize((int)0));
        }
        return (Map)f7ExtUniqueValFieldMap.get(fieldNum);
    }
}

