/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;

@ExcludeFromJacocoGeneratedReport
public final class FillInLegalValidator
extends InnerValidateHandler {
    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        if (!this.isEnable()) {
            return;
        }
        for (ImportBillData billData : billDataList) {
            DataEntityPropertyCollection properties = MetadataServiceHelper.getDataEntityType((String)billData.getMainEntityId()).getProperties();
            for (Map.Entry entry : billData.getData().entrySet()) {
                String entityNum = (String)entry.getKey();
                Object dataJson = entry.getValue();
                if (dataJson instanceof JSONArray) {
                    for (Object data : (JSONArray)dataJson) {
                        JSONObject jsonObject = (JSONObject)data;
                        this.checkEntryentityIdFieldForNewAndUpdateTpl(properties, billData, jsonObject, entityNum, importLog);
                    }
                    continue;
                }
                JSONObject jsonObject = (JSONObject)dataJson;
                this.checkEntryentityIdFieldForNewAndUpdateTpl(properties, billData, jsonObject, entityNum, importLog);
            }
        }
    }

    private void checkEntryentityIdFieldForNewAndUpdateTpl(DataEntityPropertyCollection properties, ImportBillData billData, JSONObject jsonObject, String entityNum, ImportLog importLog) {
        if (!"new".equalsIgnoreCase(billData.getOpType())) {
            return;
        }
        for (Map.Entry entry1 : jsonObject.entrySet()) {
            String fieldNumber = (String)entry1.getKey();
            Object dataJson = entry1.getValue();
            if (!(dataJson instanceof JSONArray)) continue;
            for (Object data : (JSONArray)dataJson) {
                String entityIdKey;
                JSONObject jsonObject2 = (JSONObject)data;
                String val = (String)jsonObject2.get((Object)(entityIdKey = fieldNumber + "_id"));
                if (!StringUtils.isNotEmpty((String)val) || properties.get((Object)fieldNumber) instanceof TreeEntryProp) continue;
                String cellIndex = this.getCellIndex(entityIdKey, entityNum);
                DataValidateServiceHelper.writeRowErrorLog(23, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), jsonObject2.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNum));
            }
        }
    }
}

