/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.common.enu.ValidatorOrderEnum;
import kd.hr.impt.core.validate.AbstractValidateHandler;
import kd.hr.impt.core.validate.dto.BaseDataContainer;
import kd.hr.impt.core.validate.dto.DataValidateParams;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

class InnerValidateHandler
extends AbstractValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(InnerValidateHandler.class);
    protected boolean isEnable = true;
    private DataValidateParams customParams;

    InnerValidateHandler() {
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean enable) {
        this.isEnable = enable;
    }

    public void setCustomParams(DataValidateParams customParams) {
        this.customParams = customParams;
    }

    public DataValidateParams getDataValidateParams() {
        return this.customParams;
    }

    @Override
    public ValidatorOrderEnum setValidatorRole() {
        return ValidatorOrderEnum.DEFAULT;
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
    }

    protected Object getPutWhereKey(DynamicObject dynamicObject, String customKey, String baseDataFormat, Map<String, Object> bdFieldMainPropName, String[] extF7UniqueVal, Map<String, String> f7ExtUniqueValFieldMap) {
        String realNumber = (String)bdFieldMainPropName.get("number");
        String realName = (String)bdFieldMainPropName.get("name");
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.isNotEmpty((CharSequence)realNumber)) {
            jsonObject.put(realNumber, dynamicObject.get(customKey.concat(realNumber)));
        }
        if (StringUtils.isNotEmpty((CharSequence)realName)) {
            jsonObject.put(realName, dynamicObject.get(customKey.concat(realName)));
        }
        if ("number_name".equalsIgnoreCase(baseDataFormat)) {
            jsonObject.put("$bdSplit", (Object)"##");
        }
        if ("id".equalsIgnoreCase(baseDataFormat)) {
            jsonObject.put("id", dynamicObject.get("id"));
        }
        Object putWhereKey = this.getPutWhereKey(jsonObject, baseDataFormat, bdFieldMainPropName, null, extF7UniqueVal, f7ExtUniqueValFieldMap);
        if (ObjectUtils.isNotEmpty((Object)extF7UniqueVal)) {
            for (String ext : extF7UniqueVal) {
                putWhereKey = putWhereKey + ',' + dynamicObject.getString(ext);
            }
        }
        LOGGER.info("InnerValidateHandler.getPutWhereKey()_customKey:{},baseDataFormat:{},bdFieldMainPropName:{},putWhereKey:{}", new Object[]{customKey, baseDataFormat, bdFieldMainPropName, putWhereKey});
        return putWhereKey;
    }

    protected Object getPutWhereKey(JSONObject valueJson, String baseDataFormat, Map<String, Object> bdFieldMainPropName, JSONObject billJson, String[] extF7UniqueVal, Map<String, String> f7ExtUniqueValFieldMap) {
        StringBuilder builder = new StringBuilder();
        if (ObjectUtils.isNotEmpty((Object)extF7UniqueVal) && ObjectUtils.isNotEmpty((Object)billJson)) {
            for (String ext : extF7UniqueVal) {
                if (ObjectUtils.isNotEmpty(f7ExtUniqueValFieldMap) && f7ExtUniqueValFieldMap.containsKey(ext)) {
                    ext = f7ExtUniqueValFieldMap.get(ext);
                }
                builder.append(",").append(billJson.getString(ext));
            }
        }
        String bui = builder.toString();
        Object key = ImportServiceHelper.getPutWhereKey(valueJson, baseDataFormat, bdFieldMainPropName);
        if (StringUtils.isNotEmpty((CharSequence)bui)) {
            key = key + bui;
        }
        return key;
    }

    @ExcludeFromJacocoGeneratedReport
    protected String getCellIndex(String fieldKey, String mainEntityId) {
        Map<String, Map<String, DynamicObject>> tplFieldConfig = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig();
        Map<String, String> cellIndexOfEntities = this.getDataValidateParams().getCellIndexOfEntities(mainEntityId);
        String cellIndex = cellIndexOfEntities.get(fieldKey);
        try {
            if (StringUtils.isBlank((CharSequence)cellIndex)) {
                DynamicObject fieldDy = tplFieldConfig.get(mainEntityId).get(MethodUtil.getLevelOneKey((String)fieldKey));
                String dbFormat = fieldDy.getString("imptattr");
                Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
                Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(mainEntityId).get(fieldKey);
                if (bdFieldMainPropName != null) {
                    dbFormat = (String)bdFieldMainPropName.getOrDefault(dbFormat, dbFormat);
                }
                fieldKey = cellIndexOfEntities.get(fieldKey.concat(".").concat(dbFormat)) == null ? fieldKey.concat(".").concat(Lang.get().toString()) : fieldKey.concat(".").concat(dbFormat);
                cellIndex = cellIndexOfEntities.get(fieldKey);
            }
        }
        catch (NullPointerException exception) {
            LOGGER.info("AbstractValidateHandler.getCellIndex()_,fieldKey:{},cellIndexOfEntities:{},mainEntityId:{}", new Object[]{fieldKey, cellIndexOfEntities, mainEntityId});
            LOGGER.error((Throwable)exception);
        }
        if (StringUtils.isEmpty((CharSequence)cellIndex)) {
            LOGGER.error("getCellIndex\u65b9\u6cd5\u8fd4\u56denull\u503c\u3002fieldKey=" + fieldKey);
            LOGGER.info("AbstractValidateHandler.getCellIndex(),cellIndexOfEntities:{},mainEntityId:{}", cellIndexOfEntities, (Object)mainEntityId);
        }
        return cellIndex;
    }

    protected String getCellName(String fieldCellIndex, String mainEntityId) {
        if (StringUtils.isEmpty((CharSequence)fieldCellIndex)) {
            return "";
        }
        Map<String, String> cellNameIndexOfEntities = this.getDataValidateParams().getCellNameIndexOfEntities(mainEntityId);
        return cellNameIndexOfEntities.get(fieldCellIndex);
    }

    protected List<Long> getPermMainBU(BaseDataContainer baseDataContainer, MainEntityType entityType, String entityNumber) {
        ImportContext importContext = this.customParams.getImportStart().getImportContext();
        List<Long> permBU = baseDataContainer.getPermBU(entityNumber);
        if (permBU == null) {
            if (StringUtils.isBlank((CharSequence)entityType.getMainOrg())) {
                permBU = Collections.singletonList(-2L);
            } else {
                String appId = DataValidateServiceHelper.getPermAppIdPkid(importContext.getAppId(), entityNumber, entityNumber.equals(importContext.getMainFormId()));
                String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)entityNumber);
                LOGGER.info("ControlledBaseDataValidator--getPermOrg(),orgViewType:{},appId2:{},entityNumber:{}", new Object[]{orgViewType, appId, entityNumber});
                HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)entityNumber, (String)"47150e89000000ac");
                LOGGER.info("ControlledBaseDataValidator--getPermOrg(),hasAllOrgPerm:{},hasPermOrgs:{},entityNumber:{}", new Object[]{result.hasAllOrgPerm(), result.getHasPermOrgs(), entityNumber});
                permBU = result.hasAllOrgPerm() ? Collections.singletonList(-2L) : (Objects.isNull(result.getHasPermOrgs()) || result.getHasPermOrgs().size() == 0 ? Collections.singletonList(-1L) : result.getHasPermOrgs());
            }
            baseDataContainer.setPermBU(entityNumber, permBU);
        }
        return permBU;
    }
}

