/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.validate.InnerValidateHandler;
import kd.hr.impt.core.validate.helper.DataValidateServiceHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class MustFillInValidator
extends InnerValidateHandler {
    private static final Log LOGGER = LogFactory.getLog(MustFillInValidator.class);

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        if (!this.isEnable() || this.getDataValidateParams().isDeleteTemplate()) {
            return;
        }
        Map<String, List<IDataEntityProperty>> entityToFields = this.getDataValidateParams().getEntity2MustFillInFields();
        DynamicObjectCollection templateEntry = this.getDataValidateParams().getImportStart().getImportContext().getTpl().getDynamicObjectCollection("tpltreeentryentity");
        for (ImportBillData billData : billDataList) {
            for (Map.Entry entry : billData.getData().entrySet()) {
                String entityNum = (String)entry.getKey();
                Object dataJson = entry.getValue();
                List<String> nonImportField = templateEntry.stream().filter(dy -> !dy.getBoolean("isimport") && dy.getBoolean("isfield") && dy.getString("childentity").equals(entityNum)).map(dy2 -> dy2.getString("fieldnumber")).collect(Collectors.toList());
                if (dataJson instanceof JSONArray) {
                    for (Object data : (JSONArray)dataJson) {
                        this.checkData(entityNum, billData, importLog, entityToFields.get(entityNum), (JSONObject)data, nonImportField);
                    }
                    continue;
                }
                this.checkData(entityNum, billData, importLog, entityToFields.get(entityNum), (JSONObject)dataJson, nonImportField);
            }
        }
    }

    private void checkData(String entityNum, ImportBillData billData, ImportLog importLog, List<IDataEntityProperty> entityOfMustFillFields, JSONObject dataJson, List<String> nonImportField) {
        List<String> collect = dataJson.keySet().stream().filter(nonImportField::contains).collect(Collectors.toList());
        collect.forEach(arg_0 -> ((JSONObject)dataJson).remove(arg_0));
        if (entityOfMustFillFields == null) {
            return;
        }
        entityOfMustFillFields.remove(null);
        entityOfMustFillFields.forEach(fieldProp -> {
            if (fieldProp == null) {
                return;
            }
            String fieldKey = fieldProp.getName();
            if (fieldProp.getParent() instanceof EntryType) {
                JSONArray entryJsonArray = dataJson.getJSONArray(fieldProp.getParent().getName());
                if (entryJsonArray != null) {
                    entryJsonArray.forEach(entryJsonOb -> this.checkMustFillField(entityNum, billData, importLog, (IDataEntityProperty)fieldProp, (JSONObject)entryJsonOb, fieldKey));
                }
            } else {
                this.checkMustFillField(entityNum, billData, importLog, (IDataEntityProperty)fieldProp, dataJson, fieldKey);
            }
        });
        this.checkRangeFields(entityNum, billData, importLog, 12, this.getDataValidateParams().getDateRangeFields(billData.getMainEntityId()), dataJson);
        this.checkRangeFields(entityNum, billData, importLog, 15, this.getDataValidateParams().getTimeRangeFields(billData.getMainEntityId()), dataJson);
        dataJson.values().stream().filter(value -> value instanceof JSONArray && ObjectUtils.isNotEmpty((Object)value) && ((JSONArray)value).getJSONObject(0).containsKey((Object)"$excelIndex")).forEach(value2 -> ((JSONArray)value2).forEach(jsonOb -> {
            this.checkRangeFields(entityNum, billData, importLog, 12, this.getDataValidateParams().getDateRangeFields(billData.getMainEntityId()), (JSONObject)jsonOb);
            this.checkRangeFields(entityNum, billData, importLog, 15, this.getDataValidateParams().getTimeRangeFields(billData.getMainEntityId()), (JSONObject)jsonOb);
        }));
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkRangeFields(String entityNum, ImportBillData billData, ImportLog importLog, int errType, Map<String, String> rangeFields, JSONObject dataJson) {
        if (rangeFields == null) {
            return;
        }
        rangeFields.forEach((key, value) -> {
            if (dataJson.containsKey(key) && !dataJson.containsKey(value)) {
                String cellIndex = this.getCellIndex((String)value, entityNum);
                DataValidateServiceHelper.writeRowErrorLog(errType, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNum));
            } else if (!dataJson.containsKey(key) && dataJson.containsKey(value)) {
                String cellIndex = this.getCellIndex((String)key, entityNum);
                DataValidateServiceHelper.writeRowErrorLog(errType + 1, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), cellIndex, this.getCellName(cellIndex, entityNum));
            } else {
                this.compareDateOrTime(entityNum, billData, importLog, errType, dataJson, (String)key, (String)value);
            }
        });
    }

    @ExcludeFromJacocoGeneratedReport
    private void compareDateOrTime(String entityNum, ImportBillData billData, ImportLog importLog, int errType, JSONObject dataJson, String key, String value) {
        try {
            if (dataJson.containsKey((Object)key) && dataJson.containsKey((Object)value)) {
                if (errType == 12 && ((Timestamp)dataJson.getTimestamp(key)).after((Timestamp)dataJson.getTimestamp(value))) {
                    DataValidateServiceHelper.writeRowErrorLog(errType + 2, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), this.getCellIndex(key, entityNum), this.getCellIndex(value, entityNum));
                } else if (errType == 15 && LocalTime.parse(dataJson.getString(key)).isAfter(LocalTime.parse(dataJson.getString(value)))) {
                    DataValidateServiceHelper.writeRowErrorLog(errType + 2, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), dataJson.getIntValue("$excelIndex"), this.getCellIndex(key, entityNum), this.getCellIndex(value, entityNum));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.info("MustFillInValidator.compareDateOrTime(),error:{}", (Object)exception.getMessage());
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkMustFillField(String entityNum, ImportBillData billData, ImportLog importLog, IDataEntityProperty fieldProp, JSONObject dataJsonValue, String fieldKey) {
        int rowIndex = dataJsonValue.getIntValue("$excelIndex");
        if (!dataJsonValue.containsKey((Object)fieldKey) || Objects.isNull(dataJsonValue.get((Object)fieldKey))) {
            if (fieldProp instanceof MuliLangTextProp) {
                fieldKey = fieldKey.concat(".").concat(Lang.get().toString());
            }
            String cellIndex = this.getCellIndex(fieldKey, entityNum);
            DataValidateServiceHelper.writeRowErrorLog(0, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNum));
        } else {
            if (fieldProp instanceof BasedataProp || fieldProp instanceof MulBasedataProp) {
                Object dataJsonValueTemp;
                String imptattr = this.getDataValidateParams().getImportStart().getImportContext().getTplFieldConfig().get(entityNum).get(fieldKey).getString("imptattr");
                Map<String, Map<String, Map<String, Object>>> entityBdFieldMainPropName = this.getDataValidateParams().getImportStart().getImportContext().getEntityBdFieldMainPropName();
                Map<String, Object> bdFieldMainPropName = entityBdFieldMainPropName.get(entityNum).get(fieldKey);
                imptattr = (String)bdFieldMainPropName.getOrDefault(imptattr, imptattr);
                boolean flag = "number_name".equals(imptattr) ? dataJsonValue.get((Object)fieldKey) == null : ((dataJsonValueTemp = dataJsonValue.get((Object)fieldKey)) instanceof JSONArray ? StringUtils.isBlank((CharSequence)((JSONArray)dataJsonValueTemp).getJSONObject(0).getString(imptattr)) : StringUtils.isBlank((CharSequence)((JSONObject)dataJsonValueTemp).getString(imptattr)));
                if (flag) {
                    fieldKey = fieldKey.concat(".").concat(imptattr);
                    String cellIndex = this.getCellIndex(fieldKey, entityNum);
                    DataValidateServiceHelper.writeRowErrorLog(0, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNum));
                }
            }
            if (fieldProp instanceof MuliLangTextProp && StringUtils.isBlank((CharSequence)dataJsonValue.getJSONObject(fieldProp.getName()).getString(Lang.get().toString()))) {
                fieldKey = fieldKey.concat(".").concat(Lang.get().toString());
                String cellIndex = this.getCellIndex(fieldKey, entityNum);
                DataValidateServiceHelper.writeRowErrorLog(0, importLog, billData.getSheetName(), billData.getStartIndex(), billData.getEndIndex(), rowIndex, cellIndex, this.getCellName(cellIndex, entityNum));
            }
        }
    }
}

