/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.impt.core.validate;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hies.common.util.MethodUtil;
import kd.hr.impt.business.ImportServiceHelper;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.dto.ImportContext;
import kd.hr.impt.common.dto.ImportLog;
import kd.hr.impt.core.init.ImportStart;
import kd.hr.impt.core.validate.InnerValidateHandler;

public final class RepeatDataValidator
extends InnerValidateHandler {
    private Map<String, Map<Long, Object>> tempMap;
    private Map<String, List<String>> uniqueKeyFieldsFormatMap;
    private ImportContext importContext;

    public RepeatDataValidator(ImportStart importStart) {
        this.importContext = importStart.getImportContext();
        this.tempMap = Maps.newHashMapWithExpectedSize((int)this.importContext.getSheetRowCountMap().size());
        this.uniqueKeyFieldsFormatMap = Maps.newHashMapWithExpectedSize((int)this.importContext.getSheetRowCountMap().size());
    }

    @Override
    public void validate(List<ImportBillData> billDataList, ImportLog importLog) {
        if (billDataList == null || billDataList.size() == 0) {
            return;
        }
        ListIterator<ImportBillData> iterator = billDataList.listIterator();
        while (iterator.hasNext()) {
            ImportBillData next = iterator.next();
            AtomicBoolean canRemove = new AtomicBoolean(false);
            for (Map.Entry next1 : next.getData().entrySet()) {
                String key = (String)next1.getKey();
                Object val = next1.getValue();
                List<String> uniqueKeyFieldsFormat = this.uniqueKeyFieldsFormatMap.get(key);
                if (CollectionUtils.isEmpty(uniqueKeyFieldsFormat)) {
                    uniqueKeyFieldsFormat = this.formatUniqueKeyFields(key);
                    this.uniqueKeyFieldsFormatMap.put(key, uniqueKeyFieldsFormat);
                }
                if (CollectionUtils.isEmpty(uniqueKeyFieldsFormat)) continue;
                JSONArray array = new JSONArray(1);
                if (val instanceof JSONArray) {
                    array = (JSONArray)val;
                } else if (val instanceof JSONObject) {
                    array.add(val);
                }
                for (Object item : array) {
                    JSONObject rowDataJson = (JSONObject)item;
                    Integer index = rowDataJson.getInteger("$excelIndex");
                    StringBuilder uniqueValBuilder = new StringBuilder();
                    for (String field : uniqueKeyFieldsFormat) {
                        Object objectValue = ImportServiceHelper.getObjectValue(rowDataJson, field);
                        if (ObjectUtils.isEmpty((Object)objectValue)) {
                            uniqueValBuilder = new StringBuilder();
                            break;
                        }
                        uniqueValBuilder.append(objectValue);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)uniqueValBuilder.toString())) continue;
                    long hashCode = MethodUtil.get64BitHash((String)uniqueValBuilder.toString());
                    Map<Long, Object> hashMap = this.tempMap.getOrDefault(key, Maps.newHashMapWithExpectedSize((int)16));
                    Object exsit = hashMap.get(hashCode);
                    if (exsit == null) {
                        hashMap.put(hashCode, index);
                        this.tempMap.put(key, hashMap);
                        continue;
                    }
                    String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e0e\u6e90\u6587\u4ef6\u7b2c%1$s\u884c\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RepeatDataValidator_0", (String)"hrmp-hies-import", (Object[])new Object[0]), exsit);
                    importLog.writeRowLog(next.getSheetName(), next.getStartIndex(), next.getEndIndex(), index, tip);
                    canRemove.set(true);
                }
            }
            if (!canRemove.get()) continue;
            iterator.remove();
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private List<String> formatUniqueKeyFields(String entityId) {
        String values = this.importContext.getEntityIdToUniqueValMap().get(entityId);
        String[] split = StringUtils.split((String)values, (String)",");
        List<String> uniqueKeyFields = Arrays.asList(split);
        ArrayList<String> uniqueKeyFieldsFormat = new ArrayList<String>(uniqueKeyFields.size());
        uniqueKeyFields.forEach(key -> {
            DynamicProperty property = this.importContext.getEntityType().getProperty(key);
            if (property instanceof BasedataProp) {
                Map bdMainProp = MethodUtil.getBdMainProp((String)((BasedataProp)property).getBaseEntityId());
                DynamicObject fieldDy = this.importContext.getTplFieldConfig().get(entityId).get(key);
                String baseDataFormatValue = fieldDy.getString("imptattr");
                if ("number_name".equalsIgnoreCase(baseDataFormatValue)) {
                    uniqueKeyFieldsFormat.add(key + "." + bdMainProp.get("number"));
                    uniqueKeyFieldsFormat.add(key + "." + bdMainProp.get("name"));
                } else if ("id".equalsIgnoreCase(baseDataFormatValue)) {
                    uniqueKeyFieldsFormat.add(key + ".id");
                } else {
                    uniqueKeyFieldsFormat.add(key + "." + bdMainProp.get(baseDataFormatValue));
                }
            } else {
                uniqueKeyFieldsFormat.add((String)key);
            }
        });
        return uniqueKeyFieldsFormat;
    }
}

